# (C) 2001-2025 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


#####################################################################
#
# THIS IS AN AUTO-GENERATED FILE!
# -------------------------------
# If you modify this files, all your changes will be lost if you
# regenerate the core!
#
# FILE DESCRIPTION
# ----------------
# This file specifies the timing constraints for the LVDS interface

# Source helper script
set script_dir [file dirname [info script]]
source "$script_dir/lvds_top_intel_lvds_core10_ph2_191_w7thqsa_ip_parameters.tcl"
source "$script_dir/sdc_util.tcl"

set syn_flow 0
set sta_flow 0
set fit_flow 0
if { $::TimeQuestInfo(nameofexecutable) == "quartus_syn" } {
    set syn_flow 1
} elseif { $::TimeQuestInfo(nameofexecutable) == "quartus_sta" } {
    set sta_flow 1
} elseif { $::TimeQuestInfo(nameofexecutable) == "quartus_fit" } {
    set fit_flow 1
}

if {$sta_flow == 1 && [cfg_is_on "force_lvds_sdc_fit_flow"]} {
    set syn_flow 0
    set sta_flow 0
    set fit_flow 1
}

##########################################################################################
# Modifiable user variables
# Change these values to match your design.
##########################################################################################


##########################################################################################
# The following functions are to find out all the instances and the corresponding PLL
# refclk.  If you see an critical warning, modify to match your design.
##########################################################################################

set catch_exception [catch {
    set lvds_instance_name_list [intel_lvds_get_core_full_instance_list $ip_params(corename)]
} ]

if {$catch_exception != 0} {
    post_message -type critical_warning "Errors encountered when searching for LVDS instance name and ref clock pin names.  Please override variables lvds_instance_name_list and rerun read_sdc"
    return
}

##########################################################################################
# Derived user variables
##########################################################################################


###########################################################
# IP parameters
###########################################################


# Throw error only at TimeQuest but critical warning in Fitter\n"
if {$fit_flow} {
    set msg_error_type "critical_warning"
} else {
    set msg_error_type "error"
}

# Iterate through all instances of this IP
foreach lvds_instance_name $lvds_instance_name_list {

    if {$ip_params(enable_clkgen)} {
        set cpa_core_clk_out_pin "${lvds_instance_name}|hw_inst|clkgen_sub_hier_0|clkgen_0|o_core_clk_out"

        intel_lvds_create_generated_clock \
            -source [intel_lvds_get_clock_source "$cpa_core_clk_out_pin"] \
            -divide_by $ip_params(hw_j_factor) \
            -duty_cycle 50 -phase 0 \
            -name "${lvds_instance_name}|cpa_clk" -target "${cpa_core_clk_out_pin}"
    }

    set pll_atoms {}
    if {[catch {set pll_atoms [intel_lvds_get_iopll_atom $lvds_instance_name]}]} {
        post_message -type $msg_error_type "LVDS SDC cannot find IOPLL. Ensure that IOPLL SDC is listed before LVDS SDC in the QSF and that LVDS IP data input/output ports are connected."
    } 
    foreach pll_atom_id $pll_atoms {
        if {$pll_atom_id == ""} {
            post_message -type $msg_error_type "LVDS SDC cannot find IOPLL. Ensure that IOPLL SDC is listed before LVDS SDC in the QSF and that LVDS IP data input/output ports are connected."                
        } else {
            set pll_inst [get_atom_node_info -key NAME -node $pll_atom_id]
            intel_lvds_set_multicycle_or_false_path end "${pll_inst}~pll_ctrl_reg" "${lvds_instance_name}|pll_locked_sync_inst|sync_inst|din_s1" 2 1
            if {[get_collection_size [get_nodes -nowarn ${pll_inst}~out_clk_periph0_reg]] > 0} {
                disable_min_pulse_width "${pll_inst}~out_clk_periph0_reg"
            }
            
            foreach byte {00 01 02 03 04 05 06 07} {
                if {[intel_lvds_byte_used_for_tx ip_params $byte]} {
                    set data_sub_hier "${lvds_instance_name}|hw_inst|data_sub_hier_${byte}"
                    set c2p_fa_inst "${data_sub_hier}|lane_c2p_fabric_adaptor_0"
                    
                    if {[get_collection_size [get_pins -nowarn "${pll_inst}|out_clk_periph*"] ] > 0} {
                        set_false_path -from [get_pins -nowarn "${pll_inst}|out_clk_periph*"] -to [get_registers -nowarn "${c2p_fa_inst}~lane_periph_fa_reg"]
                        set_false_path -from [get_pins -nowarn "${pll_inst}|out_clk_periph*"] -to [get_registers -nowarn "${c2p_fa_inst}~lane_fa_reg"]
                    }
                }
                if {[intel_lvds_byte_used_for_rx ip_params $byte]} {
                    set data_sub_hier ${lvds_instance_name}|hw_inst|data_sub_hier_${byte}
                    set p2c_fa_inst "${data_sub_hier}|lane_p2c_fabric_adaptor_0"
                    
                    set_false_path -from [get_pins -nowarn "${pll_inst}|vco_clk*"] -to [get_registers -nowarn "${p2c_fa_inst}~lane_periph_fa_reg"]
                    if {[get_collection_size [get_pins -nowarn "${pll_inst}|out_clk_periph*"] ] > 0} {
                        set_false_path -from [get_pins -nowarn "${pll_inst}|out_clk_periph*"] -to [get_registers -nowarn "${p2c_fa_inst}~lane_periph_fa_reg"]
                        set_false_path -from [get_pins -nowarn "${pll_inst}|out_clk_periph*"] -to [get_registers -nowarn "${p2c_fa_inst}~lane_fa_reg"]
                    }
                }
           }
                 
        }
    }

    foreach byte {00 01 02 03 04 05 06 07} {
        if {[intel_lvds_byte_used_for_tx ip_params $byte]} {
            set data_sub_hier "${lvds_instance_name}|hw_inst|data_sub_hier_${byte}"

            set pa_inst "${data_sub_hier}|phy_adaptor_0"
            set c2p_fa_inst "${data_sub_hier}|lane_c2p_fabric_adaptor_0"
            set c2p_fa_gen_clk "${c2p_fa_inst}~div_reg"

            set master_clock ""
            set all_clocks [get_clocks -nowarn -of_objects [get_registers $c2p_fa_gen_clk]]
            foreach_in_collection clk $all_clocks {
                set clk_name [get_clock_info -name $clk]
                if {([string first $lvds_instance_name $clk_name] != -1) && ([string first "fclk0" $clk_name] != -1)} {
                    set master_clock $clk_name
                    break
                }
            }

            intel_lvds_create_generated_clock \
                -source [intel_lvds_get_clock_source "$c2p_fa_gen_clk"] \
                -divide_by $ip_params(hw_j_factor) \
                -duty_cycle 50 -phase [expr -(180.0-$ip_params(hw_inclock_shift_deg))/$ip_params(hw_j_factor)] \
                -name "${lvds_instance_name}|c2p_fa_div_clk_${byte}" -target "${c2p_fa_gen_clk}" \
                -master_clock $master_clock

            set_false_path -from "${c2p_fa_inst}~lane_periph_fa_reg" -to "${pa_inst}~pa_hr_reg"
        }

        if {[intel_lvds_byte_used_for_rx ip_params $byte]} {
            set data_sub_hier "${lvds_instance_name}|hw_inst|data_sub_hier_${byte}"

            set p2c_fa_inst "${data_sub_hier}|lane_p2c_fabric_adaptor_0"
            set p2c_fa_gen_clk "${p2c_fa_inst}~div_reg"

            set master_clock ""
            set all_clocks [get_clocks -nowarn -of_objects [get_registers $p2c_fa_gen_clk]]
            foreach_in_collection clk $all_clocks {
                set clk_name [get_clock_info -name $clk]
                if {([string first $lvds_instance_name $clk_name] != -1) && ([string first "fclk0" $clk_name] != -1)} {
                    set master_clock $clk_name
                    break
                }
            }

            intel_lvds_create_generated_clock \
                -source [intel_lvds_get_clock_source "$p2c_fa_gen_clk"] \
                -divide_by $ip_params(hw_j_factor) \
                -duty_cycle 50 -phase [expr -(180.0-$ip_params(hw_inclock_shift_deg))/$ip_params(hw_j_factor)] \
                -name "${lvds_instance_name}|p2c_fa_div_clk_${byte}" -target "${p2c_fa_gen_clk}" \
                -master_clock $master_clock
     
            foreach ch {0 1 2 3 4 5} {
                set rx_ch_num [intel_lvds_ch_number ip_params $byte $ch]
                if {$rx_ch_num == -1} {
                    continue
                }

                set core_rx_ch "${lvds_instance_name}|rx_channels[${rx_ch_num}]"
                set lvds_rx_inst "${data_sub_hier}|lvds_rx_${ch}"

                if {[intel_lvds_ch_used_for_rx ip_params $byte $ch]} {
                    if {$ip_params(dpa_locked_used)} {
                        intel_lvds_set_multicycle_or_false_path     start       "${lvds_rx_inst}~lvds*reg*"              "${core_rx_ch}.hipi_ff_rx_dpa_locked"  1     1                        
                    }

                    if {$ip_params(bitslip_assert_max)} {
                        if {[intel_lvds_ch_used_for_cdr ip_params $byte $ch]} {
                            intel_lvds_set_multicycle_or_false_path start       "${lvds_rx_inst}~lvds*reg*"              "${core_rx_ch}.hipi_ff_rx_bitslip_max" 1     1
                        } else {
                            intel_lvds_set_multicycle_or_false_path start       "${lvds_rx_inst}~lvds*reg*"              "${core_rx_ch}.hipi_ff_rx_bitslip_max" 2     1
                        }
                    }
                    
                    if {[intel_lvds_ch_used_for_dpa ip_params $byte $ch]} {
                        intel_lvds_set_multicycle_or_false_path     end         "${core_rx_ch}.hipi_ff_rx_dpa_reset"     "${lvds_rx_inst}~lvds*reg*"            3     2
                        intel_lvds_set_multicycle_or_false_path     end         "${core_rx_ch}.hipi_ff_rx_fifo_reset"    "${lvds_rx_inst}~lvds*reg*"            3     2
                    }

                    intel_lvds_set_multicycle_or_false_path     end         "${core_rx_ch}.hipi_ff_rx_bitslip_reset" "${lvds_rx_inst}~lvds*reg*"            3     2

                    if {$ip_params(use_bitslip)} {
                        intel_lvds_set_multicycle_or_false_path     end         "${core_rx_ch}.hipi_ff_rx_bitslip_ctrl"  "${lvds_rx_inst}~lvds*reg*"            3     2
                    }

                    if {![intel_lvds_ch_used_for_cdr ip_params $byte $ch] && $ip_params(dpa_use_hold)} {
                        intel_lvds_set_multicycle_or_false_path end         "${core_rx_ch}.hipi_ff_rx_dpa_hold"      "${lvds_rx_inst}~lvds*reg*"            3     2
                    }
                }

                if {[intel_lvds_ch_used_for_cdr ip_params $byte $ch]} {
                    set pclk_pin "${lvds_rx_inst}|o_pclk"

                    intel_lvds_create_generated_clock \
                        -source [intel_lvds_get_clock_source $pclk_pin] \
                        -name "${lvds_instance_name}|dpa_core_clk_${byte}_${ch}" \
                        -divide_by $ip_params(hw_j_factor) \
                        -target $pclk_pin

                    if {$ip_params(hw_j_factor) == 4} {
                        intel_lvds_set_multicycle start "${lvds_rx_inst}~lvds*reg*" "${core_rx_ch}*hipi_ff_cdr_sync_reg" 1 3
                    } else {
                        intel_lvds_set_multicycle start "${lvds_rx_inst}~lvds*reg*" "${core_rx_ch}*hipi_ff_cdr_sync_reg" 3 7
                    }

                }
                
                set_false_path -from [get_registers -nowarn "${lvds_rx_inst}~lvds*reg*"] -to [get_registers -nowarn "${p2c_fa_inst}~lane_periph_fa_reg"]
            }
        }
    }
    
    set_false_path -through [get_cells "${lvds_instance_name}|reset_core|reset_reg[*]"]
}

