// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps

`define C2P_HIPI   \
    (* preserve *) \
    (* dont_merge *) \
    (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 350; -name CAN_RELAX_PERIPHERY_CORE_HYPER_REGISTER ON"} *)

`define P2C_HIPI \
    (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_PERIPHERY_CORE_TRANSFER ON; -name CAN_RELAX_PERIPHERY_CORE_HYPER_REGISTER ON"} *)

`define EXTRA_FF_PORTS \
    .clrn    (),       \
    .aload   (),       \
    .sclr1   (),       \
    .sload   (),       \
    .asdata  (),       \
    .ena     (),       \
    .devclrn (),       \
    .devpor  ()

////////////////////////////////////////////////////////////////
////LVDS SERDES CORE                  //
////////////////////////////////////////////////////////////////
module intel_lvds_core10_ph2_lvds_top_intel_lvds_core10_ph2_191_w7thqsa #(
    parameter hw_j_factor = 1,
    parameter hw_rx_mode = "cdr",
    parameter enable_pll_2 = "true",
    parameter enable_clkgen = "true",
    parameter tx_num_channels = 1,
    parameter rx_num_channels = 1,
    parameter tx_outclock_div_word = 0
) (
    input                                                                                ext_pll_locked,
    input       [1:0]                                                                    ext_outclock_periph,
    input       [7:0]                                                                    ext_phout,
    input                                                                                ext_pll_1_outclock2,
    input                                                                                ext_phout_periph,
    input                                                                                ext_pll_locked_2,
    input       [7:0]                                                                    ext_phout_2,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_in_p,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_in_n,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_bitslip_reset,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_bitslip_ctrl,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_dpa_reset,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_dpa_hold,
    input       [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_fifo_reset,
    output      [((rx_num_channels == 0) ? 0 : (rx_num_channels*hw_j_factor-1)):0]       rx_out,
    output      [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_bitslip_max,
    output      [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_dpa_locked,      
    output      [((rx_num_channels == 0) ? 0 : (rx_num_channels-1)):0]                   rx_divfwdclk,

    input       [((tx_num_channels == 0) ? 0 : (tx_num_channels*hw_j_factor-1)):0]       tx_in,
    output      [((tx_num_channels == 0) ? 0 : (tx_num_channels-1)):0]                   tx_out_p,
    output      [((tx_num_channels == 0) ? 0 : (tx_num_channels-1)):0]                   tx_out_n,
    output                                                                               tx_outclock_p,
    output                                                                               tx_outclock_n,

    input                                                                                inclock,



    input                                                                                pll_areset,
    output wire                                                                          coreclock,
    output                                                                               pll_locked
);
    localparam TX_DATA_WIDTH = 8;
    localparam SYNC_STAGES = 4;

    localparam bit IS_SIMULATION = 1'b0
// synthesis translate_off
                                 | 1'b1
// synthesis translate_on
                                 ;

    wire  [1:0] clock_periph;
    wire        clock_extra;
    wire        vcoph_periph;
    wire  [7:0] vcoph;
    wire  [7:0] vcoph_2;

    wire  pll_lock;
    wire  pll_lock_2;
    wire  pll_lock_both;
    wire  cpa_lock;
    wire  pll_reset_coreclock;
    wire  real_coreclock;
    wire  inverse_coreclock;
    wire  [((tx_num_channels == 0) ? 0 : (tx_num_channels*TX_DATA_WIDTH-1)):0] tx_data;
    wire  [((tx_num_channels == 0) ? 0 : (tx_num_channels*TX_DATA_WIDTH-1)):0] tx_reg;
    

    wire [((tx_num_channels == 0) ? 0 : (tx_num_channels-1)):0] tx_out_p_wire;
    wire [((tx_num_channels == 0) ? 0 : (tx_num_channels-1)):0] tx_out_n_wire;

    assign tx_out_p = tx_out_p_wire;
    assign tx_out_n = tx_out_n_wire;
    


    wire  [rx_num_channels*hw_j_factor-1:0] rx_data;
    wire  [rx_num_channels*hw_j_factor-1:0] rx_reg;
    wire  [rx_num_channels*hw_j_factor-1:0] cdr_sync_reg;
    logic [rx_num_channels*hw_j_factor-1:0] cdr_rx_reg;

    wire  [rx_num_channels-1:0] pll_areset_rx_divfwdclk;

    wire  [rx_num_channels-1:0] rx_bitslip_max_wire;
    wire  [rx_num_channels-1:0] rx_dpa_locked_wire;
    wire  [rx_num_channels-1:0] rx_divfwdclk_wire;

    wire  [rx_num_channels-1:0] rx_bitslip_reset_comb;
    wire  [rx_num_channels-1:0] rx_dpa_reset_comb;
    wire  [rx_num_channels-1:0] rx_dpa_switch_comb;
    wire  [rx_num_channels-1:0] rx_fifo_reset_comb;

    wire  [rx_num_channels-1:0] rx_bitslip_max_reg;
    wire  [rx_num_channels-1:0] rx_dpa_locked_reg;
    wire  [rx_num_channels-1:0] rx_bitslip_reset_reg;
    wire  [rx_num_channels-1:0] rx_dpa_reset_reg;
    wire  [rx_num_channels-1:0] rx_dpa_switch_reg;
    wire  [rx_num_channels-1:0] rx_fifo_reset_reg;
    wire  [rx_num_channels-1:0] rx_bitslip_ctrl_reg;
    wire  [rx_num_channels-1:0] rx_dpa_hold_reg;

    wire  [3:0] tx_data_wrdata_en_c2p;
    wire  [3:0] tx_data_wr_dqs_en_c2p;
    wire  [3:0] tx_data_rddata_en_c2p;
    wire  [3:0] tx_data_wr_rank_en_c2p;
    wire  [3:0] tx_data_rd_rank_en_c2p;
    wire [19:0] tx_data_ctrl_c2p;

    generate
        ////////////////////////////////////////////////////////////////
        ////PLL Instance                       //
        ////////////////////////////////////////////////////////////////
        lvds_top_intel_lvds_core10_ph2_altera_iopll_191_gyqqmxq pll_inst (
            .rst            (pll_areset),
            .refclk         (inclock),
            .locked         (pll_lock),
            .phout          (vcoph),
            .outclk_periph  (clock_periph),
            .phout_periph   (vcoph_periph)
        );

        ////////////////////////////////////////////////////////////////
        ////Hardened IP                        //
        ////////////////////////////////////////////////////////////////
        intel_lvds_core10_ph2_lvds_top_intel_lvds_core10_ph2_191_w7thqsa_hw hw_inst (
            .rx_out(rx_data),
            .rx_in_p(rx_in_p),
            .rx_in_n(rx_in_n),
            .rx_bitslip_reset(rx_bitslip_reset_reg),
            .rx_bitslip_ctrl(rx_bitslip_ctrl_reg),
            .rx_dpa_reset(rx_dpa_reset_reg),
            .rx_dpa_switch(rx_dpa_switch_reg),
            .rx_dpa_hold(rx_dpa_hold_reg),
            .rx_fifo_reset(rx_fifo_reset_reg),
            .rx_bitslip_max(rx_bitslip_max_wire),
            .rx_dpa_locked(rx_dpa_locked_wire),      
            .rx_divfwdclk(rx_divfwdclk_wire),
            .tx_in(tx_data),
            .tx_out_p(tx_out_p_wire),
            .tx_out_n(tx_out_n_wire),
            .tx_ctrl(tx_data_ctrl_c2p),
            .core_clk_in(coreclock),
            .core_clk_out(coreclock),
            .cpa_lock(cpa_lock),
            .phy_clk(clock_periph[0]),
            .phy_clk_sync(clock_periph[1]),
            .phy_clk_vco(vcoph_periph),
            .vco_clk(vcoph),
            .pll_lock(pll_lock)
        );

        ////////////////////////////////////////////////////////////////
        ////Soft Logic                         //
        ////////////////////////////////////////////////////////////////

        if (enable_pll_2 == "true") begin
            assign pll_lock_both = pll_lock & pll_lock_2;
        end else begin
            assign pll_lock_both = pll_lock;
        end

        if (enable_clkgen == "true") begin
            assign real_coreclock = coreclock;

            assign reset_and_lock = ~pll_areset & pll_lock_both & cpa_lock;
            if (tx_num_channels > 0 && IS_SIMULATION) begin
                localparam int LOCK_COUNT_WIDTH = 13;

                wire reset_and_lock_sync;  
                logic [LOCK_COUNT_WIDTH - 1 : 0] lock_count;           


                reset_sync_w_lock #(.RESET_SYNC_STAGES(SYNC_STAGES)) reset_core (
                    .pll_areset(pll_areset),
                    .pll_locked(pll_lock_both & cpa_lock),
                    .clock(real_coreclock),
                    .sync_reset(reset_and_lock_sync)
                );
                
                always_ff @(posedge real_coreclock or posedge reset_and_lock_sync) begin
                    if (reset_and_lock_sync) begin
                        lock_count <= '0;
                    end else if (~lock_count[LOCK_COUNT_WIDTH - 1]) begin
                        lock_count <= LOCK_COUNT_WIDTH'(lock_count + 1); 
                    end
                end
                
                assign pll_locked = lock_count[LOCK_COUNT_WIDTH - 1];
            end else begin
                assign pll_locked = reset_and_lock;
            end
        end else begin
            assign real_coreclock = clock_extra;
            assign pll_locked = pll_lock_both;
        end

        reset_sync_w_lock #(.RESET_SYNC_STAGES(SYNC_STAGES)) reset_core (
            .pll_areset(pll_areset),
            .pll_locked(pll_locked),
            .clock(real_coreclock),
            .sync_reset(pll_reset_coreclock)
        );

        if (tx_num_channels > 0) begin
            assign tx_data_wrdata_en_c2p  = {4{1'b1}};
            assign tx_data_wr_dqs_en_c2p  = {4{1'b1}};
            assign tx_data_rddata_en_c2p  = {4{1'b0}};
            assign tx_data_wr_rank_en_c2p = {4{1'b0}};
            assign tx_data_rd_rank_en_c2p = {4{1'b0}};

            assign tx_data_ctrl_c2p = 
              { tx_data_wrdata_en_c2p,
                tx_data_wr_dqs_en_c2p,
                tx_data_rddata_en_c2p,
                tx_data_wr_rank_en_c2p,
                tx_data_rd_rank_en_c2p };
        end

        genvar ch;
        genvar i;
        for (ch = 0; ch < tx_num_channels; ch = ch + 1) begin : tx_channels
            assign inverse_coreclock = ~real_coreclock;
            for (i = 0; i < TX_DATA_WIDTH; i = i + 1) begin : input_reg
                int tx_in_i = (i * hw_j_factor) / TX_DATA_WIDTH;

                int index_conv = (tx_in_i % 2 == 0) ? 1 : -1;

                `C2P_HIPI tennm_ff hipi_ff_tx_reg (
                    .clk (coreclock),
                    .d   ( tx_in[ch * hw_j_factor + tx_in_i + index_conv]),
                    .q   (tx_reg[ch * TX_DATA_WIDTH + i]),
                    .sclr(),
                    `EXTRA_FF_PORTS
                );

                assign tx_data[ch * TX_DATA_WIDTH + i] = tx_reg[ch * TX_DATA_WIDTH + i];
            end
        end


        for (ch = 0; ch < rx_num_channels; ch = ch + 1) begin : rx_channels

            if (hw_rx_mode == "cdr") begin
                assign rx_divfwdclk[ch] = rx_divfwdclk_wire[ch];

                reset_synchronizer_active_high #(.RESET_SYNC_LENGTH(SYNC_STAGES)) pll_areset_sync_rx_divfwdclk (
                    .async_reset(pll_areset),
                    .clock(rx_divfwdclk[ch]),
                    .sync_reset(pll_areset_rx_divfwdclk[ch])
                );

                for (i = 0; i < hw_j_factor; i = i + 1) begin : cdr_reg
                    tennm_ff hipi_ff_cdr_sync_reg (
                        .clk (rx_divfwdclk[ch]),
                        .d   (rx_data[ch * hw_j_factor + i]),
                        .q   (cdr_sync_reg[ch * hw_j_factor + i]),
                        .sclr(),
                        `EXTRA_FF_PORTS
                    );

                    always @(posedge rx_divfwdclk[ch] or posedge pll_areset_rx_divfwdclk[ch]) begin
                        if (pll_areset_rx_divfwdclk[ch])
                            cdr_rx_reg[ch * hw_j_factor + i] <= 1'b0;
                        else
                            cdr_rx_reg[ch * hw_j_factor + i] <= cdr_sync_reg[ch * hw_j_factor + i];
                    end

                    assign rx_out[ch * hw_j_factor + i] = cdr_rx_reg[ch * hw_j_factor + i];
                end

                assign rx_dpa_hold_reg[ch] = 1'b0;
            end else begin

                for (i = 0; i < hw_j_factor; i = i + 1) begin : output_reg
                    `P2C_HIPI tennm_ff hipi_ff_rx_reg (
                        .clk (coreclock),
                        .d   (rx_data[ch * hw_j_factor + i]),
                        .q   ( rx_reg[ch * hw_j_factor + i]),
                        .sclr(),
                        `EXTRA_FF_PORTS
                    );

                    assign rx_out[ch * hw_j_factor + i] = rx_reg[ch * hw_j_factor + i];
                end

                tennm_ff hipi_ff_rx_dpa_hold (
                    .clk (real_coreclock),
                    .d   (rx_dpa_hold[ch]),
                    .q   (rx_dpa_hold_reg[ch]),
                    .sclr(),
                    `EXTRA_FF_PORTS
                );
            end

            data_synchronizer #(.SYNC_LENGTH(SYNC_STAGES)) rx_bitslip_max_sync_inst (
                .data_in(rx_bitslip_max_reg[ch]),
                .clock(real_coreclock),
                .reset(pll_reset_coreclock),
                .data_out(rx_bitslip_max[ch])
            );

            data_synchronizer #(.SYNC_LENGTH(SYNC_STAGES)) rx_dpa_locked_sync_inst (
                .data_in(rx_dpa_locked_reg[ch]),
                .clock(real_coreclock),
                .reset(pll_reset_coreclock),
                .data_out(rx_dpa_locked[ch])
            );

            tennm_ff hipi_ff_rx_bitslip_max (
                .clk (real_coreclock),
                .d   (rx_bitslip_max_wire[ch]),
                .q   (rx_bitslip_max_reg[ch]),
                .sclr(),
                `EXTRA_FF_PORTS
            );

            tennm_ff hipi_ff_rx_dpa_locked (
                .clk (real_coreclock),
                .d   (rx_dpa_locked_wire[ch]),
                .q   (rx_dpa_locked_reg[ch]),
                .sclr(),
                `EXTRA_FF_PORTS
            );

            assign rx_bitslip_reset_comb[ch] = pll_reset_coreclock | rx_bitslip_reset[ch];
            assign rx_dpa_switch_comb[ch]    = 1'b0;

            tennm_ff hipi_ff_rx_bitslip_reset (
                .clk (real_coreclock),
                .d   (rx_bitslip_reset_comb[ch]),
                .q   (rx_bitslip_reset_reg[ch]),
                .sclr(),
                `EXTRA_FF_PORTS
            );

            tennm_ff hipi_ff_rx_dpa_switch (
                .clk (real_coreclock),
                .d   (rx_dpa_switch_comb[ch]),
                .q   (rx_dpa_switch_reg[ch]),
                .sclr(),
                `EXTRA_FF_PORTS
            );

            tennm_ff hipi_ff_rx_bitslip_ctrl (
                .clk (real_coreclock),
                .d   (rx_bitslip_ctrl[ch]),
                .q   (rx_bitslip_ctrl_reg[ch]),
                .sclr(),
                `EXTRA_FF_PORTS
            );

            if (hw_rx_mode == "fifo" || hw_rx_mode == "cdr") begin
                assign rx_dpa_reset_comb[ch]  = pll_reset_coreclock | rx_dpa_reset[ch];
                assign rx_fifo_reset_comb[ch] = pll_reset_coreclock | rx_fifo_reset[ch];

                tennm_ff hipi_ff_rx_dpa_reset (
                    .clk (real_coreclock),
                    .d   (rx_dpa_reset_comb[ch]),
                    .q   (rx_dpa_reset_reg[ch]),
                    .sclr(),
                    `EXTRA_FF_PORTS
                );

                tennm_ff hipi_ff_rx_fifo_reset (
                    .clk (real_coreclock),
                    .d   (rx_fifo_reset_comb[ch]),
                    .q   (rx_fifo_reset_reg[ch]),
                    .sclr(),
                    `EXTRA_FF_PORTS
                );
            end else begin
                assign rx_dpa_reset_reg[ch]  = 1'b0;
                assign rx_fifo_reset_reg[ch] = 1'b0;
            end

        end

    endgenerate

endmodule

