// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps

////////////////////////////////////////////////////////////////
////LVDS SERDES CKGEN sub-hierarchy             //
////////////////////////////////////////////////////////////////
module intel_lvds_core10_ph2_lvds_top_intel_lvds_core10_ph2_191_w7thqsa_clkgen_sub_hier (
    input         core_clk_in,
    input         phy_clk,
    input         phy_clk_sync,
    input  [7:0]  vco8ph_clk,
    input         pll_lock,

    output        core_clk_out,
    output        cpa_lock
);
    parameter vco_clk_freq_hz = 1600000000;
    parameter vco_data_rate_ratio = 1;
    parameter j_factor = 8;
    
    localparam bit IS_SIMULATION = 1'b0
// synthesis translate_off
                                 | 1'b1
// synthesis translate_on
                                 ;

    typedef bit[15:0] std_func_clkgen__base_address_type;
    typedef enum {
        FEEDBACK_DLY_SEL_DLY_CORE,
        FEEDBACK_DLY_SEL_DLY_PHY
    }                 std_func_clkgen__feedback_dly_sel_type;
    typedef int       std_func_clkgen__feedback_dly_steps_type;
    typedef enum {
        PROTOCOL_MODE_EMIF,
        PROTOCOL_MODE_NON_EMIF,
        PROTOCOL_MODE_UNUSED
    }                 std_func_clkgen__protocol_mode_type;
    typedef int       std_func_clkgen__phy_clk_div_type;
    typedef int       std_func_clkgen__vco_clk_div_exponent_type;
    typedef int       std_func_clkgen__vco_clk_div_mantissa_type;
    typedef bit[35:0] std_func_clkgen__vco_clk_freq_type;

    typedef struct packed {
        std_func_clkgen__base_address_type         std_func_clkgen_0__base_address;
        std_func_clkgen__feedback_dly_sel_type     std_func_clkgen_0__feedback_dly_sel;
        std_func_clkgen__feedback_dly_steps_type   std_func_clkgen_0__feedback_dly_steps;
        std_func_clkgen__protocol_mode_type        std_func_clkgen_0__protocol_mode;
        std_func_clkgen__phy_clk_div_type          std_func_clkgen_0__phy_clk_div;
        std_func_clkgen__vco_clk_div_exponent_type std_func_clkgen_0__vco_clk_div_exponent;
        std_func_clkgen__vco_clk_div_mantissa_type std_func_clkgen_0__vco_clk_div_mantissa;
        std_func_clkgen__vco_clk_freq_type         std_func_clkgen_0__vco_clk_freq;
    } output_params_type;

    function automatic output_params_type map_parameters (input integer vco_clk_freq_hz, j_factor);
        output_params_type output_params;

        output_params.std_func_clkgen_0__feedback_dly_sel = FEEDBACK_DLY_SEL_DLY_CORE;
        output_params.std_func_clkgen_0__feedback_dly_steps = 5;
        output_params.std_func_clkgen_0__protocol_mode = PROTOCOL_MODE_NON_EMIF;
        output_params.std_func_clkgen_0__vco_clk_div_mantissa = 0;

        output_params.std_func_clkgen_0__vco_clk_freq = vco_clk_freq_hz;

        if (j_factor == 4) begin
            output_params.std_func_clkgen_0__phy_clk_div = 2'd2;
            if (vco_data_rate_ratio == 4) begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd4;
            end else if (vco_data_rate_ratio == 2) begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd3;
            end else begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd2;
            end
        end else if (j_factor == 8) begin
            output_params.std_func_clkgen_0__phy_clk_div = 2'd3;
            if (vco_data_rate_ratio == 4) begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd5;
            end else if (vco_data_rate_ratio == 2) begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd4;
            end else begin
                output_params.std_func_clkgen_0__vco_clk_div_exponent = 3'd3;
            end
        end

        return output_params;
    endfunction

    parameter output_params_type output_params = map_parameters(vco_clk_freq_hz, j_factor);

    tennm_clkgen # (
        .base_address              (output_params.std_func_clkgen_0__base_address),
        .feedback_dly_sel          ((output_params.std_func_clkgen_0__feedback_dly_sel == FEEDBACK_DLY_SEL_DLY_CORE) ? "FEEDBACK_DLY_SEL_DLY_CORE" :
                                    (output_params.std_func_clkgen_0__feedback_dly_sel == FEEDBACK_DLY_SEL_DLY_PHY)  ? "FEEDBACK_DLY_SEL_DLY_PHY"  :
                                    "FEEDBACK_DLY_SEL_DLY_CORE"),
        .feedback_dly_steps        (output_params.std_func_clkgen_0__feedback_dly_steps),
        .protocol_mode             ((output_params.std_func_clkgen_0__protocol_mode == PROTOCOL_MODE_EMIF)     ? "PROTOCOL_MODE_EMIF"     :
                                    (output_params.std_func_clkgen_0__protocol_mode == PROTOCOL_MODE_NON_EMIF) ? "PROTOCOL_MODE_NON_EMIF" :
                                    (output_params.std_func_clkgen_0__protocol_mode == PROTOCOL_MODE_UNUSED)   ? "PROTOCOL_MODE_UNUSED"   :
                                    "PROTOCOL_MODE_EMIF"),
        .phy_clk_div               (output_params.std_func_clkgen_0__phy_clk_div),
        .vco_clk_div_exponent      (output_params.std_func_clkgen_0__vco_clk_div_exponent),
        .vco_clk_div_mantissa      (output_params.std_func_clkgen_0__vco_clk_div_mantissa),
        .vco_clk_freq              (output_params.std_func_clkgen_0__vco_clk_freq)
    ) clkgen_0 (
        .i_core_clk_in             (core_clk_in),
        .i_phyclk                  (phy_clk),
        .i_phyclk_sync             (phy_clk_sync),
        .i_vco8ph                  (vco8ph_clk),
        .i_pll_lock                (pll_lock),
        .o_core_clk_out            (core_clk_out),
        .o_lock                    (cpa_lock),
        .i_avl_clk                 (),
        .i_avl_rst_n               (),
        .i_avl_write               (),
        .i_avl_read                (),
        .i_avl_address             (),
        .i_avl_writedata           (),
        .o_avl_readdata            ()
    );

endmodule

