module lvds_bottom_intel_lvds_core10_ph2_191_hzh4hyq #(
   parameter hw_j_factor                                        = 0,
   parameter hw_rx_mode                                         = "",
   parameter enable_pll_2                                       = "",
   parameter enable_clkgen                                      = "",
   parameter tx_num_channels                                    = 0,
   parameter rx_num_channels                                    = 0,
   parameter tx_outclock_div_word                               = 0
) (
   input  logic            inclock,
   input  logic            pll_areset,
   output logic            coreclock,
   output logic            pll_locked,
   input  logic [15:0]     tx_in,
   output logic [3:0]      tx_out_p,
   output logic [3:0]      tx_out_n,
   output logic            tx_outclock_p,
   output logic            tx_outclock_n,
   input  logic [3:0]      rx_in_p,
   input  logic [3:0]      rx_in_n,
   output logic [15:0]     rx_out,
   input  logic [3:0]      rx_bitslip_reset,
   input  logic [3:0]      rx_bitslip_ctrl,
   output logic [3:0]      rx_bitslip_max,
   input  logic [3:0]      rx_dpa_reset,
   output logic [3:0]      rx_dpa_locked,
   input  logic [3:0]      rx_dpa_hold,
   input  logic [3:0]      rx_fifo_reset,
   output logic [3:0]      rx_divfwdclk,
   input  logic            ext_pll_locked,
   input  logic [1:0]      ext_outclock_periph,
   input  logic [7:0]      ext_phout,
   input  logic            ext_phout_periph,
   input  logic            ext_pll_1_outclock2,
   input  logic            ext_pll_locked_2,
   input  logic [7:0]      ext_phout_2
);
   timeunit 1ns;
   timeprecision 1ps;

   intel_lvds_core10_ph2_lvds_bottom_intel_lvds_core10_ph2_191_hzh4hyq # (
      .hw_j_factor (hw_j_factor),
      .hw_rx_mode (hw_rx_mode),
      .enable_pll_2 (enable_pll_2),
      .enable_clkgen (enable_clkgen),
      .tx_num_channels (tx_num_channels),
      .rx_num_channels (rx_num_channels),
      .tx_outclock_div_word (tx_outclock_div_word)
   ) arch_inst (
      .inclock (inclock),
      .pll_areset (pll_areset),
      .coreclock (coreclock),
      .pll_locked (pll_locked),
      .tx_in (tx_in),
      .tx_out_p (tx_out_p),
      .tx_out_n (tx_out_n),
      .tx_outclock_p (tx_outclock_p),
      .tx_outclock_n (tx_outclock_n),
      .rx_in_p (rx_in_p),
      .rx_in_n (rx_in_n),
      .rx_out (rx_out),
      .rx_bitslip_reset (rx_bitslip_reset),
      .rx_bitslip_ctrl (rx_bitslip_ctrl),
      .rx_bitslip_max (rx_bitslip_max),
      .rx_dpa_reset (rx_dpa_reset),
      .rx_dpa_locked (rx_dpa_locked),
      .rx_dpa_hold (rx_dpa_hold),
      .rx_fifo_reset (rx_fifo_reset),
      .rx_divfwdclk (rx_divfwdclk),
      .ext_pll_locked (ext_pll_locked),
      .ext_outclock_periph (ext_outclock_periph),
      .ext_phout (ext_phout),
      .ext_phout_periph (ext_phout_periph),
      .ext_pll_1_outclock2 (ext_pll_1_outclock2),
      .ext_pll_locked_2 (ext_pll_locked_2),
      .ext_phout_2 (ext_phout_2)
   );
endmodule
