// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps

////////////////////////////////////////////////////////////////
////LVDS SERDES COMMON MODULES               //
////////////////////////////////////////////////////////////////
module reset_synchronizer_active_high
#(
   parameter RESET_SYNC_LENGTH = 2
) (
   input async_reset,
   input clock,
   output sync_reset
);
    wire reset_n = ~async_reset;
    altera_std_synchronizer_nocut #(.depth(RESET_SYNC_LENGTH), .rst_value(1)) sync_inst (
        .clk(clock), 
        .reset_n(reset_n), 
        .din(1'b0), 
        .dout(sync_reset)
    );
endmodule

module data_synchronizer
#(
    parameter SYNC_LENGTH = 2
) (
    input data_in,
    input clock,
    input reset,
    output data_out
);
    wire reset_n = ~reset;
    altera_std_synchronizer_nocut #(.depth(SYNC_LENGTH)) sync_inst (
        .clk(clock), 
        .reset_n(reset_n), 
        .din(data_in), 
        .dout(data_out)
    );
endmodule


module reset_sync_w_lock
#(
    parameter RESET_SYNC_STAGES = 4
) (
    input pll_areset,
    input pll_locked,
    input clock,
    output sync_reset
);
    wire reset_n;

    (* altera_attribute = {"-name SYNCHRONIZER_IDENTIFICATION FORCED_IF_ASYNCHRONOUS; -name GLOBAL_SIGNAL OFF"}*) reg [RESET_SYNC_STAGES-1:0] reset_reg /*synthesis dont_merge */;

    assign reset_n = ~pll_areset & pll_locked;
    assign sync_reset = reset_reg[RESET_SYNC_STAGES-1];

    always @(posedge clock or negedge reset_n)
    begin
        if (~reset_n)
            reset_reg <= {RESET_SYNC_STAGES{1'b1}};
        else
            reset_reg <= {reset_reg[RESET_SYNC_STAGES-2:0], 1'b0};
    end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "3Q4EM+7fNfxThUeWE4rX6i969NDKX9whVonXgq6bnDSjn/sk/Ww3vyXRsAoKrKoHmcvc9kkG3TURhKyJPxX3UGteRYpOF+xfuPORdT7o9pm0238VtFrkga4Z5og5QQHxagMxhovuWt+mCiu4KG9jLmas9FhWnyHvoLwHNdtesvagBLYp/+XdSgeKR03gOpDBjOe3mgkEtOyZJXsEjNqF2kX/Ba6Sy+Qy3OhdzKDoPxor3o3wLnMFlIJ8KHNbMGHZHTLgrGHkIp/oQdkAbwqUfJkfCrBCEyTJe6106yYdJVeAtn2T09J5DqJbHWJn3sIv5Hmw0bNTjt5NZVNJfa313j6eXlrSUveHm3f0gI2w5wguaIhtrmomw5TsoQ6/bHALcW/KImIU8REptw1UyoeIGPwI3wEwT2+lUUs6XO4IWI4MF2muaawBfpjuPKabauo20FRgD49rOGEpWP7aWB/NG8k2Zmnk6JnlAUPwXGpfeLDU8RknL00qZPOgQT+Fs4tCs8h2UBZYXb5ybiKZRNXQmOpO5Iah4YqzHujF3tcl0ovh3LJUC1Lyaz2LUETlvaU7V6GS7jXyY6OD0e4YjpWLGvRgapyK73pyR/KnyWM3CMg+pt76WC8CTHV/Z6GlNjG/4N1KDqwX0tqya/v76pBzPCEcAX2JvY83cQHFKTHD16sthW/0qJBUOFyIVOBeXbFxYOixgumYecm54+UDZG3yVIyZsVumJL79jtaDVtgjHvPLidk3OXXRH+K7ptFSgx7YWQJyt37OMrN4DyHX9mWY6WV/tmYeaFtKyFH9loK0qT0f/87I1GVz11iC40Jvp9ZaRBWJqqsgZL6oelpiUKmFkUIDOfmSlH14/A6vbgsLbzRNKURvUpJ2RBkMuK2d7pKnAqw0hk3ChNpjXzg5qfS+5lLHchpC+ECYF0F4z8zMjSuzcyhv9eK4I0yxQwDhOljPIA3aFu0GXnEzG70V/YdCAB2ZSqyJ26rRU5rlMLKNZxCPR0hyEX4G9qRRNqgCT4On"
`endif