// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Sep 11 11:27:23 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_LPDDR4C
//`define ENABLE_HPS
//`define ENABLE_SLVS
//`define ENABLE_ENET
//`define ENABLE_PCIE
//`define ENABLE_QSFP
//`define ENABLE_CAM1
//`define ENABLE_CAM2
//`define ENABLE_GTSL1A
//`define ENABLE_GTSL1B
//`define ENABLE_GTSL1C
//`define ENABLE_GTSR4A
//`define ENABLE_GTSR4C

//`define ENABLE_QTH_LVDS_TOP
`define ENABLE_QTH_LVDS_BOTTOM



module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_p,
		//input              CLK_100_BOTTOM_p,
      input              CLK_50_B5B,
      input              CLK_50_B6A,
      input              CLK_50_B6C,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active
      input              BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active
      output             LED, //LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_LPDDR4C
      ///////// LPDDR4C /////////
      input              LPDDR4C_REFCLK_p,
      output             LPDDR4C_CS_n,
      output   [ 5: 0]   LPDDR4C_CA,
      output             LPDDR4C_CK,
      output             LPDDR4C_CKE,
      output             LPDDR4C_CK_n,
      inout    [ 3: 0]   LPDDR4C_DM,
      inout    [31: 0]   LPDDR4C_DQ,
      inout    [ 3: 0]   LPDDR4C_DQS,
      inout    [ 3: 0]   LPDDR4C_DQS_n,
      output             LPDDR4C_RESET_n,
      input              LPDDR4C_RZQ,
`endif /*ENABLE_LPDDR4C*/

//      ///////// HDMI /////////
//      inout              DDC_I2C_SCL,
//      inout              DDC_I2C_SDA,
//      inout              HDMI_I2C_SCL,
//      inout              HDMI_I2C_SDA,
//      output             HDMI_TX_HS,
//      output             HDMI_TX_VS,
//      output   [23: 0]   HDMI_TX_D,
//      output             HDMI_TX_DE,
//      output             HDMI_TX_CLK_p,
//      output             HDMI_EDGE_HPD,
//      output             HDMI_ISEL,
//      output             HDMI_PD_n,

`ifdef ENABLE_SLVS
      ///////// SLVS /////////
      input    [ 7: 0]   SLVS_EC_RX_p,
      input    [ 7: 0]   SLVS_EC_RX_n,
      input              SLVS_EC_SDO,
      input              SLVS_EC_REFCLK_p, //J1_GTSL1A_REFCLK_p
      output             SLVS_EC_INCK_OE,
      output             SLVS_EC_OMODE,
      inout              SLVS_EC_SCK_SCL,
      inout              SLVS_EC_SDI_SDA,
      input              SLVS_EC_SENSOR_PGOOD,
      output             SLVS_EC_SENSOR_PON,
      output             SLVS_EC_XCE,
      output             SLVS_EC_XCLR,
      output             SLVS_EC_XHS,
      output             SLVS_EC_XMASTER,
      output   [ 2: 1]   SLVS_EC_XTRIG,
      output             SLVS_EC_XVS,
`endif /*ENABLE_SLVS*/

`ifdef ENABLE_ENET
      ///////// ENET /////////
      output             ENET_88E2110_TX_p,
      output             ENET_88E2110_TX_n,
      input              ENET_88E2110_RX_p,
      input              ENET_88E2110_RX_n,
      input              ENET_88E2110_REFCLK_125M_p, //GTSL1C_REFCLK_125M_p
      input              ENET_88E2110_INT_n,
      output             ENET_88E2110_MDC,
      inout              ENET_88E2110_MDIO,
      output             ENET_88E2110_RESET_n,
`endif /*ENABLE_ENET*/

      ///////// SI5332B /////////
      inout              SI5332B_I2C_SCL,
      inout              SI5332B_I2C_SDA,

      ///////// SI5340B /////////
      inout              SI5340B_I2C_SCL,
      inout              SI5340B_I2C_SDA,
      output             SI5340B_OE_n,
      output             SI5340B_RST_n,

      ///////// SI564 /////////
      inout              SI564_SCL,
      inout              SI564_SDA,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

      ///////// SMA /////////
      input              SMA_CLKIN_p,

//      ///////// QTH /////////
////      inout    [15: 0]   QTH_30_p,
////      inout    [15: 0]   QTH_30_n,
////      inout    [ 3: 0]   QTH_30_D,


		
`ifdef ENABLE_QTH_LVDS_TOP			
		output				LVDS_TX_p0,
		output				LVDS_TX_p2,
		output				LVDS_TX_p5,
		output				LVDS_TX_p6,
		output				LVDS_TX_n0,
		output				LVDS_TX_n2,
		output				LVDS_TX_n5,
		output				LVDS_TX_n6,
		
		input				LVDS_RX_p0,
		input				LVDS_RX_p2,
		input				LVDS_RX_p5,
		input				LVDS_RX_p6,
		input				LVDS_RX_n0,
		input				LVDS_RX_n2,
		input				LVDS_RX_n5,
		input				LVDS_RX_n6,		
`endif  //ENABLE_QTH_LVDS_TOP		

`ifdef ENABLE_QTH_LVDS_BOTTOM			
		output				LVDS_TX_p1,
		output				LVDS_TX_p3,
		output				LVDS_TX_p4,
		output				LVDS_TX_p7,
		output				LVDS_TX_n1,
		output				LVDS_TX_n3,
		output				LVDS_TX_n4,
		output				LVDS_TX_n7,
		
		input				LVDS_RX_p1,
		input				LVDS_RX_p3,
		input				LVDS_RX_p4,
		input				LVDS_RX_p7,
		input				LVDS_RX_n1,
		input				LVDS_RX_n3,
		input				LVDS_RX_n4,
		input				LVDS_RX_n7,		
`endif  //ENABLE_QTH_LVDS_TOP		
	

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 3: 0]   PCIE_TX_p,
      output   [ 3: 0]   PCIE_TX_n,
      input    [ 3: 0]   PCIE_RX_p,
      input    [ 3: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p, //J2_GTSR4A_REFCLK_p
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP
      ///////// QSFP /////////
      output   [ 3: 0]   QSFP_TX_p,
      output   [ 3: 0]   QSFP_TX_n,
      input    [ 3: 0]   QSFP_RX_p,
      input    [ 3: 0]   QSFP_RX_n,
      input              CIPRI_REFCLK_p, //GTSR4B_REFCLK_184M32_p
      input              QSFP_REFCLK_p, //GTSR4B_REFCLK_156M25_p
      input              QSFP_INTERRUPT_n,
      output             QSFP_LP_MODE,
      input              QSFP_MOD_PRS_n,
      output             QSFP_MOD_SEL_n,
      output             QSFP_RST_n,
      inout              QSFP_SCL,
      inout              QSFP_SDA,
`endif /*ENABLE_QSFP*/

      ///////// CAM /////////
//      input              CAM_RZQ1, //RZQ_B_2A_T

`ifdef ENABLE_CAM1
      ///////// CAM1 /////////
      input              CAM1_CLK_p,
      input              CAM1_CLK_n,
      input    [ 3: 0]   CAM1_D_p,
      input    [ 3: 0]   CAM1_D_n,
      inout              CAM1_I2C_SCL,
      inout              CAM1_I2C_SDA,
      inout              CAM1_GPIO,
`endif /*ENABLE_CAM1*/

`ifdef ENABLE_CAM2
      ///////// CAM2 /////////
      input              CAM2_CLK_p,
      input              CAM2_CLK_n,
      input    [ 3: 0]   CAM2_D_p,
      input    [ 3: 0]   CAM2_D_n,
      inout              CAM2_I2C_SCL,
      inout              CAM2_I2C_SDA,
      inout              CAM2_GPIO,
`endif /*ENABLE_CAM2*/

`ifdef ENABLE_GTSL1A
      ///////// GTSL1A /////////
      input              GTSL1A_REFCLK_100M_p,
`endif /*ENABLE_GTSL1A*/

`ifdef ENABLE_GTSL1B
      ///////// GTSL1B /////////
      input              GTSL1B_REFCLK_156M25_p,
`endif /*ENABLE_GTSL1B*/

`ifdef ENABLE_GTSL1C
      ///////// GTSL1C /////////
      input              GTSL1C_REFCLK_100M_p,
`endif /*ENABLE_GTSL1C*/

`ifdef ENABLE_GTSR4A
      ///////// GTSR4A /////////
      input              GTSR4A_REFCLK_148M5_p,
`endif /*ENABLE_GTSR4A*/

`ifdef ENABLE_GTSR4C
      ///////// GTSR4C /////////
      input              GTSR4C_REFCLK_100M_p,
`endif /*ENABLE_GTSR4C*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_13, //reserved for vendor test
      inout              HPS_IOB_14, //reserved for vendor test
      inout              HPS_IOB_19, //reserved for vendor test
      inout              HPS_IOB_20, //reserved for vendor test
      inout              HPS_IOB_21, //reserved for vendor test
      inout              HPS_IOB_22, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout              HPS_LED,
      inout              HPS_LED2,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

assign SI5340B_OE_n = 1'bZ;
assign SI5340B_RST_n = 1'bZ;



//=======================================================
//  Structural coding
//=======================================================
//---heart
wire HZ ;
CLOCKMEM u_CLOCKMEM( .reset(0),.CLK(CLK_100_p) ,.CLK_FREQ(100_000000) ,.CK_1HZ(HZ)    ) ;

//--init reset_release
	wire ninit_done;
	wire reset_n;
	
	reset_release reset_release_inst (
		.ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
	);
	
	assign reset_n = ~ninit_done;

//---long time reset delay	
wire JRESET_n ; 
RESET_DELY u_delay( 
   .BUTTON ( BUTTON & reset_n ), 
	.OSC    ( CLK_100_p), 
   .RESET_n( JRESET_n ) 
) ;
	
parameter TEST_pattern =16'h8421;	
//=======================================================
// LVDS Loopback - TOP SubBank

`ifdef ENABLE_QTH_LVDS_TOP	

	wire 			top_pll_areset;
	wire 			top_coreclock;
	wire 			top_pll_locked;
	wire [15:0]	top_tx_in;
	wire [15:0]	top_rx_out;
	wire 			top_rx_dpa_locked;
	
	wire [3:0]	top_tx_out_p;
	wire [3:0]	top_tx_out_n;
	wire [3:0]	top_rx_in_p;
	wire [3:0]	top_rx_in_n;
	wire [3:0]	rx_dpa_reset   ;
	wire [3:0]	rx_fifo_reset  ;
	wire [3:0]	rx_bitslip_ctrl;
   wire [3:0]	Alignment	   ;
	wire        fifo_dpa_reset ;
	wire        top_pass;
	
	
	assign top_rx_in_p = {LVDS_RX_p6,LVDS_RX_p5,LVDS_RX_p2,LVDS_RX_p0};
	assign top_rx_in_n = {LVDS_RX_n6,LVDS_RX_n5,LVDS_RX_n2,LVDS_RX_n0};
	
	
	assign {LVDS_TX_p6,LVDS_TX_p5,LVDS_TX_p2,LVDS_TX_p0} = top_tx_out_p;
	assign {LVDS_TX_n6,LVDS_TX_n5,LVDS_TX_n2,LVDS_TX_n0} = top_tx_out_n;	
	
//--sync reset
wire JRESET_NN;

altera_std_synchronizer #(
    .depth      (3)
) JRESET_sync (
    .clk        (CLK_100_p       ), 
    .reset_n    (1'b1            ),
    .din        (JRESET_n        ), 
    .dout       (JRESET_NN       )
);	
	
	assign top_pll_areset    = ~reset_n ;
	assign fifo_dpa_reset    = ~(JRESET_NN &  reset_n  );
	
	assign rx_dpa_reset ={4{fifo_dpa_reset}};
	assign rx_fifo_reset={4{fifo_dpa_reset}};

	assign top_tx_in =TEST_pattern ;
	
   //---bitslipcontroller 4bit 
   bitslip_controller_4bit u_bitslip_controller_4bit(
   /*input         */ .coreclock ( top_coreclock  ),
   /*input         */ .reset     (~top_pll_locked ), 
   /*input  [15:0] */ .tx_data   ( top_tx_in      ),
	/*input  [15:0] */ .rx_data   ( top_rx_out     ),
   /*output [3:0]  */ .bitslip   ( rx_bitslip_ctrl),
	/*output [3:0]  */ .Alignment ( Alignment      )
	
   );	

	lvds_top lvds_top_inst (
		.inclock       (CLK_100_p     ),       //   input,   width = 1,       inclock.export
		.pll_areset    (top_pll_areset),       //   input,   width = 1,    pll_areset.export
		.coreclock     (top_coreclock ),       //  output,   width = 1,     coreclock.export
		.pll_locked    (top_pll_locked),       //  output,   width = 1,    pll_locked.export
		.tx_in         (top_tx_in     ),       //   input,  width = 16,         tx_in.export
		.tx_out_p      (top_tx_out_p  ),       //  output,   width = 4,      tx_out_p.export
		.tx_out_n      (top_tx_out_n  ),       //  output,   width = 4,      tx_out_n.export
		.rx_in_p       (top_rx_in_p   ),       //   input,   width = 4,       rx_in_p.export
		.rx_in_n       (top_rx_in_n   ),       //   input,   width = 4,       rx_in_n.export
		.rx_out        (top_rx_out    ),        //  output,  width = 16,        rx_out.export
		.rx_dpa_locked () , //  output,   width = 4, rx_dpa_locked.export
		/*input  wire [3:0]*/  .rx_dpa_reset   ( rx_dpa_reset   ),  //  rx_dpa_reset.export, Asynchronous, active-high reset to DPA blocks. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO and soft-CDR modes only.
		/*input  wire [3:0]*/  .rx_fifo_reset  ( rx_fifo_reset  ),
		/*input  wire [3:0]*/  .rx_bitslip_ctrl( rx_bitslip_ctrl)		
		
	);
	
	assign top_pass = (top_rx_out == top_tx_in)?1'b1:1'b0;
	
	assign USER_LED = ~( top_pass & HZ);//LED blink pass
   assign LED      = ~&Alignment	;	   //LED light pass;
	

`endif //ENABLE_QTH_LVDS_TOP
	
//=======================================================
// LVDS Loopback - Bottom SubBank	

`ifdef ENABLE_QTH_LVDS_BOTTOM	
	
	wire 			bottom_pll_areset;
	wire 			bottom_coreclock;
	wire 			bottom_pll_locked;
	wire [15:0]	bottom_tx_in;
	wire [15:0]	bottom_rx_out;
	wire 			bottom_rx_dpa_locked;
	
	wire [3:0]	bottom_tx_out_p;
	wire [3:0]	bottom_tx_out_n;
	wire [3:0]	bottom_rx_in_p;
	wire [3:0]	bottom_rx_in_n;
	
	wire [3:0]	rx_dpa_reset ;
	wire [3:0]	rx_fifo_reset;
	wire [3:0]	rx_bitslip_ctrl;
   wire [3:0]	Alignment	   ;	
	wire        fifo_dpa_reset ;	
	wire        bottom_pass;
	
	
	assign bottom_rx_in_p = {LVDS_RX_p7,LVDS_RX_p4,LVDS_RX_p3,LVDS_RX_p1};
	assign bottom_rx_in_n = {LVDS_RX_n7,LVDS_RX_n4,LVDS_RX_n3,LVDS_RX_n1};
	
	
	assign {LVDS_TX_p7,LVDS_TX_p4,LVDS_TX_p3,LVDS_TX_p1} = bottom_tx_out_p;
	assign {LVDS_TX_n7,LVDS_TX_n4,LVDS_TX_n3,LVDS_TX_n1} = bottom_tx_out_n;	
	
//--sync reset
wire JRESET_NN;

altera_std_synchronizer #(
    .depth      (3)
) JRESET_sync (
    .clk        (CLK_100_p       ), 
    .reset_n    (1'b1            ),
    .din        (JRESET_n        ), 
    .dout       (JRESET_NN       )
);
	
		
	assign bottom_pll_areset = ~reset_n;
	assign fifo_dpa_reset    = ~(JRESET_NN &  reset_n  );
	
	assign rx_dpa_reset ={4{fifo_dpa_reset}};
	assign rx_fifo_reset={4{fifo_dpa_reset}};
	
	assign bottom_tx_in =TEST_pattern;
   //---bitslipcontroller 4bit 
   bitslip_controller_4bit u_bitslip_controller_4bit(
   /*input         */ .coreclock ( bottom_coreclock  ),
   /*input         */ .reset     (~bottom_pll_locked ), 
   /*input  [15:0] */ .tx_data   ( bottom_tx_in      ),
	/*input  [15:0] */ .rx_data   ( bottom_rx_out     ),
   /*output [3:0]  */ .bitslip   ( rx_bitslip_ctrl   ),
	/*output [3:0]  */ .Alignment ( Alignment         )
  );
	
	lvds_bottom lvds_bottom_inst (
		.inclock       ( CLK_100_p       ),       //   input,   width = 1,       inclock.export
		.pll_areset    ( bottom_pll_areset),    //   input,   width = 1,    pll_areset.export
		.coreclock     (bottom_coreclock ),     //  output,   width = 1,     coreclock.export
		.pll_locked    (bottom_pll_locked),    //  output,   width = 1,    pll_locked.export
		.tx_in         (bottom_tx_in),         //   input,  width = 16,         tx_in.export
		.tx_out_p      (bottom_tx_out_p),      //  output,   width = 4,      tx_out_p.export
		.tx_out_n      (bottom_tx_out_n),      //  output,   width = 4,      tx_out_n.export
		.rx_in_p       (bottom_rx_in_p),       //   input,   width = 4,       rx_in_p.export
		.rx_in_n       (bottom_rx_in_n),       //   input,   width = 4,       rx_in_n.export
		.rx_out        (bottom_rx_out),        //  output,  width = 16,        rx_out.export
		.rx_dpa_locked (),  //  output,   width = 4, rx_dpa_locked.export
		/*input  wire [3:0]*/  .rx_dpa_reset (rx_dpa_reset ),  //  rx_dpa_reset.export, Asynchronous, active-high reset to DPA blocks. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO and soft-CDR modes only.
		/*input  wire [3:0]*/  .rx_fifo_reset(rx_fifo_reset),
		/*input  wire [3:0]*/  .rx_bitslip_ctrl(rx_bitslip_ctrl)
		
		
	);	
	
	assign bottom_pass = (bottom_rx_out == bottom_tx_in)?1'b1:1'b0;
	
	assign USER_LED    = ~(bottom_pass & HZ ) ;//LED blink pass
   assign LED         = ~&Alignment	  ;       //LED light pass;
	
`endif //ENABLE_QTH_LVDS_BOTTOM



endmodule
