module bitslip_controller_4bit (
input  coreclock ,
input  reset , 
input       [15:0] tx_data ,
input       [15:0] rx_data ,
output      [3:0]  bitslip ,
output      [3:0]  Alignment 
);


//---bitslip[0]
bitslip_controller u_bitslip_controller0(
	/*input      */ .coreclock (coreclock ),
	/*input      */ .reset     (reset     ),
	/*input [3:0]*/ .tx_data   (tx_data[1*4-1:0*4]  ),
	/*input [3:0]*/ .rx_data   (rx_data[1*4-1:0*4]  ),
	/*output reg */ .bitslip   (bitslip[0] ),
   /*output reg */ .Alignment	(Alignment[0])
);	

//---bitslip[1]
bitslip_controller u_bitslip_controller1(
	/*input      */ .coreclock (coreclock),
	/*input      */ .reset     (reset    ),
	/*input [3:0]*/ .tx_data   (tx_data[2*4-1:1*4]  ),
	/*input [3:0]*/ .rx_data   (rx_data[2*4-1:1*4]  ),
	/*output reg */ .bitslip   (bitslip[1] )	,
   /*output reg */ .Alignment	(Alignment[1])
	
);	

//---bitslip[2]
bitslip_controller u_bitslip_controller2(
	/*input      */ .coreclock (coreclock),
	/*input      */ .reset     (reset    ),
	/*input [3:0]*/ .tx_data   (tx_data[3*4-1:2*4]  ),
	/*input [3:0]*/ .rx_data   (rx_data[3*4-1:2*4]  ),
	/*output reg */ .bitslip   (bitslip[2] )	,
   /*output reg */ .Alignment	(Alignment[2])
	
);	
//---bitslip[3]
bitslip_controller u_bitslip_controller3(
	/*input      */ .coreclock (coreclock),
	/*input      */ .reset     (reset    ),
	/*input [3:0]*/ .tx_data   (tx_data[4*4-1:3*4]  ),
	/*input [3:0]*/ .rx_data   (rx_data[4*4-1:3*4]  ),
	/*output reg */ .bitslip   (bitslip[3] )	,
	/*output reg */ .Alignment	(Alignment[3])

);
endmodule
