// PCIE_FUNDAMENTAL.cpp : Defines the entry point for the console application.
//
#include <stdio.h>
#include <stdlib.h>
#include "TERASIC_PCIE_MCDMA.h"

#define DEMO_PCIE_USER_BAR			PCIE_BAR2
#define DEMO_PCIE_IO_LED_ADDR		0x800000
#define DEMO_PCIE_IO_BUTTON_ADDR	0x800040
#define DEMO_PCIE_MEM_ADDR			0x100000

#define MEM_SIZE					(512*1024) //512KB

typedef enum {
	MENU_LED = 0,
	MENU_BUTTON,
	MENU_LINK_INFO,
	MENU_DMA_MEMORY,
	MENU_QUIT = 99
} MENU_ID;

void UI_ShowMenu(void)
{
	printf("==============================\n");
	printf("[%d]: Led control\n", MENU_LED);
	printf("[%d]: Button Status Read\n", MENU_BUTTON);
	printf("[%d]: LInk Information\n", MENU_LINK_INFO);
	printf("[%d]: DMA Memory Test\n", MENU_DMA_MEMORY);
	printf("[%d]: Quit\n", MENU_QUIT);
	printf("Plesae input your selection:");
}

int UI_UserSelect(void)
{
	int nSel;
	scanf("%d", &nSel);
	return nSel;
}

bool TEST_LED(PCIE_HANDLE hPCIe)
{
	bool bPass;
	int Mask;

	printf("Please input led conrol mask:");
	scanf("%d", &Mask);

	bPass = PCIE_Write32(hPCIe, DEMO_PCIE_USER_BAR, DEMO_PCIE_IO_LED_ADDR,
		(uint32_t) Mask);
	if (bPass)
		printf("Led control success, mask=%xh\n", Mask);
	else
		printf("Led conrol failed\n");

	return bPass;
}

bool TEST_BUTTON(PCIE_HANDLE hPCIe)
{
	bool bPass = true;
	uint32_t Status;

	bPass = PCIE_Read32(hPCIe, DEMO_PCIE_USER_BAR, DEMO_PCIE_IO_BUTTON_ADDR,
		&Status);
	if (bPass)
		printf("Button status mask:=%xh\n", Status);
	else
		printf("Failed to read button status\n");

	return bPass;
}

bool TEST_LINK_INFO(PCIE_HANDLE hPCIe)
{
	bool bPass = true;
	uint32_t Data32;

	// read config - id
	if (PCIE_ConfigRead32(hPCIe, 0x00, &Data32)) {
		printf("Vender ID:%04Xh\n", Data32 & 0xFFFF);
		printf("Device ID:%04Xh\n", (Data32 >> 16) & 0xFFFF);
	} else {
		bPass = false;
	}

	// read config - link status
	if (PCIE_ConfigRead32(hPCIe, 0x80, &Data32)) {
		switch ((Data32 >> 16) & 0x0F) {
		case 1:
			printf("Current Link Speed is Gen1\n");
			break;
		case 2:
			printf("Current Link Speed is Gen2\n");
			break;
		case 3:
			printf("Current Link Speed is Gen3\n");
			break;
		case 4:
			printf("Current Link Speed is Gen4\n");
			break;
		default:
			printf("Current Link Speed is Unknown\n");
			break;
		}
		switch ((Data32 >> 20) & 0x3F) {
		case 1:
			printf("Negotiated Link Width is x1\n");
			break;
		case 2:
			printf("Negotiated Link Width is x2\n");
			break;
		case 4:
			printf("Negotiated Link Width is x4\n");
			break;
		case 8:
			printf("Negotiated Link Width is x8\n");
			break;
		case 16:
			printf("Negotiated Link Width is x16\n");
			break;
		default:
			printf("Negotiated Link Width is Unknown\n");
			break;
		}
	} else {
		bPass = false;
	}

	// read config - id
	if (PCIE_ConfigRead32(hPCIe, 0x78, &Data32)) {
		switch ((Data32 >> 5) & 0x0007) {
		case 0:
			printf("Maximum Payload Size is 128-byte\n");
			break;
		case 1:
			printf("Maximum Payload Size is 256-byte\n");
			break;
		case 2:
			printf("Maximum Payload Size is 512-byte\n");
			break;
		case 3:
			printf("Maximum Payload Size is 1024-byte\n");
			break;
		case 4:
			printf("Maximum Payload Size is 2048-byte\n");
			break;
		default:
			printf("Maximum Payload Size is Unknown\n");
			break;
		}
	} else {
		bPass = false;
	}

	return bPass;
}

char PAT_GEN(uint32_t nIndex)
{
	char Data;
	Data = nIndex & 0xFF;
	return Data;
}

bool TEST_DMA_MEMORY(PCIE_HANDLE hPCIe)
{
	bool bPass = true;
	size_t i;
	const int nTestSize = MEM_SIZE;
	const PCIE_LOCAL_ADDRESS LocalAddr = DEMO_PCIE_MEM_ADDR;
	char *pWrite;
	char *pRead;
	char szError[256];

	pWrite = (char *) malloc(nTestSize);
	pRead = (char *) malloc(nTestSize);
	if (!pWrite || !pRead) {
		bPass = false;
		sprintf(szError, "DMA Memory:malloc failed\n");
	}

	// init test pattern
	for (i = 0; i < nTestSize && bPass; i++)
		*(pWrite + i) = PAT_GEN(uint32_t(i));

	// write test pattern
	if (bPass) {
		bPass = PCIE_DmaWrite(hPCIe, LocalAddr, pWrite, nTestSize);
		if (!bPass)
			sprintf(szError, "DMA Memory:PCIE_DmaWrite failed\n");
	}

	// read back test pattern and verify
	if (bPass) {
		bPass = PCIE_DmaRead(hPCIe, LocalAddr, pRead, nTestSize);

		if (!bPass) {
			sprintf(szError, "DMA Memory:PCIE_DmaRead failed\n");
		} else {
			for (i = 0; i < nTestSize && bPass; i++) {
				if (*(pRead + i) != PAT_GEN(uint32_t(i))) {
					bPass = false;
                    sprintf(szError,
                        "DMA Memory:Read-back verify unmatch, index = %lld, read=%xh, expected=%xh\n",
                        i, *(pRead + i), PAT_GEN(uint32_t(i)));
				}
			}
		}
	}

	if (!bPass)
		printf("%s", szError);
	else
		printf("DMA-Memory (Size = %d byes) pass\n", nTestSize);

	// free resource
	if (pWrite)
		free(pWrite);
	if (pRead)
		free(pRead);

	return bPass;
}

int main(int argc, char* argv[])
{
	PCIE_HANDLE hPCIE;
	bool bQuit = false;
	int nSel;

	printf("== Terasic: PCIe Demo Program ==\n");

	hPCIE = PCIE_Open(DEFAULT_PCIE_VID, DEFAULT_PCIE_DID, 0, 0, 0);
	if (!hPCIE) {
		printf("PCIE_Open failed\n");
	} else {
		while (!bQuit) {
			UI_ShowMenu();
			nSel = UI_UserSelect();
			switch (nSel) {
			case MENU_LED:
				TEST_LED(hPCIE);
				break;
			case MENU_BUTTON:
				TEST_BUTTON(hPCIE);
				break;
			case MENU_LINK_INFO:
				TEST_LINK_INFO(hPCIE);
				break;
			case MENU_DMA_MEMORY:
				TEST_DMA_MEMORY(hPCIE);
				break;
			case MENU_QUIT:
				bQuit = true;
				printf("Bye!\n");
				break;
			default:
				printf("Invalid selection\n");
			} // switch

		} // while

		PCIE_Close(hPCIE);

	}

	return 0;

}

