// pcie_ed_dut.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module pcie_ed_dut (
		input  wire         refclk0,                        //                      refclk0.clk,                      Input reference clock for IP core.
		input  wire         p0_i_syspll_c0_clk,             //           p0_i_syspll_c0_clk.clk,                      System PLL clock input c0 port.
		input  wire         p0_i_ss_vccl_syspll_locked,     //   p0_i_ss_vccl_syspll_locked.o_pll_lock,               System PLL locked signal
		input  wire [0:0]   i_flux_clk,                     //                   i_flux_clk.clk,                      Check User Guide for details
		input  wire         rx_n_in0,                       //                   hip_serial.rx_n_in0,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in0,                       //                             .rx_p_in0,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out0,                      //                             .tx_n_out0,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out0,                      //                             .tx_p_out0,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in1,                       //                             .rx_n_in1,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in1,                       //                             .rx_p_in1,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out1,                      //                             .tx_n_out1,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out1,                      //                             .tx_p_out1,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in2,                       //                             .rx_n_in2,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in2,                       //                             .rx_p_in2,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out2,                      //                             .tx_n_out2,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out2,                      //                             .tx_p_out2,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in3,                       //                             .rx_n_in3,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in3,                       //                             .rx_p_in3,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out3,                      //                             .tx_n_out3,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out3,                      //                             .tx_p_out3,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As itÃ-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         p0_pin_perst_n_i,               //             p0_pin_perst_n_i.reset_n,                  This is an active-low input to PCIe Hard IP for PERST# function defined by PCIe specification
		input  wire         p0_pin_perst_n_1_i,             //           p0_pin_perst_n_1_i.reset_n,                  This is an active-low input to PCIe Hard IP for PERST# function defined by PCIe specification
		output wire         p0_coreclkout_hip_toapp,        //      p0_coreclkout_hip_toapp.clk,                      This clock drives the PLD interface layer. Clock freq depends on datarate and number of lanes being use. Gen3 : 250Mhz. Gen4 : 350Mhz to 500Mhz.
		output wire         p0_pin_perst_n,                 //               p0_pin_perst_n.reset_n,                  PERST0 status indication for port 0. User shall expect this as async signal.
		output wire         p0_reset_status_n,              //            p0_reset_status_n.reset_n,                  The active low signal, when low indicates pin perstn is deasserted and HARD IP is in reset state. The application logic can use this signal to drive its reset network. The reset_status_n output of HIP drives this signal. The signal is synchronous to coreclkout_hip of Hard IP.
		input  wire         ninit_done,                     //                   ninit_done.reset,                    From "Reset Release IP". A "1" on this active-low signal indicates that the FPGA device is not yet fully configured. A "0" indicates the device has been configured and is in normal operating mode.
		input  wire         p0_axi_st_clk,                  //                p0_axi_st_clk.clk,                      This clock is an input to the SM PCI QHIP, it can be synchronous with coreclkout_hip or async with slower frequency.
		input  wire         p0_axi_lite_clk,                //              p0_axi_lite_clk.clk,                      This clock is an input to the SM PCI QHIP, it can be synchronous with coreclkout_hip or async with slower frequency.
		input  wire         p0_axi_st_areset_n,             //           p0_axi_st_areset_n.reset_n,                  AXI-Streaming main datapath reset. Active-LOW reset signal. The reset signal can be asserted asynchronously, but deassertion must be synchronous after the rising edge of axi_st_clk.
		input  wire         p0_axi_lite_areset_n,           //         p0_axi_lite_areset_n.reset_n,                  AXI-Lite reset. Active-LOW reset signal. The reset signal can be asserted asynchronously, but deassertion must be synchronous after the rising edge of axi_lite_clk.
		input  wire         p0_subsystem_cold_rst_n,        //      p0_subsystem_cold_rst_n.reset_n,                  Subsystem global reset. Resets sticky register bits. Active low. Could be implemented as synchronous or asynchronous reset.
		input  wire         p0_subsystem_warm_rst_n,        //      p0_subsystem_warm_rst_n.reset_n,                  Subsystem warm reset. Does not reset sticky register bits. Active low. Could be implemented as synchronous or asynchronous reset.
		output wire         p0_subsystem_cold_rst_ack_n,    //  p0_subsystem_cold_rst_ack_n.subsystem_cold_rst_ack_n, Indicates cold reset action is completed by subsystem.
		output wire         p0_subsystem_warm_rst_ack_n,    //  p0_subsystem_warm_rst_ack_n.subsystem_warm_rst_ack_n, Indicates warm reset action is completed by subsystem.
		input  wire         p0_subsystem_rst_req,           //         p0_subsystem_rst_req.subsystem_rst_req,        Reset entry indication from Central Reset Sequencer block in SOC. Subsystem quiesces the blocks in design upon receiving this request and sends acknowledgement back when block is ready for reset entry.
		output wire         p0_subsystem_rst_rdy,           //         p0_subsystem_rst_rdy.subsystem_rst_rdy,        Ready for reset entry indication from Subsystem to Central Reset Sequencer block.
		output wire         p0_initiate_warmrst_req,        //      p0_initiate_warmrst_req.initiate_warmrst_req,     Reset entry required indication from SIP SRC block to Central Reset Sequencer. Initiator block cannot issue new reset entry request until previous reset sequence (entire reset operation) is completed.
		input  wire         p0_initiate_rst_req_rdy,        //      p0_initiate_rst_req_rdy.initiate_rst_req_rdy,     Indicates Central Reset Sequencer block has accepted initiation request and will start issuing resets.
		output wire         p0_ss_app_st_rx_tvalid,         //                     p0_st_rx.tvalid,                   ss_app_st_rx_tvalid indicates that the source is driving a valid transfer.
		input  wire         p0_app_ss_st_rx_tready,         //                             .tready,                   app_ss_st_rx_tready indicates that the sink can accept a transfer in the current cycle. readyLatency parameter defined in AXI HAS spec shall be supported. By default the value is '0'.
		output wire [255:0] p0_ss_app_st_rx_tdata,          //                             .tdata,                    Data interface with configurable width specified by DWIDTH_SEG*NUM_OF_SEG parameter. Default DWIDTH = DWIDTH_SEG*NUM_OF_SEG= 1024. For Sideband header type: tdata carries only payload. For In-band header type, tdata carries header followed by payload.
		output wire [31:0]  p0_ss_app_st_rx_tkeep,          //                             .tkeep,                    A byte qualifier used to indicate whether the content of the associated byte is valid. The invalid bytes are allowed only during ss_app_st_tx_tlast cycle.
		output wire         p0_ss_app_st_rx_tlast,          //                             .tlast,                    Indicates End of Data/Command Transmission, tlast may seem redundant with tuser.last_segment. But tlast can be used by the front-end layer of AXI BFM/routing fabric that doesnÃ-t deal with decoding of the multipacket data.
		output wire [255:0] p0_ss_app_st_rx_tuser_hdr,      //    p0_ss_app_st_rx_tuser_hdr.st_rx_tuser_hdr,          Header interface: Only applicable when Sideband Header is enabled
		output wire         p0_ss_app_st_rx_tuser_hvalid,   // p0_ss_app_st_rx_tuser_hvalid.st_rx_tuser_hvalid,       Indicates that the source is driving a valid Header transfer: Only applicable when Sideband Header is enabled
		input  wire         p0_app_ss_st_tx_tvalid,         //                     p0_st_tx.tvalid,                   app_ss_st_tx_tvalid indicates that the source is driving a valid transfer.
		output wire         p0_ss_app_st_tx_tready,         //                             .tready,                   ss_app_axi_st_tx_tready indicates that the sink can accept a transfer in the current cycle. readyLatency parameter defined in AXI HAS spec shall be supported. By default the value is '0'.
		input  wire [255:0] p0_app_ss_st_tx_tdata,          //                             .tdata,                    Data interface with configurable width specified by DWIDTH_SEG*NUM_OF_SEG parameter. Default DWIDTH = DWIDTH_SEG*NUM_OF_SEG= 1024. For Sideband header type: tdata carries only payload. For In-band header type, tdata carries header followed by payload.
		input  wire [31:0]  p0_app_ss_st_tx_tkeep,          //                             .tkeep,                    A byte qualifier used to indicate whether the content of the associated byte is valid. The invalid bytes are allowed only during app_axi_st_tx_tlast cycle.
		input  wire         p0_app_ss_st_tx_tlast,          //                             .tlast,                    Indicates End of Data/Command Transmission.
		input  wire [255:0] p0_app_ss_st_tx_tuser_hdr,      //    p0_app_ss_st_tx_tuser_hdr.st_tx_tuser_hdr,          Header interface: Only applicable when Sideband Header is enabled
		input  wire         p0_app_ss_st_tx_tuser_hvalid,   // p0_app_ss_st_tx_tuser_hvalid.st_tx_tuser_hvalid,       Indicates that the source is driving a valid Header transfer: Only applicable when Sideband Header is enabled
		output wire         p0_ss_app_st_ciireq_tvalid,     //                 p0_st_ciireq.tvalid,                   When asserted, indicates a valid CFG request cycle is waiting to be intercepted. De-asserted when app_ss_st_ciireq_tready is asserted.
		input  wire         p0_app_ss_st_ciireq_tready,     //                             .tready,                   Application assert this signal for one clock to acknowledge ss_app_st_ciireq_tvalid is seen by responder.
		output wire [71:0]  p0_ss_app_st_ciireq_tdata,      //                             .tdata,                    st_app_st_ciireq_tdata[0] - hdr_poisoned: The poisoned bit in the received TLP header on the CII. st_app_st_ciireq_tdata[4:1] - hdr_first_be: The first dword byte enable field in the received TLP header on the CII. st_app_st_ciireq_tdata[9:5] -slot_num: The slot number in the received TLP header on the CII, Rsvd when SEP is not present. st_app_st_ciireq_tdata[12:10] - func_num: The PF number in the received TLP header on the CII. (PF[2:0]). st_app_st_ciireq_tdata[23:13] - vf_num: The child VF number of parent PF in the received TLP header on the CII. st_app_st_ciireq_tdata[24] - vf_active: Indicates VF number is valid in the received TLP header on the CII. st_app_st_ciireq_tdata[25] - wr: Indicates a configuration write request detected in the received TLP header on the CII. Also indicates that st_app_st_ciireq_tdata[67:36] is valid. st_app_st_ciireq_tdata[35:26] - addr: The double word register address in the received TLP header on the CII. st_app_st_ciireq_tdata[67:36] - dout: Received TLP payload data from the link partner to your application client. The data is in little endian format. The first received payload byte is in [43:36]. st_app_st_ciireq_tdata[69:68] - func_num: The PF number in the received TLP header on the CII. (PF[4:3]). st_app_st_ciireq_tdata[71:70] - SEP Type: Indicates the type of cfg space being accessed "00" - Switch Up "01" - Switch Down "10" - Embedded EP Note: This field is only applicable when SEP is integrated into PCIe SS.
		input  wire         p0_app_ss_st_ciiresp_tvalid,    //                p0_st_ciiresp.tvalid,                   Application assert this signal for one clock to indicate that valid data is driven on app_ss_st_ciiresp_tdata bus.
		input  wire [32:0]  p0_app_ss_st_ciiresp_tdata,     //                             .tdata,                    Override data from application for the intercepted config request on "st_ciireq interface". For CfgWr: override the write data to the Config register with data supplied by the application logic. For CfgRd: override the data payload of the completion TLP with data supplied by the application logic.<n>Override Data Enable: Application assert this signal to override the CfgWr payload or CfgRd completion using the data supplied by the application logic on app_ss_st_ciiresp_tdata[31:0] bus.
		output wire         p0_ss_app_st_ctrlshadow_tvalid, //             p0_st_ctrlshadow.tvalid,                   The subsystem asserts this output for one clock cycle when there is an update to the register fields being monitored, because of a Configuration Write performed by the Root Complex.  The user can copy the new settings of the register fields from the tdata bus.
		output wire [39:0]  p0_ss_app_st_ctrlshadow_tdata,  //                             .tdata,                    When app_ctrl_shadow_tvalid has been asserted, this output provides the current settings of the register fields of the associated Function. Bit[2:0] - Identifies the physical function Number of configuration register (PF[2:0]). Bit[13:3] - Identifies the virtual function Number of configuration register. Bit[14] - Indicates information is for Virtual Function implemented in slot's physical function. Bit[19:15] - Identifies the slot Number of configuration register, Rsvd when SEP is not present. Bit[20] - Bus Master Enable. Bit[21] - MSIX Mask. Bit[22] - MSIX Enable. Bit[23] - Mem Space Enable. Bit[24] - ExpRom Enable. Bit[25] - TPH Req Enable  . Bit[26] - ATS Enable. Bit[27] - MSI Enable. Bit[28] - MSI Mask Update. Bit[29] - Extended Tag. Bit[30] - 10Bit Tag Req Enable. Bit[31] - PTM Enable. Bit[34:32] - MPS Size. Bit[37:35] - MRRS Size. Bit[38] - VF Enable. Bit[39] - Page Request Enable. Bit[41:40] - Identifies the physical function Number of configuration register (PF[4:3]).
		output wire         p0_ss_app_st_txcrdt_tvalid,     //                 p0_st_txcrdt.tvalid,                   tvalid indicates that the credit information on tdata is valid
		output wire [18:0]  p0_ss_app_st_txcrdt_tdata,      //                             .tdata,                    Carries credit limit information and type of credit. Bit[15:0] - Credit Limit Value. Bit[18:16] - Credit Type. 3'b000 - Posted Header Credit. 3'b001 - Non-Posted Header Credit. 3'b010 - Completion Header Credit. 3'b011 - Reserved. 3'b100 - Posted Data Credit. 3'b101 - Non-Posted Data Credit. 3'b110 - Completion Data Credit. 3'b111 - Reserved. Bit[15:0] - All zero indicate of Infinite Credit Advertise.
		output wire         p0_ss_app_st_cplto_tvalid,      //                  p0_st_cplto.tvalid,                   tvalid indicates that the completion timeout received for outstanding NP request
		output wire [48:0]  p0_ss_app_st_cplto_tdata,       //                             .tdata,                    Carries completion Timeout Information. Bit[9:0] - Tag Number. Bit[12:10] - PF Number (PF[2:0]), indicates parent PF number of VF when VF Active is high else PF Number of function. Bit[23:13] - VF Number, indicates VF number when VF Active js high. Bit[24] - VF Active, indicates timeout is for VF. Bit[29:25] - Slot Number, always zero when SEP is not present. Bit[31:30] - PF Number (PF[4:3]). Bit[43:32] - Transfer length in bytes (least significant 12 bits), of the expected completion that timed out for the non-posted transaction. For a split completion, it indicates the number of bytes remaining to be delivered when the completion timed out (Max length is Max Read request size. Ex: 4K Bytes = 2^12 bytes). Bit[46:44] - Traffic class of the expected completion that timed out for the non-posted transaction.. Bit[48:47]: Attribute of the expected completion that timed out for the non-posted transaction. ID based ordering is not supported. [48] -> Relaxed ordering, [47] -> No Snoop.
		input  wire         p0_app_ss_lite_csr_awvalid,     //                  p0_lite_csr.awvalid,                  Indicates that the write address channel signals are valid
		output wire         p0_ss_app_lite_csr_awready,     //                             .awready,                  Indicates that a transfer on the write address channel can be accepted
		input  wire [19:0]  p0_app_ss_lite_csr_awaddr,      //                             .awaddr,                   The address of the first transfer in a write transaction. The default value of LiteSlvAWD = 18.
		input  wire         p0_app_ss_lite_csr_wvalid,      //                             .wvalid,                   Indicates that the write data channel signals are valid.
		output wire         p0_ss_app_lite_csr_wready,      //                             .wready,                   Indicates that a transfer on the write data channel can be accepted.
		input  wire [31:0]  p0_app_ss_lite_csr_wdata,       //                             .wdata,                    Write Data. The default value of LiteSlvDWD=32.
		input  wire [3:0]   p0_app_ss_lite_csr_wstrb,       //                             .wstrb,                    Write strobes, indicate which byte lanes hold valid data.
		output wire         p0_ss_app_lite_csr_bvalid,      //                             .bvalid,                   Indicates that the write response channel signals are valid.
		input  wire         p0_app_ss_lite_csr_bready,      //                             .bready,                   Indicates that a transfer on the write response channel can be accepted.
		output wire [1:0]   p0_ss_app_lite_csr_bresp,       //                             .bresp,                    Write response, indicates the status of a write transaction.
		input  wire         p0_app_ss_lite_csr_arvalid,     //                             .arvalid,                  Indicates that the read address channel signals are valid.
		output wire         p0_ss_app_lite_csr_arready,     //                             .arready,                  Indicates that a transfer on the read address channel can be accepted.
		input  wire [19:0]  p0_app_ss_lite_csr_araddr,      //                             .araddr,                   The address of the first transfer in a read transaction. The default value of LiteSlvAWD = 18.
		output wire         p0_ss_app_lite_csr_rvalid,      //                             .rvalid,                   Indicates that the read data channel signals are valid.
		input  wire         p0_app_ss_lite_csr_rready,      //                             .rready,                   Indicates that a transfer on the read data channel can be accepted.
		output wire [31:0]  p0_ss_app_lite_csr_rdata,       //                             .rdata,                    Read data. The default value of LiteSlvDWD=32.
		output wire [1:0]   p0_ss_app_lite_csr_rresp,       //                             .rresp,                    Read response, indicates the status of a read transfer.
		output wire         p0_ss_app_serr,                 //               p0_ss_app_serr.ss_app_serr,              Indicates System Error is detected. In TLP Bypass Mode indicates PL/DL/TL layer error detected by HardIP. Note: Applicable for all modes (EP/RP/BP)
		output wire         p0_ss_app_dlup,                 //               p0_ss_app_dlup.ss_app_dlup,              Indicates Data Link Layer is UP. Note: Applicable for all modes (EP/RP/BP)
		output wire         p0_ss_app_linkup,               //             p0_ss_app_linkup.ss_app_linkup,            Link Up Indication: 0 - Link Down; 1 - Link up. Note: Applicable for all modes (EP/RP/BP)
		output wire [5:0]   p0_ss_app_ltssmstate,           //         p0_ss_app_ltssmstate.ss_app_ltssmstate,        Indicates LTSSM State: 6'h00: S_DETECT_QUIET; 6'h01: S_DETECT_ACT; 6'h02: S_POLL_ACTIVE; 6'h03: S_POLL_COMPLIANCE; 6'h04: S_POLL_CONFIG; 6'h05: S_PRE_DETECT_QUIET; 6'h06: S_DETECT_WAIT; 6'h07: S_CFG_LINKWD_START; 6'h08: S_CFG_LINKWD_ACCEPT; 6'h09: S_CFG_LANENUM_WAIT; 6'h0A: S_CFG_LANENUM_ACCEPT; 6'h0B: S_CFG_COMPLETE; 6'h0C: S_CFG_IDLE; 6'h0D: S_RCVRY_LOCK; 6'h0E: S_RCVRY_SPEED; 6'h0F: S_RCVRY_RCVRCFG; 6'h10: S_RCVRY_IDLE; 6'h11: S_L0; 6'h12: S_L0S; 6'h13: S_L123_SEND_EIDLE; 6'h14: S_L1_IDLE; 6'h15: S_L2_IDLE; 6'h16: S_L2_WAKE; 6'h17: S_DISABLED_ENTRY; 6'h18: S_DISABLED_IDLE; 6'h19: S_DISABLED; 6'h1A: S_LPBK_ENTRY; 6'h1B: S_LPBK_ACTIVE; 6'h1C: S_LPBK_EXIT; 6'h1D: S_LPBK_EXIT_TIMEOUT; 6'h1E: S_HOT_RESET_ENTRY; 6'h1F: S_HOT_RESET; 6'h20: S_RCVRY_EQ0; 6'h21: S_RCVRY_EQ1; 6'h22: S_RCVRY_EQ2; 6'h23: S_RCVRY_EQ3. Note: Applicable for all modes (EP/RP/BP)
		input  wire [2:0]   p0_app_ss_st_rx_tuser_halt      //   p0_app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt,  Indicates PLD interface temporarily wants to halt reception of particular type of packet. bit[0] Ã- Halt Posted TLP; bit[1] Ã- Halt Non Posted TLP; bit[2] Ã- Halt Completion TLP. Note:	Applicable for SM, SS PU HIP-native mode. NA for P/F/R tiles.
	);

	pcie_ed_dut_intel_pcie_gts_910_adwpmni #(
		.TILE                                                                 ("SM"),
		.MIF_DIRECTORY                                                        (""),
		.DFL_MIF_DIRECTORY                                                    (""),
		.device_type                                                          ("EP"),
		.core8_device_type                                                    ("EP"),
		.core16_ceb_en_hwtcl                                                  (0),
		.core16_ceb_ack_latency_hwtcl                                         (100),
		.core16_cii_en_hwtcl                                                  (1),
		.core16_cii_ack_latency_hwtcl                                         (100),
		.core16_virtio_pci_cfg_acc_intf_en_hwtcl                              (0),
		.core8_ceb_en_hwtcl                                                   (0),
		.core8_ceb_ack_latency_hwtcl                                          (100),
		.core8_cii_en_hwtcl                                                   (0),
		.core8_cii_ack_latency_hwtcl                                          (100),
		.core8_virtio_pci_cfg_acc_intf_en_hwtcl                               (0),
		.core16_dfl_en_hwtcl                                                  (0),
		.core16_dfh_fid_hwtcl                                                 (0),
		.core16_dfh_major_ver_hwtcl                                           (0),
		.core16_dfh_next_byte_offset_hwtcl                                    (0),
		.core16_dfh_end_hwtcl                                                 (0),
		.core16_dfh_minor_rev_hwtcl                                           (0),
		.core16_dfh_ver_hwtcl                                                 (0),
		.core16_dfh_feature_type_hwtcl                                        (0),
		.core16_inst_id_hwtcl                                                 (0),
		.core8_dfl_en_hwtcl                                                   (0),
		.core8_dfh_fid_hwtcl                                                  (0),
		.core8_dfh_major_ver_hwtcl                                            (0),
		.core8_dfh_next_byte_offset_hwtcl                                     (0),
		.core8_dfh_end_hwtcl                                                  (0),
		.core8_dfh_minor_rev_hwtcl                                            (0),
		.core8_dfh_ver_hwtcl                                                  (0),
		.core8_dfh_feature_type_hwtcl                                         (0),
		.core8_inst_id_hwtcl                                                  (0),
		.core16_hip_native_mode_hwtcl                                         (1),
		.core8_hip_native_mode_hwtcl                                          (1),
		.core16_sbh_en_hwtcl                                                  (1),
		.core8_sbh_en_hwtcl                                                   (1),
		.core16_FUNC_MODE                                                     ("POWER_USER"),
		.core16_Header_Packing_scheme                                         ("Simple"),
		.core16_DWIDTH                                                        (256),
		.core16_NUM_OF_SEG                                                    (2),
		.core16_ST_readyLatency                                               (0),
		.core16_LiteSlvAWD                                                    (20),
		.core16_LiteSlvDWD                                                    (32),
		.core16_LiteMstrAWD                                                   (32),
		.core16_LiteMstrDWD                                                   (32),
		.core16_LiteMstr_readyLatency                                         (0),
		.core16_MMAWD                                                         (64),
		.core16_MMBLWD                                                        (8),
		.core16_MMDWD                                                         (512),
		.core16_MM_readyLatency                                               (0),
		.core16_CPL_REORDERING                                                ("Disable"),
		.core16_REORDER_BUFF_SIZE                                             (64),
		.core16_CPLTO_THRU_AXI_ST                                             ("Disable"),
		.core16_DEVATT_TX_ROUTING                                             ("Disable"),
		.core16_DOWNSTREAM_MSG_FWD                                            ("Disable"),
		.core16_MSI_MSG_GEN                                                   ("Disable"),
		.core16_FLR_REQ_DROP                                                  ("Disable"),
		.core16_MSIX_TABLE                                                    ("Disable"),
		.core16_MSIX_TABLE_SIZE                                               (2048),
		.core16_MSIX_BIR                                                      (5),
		.core16_MSIX_BAR_OFFSET                                               (0),
		.core16_MSIX_VECTOR_ALLOC                                             ("Static"),
		.core16_autonomous_pm_enter_l23                                       (0),
		.core16_device_att                                                    ("Disable"),
		.core16_DM_ADR_ALIGN                                                  ("Disable"),
		.core16_MMIO_ADR_ALIGN                                                ("Disable"),
		.core8_FUNC_MODE                                                      ("POWER_USER"),
		.core8_Header_Packing_scheme                                          ("Simple"),
		.core8_DWIDTH                                                         (128),
		.core8_NUM_OF_SEG                                                     (1),
		.core8_ST_readyLatency                                                (0),
		.core8_LiteSlvAWD                                                     (20),
		.core8_LiteSlvDWD                                                     (32),
		.core8_LiteMstrAWD                                                    (32),
		.core8_LiteMstrDWD                                                    (32),
		.core8_LiteMstr_readyLatency                                          (0),
		.core8_MMAWD                                                          (64),
		.core8_MMBLWD                                                         (8),
		.core8_MMDWD                                                          (512),
		.core8_MM_readyLatency                                                (0),
		.core8_CPL_REORDERING                                                 ("Disable"),
		.core8_REORDER_BUFF_SIZE                                              (64),
		.core8_CPLTO_THRU_AXI_ST                                              ("Disable"),
		.core8_DEVATT_TX_ROUTING                                              ("Disable"),
		.core8_DOWNSTREAM_MSG_FWD                                             ("Disable"),
		.core8_MSI_MSG_GEN                                                    ("Disable"),
		.core8_FLR_REQ_DROP                                                   ("Disable"),
		.core8_MSIX_TABLE                                                     ("Disable"),
		.core8_MSIX_TABLE_SIZE                                                (2048),
		.core8_MSIX_BIR                                                       (5),
		.core8_MSIX_BAR_OFFSET                                                (0),
		.core8_MSIX_VECTOR_ALLOC                                              ("Static"),
		.core8_autonomous_pm_enter_l23                                        (0),
		.core8_device_att                                                     ("Disable"),
		.core8_DM_ADR_ALIGN                                                   ("Disable"),
		.core8_MMIO_ADR_ALIGN                                                 ("Disable"),
		.core16_pf0_bar01_size_mask                                           (64'b0000000000000000000000000000000000000000001111111111111111111111),
		.core16_pf0_bar23_size_mask                                           (64'b0000000000000000000000000000000000000000111111111111111111111111),
		.core16_pf0_bar45_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_bar01_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_bar23_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_bar45_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_bar01_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_bar23_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_bar45_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_bar01_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_bar23_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_bar45_size_mask                                           (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf0_sriov_vf_bar01_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf0_sriov_vf_bar23_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf0_sriov_vf_bar45_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_sriov_vf_bar01_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_sriov_vf_bar23_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf1_sriov_vf_bar45_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_sriov_vf_bar01_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_sriov_vf_bar23_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf2_sriov_vf_bar45_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_sriov_vf_bar01_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_sriov_vf_bar23_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core16_pf3_sriov_vf_bar45_size_mask                                  (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_bar01_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_bar23_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_bar45_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_bar01_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_bar23_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_bar45_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_bar01_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_bar23_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_bar45_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_bar01_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_bar23_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_bar45_size_mask                                            (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_sriov_vf_bar01_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_sriov_vf_bar23_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf0_sriov_vf_bar45_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_sriov_vf_bar01_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_sriov_vf_bar23_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf1_sriov_vf_bar45_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_sriov_vf_bar01_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_sriov_vf_bar23_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf2_sriov_vf_bar45_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_sriov_vf_bar01_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_sriov_vf_bar23_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.core8_pf3_sriov_vf_bar45_size_mask                                   (64'b0000000000000000000000000000000000000000000000000000000000000000),
		.device_family                                                        ("Agilex 5"),
		.is_sm4_sm7_revA                                                      (1),
		.core8_virtual_tlp_bypass_en_hwtcl                                    (0),
		.xcvr_reconfig_hwtcl                                                  (0),
		.debug_toolkit_hwtcl                                                  (0),
		.enable_pciess_register_access_hwtcl                                  (0),
		.link_insp_en_hwtcl                                                   (0),
		.pciess_topology                                                      ("pcie_x4"),
		.core8_pciess_topology                                                ("pcie_x8"),
		.core16_topology                                                      ("pcie_x4"),
		.core8_topology                                                       ("pcie_x8"),
		.l_quad_num                                                           (1),
		.core16_func_mode_hwtcl                                               ("Enable"),
		.core16_virtual_tlp_bypass_en_hwtcl                                   (0),
		.core16_use_ast_parity_hwtcl                                          (1),
		.core16_payload_width_integer_hwtcl                                   (256),
		.core16_hdr_width_integer_hwtcl                                       (128),
		.core16_double_width_integer_hwtcl                                    (1),
		.core16_pfx_width_integer_hwtcl                                       (32),
		.core16_empty_width_integer_hwtcl                                     (3),
		.core16_tdata_width_integer_hwtcl                                     (256),
		.core16_enable_rx_buffer_limit_ports_hwtcl                            (0),
		.core16_enable_power_mgnt_intf_hwtcl                                  (0),
		.core16_enable_cpl_timeout_hwtcl                                      (0),
		.core16_enable_error_intf_hwtcl                                       (0),
		.core16_enable_ecc_hwtcl                                              (0),
		.core8_func_mode_hwtcl                                                ("Disable"),
		.core8_use_ast_parity_hwtcl                                           (1),
		.core8_payload_width_integer_hwtcl                                    (256),
		.core8_hdr_width_integer_hwtcl                                        (128),
		.core8_double_width_integer_hwtcl                                     (1),
		.core8_pfx_width_integer_hwtcl                                        (32),
		.core8_empty_width_integer_hwtcl                                      (2),
		.core8_tdata_width_integer_hwtcl                                      (128),
		.core8_enable_rx_buffer_limit_ports_hwtcl                             (0),
		.core8_enable_power_mgnt_intf_hwtcl                                   (0),
		.core8_enable_cpl_timeout_hwtcl                                       (0),
		.core8_enable_error_intf_hwtcl                                        (0),
		.core8_enable_ecc_hwtcl                                               (0),
		.core16_pf0_bar0_address_width_hwtcl                                  (22),
		.core16_pf0_bar1_address_width_hwtcl                                  (0),
		.core16_pf0_bar2_address_width_hwtcl                                  (24),
		.core16_pf0_bar3_address_width_hwtcl                                  (0),
		.core16_pf0_bar4_address_width_hwtcl                                  (0),
		.core16_pf0_bar5_address_width_hwtcl                                  (0),
		.core16_pf0_sriov_vf_bar0_address_width_int_hwtcl                     (0),
		.core16_pf0_sriov_vf_bar1_address_width_int_hwtcl                     (0),
		.core16_pf0_sriov_vf_bar2_address_width_int_hwtcl                     (0),
		.core16_pf0_sriov_vf_bar3_address_width_int_hwtcl                     (0),
		.core16_pf0_sriov_vf_bar4_address_width_int_hwtcl                     (0),
		.core16_pf0_sriov_vf_bar5_address_width_int_hwtcl                     (0),
		.core16_pf1_bar0_address_width_hwtcl                                  (0),
		.core16_pf1_bar1_address_width_hwtcl                                  (0),
		.core16_pf1_bar2_address_width_hwtcl                                  (0),
		.core16_pf1_bar3_address_width_hwtcl                                  (0),
		.core16_pf1_bar4_address_width_hwtcl                                  (0),
		.core16_pf1_bar5_address_width_hwtcl                                  (0),
		.core16_pf1_sriov_vf_bar0_address_width_int_hwtcl                     (0),
		.core16_pf1_sriov_vf_bar1_address_width_int_hwtcl                     (0),
		.core16_pf1_sriov_vf_bar2_address_width_int_hwtcl                     (0),
		.core16_pf1_sriov_vf_bar3_address_width_int_hwtcl                     (0),
		.core16_pf1_sriov_vf_bar4_address_width_int_hwtcl                     (0),
		.core16_pf1_sriov_vf_bar5_address_width_int_hwtcl                     (0),
		.core16_pf2_bar0_address_width_hwtcl                                  (0),
		.core16_pf2_bar1_address_width_hwtcl                                  (0),
		.core16_pf2_bar2_address_width_hwtcl                                  (0),
		.core16_pf2_bar3_address_width_hwtcl                                  (0),
		.core16_pf2_bar4_address_width_hwtcl                                  (0),
		.core16_pf2_bar5_address_width_hwtcl                                  (0),
		.core16_pf2_sriov_vf_bar0_address_width_int_hwtcl                     (0),
		.core16_pf2_sriov_vf_bar1_address_width_int_hwtcl                     (0),
		.core16_pf2_sriov_vf_bar2_address_width_int_hwtcl                     (0),
		.core16_pf2_sriov_vf_bar3_address_width_int_hwtcl                     (0),
		.core16_pf2_sriov_vf_bar4_address_width_int_hwtcl                     (0),
		.core16_pf2_sriov_vf_bar5_address_width_int_hwtcl                     (0),
		.core16_pf3_bar0_address_width_hwtcl                                  (0),
		.core16_pf3_bar1_address_width_hwtcl                                  (0),
		.core16_pf3_bar2_address_width_hwtcl                                  (0),
		.core16_pf3_bar3_address_width_hwtcl                                  (0),
		.core16_pf3_bar4_address_width_hwtcl                                  (0),
		.core16_pf3_bar5_address_width_hwtcl                                  (0),
		.core16_pf3_sriov_vf_bar0_address_width_int_hwtcl                     (0),
		.core16_pf3_sriov_vf_bar1_address_width_int_hwtcl                     (0),
		.core16_pf3_sriov_vf_bar2_address_width_int_hwtcl                     (0),
		.core16_pf3_sriov_vf_bar3_address_width_int_hwtcl                     (0),
		.core16_pf3_sriov_vf_bar4_address_width_int_hwtcl                     (0),
		.core16_pf3_sriov_vf_bar5_address_width_int_hwtcl                     (0),
		.core8_pf0_bar0_address_width_hwtcl                                   (0),
		.core8_pf0_bar1_address_width_hwtcl                                   (0),
		.core8_pf0_bar2_address_width_hwtcl                                   (0),
		.core8_pf0_bar3_address_width_hwtcl                                   (0),
		.core8_pf0_bar4_address_width_hwtcl                                   (0),
		.core8_pf0_bar5_address_width_hwtcl                                   (0),
		.core8_pf0_sriov_vf_bar0_address_width_int_hwtcl                      (0),
		.core8_pf0_sriov_vf_bar1_address_width_int_hwtcl                      (0),
		.core8_pf0_sriov_vf_bar2_address_width_int_hwtcl                      (0),
		.core8_pf0_sriov_vf_bar3_address_width_int_hwtcl                      (0),
		.core8_pf0_sriov_vf_bar4_address_width_int_hwtcl                      (0),
		.core8_pf0_sriov_vf_bar5_address_width_int_hwtcl                      (0),
		.core8_pf1_bar0_address_width_hwtcl                                   (0),
		.core8_pf1_bar1_address_width_hwtcl                                   (0),
		.core8_pf1_bar2_address_width_hwtcl                                   (0),
		.core8_pf1_bar3_address_width_hwtcl                                   (0),
		.core8_pf1_bar4_address_width_hwtcl                                   (0),
		.core8_pf1_bar5_address_width_hwtcl                                   (0),
		.core8_pf1_sriov_vf_bar0_address_width_int_hwtcl                      (0),
		.core8_pf1_sriov_vf_bar1_address_width_int_hwtcl                      (0),
		.core8_pf1_sriov_vf_bar2_address_width_int_hwtcl                      (0),
		.core8_pf1_sriov_vf_bar3_address_width_int_hwtcl                      (0),
		.core8_pf1_sriov_vf_bar4_address_width_int_hwtcl                      (0),
		.core8_pf1_sriov_vf_bar5_address_width_int_hwtcl                      (0),
		.core8_pf2_bar0_address_width_hwtcl                                   (0),
		.core8_pf2_bar1_address_width_hwtcl                                   (0),
		.core8_pf2_bar2_address_width_hwtcl                                   (0),
		.core8_pf2_bar3_address_width_hwtcl                                   (0),
		.core8_pf2_bar4_address_width_hwtcl                                   (0),
		.core8_pf2_bar5_address_width_hwtcl                                   (0),
		.core8_pf2_sriov_vf_bar0_address_width_int_hwtcl                      (0),
		.core8_pf2_sriov_vf_bar1_address_width_int_hwtcl                      (0),
		.core8_pf2_sriov_vf_bar2_address_width_int_hwtcl                      (0),
		.core8_pf2_sriov_vf_bar3_address_width_int_hwtcl                      (0),
		.core8_pf2_sriov_vf_bar4_address_width_int_hwtcl                      (0),
		.core8_pf2_sriov_vf_bar5_address_width_int_hwtcl                      (0),
		.core8_pf3_bar0_address_width_hwtcl                                   (0),
		.core8_pf3_bar1_address_width_hwtcl                                   (0),
		.core8_pf3_bar2_address_width_hwtcl                                   (0),
		.core8_pf3_bar3_address_width_hwtcl                                   (0),
		.core8_pf3_bar4_address_width_hwtcl                                   (0),
		.core8_pf3_bar5_address_width_hwtcl                                   (0),
		.core8_pf3_sriov_vf_bar0_address_width_int_hwtcl                      (0),
		.core8_pf3_sriov_vf_bar1_address_width_int_hwtcl                      (0),
		.core8_pf3_sriov_vf_bar2_address_width_int_hwtcl                      (0),
		.core8_pf3_sriov_vf_bar3_address_width_int_hwtcl                      (0),
		.core8_pf3_sriov_vf_bar4_address_width_int_hwtcl                      (0),
		.core8_pf3_sriov_vf_bar5_address_width_int_hwtcl                      (0),
		.core16_enable_multi_func_hwtcl                                       (0),
		.core16_total_pf_count_hwtcl                                          (1),
		.core16_total_pf_count_width_hwtcl                                    (1),
		.core16_enable_sriov_hwtcl                                            (0),
		.core16_pf0_vf_count_hwtcl                                            (0),
		.core16_pf1_vf_count_hwtcl                                            (0),
		.core16_pf2_vf_count_hwtcl                                            (0),
		.core16_pf3_vf_count_hwtcl                                            (0),
		.core16_total_vf_count_hwtcl                                          (0),
		.core16_total_vf_count_width_hwtcl                                    (1),
		.core8_enable_multi_func_hwtcl                                        (0),
		.core8_total_pf_count_hwtcl                                           (1),
		.core8_total_pf_count_width_hwtcl                                     (1),
		.core8_enable_sriov_hwtcl                                             (0),
		.core8_pf0_vf_count_hwtcl                                             (0),
		.core8_pf1_vf_count_hwtcl                                             (0),
		.core8_pf2_vf_count_hwtcl                                             (0),
		.core8_pf3_vf_count_hwtcl                                             (0),
		.core8_total_vf_count_hwtcl                                           (0),
		.core8_total_vf_count_width_hwtcl                                     (1),
		.core16_flr_cap_hwtcl                                                 (0),
		.core16_virtual_pf0_msix_enable_hwtcl                                 (1),
		.core16_virtual_pf1_msix_enable_hwtcl                                 (0),
		.core16_virtual_pf2_msix_enable_hwtcl                                 (0),
		.core16_virtual_pf3_msix_enable_hwtcl                                 (0),
		.core16_pf0_pci_msix_table_size_hwtcl                                 (15),
		.core16_pf1_pci_msix_table_size_hwtcl                                 (0),
		.core16_pf2_pci_msix_table_size_hwtcl                                 (0),
		.core16_pf3_pci_msix_table_size_hwtcl                                 (0),
		.core16_virtual_pf0_exvf_msix_cap_enable_hwtcl                        (0),
		.core16_virtual_pf1_exvf_msix_cap_enable_hwtcl                        (0),
		.core16_virtual_pf2_exvf_msix_cap_enable_hwtcl                        (0),
		.core16_virtual_pf3_exvf_msix_cap_enable_hwtcl                        (0),
		.core16_exvf_msix_tablesize_pf0                                       (0),
		.core16_exvf_msix_tablesize_pf1                                       (0),
		.core16_exvf_msix_tablesize_pf2                                       (0),
		.core16_exvf_msix_tablesize_pf3                                       (0),
		.core16_pf0_pcie_slot_imp_hwtcl                                       (0),
		.core16_virtual_ptm_hwtcl                                             (0),
		.core8_flr_cap_hwtcl                                                  (0),
		.core8_virtual_pf0_msix_enable_hwtcl                                  (0),
		.core8_virtual_pf1_msix_enable_hwtcl                                  (0),
		.core8_virtual_pf2_msix_enable_hwtcl                                  (0),
		.core8_virtual_pf3_msix_enable_hwtcl                                  (0),
		.core8_pf0_pci_msix_table_size_hwtcl                                  (0),
		.core8_pf1_pci_msix_table_size_hwtcl                                  (0),
		.core8_pf2_pci_msix_table_size_hwtcl                                  (0),
		.core8_pf3_pci_msix_table_size_hwtcl                                  (0),
		.core8_virtual_pf0_exvf_msix_cap_enable_hwtcl                         (0),
		.core8_virtual_pf1_exvf_msix_cap_enable_hwtcl                         (0),
		.core8_virtual_pf2_exvf_msix_cap_enable_hwtcl                         (0),
		.core8_virtual_pf3_exvf_msix_cap_enable_hwtcl                         (0),
		.core8_exvf_msix_tablesize_pf0                                        (0),
		.core8_exvf_msix_tablesize_pf1                                        (0),
		.core8_exvf_msix_tablesize_pf2                                        (0),
		.core8_exvf_msix_tablesize_pf3                                        (0),
		.core8_pf0_pcie_slot_imp_hwtcl                                        (0),
		.core8_virtual_ptm_hwtcl                                              (0),
		.core16_pf0_vf_ats_cap_enable_hwtcl                                   (0),
		.core16_pf1_vf_ats_cap_enable_hwtcl                                   (0),
		.core16_pf2_vf_ats_cap_enable_hwtcl                                   (0),
		.core16_pf3_vf_ats_cap_enable_hwtcl                                   (0),
		.core16_pf0_vf_tph_cap_enable_hwtcl                                   (0),
		.core16_pf1_vf_tph_cap_enable_hwtcl                                   (0),
		.core16_pf2_vf_tph_cap_enable_hwtcl                                   (0),
		.core16_pf3_vf_tph_cap_enable_hwtcl                                   (0),
		.core16_pf0_vf_acs_cap_enable_hwtcl                                   (0),
		.core16_pf1_vf_acs_cap_enable_hwtcl                                   (0),
		.core16_pf2_vf_acs_cap_enable_hwtcl                                   (0),
		.core16_pf3_vf_acs_cap_enable_hwtcl                                   (0),
		.core8_pf0_vf_ats_cap_enable_hwtcl                                    (0),
		.core8_pf1_vf_ats_cap_enable_hwtcl                                    (0),
		.core8_pf2_vf_ats_cap_enable_hwtcl                                    (0),
		.core8_pf3_vf_ats_cap_enable_hwtcl                                    (0),
		.core8_pf0_vf_tph_cap_enable_hwtcl                                    (0),
		.core8_pf1_vf_tph_cap_enable_hwtcl                                    (0),
		.core8_pf2_vf_tph_cap_enable_hwtcl                                    (0),
		.core8_pf3_vf_tph_cap_enable_hwtcl                                    (0),
		.core8_pf0_vf_acs_cap_enable_hwtcl                                    (0),
		.core8_pf1_vf_acs_cap_enable_hwtcl                                    (0),
		.core8_pf2_vf_acs_cap_enable_hwtcl                                    (0),
		.core8_pf3_vf_acs_cap_enable_hwtcl                                    (0),
		.core16_hip_reconfig_hwtcl                                            (0),
		.core8_hip_reconfig_hwtcl                                             (0),
		.core16_enable_virtio_hwtcl                                           (0),
		.core16_virtio_start_byte_address_hwtcl                               (72),
		.core16_pf0_virtio_capability_present_hwtcl                           (0),
		.core16_pf0_virtio_device_specific_cap_present_hwtcl                  (0),
		.core16_pf0_virtio_cmn_config_bar_indicator_hwtcl                     (0),
		.core16_pf0_virtio_cmn_config_bar_offset_hwtcl                        (0),
		.core16_pf0_virtio_cmn_config_structure_length_hwtcl                  (0),
		.core16_pf0_virtio_notification_bar_indicator_hwtcl                   (0),
		.core16_pf0_virtio_notification_bar_offset_hwtcl                      (0),
		.core16_pf0_virtio_notification_structure_length_hwtcl                (0),
		.core16_pf0_virtio_notify_off_multiplier_hwtcl                        (0),
		.core16_pf0_virtio_isrstatus_bar_indicator_hwtcl                      (0),
		.core16_pf0_virtio_isrstatus_bar_offset_hwtcl                         (0),
		.core16_pf0_virtio_isrstatus_structure_length_hwtcl                   (0),
		.core16_pf0_virtio_devspecific_bar_indicator_hwtcl                    (0),
		.core16_pf0_virtio_devspecific_bar_offset_hwtcl                       (0),
		.core16_pf0_virtio_devspecific_structure_length_hwtcl                 (0),
		.core16_pf0_virtio_pciconfig_access_bar_indicator_hwtcl               (0),
		.core16_pf0_virtio_pciconfig_access_bar_offset_hwtcl                  (0),
		.core16_pf0_virtio_pciconfig_access_structure_length_hwtcl            (0),
		.core16_pf1_virtio_capability_present_hwtcl                           (0),
		.core16_pf1_virtio_device_specific_cap_present_hwtcl                  (0),
		.core16_pf1_virtio_cmn_config_bar_indicator_hwtcl                     (0),
		.core16_pf1_virtio_cmn_config_bar_offset_hwtcl                        (0),
		.core16_pf1_virtio_cmn_config_structure_length_hwtcl                  (0),
		.core16_pf1_virtio_notification_bar_indicator_hwtcl                   (0),
		.core16_pf1_virtio_notification_bar_offset_hwtcl                      (0),
		.core16_pf1_virtio_notification_structure_length_hwtcl                (0),
		.core16_pf1_virtio_notify_off_multiplier_hwtcl                        (0),
		.core16_pf1_virtio_isrstatus_bar_indicator_hwtcl                      (0),
		.core16_pf1_virtio_isrstatus_bar_offset_hwtcl                         (0),
		.core16_pf1_virtio_isrstatus_structure_length_hwtcl                   (0),
		.core16_pf1_virtio_devspecific_bar_indicator_hwtcl                    (0),
		.core16_pf1_virtio_devspecific_bar_offset_hwtcl                       (0),
		.core16_pf1_virtio_devspecific_structure_length_hwtcl                 (0),
		.core16_pf1_virtio_pciconfig_access_bar_indicator_hwtcl               (0),
		.core16_pf1_virtio_pciconfig_access_bar_offset_hwtcl                  (0),
		.core16_pf1_virtio_pciconfig_access_structure_length_hwtcl            (0),
		.core16_pf2_virtio_capability_present_hwtcl                           (0),
		.core16_pf2_virtio_device_specific_cap_present_hwtcl                  (0),
		.core16_pf2_virtio_cmn_config_bar_indicator_hwtcl                     (0),
		.core16_pf2_virtio_cmn_config_bar_offset_hwtcl                        (0),
		.core16_pf2_virtio_cmn_config_structure_length_hwtcl                  (0),
		.core16_pf2_virtio_notification_bar_indicator_hwtcl                   (0),
		.core16_pf2_virtio_notification_bar_offset_hwtcl                      (0),
		.core16_pf2_virtio_notification_structure_length_hwtcl                (0),
		.core16_pf2_virtio_notify_off_multiplier_hwtcl                        (0),
		.core16_pf2_virtio_isrstatus_bar_indicator_hwtcl                      (0),
		.core16_pf2_virtio_isrstatus_bar_offset_hwtcl                         (0),
		.core16_pf2_virtio_isrstatus_structure_length_hwtcl                   (0),
		.core16_pf2_virtio_devspecific_bar_indicator_hwtcl                    (0),
		.core16_pf2_virtio_devspecific_bar_offset_hwtcl                       (0),
		.core16_pf2_virtio_devspecific_structure_length_hwtcl                 (0),
		.core16_pf2_virtio_pciconfig_access_bar_indicator_hwtcl               (0),
		.core16_pf2_virtio_pciconfig_access_bar_offset_hwtcl                  (0),
		.core16_pf2_virtio_pciconfig_access_structure_length_hwtcl            (0),
		.core16_pf3_virtio_capability_present_hwtcl                           (0),
		.core16_pf3_virtio_device_specific_cap_present_hwtcl                  (0),
		.core16_pf3_virtio_cmn_config_bar_indicator_hwtcl                     (0),
		.core16_pf3_virtio_cmn_config_bar_offset_hwtcl                        (0),
		.core16_pf3_virtio_cmn_config_structure_length_hwtcl                  (0),
		.core16_pf3_virtio_notification_bar_indicator_hwtcl                   (0),
		.core16_pf3_virtio_notification_bar_offset_hwtcl                      (0),
		.core16_pf3_virtio_notification_structure_length_hwtcl                (0),
		.core16_pf3_virtio_notify_off_multiplier_hwtcl                        (0),
		.core16_pf3_virtio_isrstatus_bar_indicator_hwtcl                      (0),
		.core16_pf3_virtio_isrstatus_bar_offset_hwtcl                         (0),
		.core16_pf3_virtio_isrstatus_structure_length_hwtcl                   (0),
		.core16_pf3_virtio_devspecific_bar_indicator_hwtcl                    (0),
		.core16_pf3_virtio_devspecific_bar_offset_hwtcl                       (0),
		.core16_pf3_virtio_devspecific_structure_length_hwtcl                 (0),
		.core16_pf3_virtio_pciconfig_access_bar_indicator_hwtcl               (0),
		.core16_pf3_virtio_pciconfig_access_bar_offset_hwtcl                  (0),
		.core16_pf3_virtio_pciconfig_access_structure_length_hwtcl            (0),
		.core16_pf0vf_virtio_capability_present_hwtcl                         (0),
		.core16_pf0vf_virtio_device_specific_cap_present_hwtcl                (0),
		.core16_pf0vf_virtio_cmn_config_bar_indicator_hwtcl                   (0),
		.core16_pf0vf_virtio_cmn_config_bar_offset_hwtcl                      (0),
		.core16_pf0vf_virtio_cmn_config_structure_length_hwtcl                (0),
		.core16_pf0vf_virtio_notification_bar_indicator_hwtcl                 (0),
		.core16_pf0vf_virtio_notification_bar_offset_hwtcl                    (0),
		.core16_pf0vf_virtio_notification_structure_length_hwtcl              (0),
		.core16_pf0vf_virtio_notify_off_multiplier_hwtcl                      (0),
		.core16_pf0vf_virtio_isrstatus_bar_indicator_hwtcl                    (0),
		.core16_pf0vf_virtio_isrstatus_bar_offset_hwtcl                       (0),
		.core16_pf0vf_virtio_isrstatus_structure_length_hwtcl                 (0),
		.core16_pf0vf_virtio_devspecific_bar_indicator_hwtcl                  (0),
		.core16_pf0vf_virtio_devspecific_bar_offset_hwtcl                     (0),
		.core16_pf0vf_virtio_devspecific_structure_length_hwtcl               (0),
		.core16_pf0vf_virtio_pciconfig_access_bar_indicator_hwtcl             (0),
		.core16_pf0vf_virtio_pciconfig_access_bar_offset_hwtcl                (0),
		.core16_pf0vf_virtio_pciconfig_access_structure_length_hwtcl          (0),
		.core16_pf1vf_virtio_capability_present_hwtcl                         (0),
		.core16_pf1vf_virtio_device_specific_cap_present_hwtcl                (0),
		.core16_pf1vf_virtio_cmn_config_bar_indicator_hwtcl                   (0),
		.core16_pf1vf_virtio_cmn_config_bar_offset_hwtcl                      (0),
		.core16_pf1vf_virtio_cmn_config_structure_length_hwtcl                (0),
		.core16_pf1vf_virtio_notification_bar_indicator_hwtcl                 (0),
		.core16_pf1vf_virtio_notification_bar_offset_hwtcl                    (0),
		.core16_pf1vf_virtio_notification_structure_length_hwtcl              (0),
		.core16_pf1vf_virtio_notify_off_multiplier_hwtcl                      (0),
		.core16_pf1vf_virtio_isrstatus_bar_indicator_hwtcl                    (0),
		.core16_pf1vf_virtio_isrstatus_bar_offset_hwtcl                       (0),
		.core16_pf1vf_virtio_isrstatus_structure_length_hwtcl                 (0),
		.core16_pf1vf_virtio_devspecific_bar_indicator_hwtcl                  (0),
		.core16_pf1vf_virtio_devspecific_bar_offset_hwtcl                     (0),
		.core16_pf1vf_virtio_devspecific_structure_length_hwtcl               (0),
		.core16_pf1vf_virtio_pciconfig_access_bar_indicator_hwtcl             (0),
		.core16_pf1vf_virtio_pciconfig_access_bar_offset_hwtcl                (0),
		.core16_pf1vf_virtio_pciconfig_access_structure_length_hwtcl          (0),
		.core16_pf2vf_virtio_capability_present_hwtcl                         (0),
		.core16_pf2vf_virtio_device_specific_cap_present_hwtcl                (0),
		.core16_pf2vf_virtio_cmn_config_bar_indicator_hwtcl                   (0),
		.core16_pf2vf_virtio_cmn_config_bar_offset_hwtcl                      (0),
		.core16_pf2vf_virtio_cmn_config_structure_length_hwtcl                (0),
		.core16_pf2vf_virtio_notification_bar_indicator_hwtcl                 (0),
		.core16_pf2vf_virtio_notification_bar_offset_hwtcl                    (0),
		.core16_pf2vf_virtio_notification_structure_length_hwtcl              (0),
		.core16_pf2vf_virtio_notify_off_multiplier_hwtcl                      (0),
		.core16_pf2vf_virtio_isrstatus_bar_indicator_hwtcl                    (0),
		.core16_pf2vf_virtio_isrstatus_bar_offset_hwtcl                       (0),
		.core16_pf2vf_virtio_isrstatus_structure_length_hwtcl                 (0),
		.core16_pf2vf_virtio_devspecific_bar_indicator_hwtcl                  (0),
		.core16_pf2vf_virtio_devspecific_bar_offset_hwtcl                     (0),
		.core16_pf2vf_virtio_devspecific_structure_length_hwtcl               (0),
		.core16_pf2vf_virtio_pciconfig_access_bar_indicator_hwtcl             (0),
		.core16_pf2vf_virtio_pciconfig_access_bar_offset_hwtcl                (0),
		.core16_pf2vf_virtio_pciconfig_access_structure_length_hwtcl          (0),
		.core16_pf3vf_virtio_capability_present_hwtcl                         (0),
		.core16_pf3vf_virtio_device_specific_cap_present_hwtcl                (0),
		.core16_pf3vf_virtio_cmn_config_bar_indicator_hwtcl                   (0),
		.core16_pf3vf_virtio_cmn_config_bar_offset_hwtcl                      (0),
		.core16_pf3vf_virtio_cmn_config_structure_length_hwtcl                (0),
		.core16_pf3vf_virtio_notification_bar_indicator_hwtcl                 (0),
		.core16_pf3vf_virtio_notification_bar_offset_hwtcl                    (0),
		.core16_pf3vf_virtio_notification_structure_length_hwtcl              (0),
		.core16_pf3vf_virtio_notify_off_multiplier_hwtcl                      (0),
		.core16_pf3vf_virtio_isrstatus_bar_indicator_hwtcl                    (0),
		.core16_pf3vf_virtio_isrstatus_bar_offset_hwtcl                       (0),
		.core16_pf3vf_virtio_isrstatus_structure_length_hwtcl                 (0),
		.core16_pf3vf_virtio_devspecific_bar_indicator_hwtcl                  (0),
		.core16_pf3vf_virtio_devspecific_bar_offset_hwtcl                     (0),
		.core16_pf3vf_virtio_devspecific_structure_length_hwtcl               (0),
		.core16_pf3vf_virtio_pciconfig_access_bar_indicator_hwtcl             (0),
		.core16_pf3vf_virtio_pciconfig_access_bar_offset_hwtcl                (0),
		.core16_pf3vf_virtio_pciconfig_access_structure_length_hwtcl          (0),
		.core8_enable_virtio_hwtcl                                            (0),
		.core8_virtio_start_byte_address_hwtcl                                (72),
		.core8_pf0_virtio_capability_present_hwtcl                            (0),
		.core8_pf0_virtio_device_specific_cap_present_hwtcl                   (0),
		.core8_pf0_virtio_cmn_config_bar_indicator_hwtcl                      (0),
		.core8_pf0_virtio_cmn_config_bar_offset_hwtcl                         (0),
		.core8_pf0_virtio_cmn_config_structure_length_hwtcl                   (0),
		.core8_pf0_virtio_notification_bar_indicator_hwtcl                    (0),
		.core8_pf0_virtio_notification_bar_offset_hwtcl                       (0),
		.core8_pf0_virtio_notification_structure_length_hwtcl                 (0),
		.core8_pf0_virtio_notify_off_multiplier_hwtcl                         (0),
		.core8_pf0_virtio_isrstatus_bar_indicator_hwtcl                       (0),
		.core8_pf0_virtio_isrstatus_bar_offset_hwtcl                          (0),
		.core8_pf0_virtio_isrstatus_structure_length_hwtcl                    (0),
		.core8_pf0_virtio_devspecific_bar_indicator_hwtcl                     (0),
		.core8_pf0_virtio_devspecific_bar_offset_hwtcl                        (0),
		.core8_pf0_virtio_devspecific_structure_length_hwtcl                  (0),
		.core8_pf0_virtio_pciconfig_access_bar_indicator_hwtcl                (0),
		.core8_pf0_virtio_pciconfig_access_bar_offset_hwtcl                   (0),
		.core8_pf0_virtio_pciconfig_access_structure_length_hwtcl             (0),
		.core8_pf1_virtio_capability_present_hwtcl                            (0),
		.core8_pf1_virtio_device_specific_cap_present_hwtcl                   (0),
		.core8_pf1_virtio_cmn_config_bar_indicator_hwtcl                      (0),
		.core8_pf1_virtio_cmn_config_bar_offset_hwtcl                         (0),
		.core8_pf1_virtio_cmn_config_structure_length_hwtcl                   (0),
		.core8_pf1_virtio_notification_bar_indicator_hwtcl                    (0),
		.core8_pf1_virtio_notification_bar_offset_hwtcl                       (0),
		.core8_pf1_virtio_notification_structure_length_hwtcl                 (0),
		.core8_pf1_virtio_notify_off_multiplier_hwtcl                         (0),
		.core8_pf1_virtio_isrstatus_bar_indicator_hwtcl                       (0),
		.core8_pf1_virtio_isrstatus_bar_offset_hwtcl                          (0),
		.core8_pf1_virtio_isrstatus_structure_length_hwtcl                    (0),
		.core8_pf1_virtio_devspecific_bar_indicator_hwtcl                     (0),
		.core8_pf1_virtio_devspecific_bar_offset_hwtcl                        (0),
		.core8_pf1_virtio_devspecific_structure_length_hwtcl                  (0),
		.core8_pf1_virtio_pciconfig_access_bar_indicator_hwtcl                (0),
		.core8_pf1_virtio_pciconfig_access_bar_offset_hwtcl                   (0),
		.core8_pf1_virtio_pciconfig_access_structure_length_hwtcl             (0),
		.core8_pf2_virtio_capability_present_hwtcl                            (0),
		.core8_pf2_virtio_device_specific_cap_present_hwtcl                   (0),
		.core8_pf2_virtio_cmn_config_bar_indicator_hwtcl                      (0),
		.core8_pf2_virtio_cmn_config_bar_offset_hwtcl                         (0),
		.core8_pf2_virtio_cmn_config_structure_length_hwtcl                   (0),
		.core8_pf2_virtio_notification_bar_indicator_hwtcl                    (0),
		.core8_pf2_virtio_notification_bar_offset_hwtcl                       (0),
		.core8_pf2_virtio_notification_structure_length_hwtcl                 (0),
		.core8_pf2_virtio_notify_off_multiplier_hwtcl                         (0),
		.core8_pf2_virtio_isrstatus_bar_indicator_hwtcl                       (0),
		.core8_pf2_virtio_isrstatus_bar_offset_hwtcl                          (0),
		.core8_pf2_virtio_isrstatus_structure_length_hwtcl                    (0),
		.core8_pf2_virtio_devspecific_bar_indicator_hwtcl                     (0),
		.core8_pf2_virtio_devspecific_bar_offset_hwtcl                        (0),
		.core8_pf2_virtio_devspecific_structure_length_hwtcl                  (0),
		.core8_pf2_virtio_pciconfig_access_bar_indicator_hwtcl                (0),
		.core8_pf2_virtio_pciconfig_access_bar_offset_hwtcl                   (0),
		.core8_pf2_virtio_pciconfig_access_structure_length_hwtcl             (0),
		.core8_pf3_virtio_capability_present_hwtcl                            (0),
		.core8_pf3_virtio_device_specific_cap_present_hwtcl                   (0),
		.core8_pf3_virtio_cmn_config_bar_indicator_hwtcl                      (0),
		.core8_pf3_virtio_cmn_config_bar_offset_hwtcl                         (0),
		.core8_pf3_virtio_cmn_config_structure_length_hwtcl                   (0),
		.core8_pf3_virtio_notification_bar_indicator_hwtcl                    (0),
		.core8_pf3_virtio_notification_bar_offset_hwtcl                       (0),
		.core8_pf3_virtio_notification_structure_length_hwtcl                 (0),
		.core8_pf3_virtio_notify_off_multiplier_hwtcl                         (0),
		.core8_pf3_virtio_isrstatus_bar_indicator_hwtcl                       (0),
		.core8_pf3_virtio_isrstatus_bar_offset_hwtcl                          (0),
		.core8_pf3_virtio_isrstatus_structure_length_hwtcl                    (0),
		.core8_pf3_virtio_devspecific_bar_indicator_hwtcl                     (0),
		.core8_pf3_virtio_devspecific_bar_offset_hwtcl                        (0),
		.core8_pf3_virtio_devspecific_structure_length_hwtcl                  (0),
		.core8_pf3_virtio_pciconfig_access_bar_indicator_hwtcl                (0),
		.core8_pf3_virtio_pciconfig_access_bar_offset_hwtcl                   (0),
		.core8_pf3_virtio_pciconfig_access_structure_length_hwtcl             (0),
		.core8_pf0vf_virtio_capability_present_hwtcl                          (0),
		.core8_pf0vf_virtio_device_specific_cap_present_hwtcl                 (0),
		.core8_pf0vf_virtio_cmn_config_bar_indicator_hwtcl                    (0),
		.core8_pf0vf_virtio_cmn_config_bar_offset_hwtcl                       (0),
		.core8_pf0vf_virtio_cmn_config_structure_length_hwtcl                 (0),
		.core8_pf0vf_virtio_notification_bar_indicator_hwtcl                  (0),
		.core8_pf0vf_virtio_notification_bar_offset_hwtcl                     (0),
		.core8_pf0vf_virtio_notification_structure_length_hwtcl               (0),
		.core8_pf0vf_virtio_notify_off_multiplier_hwtcl                       (0),
		.core8_pf0vf_virtio_isrstatus_bar_indicator_hwtcl                     (0),
		.core8_pf0vf_virtio_isrstatus_bar_offset_hwtcl                        (0),
		.core8_pf0vf_virtio_isrstatus_structure_length_hwtcl                  (0),
		.core8_pf0vf_virtio_devspecific_bar_indicator_hwtcl                   (0),
		.core8_pf0vf_virtio_devspecific_bar_offset_hwtcl                      (0),
		.core8_pf0vf_virtio_devspecific_structure_length_hwtcl                (0),
		.core8_pf0vf_virtio_pciconfig_access_bar_indicator_hwtcl              (0),
		.core8_pf0vf_virtio_pciconfig_access_bar_offset_hwtcl                 (0),
		.core8_pf0vf_virtio_pciconfig_access_structure_length_hwtcl           (0),
		.core8_pf1vf_virtio_capability_present_hwtcl                          (0),
		.core8_pf1vf_virtio_device_specific_cap_present_hwtcl                 (0),
		.core8_pf1vf_virtio_cmn_config_bar_indicator_hwtcl                    (0),
		.core8_pf1vf_virtio_cmn_config_bar_offset_hwtcl                       (0),
		.core8_pf1vf_virtio_cmn_config_structure_length_hwtcl                 (0),
		.core8_pf1vf_virtio_notification_bar_indicator_hwtcl                  (0),
		.core8_pf1vf_virtio_notification_bar_offset_hwtcl                     (0),
		.core8_pf1vf_virtio_notification_structure_length_hwtcl               (0),
		.core8_pf1vf_virtio_notify_off_multiplier_hwtcl                       (0),
		.core8_pf1vf_virtio_isrstatus_bar_indicator_hwtcl                     (0),
		.core8_pf1vf_virtio_isrstatus_bar_offset_hwtcl                        (0),
		.core8_pf1vf_virtio_isrstatus_structure_length_hwtcl                  (0),
		.core8_pf1vf_virtio_devspecific_bar_indicator_hwtcl                   (0),
		.core8_pf1vf_virtio_devspecific_bar_offset_hwtcl                      (0),
		.core8_pf1vf_virtio_devspecific_structure_length_hwtcl                (0),
		.core8_pf1vf_virtio_pciconfig_access_bar_indicator_hwtcl              (0),
		.core8_pf1vf_virtio_pciconfig_access_bar_offset_hwtcl                 (0),
		.core8_pf1vf_virtio_pciconfig_access_structure_length_hwtcl           (0),
		.core8_pf2vf_virtio_capability_present_hwtcl                          (0),
		.core8_pf2vf_virtio_device_specific_cap_present_hwtcl                 (0),
		.core8_pf2vf_virtio_cmn_config_bar_indicator_hwtcl                    (0),
		.core8_pf2vf_virtio_cmn_config_bar_offset_hwtcl                       (0),
		.core8_pf2vf_virtio_cmn_config_structure_length_hwtcl                 (0),
		.core8_pf2vf_virtio_notification_bar_indicator_hwtcl                  (0),
		.core8_pf2vf_virtio_notification_bar_offset_hwtcl                     (0),
		.core8_pf2vf_virtio_notification_structure_length_hwtcl               (0),
		.core8_pf2vf_virtio_notify_off_multiplier_hwtcl                       (0),
		.core8_pf2vf_virtio_isrstatus_bar_indicator_hwtcl                     (0),
		.core8_pf2vf_virtio_isrstatus_bar_offset_hwtcl                        (0),
		.core8_pf2vf_virtio_isrstatus_structure_length_hwtcl                  (0),
		.core8_pf2vf_virtio_devspecific_bar_indicator_hwtcl                   (0),
		.core8_pf2vf_virtio_devspecific_bar_offset_hwtcl                      (0),
		.core8_pf2vf_virtio_devspecific_structure_length_hwtcl                (0),
		.core8_pf2vf_virtio_pciconfig_access_bar_indicator_hwtcl              (0),
		.core8_pf2vf_virtio_pciconfig_access_bar_offset_hwtcl                 (0),
		.core8_pf2vf_virtio_pciconfig_access_structure_length_hwtcl           (0),
		.core8_pf3vf_virtio_capability_present_hwtcl                          (0),
		.core8_pf3vf_virtio_device_specific_cap_present_hwtcl                 (0),
		.core8_pf3vf_virtio_cmn_config_bar_indicator_hwtcl                    (0),
		.core8_pf3vf_virtio_cmn_config_bar_offset_hwtcl                       (0),
		.core8_pf3vf_virtio_cmn_config_structure_length_hwtcl                 (0),
		.core8_pf3vf_virtio_notification_bar_indicator_hwtcl                  (0),
		.core8_pf3vf_virtio_notification_bar_offset_hwtcl                     (0),
		.core8_pf3vf_virtio_notification_structure_length_hwtcl               (0),
		.core8_pf3vf_virtio_notify_off_multiplier_hwtcl                       (0),
		.core8_pf3vf_virtio_isrstatus_bar_indicator_hwtcl                     (0),
		.core8_pf3vf_virtio_isrstatus_bar_offset_hwtcl                        (0),
		.core8_pf3vf_virtio_isrstatus_structure_length_hwtcl                  (0),
		.core8_pf3vf_virtio_devspecific_bar_indicator_hwtcl                   (0),
		.core8_pf3vf_virtio_devspecific_bar_offset_hwtcl                      (0),
		.core8_pf3vf_virtio_devspecific_structure_length_hwtcl                (0),
		.core8_pf3vf_virtio_pciconfig_access_bar_indicator_hwtcl              (0),
		.core8_pf3vf_virtio_pciconfig_access_bar_offset_hwtcl                 (0),
		.core8_pf3vf_virtio_pciconfig_access_structure_length_hwtcl           (0),
		.core16_pf_ceb_pointer_addr_hwtcl                                     (8'b00000000),
		.core16_vf_ceb_pointer_addr_hwtcl                                     (8'b00000000),
		.core8_pf_ceb_pointer_addr_hwtcl                                      (8'b00000000),
		.core8_vf_ceb_pointer_addr_hwtcl                                      (8'b00000000),
		.core16_perfmon_clk_freq                                              (250),
		.core8_perfmon_clk_freq                                               (250),
		.PERFMON_EN                                                           (0),
		.BP_DEBUG_MON_EN                                                      (0),
		.core16_pf_std_cap_last_ptr                                           (8'b00000000),
		.core16_pf_ext_cap_last_ptr                                           (12'b000000000000),
		.core16_vf_std_cap_last_ptr                                           (8'b00000000),
		.core16_vf_ext_cap_last_ptr                                           (12'b000000000000),
		.core8_pf_std_cap_last_ptr                                            (8'b00000000),
		.core8_pf_ext_cap_last_ptr                                            (12'b000000000000),
		.core8_vf_std_cap_last_ptr                                            (8'b00000000),
		.core8_vf_ext_cap_last_ptr                                            (12'b000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000111111111111111111111),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000011111111111111111111111),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_prs_ext_cap_outstanding_capacity_hwtcl       (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf1_prs_ext_cap_outstanding_capacity_hwtcl       (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf2_prs_ext_cap_outstanding_capacity_hwtcl       (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf3_prs_ext_cap_outstanding_capacity_hwtcl       (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sn_ser_num_reg_1_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sn_ser_num_reg_2_dw_hwtcl                    (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar0_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar1_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar2_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar3_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar4_mask_31_1_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar5_mask_31_0_hwtcl               (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar0_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar1_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar2_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar3_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar4_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar5_mask_hwtcl                     (32'b00000000000000000000000000000000),
		.sm_hssi_pcie_ctl_x4_pf0_gen3_eq_pset_req_vec_hwtcl                   (292),
		.sm_hssi_pcie_ctl_x4_pf0_gen3_eq_pset_req_vec_atg4_hwtcl              (352),
		.sm_hssi_pcie_ctl_x4_rxbuf_limit_bypass_hwtcl                         (7),
		.sm_hssi_pcie_ctl_x4_maxpayload_size_hwtcl                            ("MAXPAYLOAD_SIZE_MAX_PAYLOAD_512"),
		.sm_hssi_pcie_ctl_x4_port_type_hwtcl                                  ("PORT_TYPE_NATIVE_EP"),
		.sm_hssi_pcie_ctl_x4_sris_enable_hwtcl                                ("SRIS_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_link_num_hwtcl                                   ("SRIS_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_sris_mode_hwtcl                                  ("false"),
		.sm_hssi_pcie_ctl_x4_sim_mode_hwtcl                                   ("SIM_MODE_EP4_VSIM_MODE"),
		.sm_hssi_pcie_ctl_x4_sup_mode_hwtcl                                   ("SUP_MODE_USER_MODE"),
		.sm_hssi_pcie_ctl_x4_cvp_enable_hwtcl                                 ("CVP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_cii_monitor_en_hwtcl                             ("CII_MONITOR_EN_DISABLE"),
		.sm_hssi_pcie_ctl_x4_link_rate_hwtcl                                  ("LINK_RATE_GEN4"),
		.sm_hssi_pcie_ctl_x4_link_width_hwtcl                                 ("LINK_WIDTH_X4"),
		.sm_hssi_pcie_ctl_x4_pf0_cap_link_surprise_down_err_cap_hwtcl         ("PF0_CAP_LINK_SURPRISE_DOWN_ERR_CAP_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_port_logic_fast_link_mode                    ("PF0_PORT_LOGIC_FAST_LINK_MODE_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_prefetch_decode_hwtcl                        ("PF0_PREFETCH_DECODE_PREF64"),
		.sm_hssi_pcie_ctl_x4_pf0_virtio_en_hwtcl                              ("PF0_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_virtio_en_hwtcl                              ("PF1_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_virtio_en_hwtcl                              ("PF2_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_virtio_en_hwtcl                              ("PF3_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_exvf_virtio_en_hwtcl                         ("PF0_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_exvf_virtio_en_hwtcl                         ("PF1_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_exvf_virtio_en_hwtcl                         ("PF2_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_exvf_virtio_en_hwtcl                         ("PF3_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_device_id_hwtcl                    (2500),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_vendor_id_hwtcl                    (4466),
		.sm_hssi_pcie_ctl_x4_pf0_revision_id_hwtcl                            (1),
		.sm_hssi_pcie_ctl_x4_pf0_base_class_code_hwtcl                        (255),
		.sm_hssi_pcie_ctl_x4_pf0_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf0_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf0_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf0_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_subsysid_pf0_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf1_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x4_pf1_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x4_pf1_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf1_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf1_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf1_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_subsysid_pf1_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf2_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x4_pf2_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x4_pf2_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf2_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf2_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf2_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_subsysid_pf2_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf3_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x4_pf3_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x4_pf3_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf3_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf3_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf3_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_subsysid_pf3_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x4_pf0_user_vsec_cap_enable_hwtcl                   ("PF0_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_user_vsec_cap_enable_hwtcl                   ("PF1_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_user_vsec_cap_enable_hwtcl                   ("PF2_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_user_vsec_cap_enable_hwtcl                   ("PF3_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_vsec_next_offset_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf1_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf2_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf3_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_cvp_vendor_specific_header_id_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_drop_vendor0_msg_hwtcl                           ("FALSE"),
		.sm_hssi_pcie_ctl_x4_drop_vendor1_msg_hwtcl                           ("FALSE"),
		.sm_hssi_pcie_ctl_x4_num_of_lanes_hwtcl                               ("NUM_OF_LANES_NUM_4"),
		.sm_hssi_pcie_ctl_x4_pf0_int_pin_hwtcl                                ("PF0_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x4_pf1_int_pin_hwtcl                                ("PF1_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x4_pf2_int_pin_hwtcl                                ("PF2_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x4_pf3_int_pin_hwtcl                                ("PF3_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x4_ecrc_strip_hwtcl                                 ("ECRC_STRIP_ENABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_ats_cap_enable_hwtcl                         ("PF0_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_ats_cap_enable_hwtcl                         ("PF1_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_ats_cap_enable_hwtcl                         ("PF2_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_ats_cap_enable_hwtcl                         ("PF3_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_exvf_ats_cap_enable_hwtcl                    ("PF0_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_exvf_ats_cap_enable_hwtcl                    ("PF1_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_exvf_ats_cap_enable_hwtcl                    ("PF2_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_exvf_ats_cap_enable_hwtcl                    ("PF3_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_ats_exvf_align_request_hwtcl                 ("PF0_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf1_ats_exvf_align_request_hwtcl                 ("PF1_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf2_ats_exvf_align_request_hwtcl                 ("PF2_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf3_ats_exvf_align_request_hwtcl                 ("PF3_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_cap_enable_hwtcl                         ("PF0_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_cap_enable_hwtcl                         ("PF1_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_cap_enable_hwtcl                         ("PF2_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_cap_enable_hwtcl                         ("PF3_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_exvf_tph_cap_enable_hwtcl                    ("PF0_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_exvf_tph_cap_enable_hwtcl                    ("PF1_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_exvf_tph_cap_enable_hwtcl                    ("PF2_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_exvf_tph_cap_enable_hwtcl                    ("PF3_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_int_vec_hwtcl                    ("PF0_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_int_vec_hwtcl                    ("PF1_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_int_vec_hwtcl                    ("PF2_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_int_vec_hwtcl                    ("PF3_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF0_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF1_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF2_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF3_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_st_table_loc_1_hwtcl             ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_st_table_loc_1_hwtcl             ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_st_table_loc_1_hwtcl             ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_st_table_loc_1_hwtcl             ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_device_spec_hwtcl                    ("PF0_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_device_spec_hwtcl                    ("PF1_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_device_spec_hwtcl                    ("PF2_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_device_spec_hwtcl                    ("PF3_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF0_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF1_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF2_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF3_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_enable_hwtcl                         ("PF0_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_enable_hwtcl                         ("PF1_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_enable_hwtcl                         ("PF2_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_enable_hwtcl                         ("PF3_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_exvf_acs_cap_enable_hwtcl                    ("PF0_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_exvf_acs_cap_enable_hwtcl                    ("PF1_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_exvf_acs_cap_enable_hwtcl                    ("PF2_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_exvf_acs_cap_enable_hwtcl                    ("PF3_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_src_valid_hwtcl                  ("PF0_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_src_valid_hwtcl                  ("PF1_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_src_valid_hwtcl                  ("PF2_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_src_valid_hwtcl                  ("PF3_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_at_block_hwtcl                   ("PF0_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_at_block_hwtcl                   ("PF1_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_at_block_hwtcl                   ("PF2_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_at_block_hwtcl                   ("PF3_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF0_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF1_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF2_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF3_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF0_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF1_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF2_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF3_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_usp_forwarding_hwtcl             ("PF0_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_usp_forwarding_hwtcl             ("PF1_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_usp_forwarding_hwtcl             ("PF2_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_usp_forwarding_hwtcl             ("PF3_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_p2p_egress_control_hwtcl         ("PF0_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_p2p_egress_control_hwtcl         ("PF1_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_p2p_egress_control_hwtcl         ("PF2_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_p2p_egress_control_hwtcl         ("PF3_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x4_pf0_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF0_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF1_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF2_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF3_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_ext_tag_en_hwtcl                    ("true"),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_flr_cap_hwtcl                       ("PF0_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_flr_cap_hwtcl                       ("PF1_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_flr_cap_hwtcl                       ("PF2_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_flr_cap_hwtcl                       ("PF3_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_port_num_hwtcl                      (1),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_slot_clk_config_hwtcl               ("true"),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_msi_enable_hwtcl                             ("PF0_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_msi_enable_hwtcl                             ("PF1_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_msi_enable_hwtcl                             ("PF2_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_msi_enable_hwtcl                             ("PF3_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msi_multiple_msg_cap_hwtcl               ("PF0_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msi_multiple_msg_cap_hwtcl               ("PF1_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msi_multiple_msg_cap_hwtcl               ("PF2_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msi_multiple_msg_cap_hwtcl               ("PF3_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x4_pf0_msix_enable_hwtcl                            ("PF0_MSIX_ENABLE_ENABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_msix_enable_hwtcl                            ("PF1_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_msix_enable_hwtcl                            ("PF2_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_msix_enable_hwtcl                            ("PF3_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_table_size_hwtcl                    (15),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_table_offset_hwtcl                  (131072),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_pba_offset_hwtcl                    (196608),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x4_pf1_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x4_pf2_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x4_pf3_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x4_pf0_exvf_msix_cap_enable_hwtcl                   ("PF0_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_exvf_msix_cap_enable_hwtcl                   ("PF1_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_exvf_msix_cap_enable_hwtcl                   ("PF2_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_exvf_msix_cap_enable_hwtcl                   ("PF3_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_exvf_msix_tablesize_pf0_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msix_tablesize_pf1_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msix_tablesize_pf2_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msix_tablesize_pf3_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_offset_pf0_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_offset_pf1_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_offset_pf2_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_offset_pf3_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_bir_pf0_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_bir_pf1_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_bir_pf2_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixtable_bir_pf3_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_offset_pf0_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_offset_pf1_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_offset_pf2_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_offset_pf3_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_bir_pf0_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_bir_pf1_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_bir_pf2_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_exvf_msixpba_bir_pf3_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_slot_imp_hwtcl                          ("PF0_PCIE_SLOT_IMP_NOT_IMPLEMENTED"),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_slot_power_limit_scale_hwtcl        (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_slot_power_limit_value_hwtcl        (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_phy_slot_num_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_hot_plug_capable_hwtcl              ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (7),
		.sm_hssi_pcie_ctl_x4_pf0_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (7),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x4_pf1_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x4_pf2_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x4_pf3_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x4_aspm_support_hwtcl                               ("ASPM_SUPPORT_L0S_L1"),
		.sm_hssi_pcie_ctl_x4_dbi_ro_wr_disable_hwtcl                          ("DBI_RO_WR_DISABLE_ENABLE"),
		.sm_hssi_pcie_ctl_x4_pf0_prs_ext_cap_enable_hwtcl                     ("PF0_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_prs_ext_cap_enable_hwtcl                     ("PF1_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_prs_ext_cap_enable_hwtcl                     ("PF2_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_prs_ext_cap_enable_hwtcl                     ("PF3_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sn_cap_enable_hwtcl                          ("PF0_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sn_cap_enable_hwtcl                          ("PF1_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sn_cap_enable_hwtcl                          ("PF2_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sn_cap_enable_hwtcl                          ("PF3_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pasid_cap_enable_hwtcl                       ("PF0_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pasid_cap_enable_hwtcl                       ("PF1_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pasid_cap_enable_hwtcl                       ("PF2_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pasid_cap_enable_hwtcl                       ("PF3_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pasid_cap_execute_permission_supported_hwtcl ("PF0_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pasid_cap_execute_permission_supported_hwtcl ("PF1_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pasid_cap_execute_permission_supported_hwtcl ("PF2_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pasid_cap_execute_permission_supported_hwtcl ("PF3_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf1_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf2_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf3_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x4_pf0_pasid_cap_privileged_mode_supported_hwtcl    ("PF0_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pasid_cap_privileged_mode_supported_hwtcl    ("PF1_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pasid_cap_privileged_mode_supported_hwtcl    ("PF2_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pasid_cap_privileged_mode_supported_hwtcl    ("PF3_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_ltr_cap_enable_hwtcl                         ("PF0_LTR_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_virtual_ptm_hwtcl                                ("PTM_ENABLE_DISABLE"),
		.sm_hssi_pcie_ctl_x4_ptm_autoupdate_hwtcl                             ("PTM_AUTOUPDATE_AUTOUPDATE_DISABLE"),
		.sm_hssi_pcie_ctl_x4_pf1_enable_hwtcl                                 ("PF1_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_enable_hwtcl                                 ("PF2_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_enable_hwtcl                                 ("PF3_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_enable_hwtcl                           ("PF0_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_enable_hwtcl                           ("PF1_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_enable_hwtcl                           ("PF2_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_enable_hwtcl                           ("PF3_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar0_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR0_ENABLED_ENABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar1_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar2_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR2_ENABLED_ENABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar3_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar4_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_pci_type0_bar5_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_bar0_prefetch_hwtcl                          ("true"),
		.sm_hssi_pcie_ctl_x4_pf0_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_bar2_prefetch_hwtcl                          ("true"),
		.sm_hssi_pcie_ctl_x4_pf0_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_rom_bar_enable_hwtcl                         ("PF0_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_rom_bar_enabled_hwtcl                        ("PF0_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x4_pf0_rp_rom_bar_enabled_hwtcl                     ("PF0_RP_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_rp_rom_mask_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar0_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar1_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar2_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar3_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar4_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar5_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf0_bar0_type_hwtcl                              ("PF0_BAR0_TYPE_BAR_MEM64"),
		.sm_hssi_pcie_ctl_x4_pf0_bar2_type_hwtcl                              ("PF0_BAR2_TYPE_BAR_MEM64"),
		.sm_hssi_pcie_ctl_x4_pf0_bar4_type_hwtcl                              ("PF0_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar0_type_hwtcl                     ("PF0_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar2_type_hwtcl                     ("PF0_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf0_sriov_vf_bar4_type_hwtcl                     ("PF0_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar0_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar1_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar2_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar3_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar4_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_pci_type0_bar5_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_rom_bar_enable_hwtcl                         ("PF1_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_rom_bar_enabled_hwtcl                        ("PF1_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar0_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar1_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar2_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar3_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar4_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar5_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf1_bar0_type_hwtcl                              ("PF1_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_bar2_type_hwtcl                              ("PF1_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_bar4_type_hwtcl                              ("PF1_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar0_type_hwtcl                     ("PF1_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar2_type_hwtcl                     ("PF1_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf1_sriov_vf_bar4_type_hwtcl                     ("PF1_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar0_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar1_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar2_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar3_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar4_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_pci_type0_bar5_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_rom_bar_enable_hwtcl                         ("PF2_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_rom_bar_enabled_hwtcl                        ("PF2_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar0_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar1_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar2_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar3_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar4_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar5_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf2_bar0_type_hwtcl                              ("PF2_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_bar2_type_hwtcl                              ("PF2_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_bar4_type_hwtcl                              ("PF2_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar0_type_hwtcl                     ("PF2_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar2_type_hwtcl                     ("PF2_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf2_sriov_vf_bar4_type_hwtcl                     ("PF2_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar0_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar1_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar2_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar3_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar4_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_pci_type0_bar5_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_rom_bar_enable_hwtcl                         ("PF3_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_rom_bar_enabled_hwtcl                        ("PF3_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar0_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar1_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar2_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar3_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar4_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar5_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x4_pf3_bar0_type_hwtcl                              ("PF3_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_bar2_type_hwtcl                              ("PF3_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_bar4_type_hwtcl                              ("PF3_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar0_type_hwtcl                     ("PF3_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar2_type_hwtcl                     ("PF3_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x4_pf3_sriov_vf_bar4_type_hwtcl                     ("PF3_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.ch0_xcvr_rx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch1_xcvr_rx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch2_xcvr_rx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch3_xcvr_rx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch0_xcvr_tx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch1_xcvr_tx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch2_xcvr_tx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.ch3_xcvr_tx_protocol_hint_hwtcl                                      ("PCIE_GEN4"),
		.sm_hssi_pcie_ctl_x8_pf0_gen3_eq_pset_req_vec_hwtcl                   (0),
		.sm_hssi_pcie_ctl_x8_pf0_gen3_eq_pset_req_vec_atg4_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_rxbuf_limit_bypass_hwtcl                         (7),
		.sm_hssi_pcie_ctl_x8_maxpayload_size_hwtcl                            ("MAXPAYLOAD_SIZE_MAX_PAYLOAD_512"),
		.sm_hssi_pcie_ctl_x8_port_type_hwtcl                                  ("PORT_TYPE_NATIVE_EP"),
		.sm_hssi_pcie_ctl_x8_sris_enable_hwtcl                                ("SRIS_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_link_num_hwtcl                                   ("SRIS_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_sris_mode_hwtcl                                  ("false"),
		.sm_hssi_pcie_ctl_x8_sim_mode_hwtcl                                   ("SIM_MODE_DISABLE_VSIM_MODE"),
		.sm_hssi_pcie_ctl_x8_sup_mode_hwtcl                                   ("SUP_MODE_USER_MODE"),
		.sm_hssi_pcie_ctl_x8_cvp_enable_hwtcl                                 ("CVP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_cii_monitor_en_hwtcl                             ("CII_MONITOR_EN_DISABLE"),
		.sm_hssi_pcie_ctl_x8_link_rate_hwtcl                                  ("LINK_RATE_GEN1"),
		.sm_hssi_pcie_ctl_x8_link_width_hwtcl                                 ("LINK_WIDTH_X1"),
		.sm_hssi_pcie_ctl_x8_pf0_cap_link_surprise_down_err_cap_hwtcl         ("PF0_CAP_LINK_SURPRISE_DOWN_ERR_CAP_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_port_logic_fast_link_mode                    ("PF0_PORT_LOGIC_FAST_LINK_MODE_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_prefetch_decode_hwtcl                        ("PF0_PREFETCH_DECODE_PREF64"),
		.sm_hssi_pcie_ctl_x8_pf0_virtio_en_hwtcl                              ("PF0_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_virtio_en_hwtcl                              ("PF1_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_virtio_en_hwtcl                              ("PF2_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_virtio_en_hwtcl                              ("PF3_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_exvf_virtio_en_hwtcl                         ("PF0_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_exvf_virtio_en_hwtcl                         ("PF1_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_exvf_virtio_en_hwtcl                         ("PF2_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_exvf_virtio_en_hwtcl                         ("PF3_EXVF_VIRTIO_EN_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf0_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x8_pf0_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x8_pf0_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf0_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf0_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf0_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_subsysid_pf0_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf1_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x8_pf1_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x8_pf1_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf1_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf1_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf1_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_subsysid_pf1_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf2_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x8_pf2_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x8_pf2_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf2_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf2_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf2_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_subsysid_pf2_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_vendor_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_device_id_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf3_revision_id_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x8_pf3_base_class_code_hwtcl                        (0),
		.sm_hssi_pcie_ctl_x8_pf3_subclass_code_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf3_program_interface_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf3_subsys_vendor_id_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf3_subsys_dev_id_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_device_id_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_subsysid_pf3_hwtcl                          (0),
		.sm_hssi_pcie_ctl_x8_pf0_user_vsec_cap_enable_hwtcl                   ("PF0_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_user_vsec_cap_enable_hwtcl                   ("PF1_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_user_vsec_cap_enable_hwtcl                   ("PF2_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_user_vsec_cap_enable_hwtcl                   ("PF3_USER_VSEC_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_vsec_next_offset_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf1_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf2_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf3_user_vsec_offset_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_cvp_vendor_specific_header_id_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_drop_vendor0_msg_hwtcl                           ("FALSE"),
		.sm_hssi_pcie_ctl_x8_drop_vendor1_msg_hwtcl                           ("FALSE"),
		.sm_hssi_pcie_ctl_x8_num_of_lanes_hwtcl                               ("NUM_OF_LANES_NUM_1"),
		.sm_hssi_pcie_ctl_x8_pf0_int_pin_hwtcl                                ("PF0_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x8_pf1_int_pin_hwtcl                                ("PF1_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x8_pf2_int_pin_hwtcl                                ("PF2_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x8_pf3_int_pin_hwtcl                                ("PF3_INT_PIN_NO_INT"),
		.sm_hssi_pcie_ctl_x8_ecrc_strip_hwtcl                                 ("ECRC_STRIP_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_ats_cap_enable_hwtcl                         ("PF0_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_ats_cap_enable_hwtcl                         ("PF1_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_ats_cap_enable_hwtcl                         ("PF2_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_ats_cap_enable_hwtcl                         ("PF3_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_exvf_ats_cap_enable_hwtcl                    ("PF0_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_exvf_ats_cap_enable_hwtcl                    ("PF1_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_exvf_ats_cap_enable_hwtcl                    ("PF2_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_exvf_ats_cap_enable_hwtcl                    ("PF3_EXVF_ATS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_ats_exvf_align_request_hwtcl                 ("PF0_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf1_ats_exvf_align_request_hwtcl                 ("PF1_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf2_ats_exvf_align_request_hwtcl                 ("PF2_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf3_ats_exvf_align_request_hwtcl                 ("PF3_ATS_EXVF_ALIGN_REQUEST_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_cap_enable_hwtcl                         ("PF0_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_cap_enable_hwtcl                         ("PF1_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_cap_enable_hwtcl                         ("PF2_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_cap_enable_hwtcl                         ("PF3_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_exvf_tph_cap_enable_hwtcl                    ("PF0_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_exvf_tph_cap_enable_hwtcl                    ("PF1_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_exvf_tph_cap_enable_hwtcl                    ("PF2_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_exvf_tph_cap_enable_hwtcl                    ("PF3_EXVF_TPH_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_int_vec_hwtcl                    ("PF0_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_int_vec_hwtcl                    ("PF1_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_int_vec_hwtcl                    ("PF2_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_int_vec_hwtcl                    ("PF3_TPH_REQ_CAP_INT_VEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF0_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF1_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF2_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_int_vec_vfcomm_cs2_hwtcl         ("PF3_TPH_REQ_CAP_INT_VEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_st_table_loc_0_vfcomm_cs2_hwtcl  ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_0_VFCOMM_CS2_NOT_IN_TPH_STRUCT_VF"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_st_table_loc_1_hwtcl             ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_st_table_loc_1_hwtcl             ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_st_table_loc_1_hwtcl             ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_st_table_loc_1_hwtcl             ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_1_NOT_IN_MSIX_TABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF0_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF1_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF2_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_st_table_loc_1_vfcomm_cs2_hwtcl  ("PF3_TPH_REQ_CAP_ST_TABLE_LOC_1_VFCOMM_CS2_NOT_IN_MSIX_TABLE_VF"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_st_table_size_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_cap_st_table_size_vfcomm_cs2_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_device_spec_hwtcl                    ("PF0_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_device_spec_hwtcl                    ("PF1_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_device_spec_hwtcl                    ("PF2_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_device_spec_hwtcl                    ("PF3_TPH_REQ_DEVICE_SPEC_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF0_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF1_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF2_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_tph_req_device_spec_vfcomm_cs2_hwtcl         ("PF3_TPH_REQ_DEVICE_SPEC_VFCOMM_CS2_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_enable_hwtcl                         ("PF0_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_enable_hwtcl                         ("PF1_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_enable_hwtcl                         ("PF2_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_enable_hwtcl                         ("PF3_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_exvf_acs_cap_enable_hwtcl                    ("PF0_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_exvf_acs_cap_enable_hwtcl                    ("PF1_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_exvf_acs_cap_enable_hwtcl                    ("PF2_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_exvf_acs_cap_enable_hwtcl                    ("PF3_EXVF_ACS_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_src_valid_hwtcl                  ("PF0_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_src_valid_hwtcl                  ("PF1_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_src_valid_hwtcl                  ("PF2_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_src_valid_hwtcl                  ("PF3_ACS_CAP_ACS_SRC_VALID_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_at_block_hwtcl                   ("PF0_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_at_block_hwtcl                   ("PF1_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_at_block_hwtcl                   ("PF2_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_at_block_hwtcl                   ("PF3_ACS_CAP_ACS_AT_BLOCK_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF0_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF1_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF2_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_p2p_req_redirect_hwtcl           ("PF3_ACS_CAP_ACS_P2P_REQ_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF0_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF1_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF2_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_p2p_cpl_redirect_hwtcl           ("PF3_ACS_CAP_ACS_P2P_CPL_REDIRECT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_usp_forwarding_hwtcl             ("PF0_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_usp_forwarding_hwtcl             ("PF1_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_usp_forwarding_hwtcl             ("PF2_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_usp_forwarding_hwtcl             ("PF3_ACS_CAP_ACS_USP_FORWARDING_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_p2p_egress_control_hwtcl         ("PF0_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_p2p_egress_control_hwtcl         ("PF1_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_p2p_egress_control_hwtcl         ("PF2_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_p2p_egress_control_hwtcl         ("PF3_ACS_CAP_ACS_P2P_EGRESS_CONTROL_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_egress_ctrl_size_hwtcl           (8),
		.sm_hssi_pcie_ctl_x8_pf0_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF0_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF1_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF2_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_acs_cap_acs_direct_translated_p2p_hwtcl      ("PF3_ACS_CAP_ACS_DIRECT_TRANSLATED_P2P_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_ext_tag_en_hwtcl                    ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_flr_cap_hwtcl                       ("PF0_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_flr_cap_hwtcl                       ("PF1_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_flr_cap_hwtcl                       ("PF2_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_flr_cap_hwtcl                       ("PF3_PCIE_CAP_FLR_CAP_NOT_CAPABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_port_num_hwtcl                      (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_slot_clk_config_hwtcl               ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_msi_enable_hwtcl                             ("PF0_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_msi_enable_hwtcl                             ("PF1_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_msi_enable_hwtcl                             ("PF2_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_msi_enable_hwtcl                             ("PF3_MSI_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msi_ext_data_cap_hwtcl                   ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msi_64_bit_addr_cap_hwtcl                ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msi_multiple_msg_cap_hwtcl               ("PF0_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msi_multiple_msg_cap_hwtcl               ("PF1_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msi_multiple_msg_cap_hwtcl               ("PF2_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msi_multiple_msg_cap_hwtcl               ("PF3_PCI_MSI_MULTIPLE_MSG_CAP_MSI_VEC_1"),
		.sm_hssi_pcie_ctl_x8_pf0_msix_enable_hwtcl                            ("PF0_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_msix_enable_hwtcl                            ("PF1_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_msix_enable_hwtcl                            ("PF2_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_msix_enable_hwtcl                            ("PF3_MSIX_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_table_size_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_table_offset_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_bir_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_pba_hwtcl                           (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_pba_offset_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x8_pf1_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x8_pf2_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x8_pf3_pci_msix_table_size_vfcomm_cs2_hwtcl         (0),
		.sm_hssi_pcie_ctl_x8_pf0_exvf_msix_cap_enable_hwtcl                   ("PF0_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_exvf_msix_cap_enable_hwtcl                   ("PF1_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_exvf_msix_cap_enable_hwtcl                   ("PF2_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_exvf_msix_cap_enable_hwtcl                   ("PF3_EXVF_MSIX_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_exvf_msix_tablesize_pf0_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msix_tablesize_pf1_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msix_tablesize_pf2_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msix_tablesize_pf3_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_offset_pf0_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_offset_pf1_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_offset_pf2_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_offset_pf3_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_bir_pf0_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_bir_pf1_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_bir_pf2_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixtable_bir_pf3_hwtcl                     (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_offset_pf0_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_offset_pf1_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_offset_pf2_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_offset_pf3_hwtcl                    (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_bir_pf0_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_bir_pf1_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_bir_pf2_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_exvf_msixpba_bir_pf3_hwtcl                       (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_slot_imp_hwtcl                          ("PF0_PCIE_SLOT_IMP_NOT_IMPLEMENTED"),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_slot_power_limit_scale_hwtcl        (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_slot_power_limit_value_hwtcl        (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_phy_slot_num_hwtcl                  (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_hot_plug_capable_hwtcl              ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_ep_l0s_accpt_latency_hwtcl          (0),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_ep_l1_accpt_latency_hwtcl           (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x8_pf0_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x8_pf1_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x8_pf2_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_l0s_exit_latency_commclk_dis_hwtcl  (0),
		.sm_hssi_pcie_ctl_x8_pf3_pcie_cap_l1_exit_latency_commclk_dis_hwtcl   (0),
		.sm_hssi_pcie_ctl_x8_aspm_support_hwtcl                               ("ASPM_SUPPORT_DISABLED"),
		.sm_hssi_pcie_ctl_x8_dbi_ro_wr_disable_hwtcl                          ("DBI_RO_WR_DISABLE_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf0_prs_ext_cap_enable_hwtcl                     ("PF0_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_prs_ext_cap_enable_hwtcl                     ("PF1_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_prs_ext_cap_enable_hwtcl                     ("PF2_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_prs_ext_cap_enable_hwtcl                     ("PF3_PRS_EXT_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_prs_ext_cap_outstanding_capacity_hwtcl       (0),
		.sm_hssi_pcie_ctl_x8_pf1_prs_ext_cap_outstanding_capacity_hwtcl       (0),
		.sm_hssi_pcie_ctl_x8_pf2_prs_ext_cap_outstanding_capacity_hwtcl       (0),
		.sm_hssi_pcie_ctl_x8_pf3_prs_ext_cap_outstanding_capacity_hwtcl       (0),
		.sm_hssi_pcie_ctl_x8_pf0_sn_cap_enable_hwtcl                          ("PF0_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sn_cap_enable_hwtcl                          ("PF1_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sn_cap_enable_hwtcl                          ("PF2_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sn_cap_enable_hwtcl                          ("PF3_SN_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pasid_cap_enable_hwtcl                       ("PF0_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pasid_cap_enable_hwtcl                       ("PF1_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pasid_cap_enable_hwtcl                       ("PF2_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pasid_cap_enable_hwtcl                       ("PF3_PASID_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pasid_cap_execute_permission_supported_hwtcl ("PF0_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pasid_cap_execute_permission_supported_hwtcl ("PF1_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pasid_cap_execute_permission_supported_hwtcl ("PF2_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pasid_cap_execute_permission_supported_hwtcl ("PF3_PASID_CAP_EXECUTE_PERMISSION_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf1_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf2_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf3_pasid_cap_max_pasid_width_hwtcl              (0),
		.sm_hssi_pcie_ctl_x8_pf0_pasid_cap_privileged_mode_supported_hwtcl    ("PF0_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pasid_cap_privileged_mode_supported_hwtcl    ("PF1_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pasid_cap_privileged_mode_supported_hwtcl    ("PF2_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pasid_cap_privileged_mode_supported_hwtcl    ("PF3_PASID_CAP_PRIVILEGED_MODE_SUPPORTED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_ltr_cap_enable_hwtcl                         ("PF0_LTR_CAP_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_virtual_ptm_hwtcl                                ("PTM_ENABLE_DISABLE"),
		.sm_hssi_pcie_ctl_x8_ptm_autoupdate_hwtcl                             ("PTM_AUTOUPDATE_AUTOUPDATE_DISABLE"),
		.sm_hssi_pcie_ctl_x8_pf1_enable_hwtcl                                 ("PF1_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_enable_hwtcl                                 ("PF2_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_enable_hwtcl                                 ("PF3_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_enable_hwtcl                           ("PF0_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_enable_hwtcl                           ("PF1_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_enable_hwtcl                           ("PF2_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_enable_hwtcl                           ("PF3_SRIOV_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_cap_sup_page_size_hwtcl                (0),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar0_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar1_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar2_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar3_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar4_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_pci_type0_bar5_enabled_hwtcl                 ("PF0_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_rom_bar_enable_hwtcl                         ("PF0_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_rom_bar_enabled_hwtcl                        ("PF0_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x8_pf0_rp_rom_bar_enabled_hwtcl                     ("PF0_RP_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_rp_rom_mask_hwtcl                            (0),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar0_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar1_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar2_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar3_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar4_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar5_enabled_hwtcl                  ("PF0_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf0_bar0_type_hwtcl                              ("PF0_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf0_bar2_type_hwtcl                              ("PF0_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf0_bar4_type_hwtcl                              ("PF0_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar0_type_hwtcl                     ("PF0_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar2_type_hwtcl                     ("PF0_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf0_sriov_vf_bar4_type_hwtcl                     ("PF0_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar0_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar1_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar2_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar3_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar4_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_pci_type0_bar5_enabled_hwtcl                 ("PF1_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_rom_bar_enable_hwtcl                         ("PF1_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_rom_bar_enabled_hwtcl                        ("PF1_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar0_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar1_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar2_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar3_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar4_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar5_enabled_hwtcl                  ("PF1_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf1_bar0_type_hwtcl                              ("PF1_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_bar2_type_hwtcl                              ("PF1_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_bar4_type_hwtcl                              ("PF1_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar0_type_hwtcl                     ("PF1_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar2_type_hwtcl                     ("PF1_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf1_sriov_vf_bar4_type_hwtcl                     ("PF1_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar0_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar1_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar2_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar3_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar4_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_pci_type0_bar5_enabled_hwtcl                 ("PF2_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_rom_bar_enable_hwtcl                         ("PF2_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_rom_bar_enabled_hwtcl                        ("PF2_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar0_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar1_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar2_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar3_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar4_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar5_enabled_hwtcl                  ("PF2_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf2_bar0_type_hwtcl                              ("PF2_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_bar2_type_hwtcl                              ("PF2_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_bar4_type_hwtcl                              ("PF2_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar0_type_hwtcl                     ("PF2_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar2_type_hwtcl                     ("PF2_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf2_sriov_vf_bar4_type_hwtcl                     ("PF2_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar0_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar1_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar2_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar3_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar4_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_pci_type0_bar5_enabled_hwtcl                 ("PF3_PCI_TYPE0_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_bar0_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar1_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar2_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar3_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar4_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar5_prefetch_hwtcl                          ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_rom_bar_enable_hwtcl                         ("PF3_ROM_BAR_ENABLE_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_rom_bar_enabled_hwtcl                        ("PF3_ROM_BAR_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_rom_mask_hwtcl                               (0),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar0_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR0_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar1_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR1_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar2_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR2_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar3_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR3_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar4_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR4_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar5_enabled_hwtcl                  ("PF3_SRIOV_VF_BAR5_ENABLED_DISABLED"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar0_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar1_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar2_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar3_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar4_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar5_prefetch_hwtcl                 ("false"),
		.sm_hssi_pcie_ctl_x8_pf3_bar0_type_hwtcl                              ("PF3_BAR0_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_bar2_type_hwtcl                              ("PF3_BAR2_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_bar4_type_hwtcl                              ("PF3_BAR4_TYPE_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar0_type_hwtcl                     ("PF3_SRIOV_VF_BAR0_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar2_type_hwtcl                     ("PF3_SRIOV_VF_BAR2_TYPE_SRIOV_VF_BAR_MEM32"),
		.sm_hssi_pcie_ctl_x8_pf3_sriov_vf_bar4_type_hwtcl                     ("PF3_SRIOV_VF_BAR4_TYPE_SRIOV_VF_BAR_MEM32"),
		.core8_ch0_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch1_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch2_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch3_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch4_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch5_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch6_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch7_xcvr_rx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch0_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch1_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch2_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch3_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch4_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch5_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch6_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3"),
		.core8_ch7_xcvr_tx_protocol_hint_hwtcl                                ("PCIE_GEN3")
	) dut (
		.refclk0                                     (refclk0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //   input,    width = 1,                      refclk0.clk
		.p0_i_syspll_c0_clk                          (p0_i_syspll_c0_clk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //   input,    width = 1,           p0_i_syspll_c0_clk.clk
		.p0_i_ss_vccl_syspll_locked                  (p0_i_ss_vccl_syspll_locked),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,   p0_i_ss_vccl_syspll_locked.o_pll_lock
		.i_flux_clk                                  (i_flux_clk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,                   i_flux_clk.clk
		.rx_n_in0                                    (rx_n_in0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                   hip_serial.rx_n_in0
		.rx_p_in0                                    (rx_p_in0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_p_in0
		.tx_n_out0                                   (tx_n_out0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_n_out0
		.tx_p_out0                                   (tx_p_out0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_p_out0
		.rx_n_in1                                    (rx_n_in1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_n_in1
		.rx_p_in1                                    (rx_p_in1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_p_in1
		.tx_n_out1                                   (tx_n_out1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_n_out1
		.tx_p_out1                                   (tx_p_out1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_p_out1
		.rx_n_in2                                    (rx_n_in2),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_n_in2
		.rx_p_in2                                    (rx_p_in2),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_p_in2
		.tx_n_out2                                   (tx_n_out2),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_n_out2
		.tx_p_out2                                   (tx_p_out2),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_p_out2
		.rx_n_in3                                    (rx_n_in3),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_n_in3
		.rx_p_in3                                    (rx_p_in3),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 1,                             .rx_p_in3
		.tx_n_out3                                   (tx_n_out3),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_n_out3
		.tx_p_out3                                   (tx_p_out3),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .tx_p_out3
		.p0_pin_perst_n_i                            (p0_pin_perst_n_i),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //   input,    width = 1,             p0_pin_perst_n_i.reset_n
		.p0_pin_perst_n_1_i                          (p0_pin_perst_n_1_i),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //   input,    width = 1,           p0_pin_perst_n_1_i.reset_n
		.p0_coreclkout_hip_toapp                     (p0_coreclkout_hip_toapp),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //  output,    width = 1,      p0_coreclkout_hip_toapp.clk
		.p0_pin_perst_n                              (p0_pin_perst_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //  output,    width = 1,               p0_pin_perst_n.reset_n
		.p0_reset_status_n                           (p0_reset_status_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     //  output,    width = 1,            p0_reset_status_n.reset_n
		.ninit_done                                  (ninit_done),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,                   ninit_done.reset
		.p0_axi_st_clk                               (p0_axi_st_clk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         //   input,    width = 1,                p0_axi_st_clk.clk
		.p0_axi_lite_clk                             (p0_axi_lite_clk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       //   input,    width = 1,              p0_axi_lite_clk.clk
		.p0_axi_st_areset_n                          (p0_axi_st_areset_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //   input,    width = 1,           p0_axi_st_areset_n.reset_n
		.p0_axi_lite_areset_n                        (p0_axi_lite_areset_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //   input,    width = 1,         p0_axi_lite_areset_n.reset_n
		.p0_subsystem_cold_rst_n                     (p0_subsystem_cold_rst_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //   input,    width = 1,      p0_subsystem_cold_rst_n.reset_n
		.p0_subsystem_warm_rst_n                     (p0_subsystem_warm_rst_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //   input,    width = 1,      p0_subsystem_warm_rst_n.reset_n
		.p0_subsystem_cold_rst_ack_n                 (p0_subsystem_cold_rst_ack_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //  output,    width = 1,  p0_subsystem_cold_rst_ack_n.subsystem_cold_rst_ack_n
		.p0_subsystem_warm_rst_ack_n                 (p0_subsystem_warm_rst_ack_n),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //  output,    width = 1,  p0_subsystem_warm_rst_ack_n.subsystem_warm_rst_ack_n
		.p0_subsystem_rst_req                        (p0_subsystem_rst_req),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //   input,    width = 1,         p0_subsystem_rst_req.subsystem_rst_req
		.p0_subsystem_rst_rdy                        (p0_subsystem_rst_rdy),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //  output,    width = 1,         p0_subsystem_rst_rdy.subsystem_rst_rdy
		.p0_initiate_warmrst_req                     (p0_initiate_warmrst_req),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //  output,    width = 1,      p0_initiate_warmrst_req.initiate_warmrst_req
		.p0_initiate_rst_req_rdy                     (p0_initiate_rst_req_rdy),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //   input,    width = 1,      p0_initiate_rst_req_rdy.initiate_rst_req_rdy
		.p0_ss_app_st_rx_tvalid                      (p0_ss_app_st_rx_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                //  output,    width = 1,                     p0_st_rx.tvalid
		.p0_app_ss_st_rx_tready                      (p0_app_ss_st_rx_tready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                //   input,    width = 1,                             .tready
		.p0_ss_app_st_rx_tdata                       (p0_ss_app_st_rx_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //  output,  width = 256,                             .tdata
		.p0_ss_app_st_rx_tkeep                       (p0_ss_app_st_rx_tkeep),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //  output,   width = 32,                             .tkeep
		.p0_ss_app_st_rx_tlast                       (p0_ss_app_st_rx_tlast),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //  output,    width = 1,                             .tlast
		.p0_ss_app_st_rx_tuser_hdr                   (p0_ss_app_st_rx_tuser_hdr),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,  width = 256,    p0_ss_app_st_rx_tuser_hdr.st_rx_tuser_hdr
		.p0_ss_app_st_rx_tuser_hvalid                (p0_ss_app_st_rx_tuser_hvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //  output,    width = 1, p0_ss_app_st_rx_tuser_hvalid.st_rx_tuser_hvalid
		.p0_app_ss_st_tx_tvalid                      (p0_app_ss_st_tx_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                //   input,    width = 1,                     p0_st_tx.tvalid
		.p0_ss_app_st_tx_tready                      (p0_ss_app_st_tx_tready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                //  output,    width = 1,                             .tready
		.p0_app_ss_st_tx_tdata                       (p0_app_ss_st_tx_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //   input,  width = 256,                             .tdata
		.p0_app_ss_st_tx_tkeep                       (p0_app_ss_st_tx_tkeep),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //   input,   width = 32,                             .tkeep
		.p0_app_ss_st_tx_tlast                       (p0_app_ss_st_tx_tlast),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 //   input,    width = 1,                             .tlast
		.p0_app_ss_st_tx_tuser_hdr                   (p0_app_ss_st_tx_tuser_hdr),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,  width = 256,    p0_app_ss_st_tx_tuser_hdr.st_tx_tuser_hdr
		.p0_app_ss_st_tx_tuser_hvalid                (p0_app_ss_st_tx_tuser_hvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //   input,    width = 1, p0_app_ss_st_tx_tuser_hvalid.st_tx_tuser_hvalid
		.p0_ss_app_st_ciireq_tvalid                  (p0_ss_app_st_ciireq_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //  output,    width = 1,                 p0_st_ciireq.tvalid
		.p0_app_ss_st_ciireq_tready                  (p0_app_ss_st_ciireq_tready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,                             .tready
		.p0_ss_app_st_ciireq_tdata                   (p0_ss_app_st_ciireq_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,   width = 72,                             .tdata
		.p0_app_ss_st_ciiresp_tvalid                 (p0_app_ss_st_ciiresp_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //   input,    width = 1,                p0_st_ciiresp.tvalid
		.p0_app_ss_st_ciiresp_tdata                  (p0_app_ss_st_ciiresp_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,   width = 33,                             .tdata
		.p0_ss_app_st_ctrlshadow_tvalid              (p0_ss_app_st_ctrlshadow_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //  output,    width = 1,             p0_st_ctrlshadow.tvalid
		.p0_ss_app_st_ctrlshadow_tdata               (p0_ss_app_st_ctrlshadow_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         //  output,   width = 40,                             .tdata
		.p0_ss_app_st_txcrdt_tvalid                  (p0_ss_app_st_txcrdt_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //  output,    width = 1,                 p0_st_txcrdt.tvalid
		.p0_ss_app_st_txcrdt_tdata                   (p0_ss_app_st_txcrdt_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,   width = 19,                             .tdata
		.p0_ss_app_st_cplto_tvalid                   (p0_ss_app_st_cplto_tvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                  p0_st_cplto.tvalid
		.p0_ss_app_st_cplto_tdata                    (p0_ss_app_st_cplto_tdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //  output,   width = 49,                             .tdata
		.p0_app_ss_lite_csr_awvalid                  (p0_app_ss_lite_csr_awvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,                  p0_lite_csr.awvalid
		.p0_ss_app_lite_csr_awready                  (p0_ss_app_lite_csr_awready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //  output,    width = 1,                             .awready
		.p0_app_ss_lite_csr_awaddr                   (p0_app_ss_lite_csr_awaddr),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,   width = 20,                             .awaddr
		.p0_app_ss_lite_csr_wvalid                   (p0_app_ss_lite_csr_wvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,    width = 1,                             .wvalid
		.p0_ss_app_lite_csr_wready                   (p0_ss_app_lite_csr_wready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .wready
		.p0_app_ss_lite_csr_wdata                    (p0_app_ss_lite_csr_wdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,   width = 32,                             .wdata
		.p0_app_ss_lite_csr_wstrb                    (p0_app_ss_lite_csr_wstrb),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //   input,    width = 4,                             .wstrb
		.p0_ss_app_lite_csr_bvalid                   (p0_ss_app_lite_csr_bvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .bvalid
		.p0_app_ss_lite_csr_bready                   (p0_app_ss_lite_csr_bready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,    width = 1,                             .bready
		.p0_ss_app_lite_csr_bresp                    (p0_ss_app_lite_csr_bresp),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //  output,    width = 2,                             .bresp
		.p0_app_ss_lite_csr_arvalid                  (p0_app_ss_lite_csr_arvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 1,                             .arvalid
		.p0_ss_app_lite_csr_arready                  (p0_ss_app_lite_csr_arready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //  output,    width = 1,                             .arready
		.p0_app_ss_lite_csr_araddr                   (p0_app_ss_lite_csr_araddr),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,   width = 20,                             .araddr
		.p0_ss_app_lite_csr_rvalid                   (p0_ss_app_lite_csr_rvalid),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //  output,    width = 1,                             .rvalid
		.p0_app_ss_lite_csr_rready                   (p0_app_ss_lite_csr_rready),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //   input,    width = 1,                             .rready
		.p0_ss_app_lite_csr_rdata                    (p0_ss_app_lite_csr_rdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //  output,   width = 32,                             .rdata
		.p0_ss_app_lite_csr_rresp                    (p0_ss_app_lite_csr_rresp),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //  output,    width = 2,                             .rresp
		.p0_ss_app_serr                              (p0_ss_app_serr),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //  output,    width = 1,               p0_ss_app_serr.ss_app_serr
		.p0_ss_app_dlup                              (p0_ss_app_dlup),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //  output,    width = 1,               p0_ss_app_dlup.ss_app_dlup
		.p0_ss_app_linkup                            (p0_ss_app_linkup),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //  output,    width = 1,             p0_ss_app_linkup.ss_app_linkup
		.p0_ss_app_ltssmstate                        (p0_ss_app_ltssmstate),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //  output,    width = 6,         p0_ss_app_ltssmstate.ss_app_ltssmstate
		.p0_app_ss_st_rx_tuser_halt                  (p0_app_ss_st_rx_tuser_halt),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            //   input,    width = 3,   p0_app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt
		.refclk1                                     (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_i_syspll_c0_clk                          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_i_ss_vccl_syspll_locked                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.rx_n_in4                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.rx_p_in4                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.tx_n_out4                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.tx_p_out4                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.rx_n_in5                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.rx_p_in5                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.tx_n_out5                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.tx_p_out5                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.rx_n_in6                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.rx_p_in6                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.tx_n_out6                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.tx_p_out6                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.rx_n_in7                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.rx_p_in7                                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.tx_n_out7                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.tx_p_out7                                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_pin_perst_n_i                            (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_gpio_perst0_n                             (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_gpio_perst1_n                             (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_coreclkout_hip_toapp                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_pin_perst_n                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_reset_status_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_axi_st_clk                               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_axi_lite_clk                             (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_axi_st_areset_n                          (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_axi_lite_areset_n                        (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_subsystem_cold_rst_n                     (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_subsystem_warm_rst_n                     (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_subsystem_cold_rst_ack_n                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_subsystem_warm_rst_ack_n                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_subsystem_rst_req                        (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_subsystem_rst_rdy                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_initiate_warmrst_req                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_initiate_rst_req_rdy                     (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_axi_mm_clk                               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_axi_mm_clk                               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_axi_mm_areset_n                          (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_axi_mm_areset_n                          (1'b1),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_st_rx_tuser_vendor                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_st_rx_tuser                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tvalid                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_rx_tready                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_rx_tdata                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tkeep                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tlast                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tuser_vendor                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tuser                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tuser_hdr                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_rx_tuser_hvalid                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_st_tx_tuser_vendor                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_app_ss_st_tx_tuser                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_tx_tvalid                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_tx_tready                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_tx_tdata                       (128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_app_ss_st_tx_tkeep                       (16'b0000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_tx_tlast                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_tx_tuser_vendor                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_app_ss_st_tx_tuser                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_tx_tuser_hdr                   (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_app_ss_st_tx_tuser_hvalid                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_st_txreq_tvalid                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_st_txreq_tready                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_st_txreq_tdata                    (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_app_ss_st_txreq_tlast                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_txreq_tvalid                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_txreq_tready                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_txreq_tdata                    (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_app_ss_st_txreq_tlast                    (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_ciireq_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_ciireq_tready                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_ciireq_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_ciiresp_tvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_ciiresp_tdata                  (33'b000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_ss_app_st_cebreq_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_st_cebreq_tready                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_st_cebreq_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_st_cebresp_tvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_st_cebresp_tdata                  (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_cebreq_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_cebreq_tready                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_cebreq_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_cebresp_tvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_cebresp_tdata                  (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_st_flrrcvd_tvalid                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_st_flrrcvd_tdata                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_st_flrcmpl_tvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_st_flrcmpl_tdata                  (22'b0000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            // (terminated),                                            
		.p0_ss_app_st_flrcmpl_tready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_flrrcvd_tvalid                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_flrrcvd_tdata                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_flrcmpl_tvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_flrcmpl_tdata                  (22'b0000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            // (terminated),                                            
		.p1_ss_app_st_flrcmpl_tready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_ctrlshadow_tvalid              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_ctrlshadow_tdata               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_txcrdt_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_txcrdt_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_cplto_tvalid                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_cplto_tdata                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_st_bp_err_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_st_bp_err_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_bp_err_tvalid                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_st_bp_err_tdata                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_awvalid                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_csr_awready                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_awaddr                   (20'b00000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              // (terminated),                                            
		.p1_app_ss_lite_csr_wvalid                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_csr_wready                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_wdata                    (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_lite_csr_wstrb                    (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.p1_ss_app_lite_csr_bvalid                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_bready                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_csr_bresp                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_arvalid                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_csr_arready                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_araddr                   (20'b00000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              // (terminated),                                            
		.p1_ss_app_lite_csr_rvalid                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_csr_rready                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_csr_rdata                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_lite_csr_rresp                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_lite_initatr_awvalid              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_awready              (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_lite_initatr_awaddr               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_lite_initatr_wvalid               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_wready               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_lite_initatr_wdata                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_lite_initatr_wstrb                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_bvalid               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_lite_initatr_bready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_bresp                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_ss_app_lite_initatr_arvalid              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_arready              (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_lite_initatr_araddr               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_rvalid               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_lite_initatr_rready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_lite_initatr_rdata                (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_lite_initatr_rresp                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_ss_app_lite_initatr_awvalid              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_awready              (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_initatr_awaddr               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_lite_initatr_wvalid               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_wready               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_initatr_wdata                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_lite_initatr_wstrb                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_bvalid               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_initatr_bready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_bresp                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_ss_app_lite_initatr_arvalid              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_arready              (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_initatr_araddr               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_rvalid               (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_lite_initatr_rready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_lite_initatr_rdata                (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_lite_initatr_rresp                (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_ss_app_mm_initatr_awvalid                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_awready                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_mm_initatr_awaddr                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_awlen                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_awsize                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_awprot                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_wvalid                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_wlast                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_wready                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_mm_initatr_wdata                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_wstrb                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_bvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_mm_initatr_bready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_bresp                  (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_ss_app_mm_initatr_arvalid                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_arready                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_mm_initatr_araddr                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_arlen                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_arsize                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_mm_initatr_arprot                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_rvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_mm_initatr_rlast                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_mm_initatr_rready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_mm_initatr_rdata                  (512'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                            
		.p0_app_ss_mm_initatr_rresp                  (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_ss_app_mm_initatr_awvalid                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_awready                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_mm_initatr_awaddr                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_awlen                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_awsize                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_awprot                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_wvalid                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_wlast                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_wready                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_mm_initatr_wdata                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_wstrb                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_bvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_mm_initatr_bready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_bresp                  (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p1_ss_app_mm_initatr_arvalid                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_arready                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_mm_initatr_araddr                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_arlen                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_arsize                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_mm_initatr_arprot                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_rvalid                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_mm_initatr_rlast                  (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_mm_initatr_rready                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_mm_initatr_rdata                  (512'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                            
		.p1_app_ss_mm_initatr_rresp                  (2'b00),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // (terminated),                                            
		.p0_ss_app_virtio_pcicfgreq_tvalid           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_virtio_pcicfgreq_tdata            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_virtio_pcicfgreq_tvalid           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_virtio_pcicfgreq_tdata            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_virtio_pcicfgcmpl_tvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_virtio_pcicfgcmpl_tdata           (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_virtio_pcicfgcmpl_tvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_virtio_pcicfgcmpl_tdata           (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_serr                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_dlup                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_linkup                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_int_status                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_int_status                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_surprise_down_err                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_surprise_down_err                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_ltssmstate                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_test_in_i                                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_test_out_o                               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_test_in_i                                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_test_out_o                               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_poisonedwrreq_s0           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_poisonedcompl_s0           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_ur_postedreq_s0            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_ca_postedreq_s0            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_vf_num_s0                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_func_num_s0                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ss_app_vf_err_overflow                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_sent_vfnonfatalmsg                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_vfnonfatalmsg_vf_num              (11'b00000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       // (terminated),                                            
		.p0_ss_app_vfnonfatalmsg_ready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_app_ss_vfnonfatalmsg_func_num            (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.p1_ss_app_vf_err_poisonedwrreq_s0           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_poisonedcompl_s0           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_ur_postedreq_s0            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_ca_postedreq_s0            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_vf_num_s0                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_func_num_s0                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_poisonedwrreq_s1           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_poisonedcompl_s1           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_ur_postedreq_s1            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_ca_postedreq_s1            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_vf_num_s1                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_func_num_s1                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ss_app_vf_err_overflow                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_sent_vfnonfatalmsg                (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_vfnonfatalmsg_vf_num              (11'b00000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       // (terminated),                                            
		.p1_ss_app_vfnonfatalmsg_ready               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_vfnonfatalmsg_func_num            (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.p1_app_ss_st_rx_tuser_halt                  (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.p0_app_ss_st_err_tvalid                     (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_st_err_tdata                      (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_app_ss_st_err_tuser_error_type           (14'b00000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    // (terminated),                                            
		.p0_app_ss_st_err_tlast                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ss_app_st_err_tready                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_app_ss_st_err_tvalid                     (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_err_tdata                      (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_app_ss_st_err_tuser_error_type           (14'b00000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    // (terminated),                                            
		.p1_app_ss_st_err_tlast                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ss_app_st_err_tready                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ptm_manual_update                        (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p0_ptm_context_valid                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_start_ptm_newclk_value                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ptm_newclk_value                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p0_ptm_clock_correction                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ptm_manual_update                        (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.p1_ptm_context_valid                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_start_ptm_newclk_value                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ptm_newclk_value                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.p1_ptm_clock_correction                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.i_rxpipe0_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe0_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe0_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe0_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe0_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe0_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe0_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe0_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe0_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe0_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe0_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe0_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe1_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe1_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe1_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe1_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe1_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe1_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe1_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe1_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe1_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe1_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe1_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe2_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe2_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe2_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe2_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe2_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe2_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe2_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe2_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe2_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe2_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe2_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe3_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe3_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe3_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe3_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe3_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe3_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe3_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe3_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe3_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe3_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe3_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe4_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe4_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe4_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe4_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe4_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe4_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe4_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe4_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe4_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe4_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe4_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe5_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe5_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe5_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe5_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe5_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe5_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe5_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe5_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe5_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe5_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe5_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe6_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe6_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe6_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe6_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe6_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe6_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe6_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe6_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe6_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe6_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe6_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_dirfeedback                       (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe7_linkevaluationfeedbackfiguremerit (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe7_localfs                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe7_locallf                           (6'b000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             // (terminated),                                            
		.i_rxpipe7_localtxcoefficientsvalid          (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_localtxpresetcoefficients         (18'b000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe7_p2m_bus                           (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           // (terminated),                                            
		.i_rxpipe7_pclkchangeok                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_phystatus                         (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_rxdata                            (40'b0000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          // (terminated),                                            
		.i_rxpipe7_rxdatak                           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe7_rxdatavalid                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_rxelecidlea                       (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_rxstandbystatus                   (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_rxstartblock                      (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_rxpipe7_rxstatus                          (3'b000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                // (terminated),                                            
		.i_rxpipe7_rxsyncheader                      (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               // (terminated),                                            
		.i_rxpipe7_rxvalid                           (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.o_txpipe0_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe0_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe1_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe2_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe3_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe4_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe5_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe6_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_asyncpowerchangeack               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_blockaligncontrol                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_cfg_hw_auto_sp_dis                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_dirchange                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_ebuf_mode                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_encodedecodebypass                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_fs                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_getlocalpresetcoefficients        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_invalidrequest                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_lf                                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_localpresetindex                  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_lowpin_nt                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_m2p_bus                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_pclk_rate                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_pclkchangeack                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_phy_mode_nt                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_powerdown                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rate                              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxelecidle_disable_a              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxeqclr                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxeqeval                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxeqinprogress                    (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxeqtraining                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxpolarity                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxpresethint                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxstandby                         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_rxtermination                     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_srisenable                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txcmnmode_disable_a               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txcompliance                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txdata                            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txdatak                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txdatavalid                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txdeemph                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txdtctrx_lb                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txelecidle                        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txmargin                          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txoneszeros                       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txstartblock                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txswing                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_txsyncheader                      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_txpipe7_width                             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs0_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs1_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs2_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs3_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs4_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs5_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs6_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.o_pcs7_pipe_rst_n                           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      // (terminated),                                            
		.i_pcs0_pclk                                 (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  // (terminated),                                            
		.i_pcs1_pclk                                 (1'b0)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   // (terminated),                                            
	);

endmodule
