// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ltssm_monitor # (
	parameter LTSSM_COUNTER_WIDTH = 26
    ) (
	input           					clk,

    input 								ninit_done,  //may change core_pll_lock

    //HIP status
   
    input [5:0]     					ltssm_state_i,
	
	output [LTSSM_COUNTER_WIDTH-1:0]   	ltssm_counter_value_o,
	output          					state_transition_o,
	output [5:0]    					captured_ltssm_state_o
	);
	
	logic [LTSSM_COUNTER_WIDTH-1:0] ltssm_counter_value_r;
	logic [5:0]  saved_ltssm_state;
	logic [5:0]  saved_ltssm_state_r;
	logic [5:0]  saved_ltssm_state_r2;
	logic [1:0]  ltssm_counter_state;
	logic [1:0]  ltssm_counter_nxt_state;
	logic [25:0] ltssm_counter_value_w;
  
        logic        init_done_hip_coreclk_sync;

        altera_std_synchronizer_nocut ninit_done_hip_coreclk_sync_inst (.clk (clk),    .reset_n (~ninit_done), .din (1'b1), .dout (init_done_hip_coreclk_sync) );
    localparam  INITIALIZE     = 2'b00;
	localparam  COUNT          = 2'b01;
	localparam  CHANGE_STATE   = 2'b10;
  
	logic state_transition_r;
	logic [5:0] captured_ltssm_state_r;
	logic [LTSSM_COUNTER_WIDTH-1:0] ltssm_counter_value_r2;
  
	assign state_transition_o = state_transition_r;                               
	assign captured_ltssm_state_o = captured_ltssm_state_r;
	assign ltssm_counter_value_o = ltssm_counter_value_r2;

	always_ff @ (posedge clk) begin
		saved_ltssm_state 		<= ltssm_state_i;
		saved_ltssm_state_r 	<= saved_ltssm_state;
		saved_ltssm_state_r2 	<= saved_ltssm_state_r;
		captured_ltssm_state_r 	<= saved_ltssm_state_r2;
		ltssm_counter_value_r2 	<= ltssm_counter_value_r;
		state_transition_r    	<= ((ltssm_counter_state == CHANGE_STATE) && (saved_ltssm_state_r == saved_ltssm_state) && (ltssm_counter_value_r2 != 'h0)); // to save last state after pin_perst            
	end

	always_ff @ (posedge clk) begin
		if (~init_done_hip_coreclk_sync)
			ltssm_counter_state <= INITIALIZE;
		else 
			ltssm_counter_state <= ltssm_counter_nxt_state;
	end
  
	always_comb begin
		case(ltssm_counter_state)
			INITIALIZE:
				if (~init_done_hip_coreclk_sync)
					ltssm_counter_nxt_state = INITIALIZE;
				else
					ltssm_counter_nxt_state = CHANGE_STATE;
			COUNT:
				if (saved_ltssm_state == saved_ltssm_state_r)
					ltssm_counter_nxt_state = COUNT;
				else
					ltssm_counter_nxt_state = CHANGE_STATE;
			CHANGE_STATE:
				ltssm_counter_nxt_state = COUNT;
			default:
				ltssm_counter_nxt_state = INITIALIZE; 
		endcase
	end

    always_ff @ (posedge clk) begin
	    ltssm_counter_value_r <= ltssm_counter_value_w;
	end
  
    always_comb begin
		if (ltssm_counter_state == INITIALIZE)
			ltssm_counter_value_w = {LTSSM_COUNTER_WIDTH{1'b0}};
		else if (ltssm_counter_state == COUNT)
			ltssm_counter_value_w = ltssm_counter_value_r + 1'h1;
		else //CHANGE_STATE
		  ltssm_counter_value_w = 'b1;
	end
  
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "u5pIbSCe10hFh7Mc65JsFx28RQM4wL6+qaJ+2v2tDwWpsOktSmARVBMHDtyrY89I/fitFtCwnW18n1mBYpwWfIaYMo1E5KiAC5Ri5q2ch3lbG9WcHCZ6+pp0mmQZj8KzblHU7UBtvqoFOaPSSVJZPei4xOGUHojt2/4uhpQrg4OHxc0/1vn5gRYHHtNxXKf9CfUth0zifEvR8bRv7qJKR3iJbMgQ8r7s2EbcbISIDkC79Ve/zQVdW2+4PFYomzSSDcLh8xF9ckPbvYITMnA8tgl8O8GIY3ZvvdRhq+pzR9pIVjwxc9qcy1/T0Fa5wQIK/FYWDg++8v8lN1AO4Dort9JOpqbI/0E0dleWKpod/ObPJhmfCrFoC45Pe3bAC4ZRAlgI04+xFJx+i2obzLkWWWrPkvPzDQt38j9ClCpHJrYHgro1KU3jaiVLHY+6whmIl3BGOeWatU+h/n1K2gdJsD/XiR3TNYXY8T+Z1MAnVJOHFONGqzQoe/sB789WZiBTtdalvpzpBWVbME2aS2xYYcxVUfjd5ULrKDbR8N5TV8k7UH5Fj579XoDmdmqMIH3ORCKNA21e74QJF3EFtahUGcJaeUNlgPVEanMscSAlKdS32RjvXN959z9wXjbSQug5RYRysuLagAJvHNvp347A3Xa/50FN4sXZNpg5VOKky7/03ZbVF6VHajXBiWBEBPUjmPcxIi+MxkmecyeIeaIVqqFvOKbu1JX+d3T5JhoSI2QS+P9mZdu3+7EdJYHGg3YQjbGJWzYWFcUvfU7eeM1VOafhCIzKo/vxmLCXDHnXnniY0m2FuIejTQzI00E2Gcv4b0T8siy+0mLAdukoFi/fpktm5MRA6rYlzb2d+b3tZmJXQQgQ+mONBtL5x2azEaAYgvPebM9VQRsMzErxUE5/6rxcRktJo4U6o3Ou1GH1IU0U1LCvRkZl1HEcBp+4XrO2speUyARTcvIoIOwGG69DzpoCJG0Ioll3wKyjg70cVQfnncMbLJXfkQwXjbDq7k0x"
`endif