// pcie_ed_dma.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module pcie_ed_dma (
		input  wire         axi_st_clk,                     //                     axi_st_clk.clk,                            AXI-ST Clock
		input  wire         axi_mm_clk,                     //                     axi_mm_clk.clk,                            AXI-MM Clock
		input  wire         axi_lite_clk,                   //                   axi_lite_clk.clk,                            AXI-Lite Clock
		input  wire         axi_st_areset_n,                //                axi_st_areset_n.reset_n,                        AXI-ST Reset
		input  wire         axi_mm_areset_n,                //                axi_mm_areset_n.reset_n,                        AXI-MM Reset
		input  wire         axi_lite_areset_n,              //              axi_lite_areset_n.reset_n,                        AXI-Lite Reset
		input  wire         ss_app_st_rx_tvalid,            //                       ss_rx_st.tvalid,                         Rx AXI-ST Slave Interface
		output wire         app_ss_st_rx_tready,            //                               .tready,                         Rx AXI-ST Slave Interface
		input  wire [255:0] ss_app_st_rx_tdata,             //                               .tdata,                          Rx AXI-ST Slave Interface
		input  wire [31:0]  ss_app_st_rx_tkeep,             //                               .tkeep,                          Rx AXI-ST Slave Interface
		input  wire         ss_app_st_rx_tlast,             //                               .tlast,                          Rx AXI-ST Slave Interface
		input  wire         ss_app_st_rx_tuser_hvalid,      //             st_rx_tuser_hvalid.st_rx_tuser_hvalid,             Rx AXI-ST Slave Interface
		input  wire [255:0] ss_app_st_rx_tuser_hdr,         //                st_rx_tuser_hdr.st_rx_tuser_hdr,                Rx AXI-ST Slave Interface
		output wire         app_ss_st_tx_tvalid,            //                       ss_tx_st.tvalid,                         Tx AXI-ST Master Interface
		input  wire         ss_app_st_tx_tready,            //                               .tready,                         Tx AXI-ST Master Interface
		output wire [255:0] app_ss_st_tx_tdata,             //                               .tdata,                          Tx AXI-ST Master Interface
		output wire [31:0]  app_ss_st_tx_tkeep,             //                               .tkeep,                          Tx AXI-ST Master Interface
		output wire         app_ss_st_tx_tlast,             //                               .tlast,                          Tx AXI-ST Master Interface
		output wire         app_ss_st_tx_tuser_hvalid,      //             st_tx_tuser_hvalid.st_tx_tuser_hvalid,             Tx AXI-ST Master Interface
		output wire [255:0] app_ss_st_tx_tuser_hdr,         //                st_tx_tuser_hdr.st_tx_tuser_hdr,                Tx AXI-ST Master Interface
		output wire         app_ss_lite_csr_awvalid,        //                    ss_csr_lite.awvalid,                        CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_awready,        //                               .awready,                        CSR AXI-Lite Master Interface
		output wire [19:0]  app_ss_lite_csr_awaddr,         //                               .awaddr,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_wvalid,         //                               .wvalid,                         CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_wready,         //                               .wready,                         CSR AXI-Lite Master Interface
		output wire [31:0]  app_ss_lite_csr_wdata,          //                               .wdata,                          CSR AXI-Lite Master Interface
		output wire [3:0]   app_ss_lite_csr_wstrb,          //                               .wstrb,                          CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_bvalid,         //                               .bvalid,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_bready,         //                               .bready,                         CSR AXI-Lite Master Interface
		input  wire [1:0]   ss_app_lite_csr_bresp,          //                               .bresp,                          CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_arvalid,        //                               .arvalid,                        CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_arready,        //                               .arready,                        CSR AXI-Lite Master Interface
		output wire [19:0]  app_ss_lite_csr_araddr,         //                               .araddr,                         CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_rvalid,         //                               .rvalid,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_rready,         //                               .rready,                         CSR AXI-Lite Master Interface
		input  wire [31:0]  ss_app_lite_csr_rdata,          //                               .rdata,                          CSR AXI-Lite Master Interface
		input  wire [1:0]   ss_app_lite_csr_rresp,          //                               .rresp,                          CSR AXI-Lite Master Interface
		output wire [2:0]   ss_app_lite_csr_awprot,         //                               .awprot,                         CSR AXI-Lite Master Interface
		output wire [2:0]   ss_app_lite_csr_arprot,         //                               .arprot,                         CSR AXI-Lite Master Interface
		output wire         dma_axi_mm_awvalid,             //                 dma_mm_initatr.awvalid,                        MM Initator Master Interface
		input  wire         dma_axi_mm_awready,             //                               .awready,                        MM Initator Master Interface
		output wire [3:0]   dma_axi_mm_awid,                //                               .awid,                           MM Initator Master Interface
		output wire [63:0]  dma_axi_mm_awaddr,              //                               .awaddr,                         MM Initator Master Interface
		output wire [7:0]   dma_axi_mm_awlen,               //                               .awlen,                          MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_awsize,              //                               .awsize,                         MM Initator Master Interface
		output wire [1:0]   dma_axi_mm_awburst,             //                               .awburst,                        MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_awprot,              //                               .awprot,                         MM Initator Master Interface
		output wire         dma_axi_mm_awlock,              //                               .awlock,                         MM Initator Master Interface
		output wire         dma_axi_mm_wvalid,              //                               .wvalid,                         MM Initator Master Interface
		output wire         dma_axi_mm_wlast,               //                               .wlast,                          MM Initator Master Interface
		input  wire         dma_axi_mm_wready,              //                               .wready,                         MM Initator Master Interface
		output wire [255:0] dma_axi_mm_wdata,               //                               .wdata,                          MM Initator Master Interface
		output wire [31:0]  dma_axi_mm_wstrb,               //                               .wstrb,                          MM Initator Master Interface
		input  wire         dma_axi_mm_bvalid,              //                               .bvalid,                         MM Initator Master Interface
		output wire         dma_axi_mm_bready,              //                               .bready,                         MM Initator Master Interface
		input  wire [3:0]   dma_axi_mm_bid,                 //                               .bid,                            MM Initator Master Interface
		input  wire [1:0]   dma_axi_mm_bresp,               //                               .bresp,                          MM Initator Master Interface
		output wire         dma_axi_mm_arvalid,             //                               .arvalid,                        MM Initator Master Interface
		input  wire         dma_axi_mm_arready,             //                               .arready,                        MM Initator Master Interface
		output wire [3:0]   dma_axi_mm_arid,                //                               .arid,                           MM Initator Master Interface
		output wire [63:0]  dma_axi_mm_araddr,              //                               .araddr,                         MM Initator Master Interface
		output wire [7:0]   dma_axi_mm_arlen,               //                               .arlen,                          MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_arsize,              //                               .arsize,                         MM Initator Master Interface
		output wire [1:0]   dma_axi_mm_arburst,             //                               .arburst,                        MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_arprot,              //                               .arprot,                         MM Initator Master Interface
		output wire         dma_axi_mm_arlock,              //                               .arlock,                         MM Initator Master Interface
		input  wire         dma_axi_mm_rvalid,              //                               .rvalid,                         MM Initator Master Interface
		input  wire         dma_axi_mm_rlast,               //                               .rlast,                          MM Initator Master Interface
		output wire         dma_axi_mm_rready,              //                               .rready,                         MM Initator Master Interface
		input  wire [3:0]   dma_axi_mm_rid,                 //                               .rid,                            MM Initator Master Interface
		input  wire [255:0] dma_axi_mm_rdata,               //                               .rdata,                          MM Initator Master Interface
		input  wire [1:0]   dma_axi_mm_rresp,               //                               .rresp,                          MM Initator Master Interface
		output wire         rx_pio_axi_lite_awvalid,        //               pio_lite_initatr.awvalid,                        PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_awready,        //                               .awready,                        PIO AXI-Lite Master Interface
		output wire [26:0]  rx_pio_axi_lite_awaddr,         //                               .awaddr,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_wvalid,         //                               .wvalid,                         PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_wready,         //                               .wready,                         PIO AXI-Lite Master Interface
		output wire [63:0]  rx_pio_axi_lite_wdata,          //                               .wdata,                          PIO AXI-Lite Master Interface
		output wire [7:0]   rx_pio_axi_lite_wstrb,          //                               .wstrb,                          PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_bvalid,         //                               .bvalid,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_bready,         //                               .bready,                         PIO AXI-Lite Master Interface
		input  wire [1:0]   rx_pio_axi_lite_bresp,          //                               .bresp,                          PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_arvalid,        //                               .arvalid,                        PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_arready,        //                               .arready,                        PIO AXI-Lite Master Interface
		output wire [26:0]  rx_pio_axi_lite_araddr,         //                               .araddr,                         PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_rvalid,         //                               .rvalid,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_rready,         //                               .rready,                         PIO AXI-Lite Master Interface
		input  wire [63:0]  rx_pio_axi_lite_rdata,          //                               .rdata,                          PIO AXI-Lite Master Interface
		input  wire [1:0]   rx_pio_axi_lite_rresp,          //                               .rresp,                          PIO AXI-Lite Master Interface
		output wire [2:0]   rx_pio_axi_lite_awprot,         //                               .awprot,                         PIO AXI-Lite Master Interface
		output wire [2:0]   rx_pio_axi_lite_arprot,         //                               .arprot,                         PIO AXI-Lite Master Interface
		input  wire         ss_app_st_ciireq_tvalid,        //                   p0_st_ciireq.tvalid,                         CII Requestor AXI-ST Slave Interface
		output wire         app_ss_st_ciireq_tready,        //                               .tready,                         CII Requestor AXI-ST Slave Interface
		input  wire [71:0]  ss_app_st_ciireq_tdata,         //                               .tdata,                          CII Requestor AXI-ST Slave Interface
		output wire         app_ss_st_ciiresp_tvalid,       //                  p0_st_ciiresp.tvalid,                         CII Responder AXI-ST Slave Interface
		output wire [32:0]  app_ss_st_ciiresp_tdata,        //                               .tdata,                          CII Responder AXI-ST Slave Interface
		input  wire         ss_app_st_txcrdt_tvalid,        //                      ss_txcrdt.tvalid,                         Check User Guide for details
		input  wire [18:0]  ss_app_st_txcrdt_tdata,         //                               .tdata,                          Check User Guide for details
		output wire [2:0]   app_ss_st_rx_tuser_halt,        //        app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt,        Indicates PLD interface temporarily wants to halt reception of particular type of packet. bit[0] Ã- Halt Posted TLP; bit[1] Ã- Halt Non Posted TLP; bit[2] Ã- Halt Completion TLP. Note:	Applicable for SM, SS PU HIP-native mode. NA for P/F/R tiles.
		input  wire         ss_app_st_ctrlshadow_tvalid,    //                  ss_ctrlshadow.tvalid,                         Check User Guide for details
		input  wire [39:0]  ss_app_st_ctrlshadow_tdata,     //                               .tdata,                          Check User Guide for details
		input  wire         ss_app_st_flrrcvd_tvalid,       //                     ss_flrrcvd.tvalid,                         Check User Guide for details
		input  wire [21:0]  ss_app_st_flrrcvd_tdata,        //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_flrcmpl_tvalid,       //                     ss_flrcmpl.tvalid,                         Check User Guide for details
		output wire [21:0]  app_ss_st_flrcmpl_tdata,        //                               .tdata,                          Check User Guide for details
		input  wire         ss_app_st_flrcmpl_tready,       //                               .tready,                         Check User Guide for details
		input  wire         ss_app_st_cplto_tvalid,         //                       ss_cplto.tvalid,                         Check User Guide for details
		input  wire [48:0]  ss_app_st_cplto_tdata,          //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_err_tvalid,           //                     ss_app_err.tvalid,                         Check User Guide for details
		output wire [31:0]  app_ss_st_err_tdata,            //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_err_tlast,            //                               .tlast,                          Check User Guide for details
		input  wire         ss_app_st_err_tready,           //                               .tready,                         Check User Guide for details
		output wire [13:0]  app_ss_st_err_tuser_error_type  // app_ss_st_err_tuser_error_type.app_ss_st_err_tuser_error_type, Check User Guide for details
	);

	pcie_ed_dma_pcie_gts_mcdma_120_bantbry #(
		.device_family_hwtcl                   ("Agilex 5"),
		.device_family_int_hwtcl               (1),
		.header_packing_scheme_hwtcl           ("Simple"),
		.dma_top_topology_hwtcl                ("Gen3 1x4"),
		.dwidth_hwtcl                          (256),
		.num_of_seg_hwtcl                      (1),
		.seg_width_hwtcl                       (256),
		.single_width_integer_hwtcl            (1),
		.st_readylatency_hwtcl                 (0),
		.csr_liteslvawd_hwtcl                  (20),
		.csr_liteslvdwd_hwtcl                  (32),
		.pio_litemstrawd_hwtcl                 (27),
		.pio_litemstrdwd_hwtcl                 (64),
		.pio_litemstr_readylatency_hwtcl       (0),
		.cs_litemstrawd_hwtcl                  (14),
		.cs_litemstrdwd_hwtcl                  (32),
		.cs_litemstr_readylatency_hwtcl        (0),
		.dma_mm_mode_hwtcl                     (1),
		.dma_mmblwd_hwtcl                      (8),
		.dma_mmidwd_hwtcl                      (4),
		.dma_mmawd_hwtcl                       (64),
		.dma_mmdwd_hwtcl                       (256),
		.dma_mm_readylatency_hwtcl             (0),
		.bam_mmblwd_hwtcl                      (8),
		.bam_mmidwd_hwtcl                      (4),
		.bam_mmawd_hwtcl                       (30),
		.bam_mmdwd_hwtcl                       (256),
		.bam_mm_readylatency_hwtcl             (0),
		.bas_mmblwd_hwtcl                      (8),
		.bas_mmidwd_hwtcl                      (4),
		.bas_mmuwd_hwtcl                       (16),
		.bas_mmawd_hwtcl                       (64),
		.bas_mmdwd_hwtcl                       (256),
		.bas_mm_readylatency_hwtcl             (0),
		.enable_mcdma_hwtcl                    (1),
		.enable_bursting_master_hwtcl          (0),
		.enable_bursting_slave_hwtcl           (0),
		.enable_config_slave_hwtcl             (0),
		.enable_user_flr_hwtcl                 (0),
		.enable_user_msix_hwtcl                (0),
		.enable_metadata_8_hwtcl               (0),
		.enable_user_cii_hwtcl                 (0),
		.enable_byte_aligned_txfr_hwtcl        (0),
		.enable_10bit_tag_hwtcl                (1),
		.enable_cpl_reorder_hwtcl              (1),
		.enable_cpl_timeout_hwtcl              (1),
		.d2h_num_active_channel_hwtcl          (8),
		.d2h_max_num_desc_fetch_hwtcl          (16),
		.enable_msi_hwtcl                      (0),
		.msi_pvm_capable_hwtcl                 (0),
		.msi_addr_64bit_capable_hwtcl          (0),
		.msi_multi_msg_capable_hwtcl           (1),
		.msi_ext_msg_data_capable_hwtcl        (0),
		.enable_device_att_hwtcl               (0),
		.att_table_address_hwtcl               (3),
		.att_window_address_hwtcl              (16),
		.enable_dca_hwtcl                      (0),
		.dca_num_chn_supported_hwtcl           (2048),
		.dca_num_log_ch_func_hwtcl             (32),
		.dca_enable_pf_ch_hwtcl                (1),
		.pfnum_hwtcl                           (1),
		.pfnum_width_hwtcl                     (1),
		.vfnum_width_hwtcl                     (1),
		.max_bar_address_width_hwtcl           (24),
		.pf2int_funct_init_file_hwtcl          ("./pf2int_funct.mif"),
		.int_funct2dma_chan_pf_init_file_hwtcl ("./int_funct2dma_chan_pf.mif"),
		.int_funct2dma_chan_vf_init_file_hwtcl ("./int_funct2dma_chan_vf.mif"),
		.dma_chan2funct_init_file_hwtcl        ("./dma_chan2funct.mif"),
		.total_pf_count_hwtcl                  (1),
		.total_vf_count_hwtcl                  (0),
		.pf0_enable_sriov_hwtcl                (0),
		.pf1_enable_sriov_hwtcl                (0),
		.pf2_enable_sriov_hwtcl                (0),
		.pf3_enable_sriov_hwtcl                (0),
		.pf4_enable_sriov_hwtcl                (0),
		.pf5_enable_sriov_hwtcl                (0),
		.pf6_enable_sriov_hwtcl                (0),
		.pf7_enable_sriov_hwtcl                (0),
		.pf0_num_vf_per_pf_hwtcl               (0),
		.pf1_num_vf_per_pf_hwtcl               (0),
		.pf2_num_vf_per_pf_hwtcl               (0),
		.pf3_num_vf_per_pf_hwtcl               (0),
		.pf4_num_vf_per_pf_hwtcl               (0),
		.pf5_num_vf_per_pf_hwtcl               (0),
		.pf6_num_vf_per_pf_hwtcl               (0),
		.pf7_num_vf_per_pf_hwtcl               (0),
		.pf0_num_dma_chan_pf_hwtcl             (4),
		.pf1_num_dma_chan_pf_hwtcl             (0),
		.pf2_num_dma_chan_pf_hwtcl             (0),
		.pf3_num_dma_chan_pf_hwtcl             (0),
		.pf4_num_dma_chan_pf_hwtcl             (0),
		.pf5_num_dma_chan_pf_hwtcl             (0),
		.pf6_num_dma_chan_pf_hwtcl             (0),
		.pf7_num_dma_chan_pf_hwtcl             (0),
		.pf0_num_dma_chan_per_vf_hwtcl         (0),
		.pf1_num_dma_chan_per_vf_hwtcl         (0),
		.pf2_num_dma_chan_per_vf_hwtcl         (0),
		.pf3_num_dma_chan_per_vf_hwtcl         (0),
		.pf4_num_dma_chan_per_vf_hwtcl         (0),
		.pf5_num_dma_chan_per_vf_hwtcl         (0),
		.pf6_num_dma_chan_per_vf_hwtcl         (0),
		.pf7_num_dma_chan_per_vf_hwtcl         (0),
		.pf0_bar0_address_width_hwtcl          (22),
		.pf0_bar1_address_width_hwtcl          (0),
		.pf0_bar2_address_width_hwtcl          (24),
		.pf0_bar3_address_width_hwtcl          (0),
		.pf0_bar4_address_width_hwtcl          (0),
		.pf0_bar5_address_width_hwtcl          (0),
		.pf1_bar0_address_width_hwtcl          (0),
		.pf1_bar1_address_width_hwtcl          (0),
		.pf1_bar2_address_width_hwtcl          (0),
		.pf1_bar3_address_width_hwtcl          (0),
		.pf1_bar4_address_width_hwtcl          (0),
		.pf1_bar5_address_width_hwtcl          (0),
		.pf2_bar0_address_width_hwtcl          (0),
		.pf2_bar1_address_width_hwtcl          (0),
		.pf2_bar2_address_width_hwtcl          (0),
		.pf2_bar3_address_width_hwtcl          (0),
		.pf2_bar4_address_width_hwtcl          (0),
		.pf2_bar5_address_width_hwtcl          (0),
		.pf3_bar0_address_width_hwtcl          (0),
		.pf3_bar1_address_width_hwtcl          (0),
		.pf3_bar2_address_width_hwtcl          (0),
		.pf3_bar3_address_width_hwtcl          (0),
		.pf3_bar4_address_width_hwtcl          (0),
		.pf3_bar5_address_width_hwtcl          (0),
		.pf4_bar0_address_width_hwtcl          (0),
		.pf4_bar1_address_width_hwtcl          (0),
		.pf4_bar2_address_width_hwtcl          (0),
		.pf4_bar3_address_width_hwtcl          (0),
		.pf4_bar4_address_width_hwtcl          (0),
		.pf4_bar5_address_width_hwtcl          (0),
		.pf5_bar0_address_width_hwtcl          (0),
		.pf5_bar1_address_width_hwtcl          (0),
		.pf5_bar2_address_width_hwtcl          (0),
		.pf5_bar3_address_width_hwtcl          (0),
		.pf5_bar4_address_width_hwtcl          (0),
		.pf5_bar5_address_width_hwtcl          (0),
		.pf6_bar0_address_width_hwtcl          (0),
		.pf6_bar1_address_width_hwtcl          (0),
		.pf6_bar2_address_width_hwtcl          (0),
		.pf6_bar3_address_width_hwtcl          (0),
		.pf6_bar4_address_width_hwtcl          (0),
		.pf6_bar5_address_width_hwtcl          (0),
		.pf7_bar0_address_width_hwtcl          (0),
		.pf7_bar1_address_width_hwtcl          (0),
		.pf7_bar2_address_width_hwtcl          (0),
		.pf7_bar3_address_width_hwtcl          (0),
		.pf7_bar4_address_width_hwtcl          (0),
		.pf7_bar5_address_width_hwtcl          (0),
		.pf0_vf_bar0_address_width_hwtcl       (0),
		.pf0_vf_bar1_address_width_hwtcl       (0),
		.pf0_vf_bar2_address_width_hwtcl       (0),
		.pf0_vf_bar3_address_width_hwtcl       (0),
		.pf0_vf_bar4_address_width_hwtcl       (0),
		.pf0_vf_bar5_address_width_hwtcl       (0),
		.pf1_vf_bar0_address_width_hwtcl       (0),
		.pf1_vf_bar1_address_width_hwtcl       (0),
		.pf1_vf_bar2_address_width_hwtcl       (0),
		.pf1_vf_bar3_address_width_hwtcl       (0),
		.pf1_vf_bar4_address_width_hwtcl       (0),
		.pf1_vf_bar5_address_width_hwtcl       (0),
		.pf2_vf_bar0_address_width_hwtcl       (0),
		.pf2_vf_bar1_address_width_hwtcl       (0),
		.pf2_vf_bar2_address_width_hwtcl       (0),
		.pf2_vf_bar3_address_width_hwtcl       (0),
		.pf2_vf_bar4_address_width_hwtcl       (0),
		.pf2_vf_bar5_address_width_hwtcl       (0),
		.pf3_vf_bar0_address_width_hwtcl       (0),
		.pf3_vf_bar1_address_width_hwtcl       (0),
		.pf3_vf_bar2_address_width_hwtcl       (0),
		.pf3_vf_bar3_address_width_hwtcl       (0),
		.pf3_vf_bar4_address_width_hwtcl       (0),
		.pf3_vf_bar5_address_width_hwtcl       (0),
		.pf4_vf_bar0_address_width_hwtcl       (0),
		.pf4_vf_bar1_address_width_hwtcl       (0),
		.pf4_vf_bar2_address_width_hwtcl       (0),
		.pf4_vf_bar3_address_width_hwtcl       (0),
		.pf4_vf_bar4_address_width_hwtcl       (0),
		.pf4_vf_bar5_address_width_hwtcl       (0),
		.pf5_vf_bar0_address_width_hwtcl       (0),
		.pf5_vf_bar1_address_width_hwtcl       (0),
		.pf5_vf_bar2_address_width_hwtcl       (0),
		.pf5_vf_bar3_address_width_hwtcl       (0),
		.pf5_vf_bar4_address_width_hwtcl       (0),
		.pf5_vf_bar5_address_width_hwtcl       (0),
		.pf6_vf_bar0_address_width_hwtcl       (0),
		.pf6_vf_bar1_address_width_hwtcl       (0),
		.pf6_vf_bar2_address_width_hwtcl       (0),
		.pf6_vf_bar3_address_width_hwtcl       (0),
		.pf6_vf_bar4_address_width_hwtcl       (0),
		.pf6_vf_bar5_address_width_hwtcl       (0),
		.pf7_vf_bar0_address_width_hwtcl       (0),
		.pf7_vf_bar1_address_width_hwtcl       (0),
		.pf7_vf_bar2_address_width_hwtcl       (0),
		.pf7_vf_bar3_address_width_hwtcl       (0),
		.pf7_vf_bar4_address_width_hwtcl       (0),
		.pf7_vf_bar5_address_width_hwtcl       (0)
	) dma (
		.axi_st_clk                     (axi_st_clk),                                                                                                                                                                                                                                                            //   input,    width = 1,                     axi_st_clk.clk
		.axi_mm_clk                     (axi_mm_clk),                                                                                                                                                                                                                                                            //   input,    width = 1,                     axi_mm_clk.clk
		.axi_lite_clk                   (axi_lite_clk),                                                                                                                                                                                                                                                          //   input,    width = 1,                   axi_lite_clk.clk
		.axi_st_areset_n                (axi_st_areset_n),                                                                                                                                                                                                                                                       //   input,    width = 1,                axi_st_areset_n.reset_n
		.axi_mm_areset_n                (axi_mm_areset_n),                                                                                                                                                                                                                                                       //   input,    width = 1,                axi_mm_areset_n.reset_n
		.axi_lite_areset_n              (axi_lite_areset_n),                                                                                                                                                                                                                                                     //   input,    width = 1,              axi_lite_areset_n.reset_n
		.ss_app_st_rx_tvalid            (ss_app_st_rx_tvalid),                                                                                                                                                                                                                                                   //   input,    width = 1,                       ss_rx_st.tvalid
		.app_ss_st_rx_tready            (app_ss_st_rx_tready),                                                                                                                                                                                                                                                   //  output,    width = 1,                               .tready
		.ss_app_st_rx_tdata             (ss_app_st_rx_tdata),                                                                                                                                                                                                                                                    //   input,  width = 256,                               .tdata
		.ss_app_st_rx_tkeep             (ss_app_st_rx_tkeep),                                                                                                                                                                                                                                                    //   input,   width = 32,                               .tkeep
		.ss_app_st_rx_tlast             (ss_app_st_rx_tlast),                                                                                                                                                                                                                                                    //   input,    width = 1,                               .tlast
		.ss_app_st_rx_tuser_hvalid      (ss_app_st_rx_tuser_hvalid),                                                                                                                                                                                                                                             //   input,    width = 1,             st_rx_tuser_hvalid.st_rx_tuser_hvalid
		.ss_app_st_rx_tuser_hdr         (ss_app_st_rx_tuser_hdr),                                                                                                                                                                                                                                                //   input,  width = 256,                st_rx_tuser_hdr.st_rx_tuser_hdr
		.app_ss_st_tx_tvalid            (app_ss_st_tx_tvalid),                                                                                                                                                                                                                                                   //  output,    width = 1,                       ss_tx_st.tvalid
		.ss_app_st_tx_tready            (ss_app_st_tx_tready),                                                                                                                                                                                                                                                   //   input,    width = 1,                               .tready
		.app_ss_st_tx_tdata             (app_ss_st_tx_tdata),                                                                                                                                                                                                                                                    //  output,  width = 256,                               .tdata
		.app_ss_st_tx_tkeep             (app_ss_st_tx_tkeep),                                                                                                                                                                                                                                                    //  output,   width = 32,                               .tkeep
		.app_ss_st_tx_tlast             (app_ss_st_tx_tlast),                                                                                                                                                                                                                                                    //  output,    width = 1,                               .tlast
		.app_ss_st_tx_tuser_hvalid      (app_ss_st_tx_tuser_hvalid),                                                                                                                                                                                                                                             //  output,    width = 1,             st_tx_tuser_hvalid.st_tx_tuser_hvalid
		.app_ss_st_tx_tuser_hdr         (app_ss_st_tx_tuser_hdr),                                                                                                                                                                                                                                                //  output,  width = 256,                st_tx_tuser_hdr.st_tx_tuser_hdr
		.app_ss_lite_csr_awvalid        (app_ss_lite_csr_awvalid),                                                                                                                                                                                                                                               //  output,    width = 1,                    ss_csr_lite.awvalid
		.ss_app_lite_csr_awready        (ss_app_lite_csr_awready),                                                                                                                                                                                                                                               //   input,    width = 1,                               .awready
		.app_ss_lite_csr_awaddr         (app_ss_lite_csr_awaddr),                                                                                                                                                                                                                                                //  output,   width = 20,                               .awaddr
		.app_ss_lite_csr_wvalid         (app_ss_lite_csr_wvalid),                                                                                                                                                                                                                                                //  output,    width = 1,                               .wvalid
		.ss_app_lite_csr_wready         (ss_app_lite_csr_wready),                                                                                                                                                                                                                                                //   input,    width = 1,                               .wready
		.app_ss_lite_csr_wdata          (app_ss_lite_csr_wdata),                                                                                                                                                                                                                                                 //  output,   width = 32,                               .wdata
		.app_ss_lite_csr_wstrb          (app_ss_lite_csr_wstrb),                                                                                                                                                                                                                                                 //  output,    width = 4,                               .wstrb
		.ss_app_lite_csr_bvalid         (ss_app_lite_csr_bvalid),                                                                                                                                                                                                                                                //   input,    width = 1,                               .bvalid
		.app_ss_lite_csr_bready         (app_ss_lite_csr_bready),                                                                                                                                                                                                                                                //  output,    width = 1,                               .bready
		.ss_app_lite_csr_bresp          (ss_app_lite_csr_bresp),                                                                                                                                                                                                                                                 //   input,    width = 2,                               .bresp
		.app_ss_lite_csr_arvalid        (app_ss_lite_csr_arvalid),                                                                                                                                                                                                                                               //  output,    width = 1,                               .arvalid
		.ss_app_lite_csr_arready        (ss_app_lite_csr_arready),                                                                                                                                                                                                                                               //   input,    width = 1,                               .arready
		.app_ss_lite_csr_araddr         (app_ss_lite_csr_araddr),                                                                                                                                                                                                                                                //  output,   width = 20,                               .araddr
		.ss_app_lite_csr_rvalid         (ss_app_lite_csr_rvalid),                                                                                                                                                                                                                                                //   input,    width = 1,                               .rvalid
		.app_ss_lite_csr_rready         (app_ss_lite_csr_rready),                                                                                                                                                                                                                                                //  output,    width = 1,                               .rready
		.ss_app_lite_csr_rdata          (ss_app_lite_csr_rdata),                                                                                                                                                                                                                                                 //   input,   width = 32,                               .rdata
		.ss_app_lite_csr_rresp          (ss_app_lite_csr_rresp),                                                                                                                                                                                                                                                 //   input,    width = 2,                               .rresp
		.ss_app_lite_csr_awprot         (ss_app_lite_csr_awprot),                                                                                                                                                                                                                                                //  output,    width = 3,                               .awprot
		.ss_app_lite_csr_arprot         (ss_app_lite_csr_arprot),                                                                                                                                                                                                                                                //  output,    width = 3,                               .arprot
		.dma_axi_mm_awvalid             (dma_axi_mm_awvalid),                                                                                                                                                                                                                                                    //  output,    width = 1,                 dma_mm_initatr.awvalid
		.dma_axi_mm_awready             (dma_axi_mm_awready),                                                                                                                                                                                                                                                    //   input,    width = 1,                               .awready
		.dma_axi_mm_awid                (dma_axi_mm_awid),                                                                                                                                                                                                                                                       //  output,    width = 4,                               .awid
		.dma_axi_mm_awaddr              (dma_axi_mm_awaddr),                                                                                                                                                                                                                                                     //  output,   width = 64,                               .awaddr
		.dma_axi_mm_awlen               (dma_axi_mm_awlen),                                                                                                                                                                                                                                                      //  output,    width = 8,                               .awlen
		.dma_axi_mm_awsize              (dma_axi_mm_awsize),                                                                                                                                                                                                                                                     //  output,    width = 3,                               .awsize
		.dma_axi_mm_awburst             (dma_axi_mm_awburst),                                                                                                                                                                                                                                                    //  output,    width = 2,                               .awburst
		.dma_axi_mm_awprot              (dma_axi_mm_awprot),                                                                                                                                                                                                                                                     //  output,    width = 3,                               .awprot
		.dma_axi_mm_awlock              (dma_axi_mm_awlock),                                                                                                                                                                                                                                                     //  output,    width = 1,                               .awlock
		.dma_axi_mm_wvalid              (dma_axi_mm_wvalid),                                                                                                                                                                                                                                                     //  output,    width = 1,                               .wvalid
		.dma_axi_mm_wlast               (dma_axi_mm_wlast),                                                                                                                                                                                                                                                      //  output,    width = 1,                               .wlast
		.dma_axi_mm_wready              (dma_axi_mm_wready),                                                                                                                                                                                                                                                     //   input,    width = 1,                               .wready
		.dma_axi_mm_wdata               (dma_axi_mm_wdata),                                                                                                                                                                                                                                                      //  output,  width = 256,                               .wdata
		.dma_axi_mm_wstrb               (dma_axi_mm_wstrb),                                                                                                                                                                                                                                                      //  output,   width = 32,                               .wstrb
		.dma_axi_mm_bvalid              (dma_axi_mm_bvalid),                                                                                                                                                                                                                                                     //   input,    width = 1,                               .bvalid
		.dma_axi_mm_bready              (dma_axi_mm_bready),                                                                                                                                                                                                                                                     //  output,    width = 1,                               .bready
		.dma_axi_mm_bid                 (dma_axi_mm_bid),                                                                                                                                                                                                                                                        //   input,    width = 4,                               .bid
		.dma_axi_mm_bresp               (dma_axi_mm_bresp),                                                                                                                                                                                                                                                      //   input,    width = 2,                               .bresp
		.dma_axi_mm_arvalid             (dma_axi_mm_arvalid),                                                                                                                                                                                                                                                    //  output,    width = 1,                               .arvalid
		.dma_axi_mm_arready             (dma_axi_mm_arready),                                                                                                                                                                                                                                                    //   input,    width = 1,                               .arready
		.dma_axi_mm_arid                (dma_axi_mm_arid),                                                                                                                                                                                                                                                       //  output,    width = 4,                               .arid
		.dma_axi_mm_araddr              (dma_axi_mm_araddr),                                                                                                                                                                                                                                                     //  output,   width = 64,                               .araddr
		.dma_axi_mm_arlen               (dma_axi_mm_arlen),                                                                                                                                                                                                                                                      //  output,    width = 8,                               .arlen
		.dma_axi_mm_arsize              (dma_axi_mm_arsize),                                                                                                                                                                                                                                                     //  output,    width = 3,                               .arsize
		.dma_axi_mm_arburst             (dma_axi_mm_arburst),                                                                                                                                                                                                                                                    //  output,    width = 2,                               .arburst
		.dma_axi_mm_arprot              (dma_axi_mm_arprot),                                                                                                                                                                                                                                                     //  output,    width = 3,                               .arprot
		.dma_axi_mm_arlock              (dma_axi_mm_arlock),                                                                                                                                                                                                                                                     //  output,    width = 1,                               .arlock
		.dma_axi_mm_rvalid              (dma_axi_mm_rvalid),                                                                                                                                                                                                                                                     //   input,    width = 1,                               .rvalid
		.dma_axi_mm_rlast               (dma_axi_mm_rlast),                                                                                                                                                                                                                                                      //   input,    width = 1,                               .rlast
		.dma_axi_mm_rready              (dma_axi_mm_rready),                                                                                                                                                                                                                                                     //  output,    width = 1,                               .rready
		.dma_axi_mm_rid                 (dma_axi_mm_rid),                                                                                                                                                                                                                                                        //   input,    width = 4,                               .rid
		.dma_axi_mm_rdata               (dma_axi_mm_rdata),                                                                                                                                                                                                                                                      //   input,  width = 256,                               .rdata
		.dma_axi_mm_rresp               (dma_axi_mm_rresp),                                                                                                                                                                                                                                                      //   input,    width = 2,                               .rresp
		.rx_pio_axi_lite_awvalid        (rx_pio_axi_lite_awvalid),                                                                                                                                                                                                                                               //  output,    width = 1,               pio_lite_initatr.awvalid
		.rx_pio_axi_lite_awready        (rx_pio_axi_lite_awready),                                                                                                                                                                                                                                               //   input,    width = 1,                               .awready
		.rx_pio_axi_lite_awaddr         (rx_pio_axi_lite_awaddr),                                                                                                                                                                                                                                                //  output,   width = 27,                               .awaddr
		.rx_pio_axi_lite_wvalid         (rx_pio_axi_lite_wvalid),                                                                                                                                                                                                                                                //  output,    width = 1,                               .wvalid
		.rx_pio_axi_lite_wready         (rx_pio_axi_lite_wready),                                                                                                                                                                                                                                                //   input,    width = 1,                               .wready
		.rx_pio_axi_lite_wdata          (rx_pio_axi_lite_wdata),                                                                                                                                                                                                                                                 //  output,   width = 64,                               .wdata
		.rx_pio_axi_lite_wstrb          (rx_pio_axi_lite_wstrb),                                                                                                                                                                                                                                                 //  output,    width = 8,                               .wstrb
		.rx_pio_axi_lite_bvalid         (rx_pio_axi_lite_bvalid),                                                                                                                                                                                                                                                //   input,    width = 1,                               .bvalid
		.rx_pio_axi_lite_bready         (rx_pio_axi_lite_bready),                                                                                                                                                                                                                                                //  output,    width = 1,                               .bready
		.rx_pio_axi_lite_bresp          (rx_pio_axi_lite_bresp),                                                                                                                                                                                                                                                 //   input,    width = 2,                               .bresp
		.rx_pio_axi_lite_arvalid        (rx_pio_axi_lite_arvalid),                                                                                                                                                                                                                                               //  output,    width = 1,                               .arvalid
		.rx_pio_axi_lite_arready        (rx_pio_axi_lite_arready),                                                                                                                                                                                                                                               //   input,    width = 1,                               .arready
		.rx_pio_axi_lite_araddr         (rx_pio_axi_lite_araddr),                                                                                                                                                                                                                                                //  output,   width = 27,                               .araddr
		.rx_pio_axi_lite_rvalid         (rx_pio_axi_lite_rvalid),                                                                                                                                                                                                                                                //   input,    width = 1,                               .rvalid
		.rx_pio_axi_lite_rready         (rx_pio_axi_lite_rready),                                                                                                                                                                                                                                                //  output,    width = 1,                               .rready
		.rx_pio_axi_lite_rdata          (rx_pio_axi_lite_rdata),                                                                                                                                                                                                                                                 //   input,   width = 64,                               .rdata
		.rx_pio_axi_lite_rresp          (rx_pio_axi_lite_rresp),                                                                                                                                                                                                                                                 //   input,    width = 2,                               .rresp
		.rx_pio_axi_lite_awprot         (rx_pio_axi_lite_awprot),                                                                                                                                                                                                                                                //  output,    width = 3,                               .awprot
		.rx_pio_axi_lite_arprot         (rx_pio_axi_lite_arprot),                                                                                                                                                                                                                                                //  output,    width = 3,                               .arprot
		.ss_app_st_ciireq_tvalid        (ss_app_st_ciireq_tvalid),                                                                                                                                                                                                                                               //   input,    width = 1,                   p0_st_ciireq.tvalid
		.app_ss_st_ciireq_tready        (app_ss_st_ciireq_tready),                                                                                                                                                                                                                                               //  output,    width = 1,                               .tready
		.ss_app_st_ciireq_tdata         (ss_app_st_ciireq_tdata),                                                                                                                                                                                                                                                //   input,   width = 72,                               .tdata
		.app_ss_st_ciiresp_tvalid       (app_ss_st_ciiresp_tvalid),                                                                                                                                                                                                                                              //  output,    width = 1,                  p0_st_ciiresp.tvalid
		.app_ss_st_ciiresp_tdata        (app_ss_st_ciiresp_tdata),                                                                                                                                                                                                                                               //  output,   width = 33,                               .tdata
		.ss_app_st_txcrdt_tvalid        (ss_app_st_txcrdt_tvalid),                                                                                                                                                                                                                                               //   input,    width = 1,                      ss_txcrdt.tvalid
		.ss_app_st_txcrdt_tdata         (ss_app_st_txcrdt_tdata),                                                                                                                                                                                                                                                //   input,   width = 19,                               .tdata
		.app_ss_st_rx_tuser_halt        (app_ss_st_rx_tuser_halt),                                                                                                                                                                                                                                               //  output,    width = 3,        app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt
		.ss_app_st_ctrlshadow_tvalid    (ss_app_st_ctrlshadow_tvalid),                                                                                                                                                                                                                                           //   input,    width = 1,                  ss_ctrlshadow.tvalid
		.ss_app_st_ctrlshadow_tdata     (ss_app_st_ctrlshadow_tdata),                                                                                                                                                                                                                                            //   input,   width = 40,                               .tdata
		.ss_app_st_flrrcvd_tvalid       (ss_app_st_flrrcvd_tvalid),                                                                                                                                                                                                                                              //   input,    width = 1,                     ss_flrrcvd.tvalid
		.ss_app_st_flrrcvd_tdata        (ss_app_st_flrrcvd_tdata),                                                                                                                                                                                                                                               //   input,   width = 22,                               .tdata
		.app_ss_st_flrcmpl_tvalid       (app_ss_st_flrcmpl_tvalid),                                                                                                                                                                                                                                              //  output,    width = 1,                     ss_flrcmpl.tvalid
		.app_ss_st_flrcmpl_tdata        (app_ss_st_flrcmpl_tdata),                                                                                                                                                                                                                                               //  output,   width = 22,                               .tdata
		.ss_app_st_flrcmpl_tready       (ss_app_st_flrcmpl_tready),                                                                                                                                                                                                                                              //   input,    width = 1,                               .tready
		.ss_app_st_cplto_tvalid         (ss_app_st_cplto_tvalid),                                                                                                                                                                                                                                                //   input,    width = 1,                       ss_cplto.tvalid
		.ss_app_st_cplto_tdata          (ss_app_st_cplto_tdata),                                                                                                                                                                                                                                                 //   input,   width = 49,                               .tdata
		.app_ss_st_err_tvalid           (app_ss_st_err_tvalid),                                                                                                                                                                                                                                                  //  output,    width = 1,                     ss_app_err.tvalid
		.app_ss_st_err_tdata            (app_ss_st_err_tdata),                                                                                                                                                                                                                                                   //  output,   width = 32,                               .tdata
		.app_ss_st_err_tlast            (app_ss_st_err_tlast),                                                                                                                                                                                                                                                   //  output,    width = 1,                               .tlast
		.ss_app_st_err_tready           (ss_app_st_err_tready),                                                                                                                                                                                                                                                  //   input,    width = 1,                               .tready
		.app_ss_st_err_tuser_error_type (app_ss_st_err_tuser_error_type),                                                                                                                                                                                                                                        //  output,   width = 14, app_ss_st_err_tuser_error_type.app_ss_st_err_tuser_error_type
		.app_ss_st_tx_tuser_vendor      (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_awvalid       (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_awready       (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_awaddr        (20'b00000000000000000000),                                                                                                                                                                                                                                              // (terminated),                                              
		.usr_hip_reconfig_wvalid        (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_wready        (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_wdata         (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_wstrb         (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.usr_hip_reconfig_bvalid        (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_bready        (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_bresp         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_arvalid       (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_arready       (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_araddr        (20'b00000000000000000000),                                                                                                                                                                                                                                              // (terminated),                                              
		.usr_hip_reconfig_rvalid        (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_rready        (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.usr_hip_reconfig_rdata         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.usr_hip_reconfig_rresp         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tvalid              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tready              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.h2d_axi_st_tdata               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tkeep               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tlast               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tuser_error         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tuser_metadata      (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.h2d_axi_st_tid                 (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.d2h_axi_st_tvalid              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.d2h_axi_st_tready              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.d2h_axi_st_tdata               (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                              
		.d2h_axi_st_tkeep               (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                  // (terminated),                                              
		.d2h_axi_st_tlast               (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.d2h_axi_st_tuser_error         (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.d2h_axi_st_tuser_metadata      (64'b0000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                  // (terminated),                                              
		.d2h_axi_st_tid                 (12'b000000000000),                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awvalid             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awready             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_awid                (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awaddr              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awlen               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awsize              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awburst             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awprot              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_awlock              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_wvalid              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_wlast               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_wready              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_wdata               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_wstrb               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_bvalid              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_bready              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_bid                 (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.bam_axi_mm_bresp               (2'b00),                                                                                                                                                                                                                                                                 // (terminated),                                              
		.bam_axi_mm_arvalid             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arready             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_arid                (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_araddr              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arlen               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arsize              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arburst             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arprot              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_arlock              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_rvalid              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_rlast               (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bam_axi_mm_rready              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bam_axi_mm_rid                 (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.bam_axi_mm_rdata               (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                              
		.bam_axi_mm_rresp               (2'b00),                                                                                                                                                                                                                                                                 // (terminated),                                              
		.bas_axi_mm_awvalid             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_awready             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_awid                (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.bas_axi_mm_awaddr              (64'b0000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_awuser              (16'b0000000000000000),                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_awlen               (8'b00000000),                                                                                                                                                                                                                                                           // (terminated),                                              
		.bas_axi_mm_awsize              (3'b000),                                                                                                                                                                                                                                                                // (terminated),                                              
		.bas_axi_mm_awburst             (2'b00),                                                                                                                                                                                                                                                                 // (terminated),                                              
		.bas_axi_mm_awprot              (3'b000),                                                                                                                                                                                                                                                                // (terminated),                                              
		.bas_axi_mm_awlock              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_wvalid              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_wlast               (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_wready              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_wdata               (256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                              
		.bas_axi_mm_wstrb               (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_bvalid              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_bready              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_bid                 (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_bresp               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_arvalid             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_arready             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_arid                (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.bas_axi_mm_araddr              (64'b0000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_aruser              (16'b0000000000000000),                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_arlen               (8'b00000000),                                                                                                                                                                                                                                                           // (terminated),                                              
		.bas_axi_mm_arsize              (3'b000),                                                                                                                                                                                                                                                                // (terminated),                                              
		.bas_axi_mm_arburst             (2'b00),                                                                                                                                                                                                                                                                 // (terminated),                                              
		.bas_axi_mm_arprot              (3'b000),                                                                                                                                                                                                                                                                // (terminated),                                              
		.bas_axi_mm_arlock              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_rvalid              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_rlast               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_rready              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.bas_axi_mm_rid                 (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_rdata               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.bas_axi_mm_rresp               (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_awvalid            (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_awready            (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_awaddr             (14'b00000000000000),                                                                                                                                                                                                                                                    // (terminated),                                              
		.cs_axi_lite_wvalid             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_wready             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_wdata              (32'b00000000000000000000000000000000),                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_wstrb              (4'b0000),                                                                                                                                                                                                                                                               // (terminated),                                              
		.cs_axi_lite_bvalid             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_bready             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_bresp              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_arvalid            (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_arready            (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_araddr             (14'b00000000000000),                                                                                                                                                                                                                                                    // (terminated),                                              
		.cs_axi_lite_rvalid             (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_rready             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.cs_axi_lite_rdata              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.cs_axi_lite_rresp              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.dma_user_st_ciireq_tvalid      (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_dma_st_ciireq_tready      (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.dma_user_st_ciireq_tdata       (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_dma_st_ciiresp_tvalid     (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.user_dma_st_ciiresp_tdata      (33'b000000000000000000000000000000000),                                                                                                                                                                                                                                 // (terminated),                                              
		.user_flr_rcvd_val              (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_flr_rcvd_chan_num         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_flr_completed             (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.user_msi_req                   (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.user_msi_func_num              (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.user_msi_num                   (5'b00000),                                                                                                                                                                                                                                                              // (terminated),                                              
		.user_msi_ack                   (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_msi_status                (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_event_msix_tready         (),                                                                                                                                                                                                                                                                      // (terminated),                                              
		.user_event_msix_tvalid         (1'b0),                                                                                                                                                                                                                                                                  // (terminated),                                              
		.user_event_msix_tdata          (16'b0000000000000000)                                                                                                                                                                                                                                                   // (terminated),                                              
	);

endmodule
