module pcie_ed_dma (
		input  wire         axi_st_clk,                     //                     axi_st_clk.clk,                            AXI-ST Clock
		input  wire         axi_mm_clk,                     //                     axi_mm_clk.clk,                            AXI-MM Clock
		input  wire         axi_lite_clk,                   //                   axi_lite_clk.clk,                            AXI-Lite Clock
		input  wire         axi_st_areset_n,                //                axi_st_areset_n.reset_n,                        AXI-ST Reset
		input  wire         axi_mm_areset_n,                //                axi_mm_areset_n.reset_n,                        AXI-MM Reset
		input  wire         axi_lite_areset_n,              //              axi_lite_areset_n.reset_n,                        AXI-Lite Reset
		input  wire         ss_app_st_rx_tvalid,            //                       ss_rx_st.tvalid,                         Rx AXI-ST Slave Interface
		output wire         app_ss_st_rx_tready,            //                               .tready,                         Rx AXI-ST Slave Interface
		input  wire [255:0] ss_app_st_rx_tdata,             //                               .tdata,                          Rx AXI-ST Slave Interface
		input  wire [31:0]  ss_app_st_rx_tkeep,             //                               .tkeep,                          Rx AXI-ST Slave Interface
		input  wire         ss_app_st_rx_tlast,             //                               .tlast,                          Rx AXI-ST Slave Interface
		input  wire         ss_app_st_rx_tuser_hvalid,      //             st_rx_tuser_hvalid.st_rx_tuser_hvalid,             Rx AXI-ST Slave Interface
		input  wire [255:0] ss_app_st_rx_tuser_hdr,         //                st_rx_tuser_hdr.st_rx_tuser_hdr,                Rx AXI-ST Slave Interface
		output wire         app_ss_st_tx_tvalid,            //                       ss_tx_st.tvalid,                         Tx AXI-ST Master Interface
		input  wire         ss_app_st_tx_tready,            //                               .tready,                         Tx AXI-ST Master Interface
		output wire [255:0] app_ss_st_tx_tdata,             //                               .tdata,                          Tx AXI-ST Master Interface
		output wire [31:0]  app_ss_st_tx_tkeep,             //                               .tkeep,                          Tx AXI-ST Master Interface
		output wire         app_ss_st_tx_tlast,             //                               .tlast,                          Tx AXI-ST Master Interface
		output wire         app_ss_st_tx_tuser_hvalid,      //             st_tx_tuser_hvalid.st_tx_tuser_hvalid,             Tx AXI-ST Master Interface
		output wire [255:0] app_ss_st_tx_tuser_hdr,         //                st_tx_tuser_hdr.st_tx_tuser_hdr,                Tx AXI-ST Master Interface
		output wire         app_ss_lite_csr_awvalid,        //                    ss_csr_lite.awvalid,                        CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_awready,        //                               .awready,                        CSR AXI-Lite Master Interface
		output wire [19:0]  app_ss_lite_csr_awaddr,         //                               .awaddr,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_wvalid,         //                               .wvalid,                         CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_wready,         //                               .wready,                         CSR AXI-Lite Master Interface
		output wire [31:0]  app_ss_lite_csr_wdata,          //                               .wdata,                          CSR AXI-Lite Master Interface
		output wire [3:0]   app_ss_lite_csr_wstrb,          //                               .wstrb,                          CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_bvalid,         //                               .bvalid,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_bready,         //                               .bready,                         CSR AXI-Lite Master Interface
		input  wire [1:0]   ss_app_lite_csr_bresp,          //                               .bresp,                          CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_arvalid,        //                               .arvalid,                        CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_arready,        //                               .arready,                        CSR AXI-Lite Master Interface
		output wire [19:0]  app_ss_lite_csr_araddr,         //                               .araddr,                         CSR AXI-Lite Master Interface
		input  wire         ss_app_lite_csr_rvalid,         //                               .rvalid,                         CSR AXI-Lite Master Interface
		output wire         app_ss_lite_csr_rready,         //                               .rready,                         CSR AXI-Lite Master Interface
		input  wire [31:0]  ss_app_lite_csr_rdata,          //                               .rdata,                          CSR AXI-Lite Master Interface
		input  wire [1:0]   ss_app_lite_csr_rresp,          //                               .rresp,                          CSR AXI-Lite Master Interface
		output wire [2:0]   ss_app_lite_csr_awprot,         //                               .awprot,                         CSR AXI-Lite Master Interface
		output wire [2:0]   ss_app_lite_csr_arprot,         //                               .arprot,                         CSR AXI-Lite Master Interface
		output wire         dma_axi_mm_awvalid,             //                 dma_mm_initatr.awvalid,                        MM Initator Master Interface
		input  wire         dma_axi_mm_awready,             //                               .awready,                        MM Initator Master Interface
		output wire [3:0]   dma_axi_mm_awid,                //                               .awid,                           MM Initator Master Interface
		output wire [63:0]  dma_axi_mm_awaddr,              //                               .awaddr,                         MM Initator Master Interface
		output wire [7:0]   dma_axi_mm_awlen,               //                               .awlen,                          MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_awsize,              //                               .awsize,                         MM Initator Master Interface
		output wire [1:0]   dma_axi_mm_awburst,             //                               .awburst,                        MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_awprot,              //                               .awprot,                         MM Initator Master Interface
		output wire         dma_axi_mm_awlock,              //                               .awlock,                         MM Initator Master Interface
		output wire         dma_axi_mm_wvalid,              //                               .wvalid,                         MM Initator Master Interface
		output wire         dma_axi_mm_wlast,               //                               .wlast,                          MM Initator Master Interface
		input  wire         dma_axi_mm_wready,              //                               .wready,                         MM Initator Master Interface
		output wire [255:0] dma_axi_mm_wdata,               //                               .wdata,                          MM Initator Master Interface
		output wire [31:0]  dma_axi_mm_wstrb,               //                               .wstrb,                          MM Initator Master Interface
		input  wire         dma_axi_mm_bvalid,              //                               .bvalid,                         MM Initator Master Interface
		output wire         dma_axi_mm_bready,              //                               .bready,                         MM Initator Master Interface
		input  wire [3:0]   dma_axi_mm_bid,                 //                               .bid,                            MM Initator Master Interface
		input  wire [1:0]   dma_axi_mm_bresp,               //                               .bresp,                          MM Initator Master Interface
		output wire         dma_axi_mm_arvalid,             //                               .arvalid,                        MM Initator Master Interface
		input  wire         dma_axi_mm_arready,             //                               .arready,                        MM Initator Master Interface
		output wire [3:0]   dma_axi_mm_arid,                //                               .arid,                           MM Initator Master Interface
		output wire [63:0]  dma_axi_mm_araddr,              //                               .araddr,                         MM Initator Master Interface
		output wire [7:0]   dma_axi_mm_arlen,               //                               .arlen,                          MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_arsize,              //                               .arsize,                         MM Initator Master Interface
		output wire [1:0]   dma_axi_mm_arburst,             //                               .arburst,                        MM Initator Master Interface
		output wire [2:0]   dma_axi_mm_arprot,              //                               .arprot,                         MM Initator Master Interface
		output wire         dma_axi_mm_arlock,              //                               .arlock,                         MM Initator Master Interface
		input  wire         dma_axi_mm_rvalid,              //                               .rvalid,                         MM Initator Master Interface
		input  wire         dma_axi_mm_rlast,               //                               .rlast,                          MM Initator Master Interface
		output wire         dma_axi_mm_rready,              //                               .rready,                         MM Initator Master Interface
		input  wire [3:0]   dma_axi_mm_rid,                 //                               .rid,                            MM Initator Master Interface
		input  wire [255:0] dma_axi_mm_rdata,               //                               .rdata,                          MM Initator Master Interface
		input  wire [1:0]   dma_axi_mm_rresp,               //                               .rresp,                          MM Initator Master Interface
		output wire         rx_pio_axi_lite_awvalid,        //               pio_lite_initatr.awvalid,                        PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_awready,        //                               .awready,                        PIO AXI-Lite Master Interface
		output wire [26:0]  rx_pio_axi_lite_awaddr,         //                               .awaddr,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_wvalid,         //                               .wvalid,                         PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_wready,         //                               .wready,                         PIO AXI-Lite Master Interface
		output wire [63:0]  rx_pio_axi_lite_wdata,          //                               .wdata,                          PIO AXI-Lite Master Interface
		output wire [7:0]   rx_pio_axi_lite_wstrb,          //                               .wstrb,                          PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_bvalid,         //                               .bvalid,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_bready,         //                               .bready,                         PIO AXI-Lite Master Interface
		input  wire [1:0]   rx_pio_axi_lite_bresp,          //                               .bresp,                          PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_arvalid,        //                               .arvalid,                        PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_arready,        //                               .arready,                        PIO AXI-Lite Master Interface
		output wire [26:0]  rx_pio_axi_lite_araddr,         //                               .araddr,                         PIO AXI-Lite Master Interface
		input  wire         rx_pio_axi_lite_rvalid,         //                               .rvalid,                         PIO AXI-Lite Master Interface
		output wire         rx_pio_axi_lite_rready,         //                               .rready,                         PIO AXI-Lite Master Interface
		input  wire [63:0]  rx_pio_axi_lite_rdata,          //                               .rdata,                          PIO AXI-Lite Master Interface
		input  wire [1:0]   rx_pio_axi_lite_rresp,          //                               .rresp,                          PIO AXI-Lite Master Interface
		output wire [2:0]   rx_pio_axi_lite_awprot,         //                               .awprot,                         PIO AXI-Lite Master Interface
		output wire [2:0]   rx_pio_axi_lite_arprot,         //                               .arprot,                         PIO AXI-Lite Master Interface
		input  wire         ss_app_st_ciireq_tvalid,        //                   p0_st_ciireq.tvalid,                         CII Requestor AXI-ST Slave Interface
		output wire         app_ss_st_ciireq_tready,        //                               .tready,                         CII Requestor AXI-ST Slave Interface
		input  wire [71:0]  ss_app_st_ciireq_tdata,         //                               .tdata,                          CII Requestor AXI-ST Slave Interface
		output wire         app_ss_st_ciiresp_tvalid,       //                  p0_st_ciiresp.tvalid,                         CII Responder AXI-ST Slave Interface
		output wire [32:0]  app_ss_st_ciiresp_tdata,        //                               .tdata,                          CII Responder AXI-ST Slave Interface
		input  wire         ss_app_st_txcrdt_tvalid,        //                      ss_txcrdt.tvalid,                         Check User Guide for details
		input  wire [18:0]  ss_app_st_txcrdt_tdata,         //                               .tdata,                          Check User Guide for details
		output wire [2:0]   app_ss_st_rx_tuser_halt,        //        app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt,        Indicates PLD interface temporarily wants to halt reception of particular type of packet. bit[0] ??- Halt Posted TLP; bit[1] ??- Halt Non Posted TLP; bit[2] ??- Halt Completion TLP. Note:	Applicable for SM, SS PU HIP-native mode. NA for P/F/R tiles.
		input  wire         ss_app_st_ctrlshadow_tvalid,    //                  ss_ctrlshadow.tvalid,                         Check User Guide for details
		input  wire [39:0]  ss_app_st_ctrlshadow_tdata,     //                               .tdata,                          Check User Guide for details
		input  wire         ss_app_st_flrrcvd_tvalid,       //                     ss_flrrcvd.tvalid,                         Check User Guide for details
		input  wire [21:0]  ss_app_st_flrrcvd_tdata,        //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_flrcmpl_tvalid,       //                     ss_flrcmpl.tvalid,                         Check User Guide for details
		output wire [21:0]  app_ss_st_flrcmpl_tdata,        //                               .tdata,                          Check User Guide for details
		input  wire         ss_app_st_flrcmpl_tready,       //                               .tready,                         Check User Guide for details
		input  wire         ss_app_st_cplto_tvalid,         //                       ss_cplto.tvalid,                         Check User Guide for details
		input  wire [48:0]  ss_app_st_cplto_tdata,          //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_err_tvalid,           //                     ss_app_err.tvalid,                         Check User Guide for details
		output wire [31:0]  app_ss_st_err_tdata,            //                               .tdata,                          Check User Guide for details
		output wire         app_ss_st_err_tlast,            //                               .tlast,                          Check User Guide for details
		input  wire         ss_app_st_err_tready,           //                               .tready,                         Check User Guide for details
		output wire [13:0]  app_ss_st_err_tuser_error_type  // app_ss_st_err_tuser_error_type.app_ss_st_err_tuser_error_type, Check User Guide for details
	);
endmodule

