// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




//
// Description
//-----------------------------------------------------------------------------
//
//   System reset controller
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Module ports
//-----------------------------------------------------------------------------

module rst_ctrl (
   input    logic clk_sys,             // Global clock
   input    logic clk_100m,            // Clock 100 MHz
   input    logic pll_locked,          // PLL locked flag
   input    logic pcie_reset_status,   // PCIe SRC reset status
   input    logic pcie_cold_rst_ack_n, // PCIe cold reset ack (active low)
   input    logic pcie_warm_rst_ack_n, // PCIe warm reset ack (active low),
   
   input   logic ninit_done,          // FPGA initialization done (active low)
   output   logic rst_n_sys,           // System reset synchronous to clk_sys 
   output   logic rst_n_100m,          // System reset synchronous to clk_100m
   output   logic pwr_good_n,          // Hardware reset synchronous to clk_sys
   output   logic pcie_cold_rst_n,     // PCIe cold reset synchronous to clk_sys
   output   logic pcie_warm_rst_n,      // PCIe warm reset synchronous to clk_sys

   output   logic subsystem_rst_req,    // Reset entry indication from Central Reset Sequencer block in SOC
   input    logic subsystem_rst_rdy,    // Ready for reset entry indication from Subsystem to Central Reset Sequencer block
   input    logic initiate_warmrst_req,  //Reset entry required indication from SIP SRC block to Central Reset Sequencer
   output   logic initiate_rst_req_rdy   //Indicates Central Reset Sequencer block has accepted initiation request and will start issuing resets
);

//--------------------------------------------------------------------------
// Reset inputs 
//--------------------------------------------------------------------------
wire  rst_n, rst_n_sync;
wire  npor;
wire ninit_done_sync;

assign npor  = ~ninit_done_sync; 
assign rst_n = npor && pll_locked && ~pcie_reset_status;

fim_resync #(
   .SYNC_CHAIN_LENGTH(3),
   .WIDTH(1),
   .INIT_VALUE(0),
   .NO_CUT(1)
) rst_in_resync (
   .clk   (clk_sys),
   .reset (~rst_n),
   .d     (1'b1),
   .q     (rst_n_sync)
);

// Configuration reset release IP
// reset release IP used in HWT
//`ifdef SIM_MODE
//   assign ninit_done = 1'b0;
//`else
//   cfg_mon cfg_mon (
//      .ninit_done (ninit_done)
//   );
//`endif

//--------------------------------------------------------------------------
// PCIe reset control
//--------------------------------------------------------------------------
logic pcie_cold_rst_ack_n_sync;
logic pcie_warm_rst_ack_n_sync;
logic pcie_rst_ack;
logic pcie_rst_release;
logic pcie_rst_n;
logic fim_rst_n;

`ifdef INCLUDE_PCIE_SS
   fim_resync #(
      .SYNC_CHAIN_LENGTH(3),
      .WIDTH(2),
      .INIT_VALUE(0),
      .NO_CUT(1)
   ) pcie_cold_rst_ack_sync (
      .clk   (clk_sys),
      .reset (1'b0),
      .d     ({pcie_cold_rst_ack_n, pcie_warm_rst_ack_n}),
      .q     ({pcie_cold_rst_ack_n_sync, pcie_warm_rst_ack_n_sync})
   );
`else
   assign pcie_cold_rst_ack_n_sync = pcie_rst_n;
   assign pcie_warm_rst_ack_n_sync = pcie_rst_n;
`endif

assign pcie_rst_ack = (~pcie_cold_rst_ack_n_sync && ~pcie_warm_rst_ack_n_sync);
assign pcie_rst_release = (pcie_rst_n && pcie_cold_rst_ack_n_sync && pcie_warm_rst_ack_n_sync);

//------------------
// PCIe reset
//    Activate PCIe cold/warm reset when reset input is active
//    Wait for PCIe cold/warm reset ack
//    Release PCIe cold/warm reset
//------------------
always_ff @(posedge clk_sys) begin
   if (~rst_n_sync) begin
      pcie_rst_n <= 1'b0;
   end else begin
     if (~pcie_rst_n && pcie_rst_ack) begin
         pcie_rst_n <= 1'b1;
     end
   end
end
//----------------------------------------------------------------
// PCIeSS reset
//     Handshake between SIP SRC block and Central Reset Sequencer
//----------------------------------------------------------------
localparam    N_CYCLE_TO_RELEASE_RST_REQ     =   5'd21;
localparam    N_CYCLE_TO_RELEASE_RST_REQ_RDY =   5'd21;

reg subsystem_rst_req_temp;
reg initiate_rst_req_rdy_temp;
reg subsystem_rst_req_i;
reg initiate_rst_req_rdy_i;

logic [5:0]   n_cycle_count_to_subsystem_rst_req_release, n_cycle_count_to_initiate_rst_req_rdy_release;

logic subsystem_rst_req_edge, initiate_rst_req_rdy_edge, subsystem_rst_req_edge_delay, initiate_rst_req_rdy_edge_delay, subsystem_rst_req_edge_long, initiate_rst_req_rdy_edge_long;

always @(posedge clk_sys) begin
     subsystem_rst_req_i <= subsystem_rst_req_temp;
     subsystem_rst_req_edge <= subsystem_rst_req_i ^ subsystem_rst_req_temp;
     subsystem_rst_req_edge_delay <= subsystem_rst_req_edge;
end
assign subsystem_rst_req_edge_long = subsystem_rst_req_edge || subsystem_rst_req_edge_delay;

always @(posedge clk_sys) begin
     initiate_rst_req_rdy_i <= initiate_rst_req_rdy_temp;
     initiate_rst_req_rdy_edge <= initiate_rst_req_rdy_i ^ initiate_rst_req_rdy_temp;
     initiate_rst_req_rdy_edge_delay <= initiate_rst_req_rdy_edge;
end
assign initiate_rst_req_rdy_edge_long = initiate_rst_req_rdy_edge || initiate_rst_req_rdy_edge_delay;
 
assign subsystem_rst_req_temp = initiate_warmrst_req; 
assign initiate_rst_req_rdy_temp = subsystem_rst_rdy;

/*
always @* begin
    if (ninit_done) 
       subsystem_rst_req = 0;
    else if (  (subsystem_rst_req_i == 1) && (n_cycle_count_to_subsystem_rst_req_release == N_CYCLE_TO_RELEASE_RST_REQ) ) 
        subsystem_rst_req = subsystem_rst_req_i;
    else if (pcie_warm_rst_n == 0) 
        subsystem_rst_req = 0;
end
*/

always @(posedge clk_sys or posedge ninit_done_sync) begin
   if (ninit_done_sync) begin
       subsystem_rst_req <= 0;
   end
   else begin
     if (  (subsystem_rst_req_i == 1) && (n_cycle_count_to_subsystem_rst_req_release == N_CYCLE_TO_RELEASE_RST_REQ) )
        subsystem_rst_req <= 1;
     else if (pcie_warm_rst_n == 0)
        subsystem_rst_req <= 0;
     else
        subsystem_rst_req  <=  subsystem_rst_req;
   end
end


/*
always @* begin
    if (ninit_done)
        initiate_rst_req_rdy = 0;
    else if ( (initiate_rst_req_rdy_i == 1) && (n_cycle_count_to_initiate_rst_req_rdy_release == N_CYCLE_TO_RELEASE_RST_REQ_RDY) )
        initiate_rst_req_rdy = initiate_rst_req_rdy_i;
    else if (pcie_warm_rst_n == 0)
        initiate_rst_req_rdy = 0;
end
*/

// logic comparator_output;

// always @(posedge clk_sys) begin
// // if(ninit_done) begin
// //   comparator_output <= 0;
// // end
// // else begin
   // if (n_cycle_count_to_initiate_rst_req_rdy_release == N_CYCLE_TO_RELEASE_RST_REQ_RDY)begin
     // comparator_output <= 1;
   // end else begin
     // comparator_output <= 0;
   // end
// // end
// end


always @(posedge clk_sys or posedge ninit_done_sync) begin
   if (ninit_done_sync) begin
      initiate_rst_req_rdy <= 0;
   end
   else begin
     if (  (initiate_rst_req_rdy_i == 1) && (n_cycle_count_to_initiate_rst_req_rdy_release == N_CYCLE_TO_RELEASE_RST_REQ_RDY) )
     // if (  (initiate_rst_req_rdy_i == 1) && (comparator_output) )
        initiate_rst_req_rdy <= 1;
     else if (pcie_warm_rst_n == 0)
        initiate_rst_req_rdy <= 0;
     else
        initiate_rst_req_rdy  <=  initiate_rst_req_rdy;
   end
end


   //counting to subsystem_rst_req release
   always_ff @(posedge clk_sys or posedge ninit_done_sync ) begin : proc_cycle_count_to_subsystem_rst_req_release
       if(ninit_done_sync) begin
         n_cycle_count_to_subsystem_rst_req_release <= 0;
      end
      else begin
         if (subsystem_rst_req_edge_long || ( n_cycle_count_to_subsystem_rst_req_release != 0 && n_cycle_count_to_subsystem_rst_req_release != N_CYCLE_TO_RELEASE_RST_REQ) )  //count until 20
            n_cycle_count_to_subsystem_rst_req_release <= n_cycle_count_to_subsystem_rst_req_release[4:0] + 1;
         else
            n_cycle_count_to_subsystem_rst_req_release <= 0;
      end
   end

   //counting to initiate_rst_req_rdy release
   always_ff @(posedge clk_sys or posedge ninit_done_sync ) begin : proc_cycle_count_to_initiate_rst_req_rdy_release
      if(ninit_done_sync) begin
         n_cycle_count_to_initiate_rst_req_rdy_release <= 0;
      end
     else 
     begin
         if (initiate_rst_req_rdy_edge_long || ( n_cycle_count_to_initiate_rst_req_rdy_release != 0 && n_cycle_count_to_initiate_rst_req_rdy_release != N_CYCLE_TO_RELEASE_RST_REQ_RDY) )  //count until 20
            n_cycle_count_to_initiate_rst_req_rdy_release <= n_cycle_count_to_initiate_rst_req_rdy_release[4:0] + 1;
         else
            n_cycle_count_to_initiate_rst_req_rdy_release <= 0;
     end
   end



//------------------
// FIM reset
//    Activate FIM reset when reset input is active
//    Wait for PCIe reset to be released
//    Release FIM reset
//------------------
always_ff @(posedge clk_sys) begin
   if (~rst_n_sync) begin
      fim_rst_n  <= 1'b0;
   end else begin
      if (~fim_rst_n && pcie_rst_release) begin
         fim_rst_n <= 1'b1;
      end
   end
end

//--------------------------------------------------------------------------
// Reset output
//--------------------------------------------------------------------------

// PCIe cold/warm reset
assign pcie_cold_rst_n = pcie_rst_n;
assign pcie_warm_rst_n = pcie_rst_n;

// FIM reset synchronous to clk_sys
fim_resync #(
   .SYNC_CHAIN_LENGTH(3),
   .WIDTH(1),
   .INIT_VALUE(0),
   .NO_CUT(1)
) rst_clk_sys_resync (
   .clk   (clk_sys),
   .reset (~rst_n | ~fim_rst_n),
   .d     (1'b1),
   .q     (rst_n_sys)
);

// FIM reset synchronous to clk_100m 
fim_resync #(
   .SYNC_CHAIN_LENGTH(3),
   .WIDTH(1),
   .INIT_VALUE(0),
   .NO_CUT(1)
) rst_clk100m_resync (
   .clk   (clk_100m),
   .reset (~rst_n | ~fim_rst_n),
   .d     (1'b1),
   .q     (rst_n_100m)
);

// FIM power good reset synchronous to clk_sys
fim_resync #(
   .SYNC_CHAIN_LENGTH(3),
   .WIDTH(1),
   .INIT_VALUE(0),
   .NO_CUT(1)
) pwr_good_n_resync (
   .clk   (clk_sys),
   .reset (~pll_locked | ninit_done),
   .d     (1'b1),
   .q     (pwr_good_n)
);

/*  ipm_cdc_sync_rst #(
      .RST_TYPE           ("ACTIVE_HIGH"),
      .NUM_STAGES         (3)
	) ninit_sync (
      .clk         (clk_sys),      //input, width = 1
      .srst_in     (ninit_done),  //input, width = 1
      .srst_out    (ninit_done_sync)  //output, width = 1
	);
	*/
	
	   ipm_cdc_1clk_sync #(
      .INITIAL_VALUE                  (0),
	  .NUM_STAGES                     (3)
	) ninit_sync (
         .clk           (clk_sys),       //input, width = 1
         .async_in      (ninit_done),  //input, width = 1
         .sync_out      (ninit_done_sync)   //output, width = 1
	);

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "CMmtAmKt5npgltBGSGayMD3S82LbrOyoIRJhaGPVZ9+1rQURt/zpqG45ZW8bu0uYgqdmqml0eEvdD4TRxWnYMa9qVt3DD8wDZFgDyC+4hk8LQe0gOhIT6pyripLwDe8s9OPDkE17E7KIjy+zKcRGPIEWW+S8TS0X4ob1FffXDsCtGX9BGI7Obc9NfOqzu4hBrmZJ8WSoLLvXaI3YwuY52dAiOf8n+195f1Ogp89gbg+TKrQe02u/Zkqr7xEAON3mg67eQnb6veryuifIVbi1xLp3gfIOgC93NI3O40i60Zqqmm6P/9wPcSsF5ZLh2ZAmgSfl+i+a1miFk9KsXe8jA/s8ju2jCnxLZrpEcvSZb96bg2F2nObU1Bz1PsE4hZG/2fhRcV8kwWjjRI8p4+kTqEb+XKwSoK0slNmjG+QFxis8MrXg+TQV/V83eukA9fdHN+ZATabFNfRDEebgLEu0Lo9XZ/7lQS/hJWKE8gcQZ6Efr4s2d0PKu9UiUUTshLbnI2PK7qjmhNngFmI3KDOMOBHlN697Sgcv2EBjTQrPtdvJsHeEHIqnlvois5uHVPDy1yitXT53G0yeIt6wfsGz5tP1uPLhr0TXpwuPO3h7RDworIMK+7yCj/iUPLzYKcTVFac+2PiqpiNy8uHr6KmJYLmHntooUnFMdSM4e7pZVilFghOHU9I0TdBVWNkHH84INmfBcmeCFYmggV9nILzu/KxT/kVQLrampK0XAGJ+I/Iyv/iou6kP1aYcQsLYNW+PF9ZqlRpOHycaOT5GkbkT2B/j8PoRomplzC+d7Ur5Eivu56gk+JVBvBSkBxPLGmGI0u5ESislkZMkaABDz5I2O4vFC54schb4Blhx46f4LASKJMdgSwXWjglpXk/GdvEvu6+4i7Rno2X/8XJv223ve05/uBniG2TBRdHX9n8IhfNn1qRDouBYjYE71wD6/kOofRWrHIht+ViXJ6sG655wZbya6dtFfDFURlr8kkIq+RaGCEgTZ0YbAzzC0+fuw9a4"
`endif