module pcie_ed_dut (
		input  wire         refclk0,                        //                      refclk0.clk,                      Input reference clock for IP core.
		input  wire         p0_i_syspll_c0_clk,             //           p0_i_syspll_c0_clk.clk,                      System PLL clock input c0 port.
		input  wire         p0_i_ss_vccl_syspll_locked,     //   p0_i_ss_vccl_syspll_locked.o_pll_lock,               System PLL locked signal
		input  wire [0:0]   i_flux_clk,                     //                   i_flux_clk.clk,                      Check User Guide for details
		input  wire         rx_n_in0,                       //                   hip_serial.rx_n_in0,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in0,                       //                             .rx_p_in0,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out0,                      //                             .tx_n_out0,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out0,                      //                             .tx_p_out0,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in1,                       //                             .rx_n_in1,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in1,                       //                             .rx_p_in1,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out1,                      //                             .tx_n_out1,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out1,                      //                             .tx_p_out1,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in2,                       //                             .rx_n_in2,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in2,                       //                             .rx_p_in2,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out2,                      //                             .tx_n_out2,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out2,                      //                             .tx_p_out2,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         rx_n_in3,                       //                             .rx_n_in3,                 Receive serial data inputs using the High Speed Differential I/O standard.
		input  wire         rx_p_in3,                       //                             .rx_p_in3,                 Receive serial data inputs using the High Speed Differential I/O standard.
		output wire         tx_n_out3,                      //                             .tx_n_out3,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		output wire         tx_p_out3,                      //                             .tx_p_out3,                Trasnmit serial data output using High Speed Differential I/O Standard. Note:The signal width stated here is per port basis. Full width will be device dependent. (As it??-s a comination of multiple ports) X4: b=4, X8: b=8
		input  wire         p0_pin_perst_n_i,               //             p0_pin_perst_n_i.reset_n,                  This is an active-low input to PCIe Hard IP for PERST# function defined by PCIe specification
		input  wire         p0_pin_perst_n_1_i,             //           p0_pin_perst_n_1_i.reset_n,                  This is an active-low input to PCIe Hard IP for PERST# function defined by PCIe specification
		output wire         p0_coreclkout_hip_toapp,        //      p0_coreclkout_hip_toapp.clk,                      This clock drives the PLD interface layer. Clock freq depends on datarate and number of lanes being use. Gen3 : 250Mhz. Gen4 : 350Mhz to 500Mhz.
		output wire         p0_pin_perst_n,                 //               p0_pin_perst_n.reset_n,                  PERST0 status indication for port 0. User shall expect this as async signal.
		output wire         p0_reset_status_n,              //            p0_reset_status_n.reset_n,                  The active low signal, when low indicates pin perstn is deasserted and HARD IP is in reset state. The application logic can use this signal to drive its reset network. The reset_status_n output of HIP drives this signal. The signal is synchronous to coreclkout_hip of Hard IP.
		input  wire         ninit_done,                     //                   ninit_done.reset,                    From "Reset Release IP". A "1" on this active-low signal indicates that the FPGA device is not yet fully configured. A "0" indicates the device has been configured and is in normal operating mode.
		input  wire         p0_axi_st_clk,                  //                p0_axi_st_clk.clk,                      This clock is an input to the SM PCI QHIP, it can be synchronous with coreclkout_hip or async with slower frequency.
		input  wire         p0_axi_lite_clk,                //              p0_axi_lite_clk.clk,                      This clock is an input to the SM PCI QHIP, it can be synchronous with coreclkout_hip or async with slower frequency.
		input  wire         p0_axi_st_areset_n,             //           p0_axi_st_areset_n.reset_n,                  AXI-Streaming main datapath reset. Active-LOW reset signal. The reset signal can be asserted asynchronously, but deassertion must be synchronous after the rising edge of axi_st_clk.
		input  wire         p0_axi_lite_areset_n,           //         p0_axi_lite_areset_n.reset_n,                  AXI-Lite reset. Active-LOW reset signal. The reset signal can be asserted asynchronously, but deassertion must be synchronous after the rising edge of axi_lite_clk.
		input  wire         p0_subsystem_cold_rst_n,        //      p0_subsystem_cold_rst_n.reset_n,                  Subsystem global reset. Resets sticky register bits. Active low. Could be implemented as synchronous or asynchronous reset.
		input  wire         p0_subsystem_warm_rst_n,        //      p0_subsystem_warm_rst_n.reset_n,                  Subsystem warm reset. Does not reset sticky register bits. Active low. Could be implemented as synchronous or asynchronous reset.
		output wire         p0_subsystem_cold_rst_ack_n,    //  p0_subsystem_cold_rst_ack_n.subsystem_cold_rst_ack_n, Indicates cold reset action is completed by subsystem.
		output wire         p0_subsystem_warm_rst_ack_n,    //  p0_subsystem_warm_rst_ack_n.subsystem_warm_rst_ack_n, Indicates warm reset action is completed by subsystem.
		input  wire         p0_subsystem_rst_req,           //         p0_subsystem_rst_req.subsystem_rst_req,        Reset entry indication from Central Reset Sequencer block in SOC. Subsystem quiesces the blocks in design upon receiving this request and sends acknowledgement back when block is ready for reset entry.
		output wire         p0_subsystem_rst_rdy,           //         p0_subsystem_rst_rdy.subsystem_rst_rdy,        Ready for reset entry indication from Subsystem to Central Reset Sequencer block.
		output wire         p0_initiate_warmrst_req,        //      p0_initiate_warmrst_req.initiate_warmrst_req,     Reset entry required indication from SIP SRC block to Central Reset Sequencer. Initiator block cannot issue new reset entry request until previous reset sequence (entire reset operation) is completed.
		input  wire         p0_initiate_rst_req_rdy,        //      p0_initiate_rst_req_rdy.initiate_rst_req_rdy,     Indicates Central Reset Sequencer block has accepted initiation request and will start issuing resets.
		output wire         p0_ss_app_st_rx_tvalid,         //                     p0_st_rx.tvalid,                   ss_app_st_rx_tvalid indicates that the source is driving a valid transfer.
		input  wire         p0_app_ss_st_rx_tready,         //                             .tready,                   app_ss_st_rx_tready indicates that the sink can accept a transfer in the current cycle. readyLatency parameter defined in AXI HAS spec shall be supported. By default the value is '0'.
		output wire [255:0] p0_ss_app_st_rx_tdata,          //                             .tdata,                    Data interface with configurable width specified by DWIDTH_SEG*NUM_OF_SEG parameter. Default DWIDTH = DWIDTH_SEG*NUM_OF_SEG= 1024. For Sideband header type: tdata carries only payload. For In-band header type, tdata carries header followed by payload.
		output wire [31:0]  p0_ss_app_st_rx_tkeep,          //                             .tkeep,                    A byte qualifier used to indicate whether the content of the associated byte is valid. The invalid bytes are allowed only during ss_app_st_tx_tlast cycle.
		output wire         p0_ss_app_st_rx_tlast,          //                             .tlast,                    Indicates End of Data/Command Transmission, tlast may seem redundant with tuser.last_segment. But tlast can be used by the front-end layer of AXI BFM/routing fabric that doesn??-t deal with decoding of the multipacket data.
		output wire [255:0] p0_ss_app_st_rx_tuser_hdr,      //    p0_ss_app_st_rx_tuser_hdr.st_rx_tuser_hdr,          Header interface: Only applicable when Sideband Header is enabled
		output wire         p0_ss_app_st_rx_tuser_hvalid,   // p0_ss_app_st_rx_tuser_hvalid.st_rx_tuser_hvalid,       Indicates that the source is driving a valid Header transfer: Only applicable when Sideband Header is enabled
		input  wire         p0_app_ss_st_tx_tvalid,         //                     p0_st_tx.tvalid,                   app_ss_st_tx_tvalid indicates that the source is driving a valid transfer.
		output wire         p0_ss_app_st_tx_tready,         //                             .tready,                   ss_app_axi_st_tx_tready indicates that the sink can accept a transfer in the current cycle. readyLatency parameter defined in AXI HAS spec shall be supported. By default the value is '0'.
		input  wire [255:0] p0_app_ss_st_tx_tdata,          //                             .tdata,                    Data interface with configurable width specified by DWIDTH_SEG*NUM_OF_SEG parameter. Default DWIDTH = DWIDTH_SEG*NUM_OF_SEG= 1024. For Sideband header type: tdata carries only payload. For In-band header type, tdata carries header followed by payload.
		input  wire [31:0]  p0_app_ss_st_tx_tkeep,          //                             .tkeep,                    A byte qualifier used to indicate whether the content of the associated byte is valid. The invalid bytes are allowed only during app_axi_st_tx_tlast cycle.
		input  wire         p0_app_ss_st_tx_tlast,          //                             .tlast,                    Indicates End of Data/Command Transmission.
		input  wire [255:0] p0_app_ss_st_tx_tuser_hdr,      //    p0_app_ss_st_tx_tuser_hdr.st_tx_tuser_hdr,          Header interface: Only applicable when Sideband Header is enabled
		input  wire         p0_app_ss_st_tx_tuser_hvalid,   // p0_app_ss_st_tx_tuser_hvalid.st_tx_tuser_hvalid,       Indicates that the source is driving a valid Header transfer: Only applicable when Sideband Header is enabled
		output wire         p0_ss_app_st_ciireq_tvalid,     //                 p0_st_ciireq.tvalid,                   When asserted, indicates a valid CFG request cycle is waiting to be intercepted. De-asserted when app_ss_st_ciireq_tready is asserted.
		input  wire         p0_app_ss_st_ciireq_tready,     //                             .tready,                   Application assert this signal for one clock to acknowledge ss_app_st_ciireq_tvalid is seen by responder.
		output wire [71:0]  p0_ss_app_st_ciireq_tdata,      //                             .tdata,                    st_app_st_ciireq_tdata[0] - hdr_poisoned: The poisoned bit in the received TLP header on the CII. st_app_st_ciireq_tdata[4:1] - hdr_first_be: The first dword byte enable field in the received TLP header on the CII. st_app_st_ciireq_tdata[9:5] -slot_num: The slot number in the received TLP header on the CII, Rsvd when SEP is not present. st_app_st_ciireq_tdata[12:10] - func_num: The PF number in the received TLP header on the CII. (PF[2:0]). st_app_st_ciireq_tdata[23:13] - vf_num: The child VF number of parent PF in the received TLP header on the CII. st_app_st_ciireq_tdata[24] - vf_active: Indicates VF number is valid in the received TLP header on the CII. st_app_st_ciireq_tdata[25] - wr: Indicates a configuration write request detected in the received TLP header on the CII. Also indicates that st_app_st_ciireq_tdata[67:36] is valid. st_app_st_ciireq_tdata[35:26] - addr: The double word register address in the received TLP header on the CII. st_app_st_ciireq_tdata[67:36] - dout: Received TLP payload data from the link partner to your application client. The data is in little endian format. The first received payload byte is in [43:36]. st_app_st_ciireq_tdata[69:68] - func_num: The PF number in the received TLP header on the CII. (PF[4:3]). st_app_st_ciireq_tdata[71:70] - SEP Type: Indicates the type of cfg space being accessed "00" - Switch Up "01" - Switch Down "10" - Embedded EP Note: This field is only applicable when SEP is integrated into PCIe SS.
		input  wire         p0_app_ss_st_ciiresp_tvalid,    //                p0_st_ciiresp.tvalid,                   Application assert this signal for one clock to indicate that valid data is driven on app_ss_st_ciiresp_tdata bus.
		input  wire [32:0]  p0_app_ss_st_ciiresp_tdata,     //                             .tdata,                    Override data from application for the intercepted config request on "st_ciireq interface". For CfgWr: override the write data to the Config register with data supplied by the application logic. For CfgRd: override the data payload of the completion TLP with data supplied by the application logic.<n>Override Data Enable: Application assert this signal to override the CfgWr payload or CfgRd completion using the data supplied by the application logic on app_ss_st_ciiresp_tdata[31:0] bus.
		output wire         p0_ss_app_st_ctrlshadow_tvalid, //             p0_st_ctrlshadow.tvalid,                   The subsystem asserts this output for one clock cycle when there is an update to the register fields being monitored, because of a Configuration Write performed by the Root Complex.  The user can copy the new settings of the register fields from the tdata bus.
		output wire [39:0]  p0_ss_app_st_ctrlshadow_tdata,  //                             .tdata,                    When app_ctrl_shadow_tvalid has been asserted, this output provides the current settings of the register fields of the associated Function. Bit[2:0] - Identifies the physical function Number of configuration register (PF[2:0]). Bit[13:3] - Identifies the virtual function Number of configuration register. Bit[14] - Indicates information is for Virtual Function implemented in slot's physical function. Bit[19:15] - Identifies the slot Number of configuration register, Rsvd when SEP is not present. Bit[20] - Bus Master Enable. Bit[21] - MSIX Mask. Bit[22] - MSIX Enable. Bit[23] - Mem Space Enable. Bit[24] - ExpRom Enable. Bit[25] - TPH Req Enable  . Bit[26] - ATS Enable. Bit[27] - MSI Enable. Bit[28] - MSI Mask Update. Bit[29] - Extended Tag. Bit[30] - 10Bit Tag Req Enable. Bit[31] - PTM Enable. Bit[34:32] - MPS Size. Bit[37:35] - MRRS Size. Bit[38] - VF Enable. Bit[39] - Page Request Enable. Bit[41:40] - Identifies the physical function Number of configuration register (PF[4:3]).
		output wire         p0_ss_app_st_txcrdt_tvalid,     //                 p0_st_txcrdt.tvalid,                   tvalid indicates that the credit information on tdata is valid
		output wire [18:0]  p0_ss_app_st_txcrdt_tdata,      //                             .tdata,                    Carries credit limit information and type of credit. Bit[15:0] - Credit Limit Value. Bit[18:16] - Credit Type. 3'b000 - Posted Header Credit. 3'b001 - Non-Posted Header Credit. 3'b010 - Completion Header Credit. 3'b011 - Reserved. 3'b100 - Posted Data Credit. 3'b101 - Non-Posted Data Credit. 3'b110 - Completion Data Credit. 3'b111 - Reserved. Bit[15:0] - All zero indicate of Infinite Credit Advertise.
		output wire         p0_ss_app_st_cplto_tvalid,      //                  p0_st_cplto.tvalid,                   tvalid indicates that the completion timeout received for outstanding NP request
		output wire [48:0]  p0_ss_app_st_cplto_tdata,       //                             .tdata,                    Carries completion Timeout Information. Bit[9:0] - Tag Number. Bit[12:10] - PF Number (PF[2:0]), indicates parent PF number of VF when VF Active is high else PF Number of function. Bit[23:13] - VF Number, indicates VF number when VF Active js high. Bit[24] - VF Active, indicates timeout is for VF. Bit[29:25] - Slot Number, always zero when SEP is not present. Bit[31:30] - PF Number (PF[4:3]). Bit[43:32] - Transfer length in bytes (least significant 12 bits), of the expected completion that timed out for the non-posted transaction. For a split completion, it indicates the number of bytes remaining to be delivered when the completion timed out (Max length is Max Read request size. Ex: 4K Bytes = 2^12 bytes). Bit[46:44] - Traffic class of the expected completion that timed out for the non-posted transaction.. Bit[48:47]: Attribute of the expected completion that timed out for the non-posted transaction. ID based ordering is not supported. [48] -> Relaxed ordering, [47] -> No Snoop.
		input  wire         p0_app_ss_lite_csr_awvalid,     //                  p0_lite_csr.awvalid,                  Indicates that the write address channel signals are valid
		output wire         p0_ss_app_lite_csr_awready,     //                             .awready,                  Indicates that a transfer on the write address channel can be accepted
		input  wire [19:0]  p0_app_ss_lite_csr_awaddr,      //                             .awaddr,                   The address of the first transfer in a write transaction. The default value of LiteSlvAWD = 18.
		input  wire         p0_app_ss_lite_csr_wvalid,      //                             .wvalid,                   Indicates that the write data channel signals are valid.
		output wire         p0_ss_app_lite_csr_wready,      //                             .wready,                   Indicates that a transfer on the write data channel can be accepted.
		input  wire [31:0]  p0_app_ss_lite_csr_wdata,       //                             .wdata,                    Write Data. The default value of LiteSlvDWD=32.
		input  wire [3:0]   p0_app_ss_lite_csr_wstrb,       //                             .wstrb,                    Write strobes, indicate which byte lanes hold valid data.
		output wire         p0_ss_app_lite_csr_bvalid,      //                             .bvalid,                   Indicates that the write response channel signals are valid.
		input  wire         p0_app_ss_lite_csr_bready,      //                             .bready,                   Indicates that a transfer on the write response channel can be accepted.
		output wire [1:0]   p0_ss_app_lite_csr_bresp,       //                             .bresp,                    Write response, indicates the status of a write transaction.
		input  wire         p0_app_ss_lite_csr_arvalid,     //                             .arvalid,                  Indicates that the read address channel signals are valid.
		output wire         p0_ss_app_lite_csr_arready,     //                             .arready,                  Indicates that a transfer on the read address channel can be accepted.
		input  wire [19:0]  p0_app_ss_lite_csr_araddr,      //                             .araddr,                   The address of the first transfer in a read transaction. The default value of LiteSlvAWD = 18.
		output wire         p0_ss_app_lite_csr_rvalid,      //                             .rvalid,                   Indicates that the read data channel signals are valid.
		input  wire         p0_app_ss_lite_csr_rready,      //                             .rready,                   Indicates that a transfer on the read data channel can be accepted.
		output wire [31:0]  p0_ss_app_lite_csr_rdata,       //                             .rdata,                    Read data. The default value of LiteSlvDWD=32.
		output wire [1:0]   p0_ss_app_lite_csr_rresp,       //                             .rresp,                    Read response, indicates the status of a read transfer.
		output wire         p0_ss_app_serr,                 //               p0_ss_app_serr.ss_app_serr,              Indicates System Error is detected. In TLP Bypass Mode indicates PL/DL/TL layer error detected by HardIP. Note: Applicable for all modes (EP/RP/BP)
		output wire         p0_ss_app_dlup,                 //               p0_ss_app_dlup.ss_app_dlup,              Indicates Data Link Layer is UP. Note: Applicable for all modes (EP/RP/BP)
		output wire         p0_ss_app_linkup,               //             p0_ss_app_linkup.ss_app_linkup,            Link Up Indication: 0 - Link Down; 1 - Link up. Note: Applicable for all modes (EP/RP/BP)
		output wire [5:0]   p0_ss_app_ltssmstate,           //         p0_ss_app_ltssmstate.ss_app_ltssmstate,        Indicates LTSSM State: 6'h00: S_DETECT_QUIET; 6'h01: S_DETECT_ACT; 6'h02: S_POLL_ACTIVE; 6'h03: S_POLL_COMPLIANCE; 6'h04: S_POLL_CONFIG; 6'h05: S_PRE_DETECT_QUIET; 6'h06: S_DETECT_WAIT; 6'h07: S_CFG_LINKWD_START; 6'h08: S_CFG_LINKWD_ACCEPT; 6'h09: S_CFG_LANENUM_WAIT; 6'h0A: S_CFG_LANENUM_ACCEPT; 6'h0B: S_CFG_COMPLETE; 6'h0C: S_CFG_IDLE; 6'h0D: S_RCVRY_LOCK; 6'h0E: S_RCVRY_SPEED; 6'h0F: S_RCVRY_RCVRCFG; 6'h10: S_RCVRY_IDLE; 6'h11: S_L0; 6'h12: S_L0S; 6'h13: S_L123_SEND_EIDLE; 6'h14: S_L1_IDLE; 6'h15: S_L2_IDLE; 6'h16: S_L2_WAKE; 6'h17: S_DISABLED_ENTRY; 6'h18: S_DISABLED_IDLE; 6'h19: S_DISABLED; 6'h1A: S_LPBK_ENTRY; 6'h1B: S_LPBK_ACTIVE; 6'h1C: S_LPBK_EXIT; 6'h1D: S_LPBK_EXIT_TIMEOUT; 6'h1E: S_HOT_RESET_ENTRY; 6'h1F: S_HOT_RESET; 6'h20: S_RCVRY_EQ0; 6'h21: S_RCVRY_EQ1; 6'h22: S_RCVRY_EQ2; 6'h23: S_RCVRY_EQ3. Note: Applicable for all modes (EP/RP/BP)
		input  wire [2:0]   p0_app_ss_st_rx_tuser_halt      //   p0_app_ss_st_rx_tuser_halt.app_ss_st_rx_tuser_halt,  Indicates PLD interface temporarily wants to halt reception of particular type of packet. bit[0] ??- Halt Posted TLP; bit[1] ??- Halt Non Posted TLP; bit[2] ??- Halt Completion TLP. Note:	Applicable for SM, SS PU HIP-native mode. NA for P/F/R tiles.
	);
endmodule

