// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module pcie_phy_user_avmm_arb (
    input		phy_avmm_read,
    input		phy_avmm_write,
    input	[23:0]	phy_avmm_address,
    input	[31:0]	phy_avmm_writedata,
    output logic	phy_avmm_readdatavalid,
    output logic [31:0]	phy_avmm_readdata,
    output logic	phy_avmm_waitrequest,
	
    output         	phy0_avmm_read,
    output         	phy0_avmm_write,
    output 	[20:0]  phy0_avmm_address,
    output 	[31:0]  phy0_avmm_writedata,
    input          	phy0_avmm_readdatavalid,
    input  	[31:0]  phy0_avmm_readdata,
    input          	phy0_avmm_waitrequest,
	
    output         	phy1_avmm_read,
    output         	phy1_avmm_write,
    output 	[20:0]  phy1_avmm_address,
    output 	[31:0]  phy1_avmm_writedata,
    input          	phy1_avmm_readdatavalid,
    input  	[31:0]  phy1_avmm_readdata,
    input          	phy1_avmm_waitrequest,
	
    output         	phy2_avmm_read,
    output         	phy2_avmm_write,
    output 	[20:0]  phy2_avmm_address,
    output 	[31:0]  phy2_avmm_writedata,
    input          	phy2_avmm_readdatavalid,
    input  	[31:0]  phy2_avmm_readdata,
    input          	phy2_avmm_waitrequest,
	
    output         	phy3_avmm_read,
    output         	phy3_avmm_write,
    output 	[20:0]  phy3_avmm_address,
    output 	[31:0]  phy3_avmm_writedata,
    input          	phy3_avmm_readdatavalid,
    input  	[31:0]  phy3_avmm_readdata,
    input          	phy3_avmm_waitrequest,

    output         	phy4_avmm_read,
    output         	phy4_avmm_write,
    output 	[20:0]  phy4_avmm_address,
    output 	[31:0]  phy4_avmm_writedata,
    input          	phy4_avmm_readdatavalid,
    input  	[31:0]  phy4_avmm_readdata,
    input          	phy4_avmm_waitrequest,

    output         	phy5_avmm_read,
    output         	phy5_avmm_write,
    output 	[20:0]  phy5_avmm_address,
    output 	[31:0]  phy5_avmm_writedata,
    input          	phy5_avmm_readdatavalid,
    input  	[31:0]  phy5_avmm_readdata,
    input          	phy5_avmm_waitrequest,

    output         	phy6_avmm_read,
    output         	phy6_avmm_write,
    output 	[20:0]  phy6_avmm_address,
    output 	[31:0]  phy6_avmm_writedata,
    input          	phy6_avmm_readdatavalid,
    input  	[31:0]  phy6_avmm_readdata,
    input          	phy6_avmm_waitrequest,

    output         	phy7_avmm_read,
    output         	phy7_avmm_write,
    output 	[20:0]  phy7_avmm_address,
    output 	[31:0]  phy7_avmm_writedata,
    input          	phy7_avmm_readdatavalid,
    input  	[31:0]  phy7_avmm_readdata,
    input          	phy7_avmm_waitrequest
);	

	logic	[2:0]	phyq_sel;

	//3-bit address decoder
	assign phyq_sel = phy_avmm_address[23:21];

	//PHY0
	assign phy0_avmm_read		= (phyq_sel == 3'd0) ? phy_avmm_read : 0;
	assign phy0_avmm_write		= (phyq_sel == 3'd0) ? phy_avmm_write : 0;
	assign phy0_avmm_address	= (phyq_sel == 3'd0) ? phy_avmm_address[20:0] : 0;
	assign phy0_avmm_writedata	= (phyq_sel == 3'd0) ? phy_avmm_writedata : 0;

	//PHY1
	assign phy1_avmm_read		= (phyq_sel == 3'd1) ? phy_avmm_read : 0;
	assign phy1_avmm_write		= (phyq_sel == 3'd1) ? phy_avmm_write : 0;
	assign phy1_avmm_address	= (phyq_sel == 3'd1) ? phy_avmm_address[20:0] : 0;
	assign phy1_avmm_writedata	= (phyq_sel == 3'd1) ? phy_avmm_writedata : 0;

	//PHY2
	assign phy2_avmm_read		= (phyq_sel == 3'd2) ? phy_avmm_read : 0;
	assign phy2_avmm_write		= (phyq_sel == 3'd2) ? phy_avmm_write : 0;
	assign phy2_avmm_address	= (phyq_sel == 3'd2) ? phy_avmm_address[20:0] : 0;
	assign phy2_avmm_writedata	= (phyq_sel == 3'd2) ? phy_avmm_writedata : 0;

	//PHY3
	assign phy3_avmm_read		= (phyq_sel == 3'd3) ? phy_avmm_read : 0;
	assign phy3_avmm_write		= (phyq_sel == 3'd3) ? phy_avmm_write : 0;
	assign phy3_avmm_address	= (phyq_sel == 3'd3) ? phy_avmm_address[20:0] : 0;
	assign phy3_avmm_writedata	= (phyq_sel == 3'd3) ? phy_avmm_writedata : 0;

	//PHY4
	assign phy4_avmm_read		= (phyq_sel == 3'd4) ? phy_avmm_read : 0;
	assign phy4_avmm_write		= (phyq_sel == 3'd4) ? phy_avmm_write : 0;
	assign phy4_avmm_address	= (phyq_sel == 3'd4) ? phy_avmm_address[20:0] : 0;
	assign phy4_avmm_writedata	= (phyq_sel == 3'd4) ? phy_avmm_writedata : 0;

	//PHY5
	assign phy5_avmm_read		= (phyq_sel == 3'd5) ? phy_avmm_read : 0;
	assign phy5_avmm_write		= (phyq_sel == 3'd5) ? phy_avmm_write : 0;
	assign phy5_avmm_address	= (phyq_sel == 3'd5) ? phy_avmm_address[20:0] : 0;
	assign phy5_avmm_writedata	= (phyq_sel == 3'd5) ? phy_avmm_writedata : 0;

	//PHY6
	assign phy6_avmm_read		= (phyq_sel == 3'd6) ? phy_avmm_read : 0;
	assign phy6_avmm_write		= (phyq_sel == 3'd6) ? phy_avmm_write : 0;
	assign phy6_avmm_address	= (phyq_sel == 3'd6) ? phy_avmm_address[20:0] : 0;
	assign phy6_avmm_writedata	= (phyq_sel == 3'd6) ? phy_avmm_writedata : 0;

	//PHY7
	assign phy7_avmm_read		= (phyq_sel == 3'd7) ? phy_avmm_read : 0;
	assign phy7_avmm_write		= (phyq_sel == 3'd7) ? phy_avmm_write : 0;
	assign phy7_avmm_address	= (phyq_sel == 3'd7) ? phy_avmm_address[20:0] : 0;
	assign phy7_avmm_writedata	= (phyq_sel == 3'd7) ? phy_avmm_writedata : 0;


	assign phy_avmm_readdatavalid = (phyq_sel == 3'd0) ? phy0_avmm_readdatavalid : (phyq_sel == 3'd1) ? phy1_avmm_readdatavalid : (phyq_sel == 3'd2) ? phy2_avmm_readdatavalid : (phyq_sel == 3'd3) ? phy3_avmm_readdatavalid : (phyq_sel == 3'd4) ? phy4_avmm_readdatavalid : (phyq_sel == 3'd5) ? phy5_avmm_readdatavalid : (phyq_sel == 3'd6) ? phy6_avmm_readdatavalid : (phyq_sel == 3'd7) ? phy7_avmm_readdatavalid : phy0_avmm_readdatavalid ;
	assign phy_avmm_readdata      = (phyq_sel == 3'd0) ? phy0_avmm_readdata : (phyq_sel == 3'd1) ? phy1_avmm_readdata : (phyq_sel == 3'd2) ? phy2_avmm_readdata : (phyq_sel == 3'd3) ? phy3_avmm_readdata : (phyq_sel == 3'd4) ? phy4_avmm_readdata : (phyq_sel == 3'd5) ? phy5_avmm_readdata : (phyq_sel == 3'd6) ? phy6_avmm_readdata : (phyq_sel == 3'd7) ? phy7_avmm_readdata : phy0_avmm_readdata ;
	assign phy_avmm_waitrequest   = (phyq_sel == 3'd0) ? phy0_avmm_waitrequest : (phyq_sel == 3'd1) ? phy1_avmm_waitrequest : (phyq_sel == 3'd2) ? phy2_avmm_waitrequest : (phyq_sel == 3'd3) ? phy3_avmm_waitrequest : (phyq_sel == 3'd4) ? phy4_avmm_waitrequest : (phyq_sel == 3'd5) ? phy5_avmm_waitrequest : (phyq_sel == 3'd6) ? phy6_avmm_waitrequest : (phyq_sel == 3'd7) ? phy7_avmm_waitrequest : phy0_avmm_waitrequest ;
	
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "u5pIbSCe10hFh7Mc65JsFx28RQM4wL6+qaJ+2v2tDwWpsOktSmARVBMHDtyrY89I/fitFtCwnW18n1mBYpwWfIaYMo1E5KiAC5Ri5q2ch3lbG9WcHCZ6+pp0mmQZj8KzblHU7UBtvqoFOaPSSVJZPei4xOGUHojt2/4uhpQrg4OHxc0/1vn5gRYHHtNxXKf9CfUth0zifEvR8bRv7qJKR3iJbMgQ8r7s2EbcbISIDkAzu+qT0dDIiHXhiKhsk5thNXKSQFJ/CBzliXv/W9w8YOIICpGaCSmxVZBtTlQdsYXP/wpwaOXq26TQmy1VOSu5DMM2BqKLiNJNa42x5u+yc9EOZ4qI1kObqIDhl9AqxFKTfyQqkDrMugkF8KkSIo1hapZzXJUupXT6UUecoIYGFitooNfO/NBKiSERy8v4/yH6PSAVAjOq7qnYPTqV94RYjV/X9polegCuVYPs3VZcqBtoPGljcBiSAePQh/hlq1Bitk0ZxII0RPmnGQgmGLBtJz3y4qInbZkB43a4y5KOrktt7fVmjrwx3+1UApbfRmvIlLjKNUuMoq9g36Q2SOXQ16PR7UkpgnMMrL0mKwoD8AYztCUWrmVfiTD8MLsNB7ZSyctapBn+elBhSP/05TkCQF5b+D+vEWdo10c7P4blFyPWfWI7w+fUQktKQYPbdRd/LSoQE3jQIWT9La5vRWLZw1aj6Un4BfeG3F2XbBeHB/8VApA6IzPDo+5g9eHqFOYX0CA43VwZtcaGiBPARKSIVzvAuKi6xoyCF5jxpXgKjiR7m7n1cwQsb2yM7ZYoRRHAiw+M1QJDhEhTD6iPgheYr0GOrrSthmSdIKJs5FiUItWSDIO1ULdp7mvLWiqHPmMHLQHETvgqjxXiTmzbiOv73ydEfAZqnYfZa45OP93B/aTb04+rfisM9yJAF4vgwuqZbPxfWKkBxNXxj2ZjRHv1icc+CuN9YgH2zUGtoeKBZUQ7okT4c2IidxDMrBMvGYRKOhW5Y0bRX3T+kpmmMvHg"
`endif