// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// (C) 2001-2020 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.


// (C) 2001-2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.


// $Id: //acds/main/ip/sopc/components/primitives/altera_std_synchronizer/altera_std_synchronizer.v#8 $
// $Revision: #8 $
// $Date: 2009/02/18 $
// $Author: pscheidt $
//-----------------------------------------------------------------------------
//
// File: altera_std_synchronizer_nocut.v
//
// Abstract: Single bit clock domain crossing synchronizer. Exactly the same
//           as altera_std_synchronizer.v, except that the embedded false
//           path constraint is removed in this module. If you use this
//           module, you will have to apply the appropriate timing
//           constraints.
//
//           We expect to make this a standard Quartus atom eventually.
//
//           Composed of two or more flip flops connected in series.
//           Random metastable condition is simulated when the
//           __ALTERA_STD__METASTABLE_SIM macro is defined.
//           Use +define+__ALTERA_STD__METASTABLE_SIM argument
//           on the Verilog simulator compiler command line to
//           enable this mode. In addition, define the macro
//           __ALTERA_STD__METASTABLE_SIM_VERBOSE to get console output
//           with every metastable event generated in the synchronizer.
//
// Copyright (C) Altera Corporation 2009, All Rights Reserved
//-----------------------------------------------------------------------------

`timescale 1ns / 1ns

module hssi_ss_std_synchronizer_nocut (
                                clk,
                                reset_n,
                                din,
                                dout
                                );

   parameter depth = 3; // This value must be >= 2 !
   parameter rst_value = 0;

   input   clk;
   input   reset_n;
   input   din;
   output  dout;

   // QuartusII synthesis directives:
   //     1. Preserve all registers ie. do not touch them.
   //     2. Do not merge other flip-flops with synchronizer flip-flops.
   // QuartusII TimeQuest directives:
   //     1. Identify all flip-flops in this module as members of the synchronizer
   //        to enable automatic metastability MTBF analysis.

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name SYNCHRONIZER_IDENTIFICATION FORCED; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON  "} *) reg din_s1;

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON"} *) reg [depth-2:0] dreg;

   //synthesis translate_off
   initial begin
      if (depth <2) begin
         $display("%m: Error: synchronizer length: %0d less than 2.", depth);
      end
   end

   // the first synchronizer register is either a simple D flop for synthesis
   // and non-metastable simulation or a D flop with a method to inject random
   // metastable events resulting in random delay of [0,1] cycles

`ifdef __ALTERA_STD__METASTABLE_SIM

   reg[31:0]  RANDOM_SEED = 123456;
   wire  next_din_s1;
   wire  dout;
   reg   din_last;
   reg          random;
   event metastable_event; // hook for debug monitoring

   initial begin
      $display("%m: Info: Metastable event injection simulation mode enabled");
      random = $random;
   end

   always @(posedge clk) begin
      if (reset_n == 0)
        random <= $random(RANDOM_SEED);
      else
        random <= $random;
   end

   assign next_din_s1 = (din_last ^ din) ? random : din;

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0)
         din_last <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_last <= din;
   end

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0)
         din_s1 <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_s1 <= next_din_s1;
   end

`else

   //synthesis translate_on
   generate if (rst_value == 0)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0)
             din_s1 <= 1'b0;
           else
             din_s1 <= din;
       end
   endgenerate

   generate if (rst_value == 1)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0)
             din_s1 <= 1'b1;
           else
             din_s1 <= din;
       end
   endgenerate
   //synthesis translate_off

`endif

`ifdef __ALTERA_STD__METASTABLE_SIM_VERBOSE
   always @(*) begin
      if (reset_n && (din_last != din) && (random != din)) begin
         $display("%m: Verbose Info: metastable event @ time %t", $time);
         ->metastable_event;
      end
   end
`endif

   //synthesis translate_on

   // the remaining synchronizer registers form a simple shift register
   // of length depth-1
   generate if (rst_value == 0)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0)
              dreg <= {depth-1{1'b0}};
            else
              dreg <= din_s1;
         end
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0)
              dreg <= {depth-1{1'b0}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate

   generate if (rst_value == 1)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0)
              dreg <= {depth-1{1'b1}};
            else
              dreg <= din_s1;
         end
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0)
              dreg <= {depth-1{1'b1}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate

   assign dout = dreg[depth-2];

endmodule



`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "u5pIbSCe10hFh7Mc65JsFx28RQM4wL6+qaJ+2v2tDwWpsOktSmARVBMHDtyrY89I/fitFtCwnW18n1mBYpwWfIaYMo1E5KiAC5Ri5q2ch3lbG9WcHCZ6+pp0mmQZj8KzblHU7UBtvqoFOaPSSVJZPei4xOGUHojt2/4uhpQrg4OHxc0/1vn5gRYHHtNxXKf9CfUth0zifEvR8bRv7qJKR3iJbMgQ8r7s2EbcbISIDkDDX34jTqBG/Ab3owMmbFTXR60GWjICuYd9GDSClyyDU4xX1sYSohtMOqhbMH/mPXN2axuYmAJpLlGRfWuqPxQauuvOO9md76p2CvA2ywtP3yaw2urKS5u9QkK8qcXueIpa4C0S+dVfsiruj6h/FMnZwFI+gO4rcEjyg+Bd4iduILDBxnrv/JJqtC1C85sVszWa+63kjr3uUi2IillempwI7ozp+4xc4w1g3jwe6uQz/9Fm57SgK5SR0uI8+wt8OfBfiuRVSxG2q4DnFWtwf5sFmc24YyLGcuLxzKmUwqEj5jyQiwTJjm0ltGwywXNYZPWCokEZT03yIT1QmKk5w9x1ZeBYtrTiwX5WI/Tz0YiBQpGUlAt4CDsmlriJuyjiGqiFHaM8O7H8YBZiYE7lX621W4Sa8yvG1X4+kz0GiVcOoElZHkJ/3nrXubnZS4HkDVLKd1k6USOCpN55jpjHY16oBQN1FB+Vvshr2IfYrEp/BJYPlVzydNQu9AnJiMMIXvAG5DvaQdCZmJv93NYWYcskP63IZZAOT/d2SzmZUoqB+nTdU11cZTQCNpBHmjMo6KRRIx1NWXgymp7UxTb5WybzdmNjEOz0JMtg8cOoYa1M3E0l71snsDrCte7yVpd78CWs22zD12+FA3B4bi1pDT/gVrCyzC6KR3BVg0MzrJHQNGiKbDpzEaq6Zg1ggl2GqQqfrTB92kdaK16NfzrfIj49EGSlDfa6IH9AUrx9W+SvNcdOAnVIdkj6F/+ppZTid6MvHuc5vFDk8q8CgGDJ646L"
`endif