// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module rd_comp_sel_cwyib4q #(
    parameter WIDTH=10,
    parameter PIPELINE_OUT=0,
    parameter PIPELINE_CMP=0
) (
    input           clk,
input [WIDTH:0] in_0, 

    input [WIDTH-1:0] base,
    input [1-1:0] shift_occurred, 
    input [1-1:0] clr,    
    output logic sel,
    output logic [1-1:0] sel_index
);
logic [1-1:0] equal,equal_reg;
logic sel_int;
logic [1-1:0] sel_index_int;
logic [1-1:0] shift_occurred_reg;


compare_eq #( .WIDTH (WIDTH) ) com0 ( .in_a(in_0[WIDTH-1:0]), .in_b(base), .equal(equal[0]) );



generate 
    if (PIPELINE_CMP) begin : PIPELINE_CMP_OUT
        always @ (posedge clk) begin
            equal_reg <= equal;
            shift_occurred_reg <= shift_occurred;
        end
    end
    else begin : NO_PIPELINE_CMP_OUT
        assign equal_reg = equal;
        assign shift_occurred_reg = shift_occurred;
    end
endgenerate

rd_pri_mux_cwyib4q pri_mux (
.in0             (equal_reg[0] && in_0[WIDTH]),

    .shift_index_out (shift_occurred_reg),
    .sel             (sel_int),
    .sel_index       (sel_index_int),
    .clr             (clr)

);

generate
    if (PIPELINE_OUT) begin
        always @ (posedge clk) begin
            sel       <= sel_int;
            sel_index <= sel_index_int;
        end
    end
    else begin
        assign sel = sel_int;
        assign sel_index = sel_index_int;
    end
endgenerate 
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkb0tXzyRGim5bLbzKDhis+WO0nwAPflz06jqGJN+RAdzEn9nQa14I0xtNpzKv1qNi5iLs/8CZasTrkCXJt+o4dkKs5nlC+fvbjBDaO93aSwer9I9mZgew07BYkejBngchn4GwJeDDeRV4CNzS+tuTn+HnT46xB1wumcyFkDoiweLU9+GD3lJ9lDDoPtyIEpw7ndqSeUORdjsf/Qiv7taMZgbXFZullJYiTzQokG/rhtANJ4p76X4DTbl3zKAWNXfA9JfaHbuSTsJuxdPpbxLx5WVw28TXD3befokJn6Qhs+02vvw9tpTp8AYUKIn2i2VtNOTgmhje2vu85Ypf6xyv6iDjRb1/zACQnNo3H7E91ajJ941hejxR2JdH1WfezWxKyIE8hoF4yu+Er6vF3vr44u4UnAf1iDshUnX0iCJaIvNcBjSp9rRAa7Syfv2aqw9c2Kj94fTRk0EiWaaOuoUnWszP+LDJ82WtOAuv8PsJoBoCKlzIxXsvAbGophyATaHKV5mL7eCpxRFX08MQpchnVg+RMd52V6U0QZSX500Xp9B/Vj2Y/64pBKlQM4yNezFyNjNAsMm1t62B8USv+wOCnUe5lw9bXZ8o1g/pd4amUFf8ylUOuGaTi1hYFhLdNyZJTCXUvLvMbyM0ZxUx4YSU0L3mRG9iNAnx5r3R2mZs0nHargA2qXizstX/CebGHE+l7vKT2UTv4xKXdhWskqRSWTF6iTyUVGOW3V/+V15hKZ2qH6VjCA6FG19NclE9bTEwlStpe97GsIniR4KcsPhA+x"
`endif