// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.






`timescale 1 ns / 1 ns



// altera message_off 16753
module ed_synth_dut_altera_merlin_demultiplexer_1921_rcor4va
(
    input  [1-1      : 0]   sink_valid,
    input  [124-1    : 0]   sink_data, 
    input  [2-1 : 0]   sink_channel, 
    input                         sink_startofpacket,
    input                         sink_endofpacket,
    output                        sink_ready,

    output reg                      src0_valid,
    output reg [124-1    : 0] src0_data, 
    output reg [2-1 : 0] src0_channel, 
    output reg                      src0_startofpacket,
    output reg                      src0_endofpacket,
    input                           src0_ready,


    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input clk,
    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input reset

);

    localparam NUM_OUTPUTS = 1;
    wire [NUM_OUTPUTS - 1 : 0] ready_vector;

    always @* begin
        src0_data          = sink_data;
        src0_startofpacket = sink_startofpacket;
        src0_endofpacket   = sink_endofpacket;
        src0_channel       = sink_channel >> NUM_OUTPUTS;

        src0_valid         = sink_channel[0] && sink_valid;

    end

    assign ready_vector[0] = src0_ready;

    assign sink_ready = |(sink_channel & {{1{1'b0}},{ready_vector[NUM_OUTPUTS - 1 : 0]}});

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "TCSI+l9TsvpNm5zWo4wf8S4CBVeml6hxYnRcvYFHGVdKrV70QtjK/Q97rnYnju29dHEElln5C63xhDaAHrDBjpTVdTMpcZmuTN8lZKh5UsIF1+KNWjGCPGEcQfOpPms/DsTE+mwaq652nt9MxysR2++l9VLHamXPFWmxpBLBMiG3v0i3UjbzPV6heoBbtnxsCXSHasHlrPtUh5zo5ECSylkvBjcVwStL/mWtlrEp1x8T1blf+JyazForWpyPqBRoQWXcTk+QDg6sPqogz9XHJ/6C9uN+hc4pPpl4Mvif8E/mt7qeiACD0p8T9w9GLllu74BfoVBtBzc5b/3S1Q9bsITynghDlaOsJMW4KRT9NvpXRwWYqgUvjq8t10xMffGFNK1C0AkaZ+lIetG/0TZ/bPSr8xTj4+eu2uE/peQfMCq/YujwNZgU99Cn+XwuQqIF5JFbA6Fmi2lfF2ujecEllr/VSgRczVQBsotOQY6wOMR+G8OBPlhJtU/yhQoWs5SvMihE+cPa6Rtly6hBVxfDADcAeD4egpzOVlJx+7UiZbYxuUssXFfaU3jYQMY3kT+Y7ABwLhSzOD8c2IsOUX1FJSXNdCLDXSCK3YhHKA6t2vf/BVR0y09DDfAs8dTvc8Q+2qi0djXQ+KSva49LtoccBqMf4bt8LpN3d/1eHsfmYTmyvNCW35ZymGwrndw/DRwJ8r0LQZnN0xsPJw/u+x8wlD71MBocFFj7ngUV/qzH5PbXAI88H8kNGBXPVWCx1FyWV7zxd5sj37n0QoR63MZdguLhAVI2Vk2XnZvF2qlNbiibaIc+Fcpk1nzZwV2o0029nS1MWRVIkQ+76glJddvMBihxK5h0Q8+2lVTJG5cmP/Ikc0GQ4QXFnfvcA2nNDLNhrI+Wyt5AbGxmw2/97Ae9mkd1eNb3ClkbAHTm1Tc8pY+KGcnb+jw0BKLmtjDH/j2vfaUALLo4OvK36J7qt+R5p9oeVMZlJpqbbVX1gXtP7bt7ZajY2qLZMcDxtsy9N+LH"
`endif