// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module wr_sipo_plus_kt2puei #(
    parameter DEPTH = 1, 
    parameter TOTAL_W = 35,
    parameter ID_W    =10
) (
    input clk,
    input rst,
    input in_valid,
    input [TOTAL_W-2:0] in_data, 
    output in_ready,
    input [DEPTH-1:0] clr, 
    output [DEPTH-1:0] shift_occurred, 
    output [TOTAL_W-1:0] dout0

);

logic [TOTAL_W-1:0] mem[DEPTH-1:0];




logic shift_in;



assign shift_in  = in_ready & in_valid;




always @ (posedge clk) begin
    if (shift_in)
        mem[1-1][TOTAL_W-2:0] <= in_data[TOTAL_W-2:0];

end

always @ (posedge clk) begin

    if (rst)
        mem[0][TOTAL_W-1] <= 0;
    else if (shift_in)
        mem[0][TOTAL_W-1] <= 1 & (! clr[0]);
    else if (clr[0])
        mem[0][TOTAL_W-1] <= 0;

end

assign in_ready = !(  mem[0][TOTAL_W-1]  );

assign dout0 = mem[0];

endmodule
    


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkZvn0IopuDcPBjpCpf4OFIaWnjyftl5c9bNkxkzrN9yyTNIgkA53LYbkcKgO/YKIKH7cOD6ARyKP0hvPdSL+h98Xzcnct1jxBUSzL37fSFYJhpkULHThLwrSRQel3Vxn7oqxZrC+mqUyF8fyDQSSnJ+aDGBbJ8IkkLzOQYHB4CNS9a5VyPImS9oBu/AmC/MYetadPzywYkrW5p+vEluhhisYGu+FSazHaSiWWmjhAnhAJPw/SYISDJci0SsWtPojIeW+YuOFiU5yHnoI+6xO2+80xprwA7fAC8YgGIWGPhKQcFyC2nGQOlrJDCjemht/SyamPbIVfZ+g3ZAivxx2QmvCLLLCRsKbYn9tuR46LCL0voOFIUBVLdhCUVGzZ/1M0lHmFkkp6q3sOV+hyI7lrVQWNSgNKC6OoTAVYOkw/tOHp8hu6sbezrjqiUmWXd1xo/hTmPpWL2liOqVqxD5NzhFE4IYmmc3j0lsrEUnfY7LMPCcP9NzUng7d+2JG6UgIjVEZX/QgJ2PE2gov3zH+/Wzv2iNJVp9MuyzYdWDM/IoGzw5g3C3hAvLcfvsjr/PuR8XGAo9clzQjUUHFegHqw3iQW7rvJKHaFW5+7VhrARP0I4c1+8NY+8y0JNuH1oxAGGcjHTV0ik2gTOlhWuSMRuXaF6H7ETaxxuFjD026ReHAUhMP8f6XZQ38P4jmBhGiJlM54gr5AHsxuWb5Oo0DtEe9z5deF9TSH7gffrMYL/Y/8G/m7BTmnUjNj9XW7UXjnr4LHR67JY4Mzsn/MnzCeXW"
`endif