// emif_lpddr4a_emif_io96b_cal_alt_mem_if_jtag_master_230_unux2ky.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module emif_lpddr4a_emif_io96b_cal_alt_mem_if_jtag_master_230_unux2ky #(
		parameter USE_PLI     = 0,
		parameter PLI_PORT    = 50000,
		parameter FIFO_DEPTHS = 2
	) (
		input  wire        clk_clk,              //          clk.clk,           Clock Input
		input  wire        clk_reset_reset,      //    clk_reset.reset,         Reset Input
		output wire        master_reset_reset,   // master_reset.reset,         Reset Output
		output wire [31:0] master_address,       //       master.address,       Address output of Avalon Memory Mapped Host
		input  wire [31:0] master_readdata,      //             .readdata,      Read Data input to Avalon Memory Mapped Host
		output wire        master_read,          //             .read,          Read command from Avalon Memory Mapped Host
		output wire        master_write,         //             .write,         Write command from Avalon Memory Mapped Host
		output wire [31:0] master_writedata,     //             .writedata,     Write Data from Avalon Memory Mapped Host
		input  wire        master_waitrequest,   //             .waitrequest,   Wait request from Avalon Memory Mapped Agent, indicates agent is not ready
		input  wire        master_readdatavalid, //             .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		output wire [3:0]  master_byteenable     //             .byteenable,    Indicates valid write data/read data location
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (USE_PLI != 0)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					use_pli_check ( .error(1'b1) );
		end
		if (PLI_PORT != 50000)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					pli_port_check ( .error(1'b1) );
		end
		if (FIFO_DEPTHS != 2)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					fifo_depths_check ( .error(1'b1) );
		end
	endgenerate

	emif_lpddr4a_alt_mem_if_jtag_master_191_2xbfrbi #(
		.USE_PLI     (0),
		.PLI_PORT    (50000),
		.FIFO_DEPTHS (2)
	) jamb (
		.clk_clk              (clk_clk),              //   input,   width = 1,          clk.clk
		.clk_reset_reset      (clk_reset_reset),      //   input,   width = 1,    clk_reset.reset
		.master_reset_reset   (master_reset_reset),   //  output,   width = 1, master_reset.reset
		.master_address       (master_address),       //  output,  width = 32,       master.address
		.master_readdata      (master_readdata),      //   input,  width = 32,             .readdata
		.master_read          (master_read),          //  output,   width = 1,             .read
		.master_write         (master_write),         //  output,   width = 1,             .write
		.master_writedata     (master_writedata),     //  output,  width = 32,             .writedata
		.master_waitrequest   (master_waitrequest),   //   input,   width = 1,             .waitrequest
		.master_readdatavalid (master_readdatavalid), //   input,   width = 1,             .readdatavalid
		.master_byteenable    (master_byteenable)     //  output,   width = 4,             .byteenable
	);

endmodule
