// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module rd_comp_sel_kt2puei #(
    parameter WIDTH=10,
    parameter PIPELINE_OUT=0,
    parameter PIPELINE_CMP=0
) (
    input           clk,
input [WIDTH:0] in_0, 

    input [WIDTH-1:0] base,
    input [1-1:0] shift_occurred, 
    input [1-1:0] clr,    
    output logic sel,
    output logic [1-1:0] sel_index
);
logic [1-1:0] equal,equal_reg;
logic sel_int;
logic [1-1:0] sel_index_int;
logic [1-1:0] shift_occurred_reg;


compare_eq #( .WIDTH (WIDTH) ) com0 ( .in_a(in_0[WIDTH-1:0]), .in_b(base), .equal(equal[0]) );



generate 
    if (PIPELINE_CMP) begin : PIPELINE_CMP_OUT
        always @ (posedge clk) begin
            equal_reg <= equal;
            shift_occurred_reg <= shift_occurred;
        end
    end
    else begin : NO_PIPELINE_CMP_OUT
        assign equal_reg = equal;
        assign shift_occurred_reg = shift_occurred;
    end
endgenerate

rd_pri_mux_kt2puei pri_mux (
.in0             (equal_reg[0] && in_0[WIDTH]),

    .shift_index_out (shift_occurred_reg),
    .sel             (sel_int),
    .sel_index       (sel_index_int),
    .clr             (clr)

);

generate
    if (PIPELINE_OUT) begin
        always @ (posedge clk) begin
            sel       <= sel_int;
            sel_index <= sel_index_int;
        end
    end
    else begin
        assign sel = sel_int;
        assign sel_index = sel_index_int;
    end
endgenerate 
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFka+f5vfPZut9d0yAohaGcOVOCcqB8MysyUkE0uZd7zeqsJka7sFmOl66YK+zgK1ZrKginGT/AFB+arPtScVK+x7wEnF2FWlwTIuOWo4GFcefgw0tXWUbPIDDvb3+mGEZZg4M82TlvsyXArDTu7to5hc9jxt8CDmf0dWejibTThg5+UdDQ960lO3xVVGuLie+Hs5Bk8GNdnbdv0pmd2ySrjeD+djN6ncs4O6cOPZoLivws64JpYjTEaMSUohekz1z4cT7rK+0+wCq4ggthPvGIoK5lM176Okheb4m8QmXSnwa2g45XxX5m/r0EBjPyfvgyoogkK+/AVpq9Pl2tBLWWpT/3094cAMf7vtn5B6lorJ0ViD6BDllvhQMbSjy5bvawTSuKXLyhKNhg3bDWxW7KCy6+yQ6eUXDnzsVxTs/mJTc9RUyQk3rLp2T/RTLU9muLAleweYCr6DDx1NM81mWktU2pq8OnNvPmYL5clBl3vlbRfAfaqKkrjuIUs/2lUnCPBw3Mrg5hWMlAAbdvyRDA6wJCk4Vs4uex+d5Lr21EylvT1dSCHRfaKwnOQRP37/S+ReIo15CwOdw2wchshuTt3FxHHmZZCmoB42xMdVNAAT0muZvO8zAZOGZNzh8t+rxrQuWWrG27rH2qoxUW4AVGbC5GtOGoCv8UzyTFEEDyDPl1fP8w5FmohAsQjo3QMIIw0T12pnK3YZcWn5ZUexquJiBfTrYA4l/6IDmJRdMXGII1Ziy3O7S6rquYlnjEcU48pWPXwBv1Wdt8ugCBfjRN0b"
`endif