// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.






`timescale 1 ns / 1 ns



// altera message_off 16753
module ed_synth_dut_altera_merlin_demultiplexer_1921_ekcygpi
(
    input  [2-1      : 0]   sink_valid,
    input  [124-1    : 0]   sink_data, 
    input  [2-1 : 0]   sink_channel, 
    input                         sink_startofpacket,
    input                         sink_endofpacket,
    output                        sink_ready,

    output reg                      src0_valid,
    output reg [124-1    : 0] src0_data, 
    output reg [2-1 : 0] src0_channel, 
    output reg                      src0_startofpacket,
    output reg                      src0_endofpacket,
    input                           src0_ready,

    output reg                      src1_valid,
    output reg [124-1    : 0] src1_data, 
    output reg [2-1 : 0] src1_channel, 
    output reg                      src1_startofpacket,
    output reg                      src1_endofpacket,
    input                           src1_ready,


    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input clk,
    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input reset

);

    localparam NUM_OUTPUTS = 2;
    wire [NUM_OUTPUTS - 1 : 0] ready_vector;

    always @* begin
        src0_data          = sink_data;
        src0_startofpacket = sink_startofpacket;
        src0_endofpacket   = sink_endofpacket;
        src0_channel       = sink_channel >> NUM_OUTPUTS;

        src0_valid         = sink_channel[0] && sink_valid[0];

        src1_data          = sink_data;
        src1_startofpacket = sink_startofpacket;
        src1_endofpacket   = sink_endofpacket;
        src1_channel       = sink_channel >> NUM_OUTPUTS;

        src1_valid         = sink_channel[1] && sink_valid[1];

    end

    assign ready_vector[0] = src0_ready;
    assign ready_vector[1] = src1_ready;

    assign sink_ready = |(sink_channel & ready_vector);

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "TCSI+l9TsvpNm5zWo4wf8S4CBVeml6hxYnRcvYFHGVdKrV70QtjK/Q97rnYnju29dHEElln5C63xhDaAHrDBjpTVdTMpcZmuTN8lZKh5UsIF1+KNWjGCPGEcQfOpPms/DsTE+mwaq652nt9MxysR2++l9VLHamXPFWmxpBLBMiG3v0i3UjbzPV6heoBbtnxsCXSHasHlrPtUh5zo5ECSylkvBjcVwStL/mWtlrEp1x+kCEFti9GymPusz4vcVx0qusSya7MBSQFO8dwgXiTUKQ/zC4CJv0aFvLhHLSdB5ZU+rVO9mdnrQ61jKjLzsjznn6vsX3F8Rg5ItMXc43YDMoODWzyPJy44RCHSd+EJxOS5+6hNeB2RsK/Jsr7npms8+Wgvw1lm/1VetIIgn3ebdBY5Gl/UkTK+bKHXSeuCaRpzlUxMfu1Sm+msJgxgcHweyOSkk5ZsC6cci32ucTjSEXSef62WXjTT9P4rwO12L38TwlN/GpsyfvY0ICTlx5mxBiwTff7gr74ZjLJHaZ2eJRYfcC9ZM7QAgzeomCVvrO2MFvwE0+hMdzHnkPQQ6x0m3EW5ECcGIipN//B4XW8VfEWYZttds59TrNXyfEosUx2UovGlGf34B1A2JhLeiZwdszOAqo52H9peAF+kD3rw1YvMVyVHKazPq2wbl38YiPbbBMEdW3GlDuRzvji4fDG/G55YpSTslSH6c1VBYj4/scfBdgdWcAnvTJVCwbmfrh9gw/bbvZjeK4gQOayn+cSoDEobNtE17uWnrtNkM68kFp4yEvQ4VWUv+m4RKnvx3FDNlGPl+xZyz15mJRru/+5YNHgtq7L+JCSB8lMEb8BgSRnpiWkk624E/OVznJkiEi1maBYUaBHe0ahXBZBS0lZkcn3OSWlDqY8bX5Zvr5p5yWU5B5Lxyyyn0sjCBdTBlme8sQgu7Z7ADjsOKzbNw9kMmQSxwMO0BbUOLpbzxdSKHCRgeNMEcpowCSIupKpMN9DjevnP7x5red0H6ffL08LQ"
`endif