// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// a generic clock divider to be used in simulation
module clk_div #(
  parameter RATIO = 2
) (
  input wire clk_input,
  output wire clk_output
);
  localparam WIDTH = $clog2(RATIO);
  logic [WIDTH-1:0] r_reg;

  initial r_reg = 0;

  always @(posedge clk_input)
    r_reg <= r_reg + 1;

  assign clk_output = r_reg[WIDTH-1];
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkYlIA8UJCmawriV/9oVkKJUWYOFriGrfde94inpSGQXPlCCbIo+AYtlXdTHdjojymJHlh7MCazvtN31O3zVecdVX/zqtEFfxn+PUNQ15K6VwiNDRL0YUlsMMpzCVso/M5VR0flGLhMDgItcZ3B3muxEa9JnpXNvQn3V3VJSiYkJ79+HTJWbhY4G5jp4e5ceLUZL2PpGF6bh5YK78ngyuJdA2PFehtJAR5cvzDqeZTaomijbfn8lhA150Z1VJJg7qN5ePaxWipW0hH7xaCwZpzpGnhvSBMM1WB8Z2e5w5atGAGMr8MZ550wEz0IgsQH9JRvVA5KK+iJhqVIcNs84i3V/Au03fx6Nc4SEzMRkJ+XHckrxX6ITXpHgOylg9PcWUIp6LA6xMXy8O0gmYIoZ6YK4nfYDCGxUfUIzxHg1fsjqXZco242SbNWz2iNbwK0yWAVB5B9ZOFziaGRZ1AnH17L0fy/9IIEMPw0oSKa6N2T3D9RSkLvesQoWhbsBFDDiLLY9tcqB0gjewhI4Isj9Kkd7FkP4gw6fFOBw1JPMYXwLKhXxurYYmh/VJQYX6vNXu+Dy2/3kmjrLqe0c7wynE0wSNGu2AW7oqTGeLRHGv/GVn6d/IAY7BzsglBM4/XqTIDRm1Orf+V937JilHXfUcwSdl45pg0NQA10tM5n3dBYmKzvb8qJjqjTt0+pPKqdHf3qecP2C8KOU+WvCF0vjK5likG+fV3HD4CYli8XAwyGtOYi/HZhnX3Sw1+zzYoYSbUAZZZsVtdUHbrhxg9NyjEfV"
`endif