// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module wr_sipo_plus_cwyib4q #(
    parameter DEPTH = 1, 
    parameter TOTAL_W = 35,
    parameter ID_W    =10
) (
    input clk,
    input rst,
    input in_valid,
    input [TOTAL_W-2:0] in_data, 
    output in_ready,
    input [DEPTH-1:0] clr, 
    output [DEPTH-1:0] shift_occurred, 
    output [TOTAL_W-1:0] dout0

);

logic [TOTAL_W-1:0] mem[DEPTH-1:0];




logic shift_in;



assign shift_in  = in_ready & in_valid;




always @ (posedge clk) begin
    if (shift_in)
        mem[1-1][TOTAL_W-2:0] <= in_data[TOTAL_W-2:0];

end

always @ (posedge clk) begin

    if (rst)
        mem[0][TOTAL_W-1] <= 0;
    else if (shift_in)
        mem[0][TOTAL_W-1] <= 1 & (! clr[0]);
    else if (clr[0])
        mem[0][TOTAL_W-1] <= 0;

end

assign in_ready = !(  mem[0][TOTAL_W-1]  );

assign dout0 = mem[0];

endmodule
    


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkbqcQP0lml2UAnjiQMANQbH6kgTAbLKoo4K82WP5SrHgz6jUzfTiO1auljqkHNKIGLLGf6BnBEsbefZULAXAZMqdweFI/qCtYRmhE2BrI8NET7OcNbqOA0GN8R/a6DyBsaCksRPXCZjxyoFpYnRUsMNzou5yKBfi1JIUfJAPC9c+KGzb1+4G+O6UHVeKup3cDFdbRuk21kIsqgxdu2Ibukhn76NY+Vjp5oVuNFwTkG1DHiZaAxbcCCJhQIPQGvrLN2wfsstExIxliut9SDY06/KCWdfVXEJ7R6kNvYFlxCWLEuvvfmSIgdNIRJc5wn4TQqbDVR38f/rRUOMIvcQVE8sGMGfHcj4Uhx3uSXwmsRCvY9YhtoXFvSG7s8KKIlnU8o0Xds100JxGnH2PgcaANC6/nQKvB6Xjo6x3OA0eESZYxvMnsNsvkZcrjm8I+iuvrr4SZIRy7pdpcU2SWmJb/8gEl0c8lNC1UIC28VhvKiI9lb5iL5GUZ0QbrM/urvQkuAE9+szxpB1LRP3HqOIRoTKlyFXepcXK5wcNRTSUpjteMZQmLD+o62JaBLRROniTIJ2csBDfR/UQDyl/tSkZ6zq2nfzNWZgNlSo9rM4VJ+Naxvxs5p34UZLgB5PkMjO55WDqsG9Qb2GSENvdZyfpH6JKr5cb9WvN3CasWUBrb9rJuVmCZ36j6p3s3h2xVNFO2dTqH/w9X79XMT4sMmUq1D+VfepAiLSL7RoIpPrfy7ZAOrHD0GQN6+buvDMSsl/01w2wHosHsX8X+ylEqCLBl6Z"
`endif