// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue Jul  1 17:29:58 2025
// ============================================================================

`define ENABLE_LPDDR4A
`define ENABLE_LPDDR4B
`define ENABLE_LPDDR4C
//`define ENABLE_HPS
//`define ENABLE_SLVS
//`define ENABLE_ENET
//`define ENABLE_PCIE
//`define ENABLE_QSFP
//`define ENABLE_CAM1
//`define ENABLE_CAM2
//`define ENABLE_GTSL1A
//`define ENABLE_GTSL1B
//`define ENABLE_GTSL1C
//`define ENABLE_GTSR4A
//`define ENABLE_GTSR4C

module golden_top(


      ///////// CLOCK /////////
      input              CLK_100_p,
      input              CLK_50_B5B,
      input              CLK_50_B6A,
      input              CLK_50_B6C,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active
      input              BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active
      output             LED, //LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_LPDDR4C
      ///////// LPDDR4C /////////
      input              LPDDR4C_REFCLK_p,
      output             LPDDR4C_CS_n,
      output   [ 5: 0]   LPDDR4C_CA,
      output             LPDDR4C_CK,
      output             LPDDR4C_CKE,
      output             LPDDR4C_CK_n,
      inout    [ 3: 0]   LPDDR4C_DM,
      inout    [31: 0]   LPDDR4C_DQ,
      inout    [ 3: 0]   LPDDR4C_DQS,
      inout    [ 3: 0]   LPDDR4C_DQS_n,
      output             LPDDR4C_RESET_n,
      input              LPDDR4C_RZQ,
`endif /*ENABLE_LPDDR4C*/

      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      output             HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,

`ifdef ENABLE_SLVS
      ///////// SLVS /////////
      input    [ 7: 0]   SLVS_EC_RX_p,
      input    [ 7: 0]   SLVS_EC_RX_n,
      input              SLVS_EC_SDO,
      input              SLVS_EC_REFCLK_p, //J1_GTSL1A_REFCLK_p
      output             SLVS_EC_INCK_OE,
      output             SLVS_EC_OMODE,
      inout              SLVS_EC_SCK_SCL,
      inout              SLVS_EC_SDI_SDA,
      input              SLVS_EC_SENSOR_PGOOD,
      output             SLVS_EC_SENSOR_PON,
      output             SLVS_EC_XCE,
      output             SLVS_EC_XCLR,
      output             SLVS_EC_XHS,
      output             SLVS_EC_XMASTER,
      output   [ 2: 1]   SLVS_EC_XTRIG,
      output             SLVS_EC_XVS,
`endif /*ENABLE_SLVS*/

`ifdef ENABLE_ENET
      ///////// ENET /////////
      output             ENET_88E2110_TX_p,
      output             ENET_88E2110_TX_n,
      input              ENET_88E2110_RX_p,
      input              ENET_88E2110_RX_n,
      input              ENET_88E2110_REFCLK_156M25_p, //GTSL1C_REFCLK_156M25_p
      input              ENET_88E2110_INT_n,
      output             ENET_88E2110_MDC,
      inout              ENET_88E2110_MDIO,
      output             ENET_88E2110_RESET_n,
`endif /*ENABLE_ENET*/

      ///////// SI5332B /////////
      inout              SI5332B_I2C_SCL,
      inout              SI5332B_I2C_SDA,

      ///////// SI5340B /////////
      inout              SI5340B_I2C_SCL,
      inout              SI5340B_I2C_SDA,
      output             SI5340B_OE_n,
      output             SI5340B_RST_n,

      ///////// SI564 /////////
      inout              SI564_SCL,
      inout              SI564_SDA,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

      ///////// SMA /////////
      input              SMA_CLKIN_p,

      ///////// QTH /////////
      inout    [15: 0]   QTH_30_p,
      inout    [15: 0]   QTH_30_n,
      inout    [ 3: 0]   QTH_30_D,

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 3: 0]   PCIE_TX_p,
      output   [ 3: 0]   PCIE_TX_n,
      input    [ 3: 0]   PCIE_RX_p,
      input    [ 3: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p, //J2_GTSR4A_REFCLK_p
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP
      ///////// QSFP /////////
      output   [ 3: 0]   QSFP_TX_p,
      output   [ 3: 0]   QSFP_TX_n,
      input    [ 3: 0]   QSFP_RX_p,
      input    [ 3: 0]   QSFP_RX_n,
      input              CIPRI_REFCLK_p, //GTSR4B_REFCLK_184M32_p
      input              QSFP_REFCLK_p, //GTSR4B_REFCLK_156M25_p
      input              QSFP_INTERRUPT_n,
      output             QSFP_LP_MODE,
      input              QSFP_MOD_PRS_n,
      output             QSFP_MOD_SEL_n,
      output             QSFP_RST_n,
      inout              QSFP_SCL,
      inout              QSFP_SDA,
`endif /*ENABLE_QSFP*/

      ///////// CAM /////////
      input              CAM_RZQ1, //RZQ_B_2A_T

`ifdef ENABLE_CAM1
      ///////// CAM1 /////////
      input              CAM1_CLK_p,
      input              CAM1_CLK_n,
      input    [ 3: 0]   CAM1_D_p,
      input    [ 3: 0]   CAM1_D_n,
      inout              CAM1_I2C_SCL,
      inout              CAM1_I2C_SDA,
      inout              CAM1_GPIO,
`endif /*ENABLE_CAM1*/

`ifdef ENABLE_CAM2
      ///////// CAM2 /////////
      input              CAM2_CLK_p,
      input              CAM2_CLK_n,
      input    [ 3: 0]   CAM2_D_p,
      input    [ 3: 0]   CAM2_D_n,
      inout              CAM2_I2C_SCL,
      inout              CAM2_I2C_SDA,
      inout              CAM2_GPIO,
`endif /*ENABLE_CAM2*/

`ifdef ENABLE_GTSL1A
      ///////// GTSL1A /////////
      input              GTSL1A_REFCLK_100M_p,
`endif /*ENABLE_GTSL1A*/

`ifdef ENABLE_GTSL1B
      ///////// GTSL1B /////////
      input              GTSL1B_REFCLK_156M25_p,
`endif /*ENABLE_GTSL1B*/

`ifdef ENABLE_GTSL1C
      ///////// GTSL1C /////////
      input              GTSL1C_REFCLK_100M_p,
`endif /*ENABLE_GTSL1C*/

`ifdef ENABLE_GTSR4A
      ///////// GTSR4A /////////
      input              GTSR4A_REFCLK_148M5_p,
`endif /*ENABLE_GTSR4A*/

`ifdef ENABLE_GTSR4C
      ///////// GTSR4C /////////
      input              GTSR4C_REFCLK_100M_p,
`endif /*ENABLE_GTSR4C*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_13, //reserved for vendor test
      inout              HPS_IOB_14, //reserved for vendor test
      inout              HPS_IOB_19, //reserved for vendor test
      inout              HPS_IOB_20, //reserved for vendor test
      inout              HPS_IOB_21, //reserved for vendor test
      inout              HPS_IOB_22, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout              HPS_LED,
      inout              HPS_LED2,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

assign SI5340B_OE_n = 1'bZ;
assign SI5340B_RST_n = 1'bZ;




//=======================================================
//  Structural coding
//=======================================================

wire AXI_LITE_CLK;
parameter AXIL_DRIVER_ADDRESS_WIDTH = 27; 



wire emif_rst_n_lpddr4a, emif_rst_n_lpddr4b, emif_rst_n_lpddr4c;
//wire LPDDR4A_cal_done_rst_n, LPDDR4B_cal_done_rst_n, LPDDR4C_cal_done_rst_n;
wire LPDDR4_IOPLL_Lock;
wire reset_handle;
assign reset_handle = LPDDR4_IOPLL_Lock & !ninit_done;

wire lpddr4_test_pass/*synthesis keep*/;
wire lpddr4_test_fail/*synthesis keep*/;
wire lpddr4_test_complete/*synthesis keep*/;
wire lpddr4_local_cal_success/*synthesis keep*/;
wire lpddr4_local_cal_fail/*synthesis keep*/;

// test status ..
//LPDDR4 Verify (A)
wire lpddr4a_test_pass/*synthesis keep*/;
wire lpddr4a_test_fail/*synthesis keep*/;
wire lpddr4a_test_complete/*synthesis keep*/;
wire lpddr4a_local_cal_success/*synthesis keep*/;
wire lpddr4a_local_cal_fail/*synthesis keep*/;
wire lpddr4a_reset_done/*synthesis keep*/;

//LPDDR4 Verify (B)
wire lpddr4b_test_pass/*synthesis keep*/;
wire lpddr4b_test_fail/*synthesis keep*/;
wire lpddr4b_test_complete/*synthesis keep*/;
wire lpddr4b_local_cal_success/*synthesis keep*/;
wire lpddr4b_local_cal_fail/*synthesis keep*/;
wire lpddr4b_reset_done/*synthesis keep*/;

//LPDDR4 Verify (C)
wire lpddr4c_test_pass/*synthesis keep*/;
wire lpddr4c_test_fail/*synthesis keep*/;
wire lpddr4c_test_complete/*synthesis keep*/;
wire lpddr4c_local_cal_success/*synthesis keep*/;
wire lpddr4c_local_cal_fail/*synthesis keep*/;
wire lpddr4c_reset_done/*synthesis keep*/;




wire global_reset;
wire	ninit_done;

debouncer debouncer_Inst(
    .clk(CLK_50_B5B),         // clock signal
    .reset(ninit_done),       // reset signal
    .button_in(USER_BUTTON),   // raw button input
    .button_out(global_reset)   // debounced button output
);

wire ninit_done;
    reset_release reset_release_inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );
		

wire	aclk;
wire	aresetn;
wire	pipe_aresetn;
//assign pipe_aresetn = global_reset & emif_rst_n_lpddr4a & emif_rst_n_lpddr4b & emif_rst_n_lpddr4c;
assign pipe_aresetn = global_reset ;
 
localparam PIPEDEPTH = 10;
hyper_pipe #(.WIDTH(1), .NUM_PIPES(PIPEDEPTH)) read_data_pipe
			(.din(pipe_aresetn), .dout (aresetn), .clk (aclk));
			


    EMIF_LPDDR4 EMIF_LPDDR4_Inst (
        .clock_310m_out_clk_clk                   (aclk),                   //  output,    width = 1,               clock_310m_out_clk.clk
        .emif_lpddr4a_s0_axi4_ctrl_ready_reset_n  (emif_rst_n_lpddr4a),  //  output,    width = 1,  emif_lpddr4a_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4a_s0_axi4_awaddr              (LPDDR4A_awaddr),              //   input,   width = 32,             emif_lpddr4a_s0_axi4.awaddr
        .emif_lpddr4a_s0_axi4_awburst             (LPDDR4A_awburst),             //   input,    width = 2,                                 .awburst
        .emif_lpddr4a_s0_axi4_awid                (LPDDR4A_awid),                //   input,    width = 7,                                 .awid
        .emif_lpddr4a_s0_axi4_awlen               (LPDDR4A_awlen),               //   input,    width = 8,                                 .awlen
        .emif_lpddr4a_s0_axi4_awlock              (LPDDR4A_awlock),              //   input,    width = 1,                                 .awlock
        .emif_lpddr4a_s0_axi4_awqos               (0),               //   input,    width = 4,                                 .awqos
        .emif_lpddr4a_s0_axi4_awsize              (LPDDR4A_awsize),              //   input,    width = 3,                                 .awsize
        .emif_lpddr4a_s0_axi4_awvalid             (LPDDR4A_awvalid),             //   input,    width = 1,                                 .awvalid
        .emif_lpddr4a_s0_axi4_awuser              (0),              //   input,   width = 14,                                 .awuser
        .emif_lpddr4a_s0_axi4_awprot              (LPDDR4A_awprot),              //   input,    width = 3,                                 .awprot
        .emif_lpddr4a_s0_axi4_awready             (LPDDR4A_awready),             //  output,    width = 1,                                 .awready
        .emif_lpddr4a_s0_axi4_araddr              (LPDDR4A_araddr),              //   input,   width = 32,                                 .araddr
        .emif_lpddr4a_s0_axi4_arburst             (LPDDR4A_arburst),             //   input,    width = 2,                                 .arburst
        .emif_lpddr4a_s0_axi4_arid                (LPDDR4A_arid),                //   input,    width = 7,                                 .arid
        .emif_lpddr4a_s0_axi4_arlen               (LPDDR4A_arlen),               //   input,    width = 8,                                 .arlen
        .emif_lpddr4a_s0_axi4_arlock              (LPDDR4A_arlock),              //   input,    width = 1,                                 .arlock
        .emif_lpddr4a_s0_axi4_arqos               (0),               //   input,    width = 4,                                 .arqos
        .emif_lpddr4a_s0_axi4_arsize              (LPDDR4A_arsize),              //   input,    width = 3,                                 .arsize
        .emif_lpddr4a_s0_axi4_arvalid             (LPDDR4A_arvalid),             //   input,    width = 1,                                 .arvalid
        .emif_lpddr4a_s0_axi4_aruser              (0),              //   input,   width = 14,                                 .aruser
        .emif_lpddr4a_s0_axi4_arprot              (LPDDR4A_arprot),              //   input,    width = 3,                                 .arprot
        .emif_lpddr4a_s0_axi4_arready             (LPDDR4A_arready),             //  output,    width = 1,                                 .arready
        .emif_lpddr4a_s0_axi4_wdata               (LPDDR4A_wdata),               //   input,  width = 256,                                 .wdata
        .emif_lpddr4a_s0_axi4_wstrb               (LPDDR4A_wstrb),               //   input,   width = 32,                                 .wstrb
        .emif_lpddr4a_s0_axi4_wlast               (LPDDR4A_wlast),               //   input,    width = 1,                                 .wlast
        .emif_lpddr4a_s0_axi4_wvalid              (LPDDR4A_wvalid),              //   input,    width = 1,                                 .wvalid        
        .emif_lpddr4a_s0_axi4_wready              (LPDDR4A_wready),              //  output,    width = 1,                                 .wready
        .emif_lpddr4a_s0_axi4_bready              (LPDDR4A_bready),              //   input,    width = 1,                                 .bready
        .emif_lpddr4a_s0_axi4_bid                 (LPDDR4A_bid),                 //  output,    width = 7,                                 .bid
        .emif_lpddr4a_s0_axi4_bresp               (LPDDR4A_bresp),               //  output,    width = 2,                                 .bresp
        .emif_lpddr4a_s0_axi4_bvalid              (LPDDR4A_bvalid),              //  output,    width = 1,                                 .bvalid
        .emif_lpddr4a_s0_axi4_rready              (LPDDR4A_rready),              //   input,    width = 1,                                 .rready
        .emif_lpddr4a_s0_axi4_rdata               (LPDDR4A_rdata),               //  output,  width = 256,                                 .rdata
        .emif_lpddr4a_s0_axi4_rid                 (LPDDR4A_rid),                 //  output,    width = 7,                                 .rid
        .emif_lpddr4a_s0_axi4_rlast               (LPDDR4A_rlast),               //  output,    width = 1,                                 .rlast
        .emif_lpddr4a_s0_axi4_rresp               (LPDDR4A_rresp),               //  output,    width = 2,                                 .rresp
        .emif_lpddr4a_s0_axi4_rvalid              (LPDDR4A_rvalid),              //  output,    width = 1,                                 .rvalid
        .emif_lpddr4a_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,    width = 1,   emif_lpddr4a_s0_axi4lite_clock.clk
        .emif_lpddr4a_s0_axi4lite_reset_n_reset_n (reset_handle), //   input,    width = 1, emif_lpddr4a_s0_axi4lite_reset_n.reset_n
        .emif_lpddr4a_s0_axi4lite_awaddr          (LPDDR4A_axil_driver_awaddr),          //   input,   width = 27,         emif_lpddr4a_s0_axi4lite.awaddr
        .emif_lpddr4a_s0_axi4lite_awprot          (LPDDR4A_axil_driver_awprot),          //   input,    width = 3,                                 .awprot
        .emif_lpddr4a_s0_axi4lite_awvalid         (LPDDR4A_axil_driver_awvalid),         //   input,    width = 1,                                 .awvalid
        .emif_lpddr4a_s0_axi4lite_awready         (LPDDR4A_axil_driver_awready),         //  output,    width = 1,                                 .awready
        .emif_lpddr4a_s0_axi4lite_araddr          (LPDDR4A_axil_driver_araddr),          //   input,   width = 27,                                 .araddr
        .emif_lpddr4a_s0_axi4lite_arprot          (LPDDR4A_axil_driver_arprot),          //   input,    width = 3,                                 .arprot
        .emif_lpddr4a_s0_axi4lite_arvalid         (LPDDR4A_axil_driver_arvalid),         //   input,    width = 1,                                 .arvalid
        .emif_lpddr4a_s0_axi4lite_arready         (LPDDR4A_axil_driver_arready),         //  output,    width = 1,                                 .arready
        .emif_lpddr4a_s0_axi4lite_wdata           (LPDDR4A_axil_driver_wdata),           //   input,   width = 32,                                 .wdata
        .emif_lpddr4a_s0_axi4lite_wstrb           (LPDDR4A_axil_driver_wstrb),           //   input,    width = 4,                                 .wstrb
        .emif_lpddr4a_s0_axi4lite_wvalid          (LPDDR4A_axil_driver_wvalid),          //   input,    width = 1,                                 .wvalid
        .emif_lpddr4a_s0_axi4lite_wready          (LPDDR4A_axil_driver_wready),          //  output,    width = 1,                                 .wready
        .emif_lpddr4a_s0_axi4lite_bready          (LPDDR4A_axil_driver_bready),          //   input,    width = 1,                                 .bready
        .emif_lpddr4a_s0_axi4lite_bresp           (LPDDR4A_axil_driver_bresp),           //  output,    width = 2,                                 .bresp
        .emif_lpddr4a_s0_axi4lite_bvalid          (LPDDR4A_axil_driver_bvalid),          //  output,    width = 1,                                 .bvalid
        .emif_lpddr4a_s0_axi4lite_rready          (LPDDR4A_axil_driver_rready),          //   input,    width = 1,                                 .rready
        .emif_lpddr4a_s0_axi4lite_rdata           (LPDDR4A_axil_driver_rdata),           //  output,   width = 32,                                 .rdata
        .emif_lpddr4a_s0_axi4lite_rresp           (LPDDR4A_axil_driver_rresp),           //  output,    width = 2,                                 .rresp
        .emif_lpddr4a_s0_axi4lite_rvalid          (LPDDR4A_axil_driver_rvalid),          //  output,    width = 1,                                 .rvalid
        .emif_lpddr4a_mem_mem_cs                  (LPDDR4A_CS_n),                  //  output,    width = 1,                 emif_lpddr4a_mem.mem_cs
        .emif_lpddr4a_mem_mem_ca                  (LPDDR4A_CA),                  //  output,    width = 6,                                 .mem_ca
        .emif_lpddr4a_mem_mem_cke                 (LPDDR4A_CKE),                 //  output,    width = 1,                                 .mem_cke
        .emif_lpddr4a_mem_mem_dq                  (LPDDR4A_DQ),                  //   inout,   width = 32,                                 .mem_dq
        .emif_lpddr4a_mem_mem_dqs_t               (LPDDR4A_DQS),               //   inout,    width = 4,                                 .mem_dqs_t
        .emif_lpddr4a_mem_mem_dqs_c               (LPDDR4A_DQS_n),               //   inout,    width = 4,                                 .mem_dqs_c
        .emif_lpddr4a_mem_mem_dmi                 (LPDDR4A_DM),                 //   inout,    width = 4,                                 .mem_dmi
        .emif_lpddr4a_mem_ck_mem_ck_t             (LPDDR4A_CK),             //  output,    width = 1,              emif_lpddr4a_mem_ck.mem_ck_t
        .emif_lpddr4a_mem_ck_mem_ck_c             (LPDDR4A_CK_n),             //  output,    width = 1,                                 .mem_ck_c
        .emif_lpddr4a_mem_reset_n_mem_reset_n     (LPDDR4A_RESET_n),     //  output,    width = 1,         emif_lpddr4a_mem_reset_n.mem_reset_n
        .emif_lpddr4a_oct_oct_rzqin               (LPDDR4A_RZQ),               //   input,    width = 1,                 emif_lpddr4a_oct.oct_rzqin
        .emif_lpddr4a_ref_clk_clk                 (LPDDR4A_REFCLK_p),                 //   input,    width = 1,             emif_lpddr4a_ref_clk.clk
        
		  
		  .emif_lpddr4b_s0_axi4_ctrl_ready_reset_n  (emif_rst_n_lpddr4b),  //  output,    width = 1,  emif_lpddr4b_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4b_s0_axi4_awaddr              (LPDDR4B_awaddr),              //   input,   width = 32,             emif_lpddr4b_s0_axi4.awaddr
        .emif_lpddr4b_s0_axi4_awburst             (LPDDR4B_awburst),             //   input,    width = 2,                                 .awburst
        .emif_lpddr4b_s0_axi4_awid                (LPDDR4B_awid),                //   input,    width = 7,                                 .awid
        .emif_lpddr4b_s0_axi4_awlen               (LPDDR4B_awlen),               //   input,    width = 8,                                 .awlen
        .emif_lpddr4b_s0_axi4_awlock              (LPDDR4B_awlock),              //   input,    width = 1,                                 .awlock
        .emif_lpddr4b_s0_axi4_awqos               (0),               //   input,    width = 4,                                 .awqos
        .emif_lpddr4b_s0_axi4_awsize              (LPDDR4B_awsize),              //   input,    width = 3,                                 .awsize
        .emif_lpddr4b_s0_axi4_awvalid             (LPDDR4B_awvalid),             //   input,    width = 1,                                 .awvalid
        .emif_lpddr4b_s0_axi4_awuser              (0),              //   input,   width = 14,                                 .awuser
        .emif_lpddr4b_s0_axi4_awprot              (LPDDR4B_awprot),              //   input,    width = 3,                                 .awprot
        .emif_lpddr4b_s0_axi4_awready             (LPDDR4B_awready),             //  output,    width = 1,                                 .awready
        .emif_lpddr4b_s0_axi4_araddr              (LPDDR4B_araddr),              //   input,   width = 32,                                 .araddr
        .emif_lpddr4b_s0_axi4_arburst             (LPDDR4B_arburst),             //   input,    width = 2,                                 .arburst
        .emif_lpddr4b_s0_axi4_arid                (LPDDR4B_arid),                //   input,    width = 7,                                 .arid
        .emif_lpddr4b_s0_axi4_arlen               (LPDDR4B_arlen),               //   input,    width = 8,                                 .arlen
        .emif_lpddr4b_s0_axi4_arlock              (LPDDR4B_arlock),              //   input,    width = 1,                                 .arlock
        .emif_lpddr4b_s0_axi4_arqos               (0),               //   input,    width = 4,                                 .arqos
        .emif_lpddr4b_s0_axi4_arsize              (LPDDR4B_arsize),              //   input,    width = 3,                                 .arsize
        .emif_lpddr4b_s0_axi4_arvalid             (LPDDR4B_arvalid),             //   input,    width = 1,                                 .arvalid
        .emif_lpddr4b_s0_axi4_aruser              (0),              //   input,   width = 14,                                 .aruser
        .emif_lpddr4b_s0_axi4_arprot              (LPDDR4B_arprot),              //   input,    width = 3,                                 .arprot
        .emif_lpddr4b_s0_axi4_arready             (LPDDR4B_arready),             //  output,    width = 1,                                 .arready
        .emif_lpddr4b_s0_axi4_wdata               (LPDDR4B_wdata),               //   input,  width = 256,                                 .wdata
        .emif_lpddr4b_s0_axi4_wstrb               (LPDDR4B_wstrb),               //   input,   width = 32,                                 .wstrb
        .emif_lpddr4b_s0_axi4_wlast               (LPDDR4B_wlast),               //   input,    width = 1,                                 .wlast
        .emif_lpddr4b_s0_axi4_wvalid              (LPDDR4B_wvalid),              //   input,    width = 1,                                 .wvalid
        .emif_lpddr4b_s0_axi4_wready              (LPDDR4B_wready),              //  output,    width = 1,                                 .wready
        .emif_lpddr4b_s0_axi4_bready              (LPDDR4B_bready),              //   input,    width = 1,                                 .bready
        .emif_lpddr4b_s0_axi4_bid                 (LPDDR4B_bid),                 //  output,    width = 7,                                 .bid
        .emif_lpddr4b_s0_axi4_bresp               (LPDDR4B_bresp),               //  output,    width = 2,                                 .bresp
        .emif_lpddr4b_s0_axi4_bvalid              (LPDDR4B_bvalid),              //  output,    width = 1,                                 .bvalid
        .emif_lpddr4b_s0_axi4_rready              (LPDDR4B_rready),              //   input,    width = 1,                                 .rready
        .emif_lpddr4b_s0_axi4_rdata               (LPDDR4B_rdata),               //  output,  width = 256,                                 .rdata
        .emif_lpddr4b_s0_axi4_rid                 (LPDDR4B_rid),                 //  output,    width = 7,                                 .rid
        .emif_lpddr4b_s0_axi4_rlast               (LPDDR4B_rlast),               //  output,    width = 1,                                 .rlast
        .emif_lpddr4b_s0_axi4_rresp               (LPDDR4B_rresp),               //  output,    width = 2,                                 .rresp
        .emif_lpddr4b_s0_axi4_rvalid              (LPDDR4B_rvalid),              //  output,    width = 1,                                 .rvalid
        .emif_lpddr4b_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,    width = 1,   emif_lpddr4b_s0_axi4lite_clock.clk
        .emif_lpddr4b_s0_axi4lite_reset_n_reset_n (reset_handle), //   input,    width = 1, emif_lpddr4b_s0_axi4lite_reset_n.reset_n
        .emif_lpddr4b_s0_axi4lite_awaddr          (LPDDR4B_axil_driver_awaddr),          //   input,   width = 27,         emif_lpddr4b_s0_axi4lite.awaddr
        .emif_lpddr4b_s0_axi4lite_awprot          (LPDDR4B_axil_driver_awprot),          //   input,    width = 3,                                 .awprot
        .emif_lpddr4b_s0_axi4lite_awvalid         (LPDDR4B_axil_driver_awvalid),         //   input,    width = 1,                                 .awvalid
        .emif_lpddr4b_s0_axi4lite_awready         (LPDDR4B_axil_driver_awready),         //  output,    width = 1,                                 .awready
        .emif_lpddr4b_s0_axi4lite_araddr          (LPDDR4B_axil_driver_araddr),          //   input,   width = 27,                                 .araddr
        .emif_lpddr4b_s0_axi4lite_arprot          (LPDDR4B_axil_driver_arprot),          //   input,    width = 3,                                 .arprot
        .emif_lpddr4b_s0_axi4lite_arvalid         (LPDDR4B_axil_driver_arvalid),         //   input,    width = 1,                                 .arvalid
        .emif_lpddr4b_s0_axi4lite_arready         (LPDDR4B_axil_driver_arready),         //  output,    width = 1,                                 .arready
        .emif_lpddr4b_s0_axi4lite_wdata           (LPDDR4B_axil_driver_wdata),           //   input,   width = 32,                                 .wdata
        .emif_lpddr4b_s0_axi4lite_wstrb           (LPDDR4B_axil_driver_wstrb),           //   input,    width = 4,                                 .wstrb
        .emif_lpddr4b_s0_axi4lite_wvalid          (LPDDR4B_axil_driver_wvalid),          //   input,    width = 1,                                 .wvalid
        .emif_lpddr4b_s0_axi4lite_wready          (LPDDR4B_axil_driver_wready),          //  output,    width = 1,                                 .wready
        .emif_lpddr4b_s0_axi4lite_bready          (LPDDR4B_axil_driver_bready),          //   input,    width = 1,                                 .bready
        .emif_lpddr4b_s0_axi4lite_bresp           (LPDDR4B_axil_driver_bresp),           //  output,    width = 2,                                 .bresp
        .emif_lpddr4b_s0_axi4lite_bvalid          (LPDDR4B_axil_driver_bvalid),          //  output,    width = 1,                                 .bvalid
        .emif_lpddr4b_s0_axi4lite_rready          (LPDDR4B_axil_driver_rready),          //   input,    width = 1,                                 .rready
        .emif_lpddr4b_s0_axi4lite_rdata           (LPDDR4B_axil_driver_rdata),           //  output,   width = 32,                                 .rdata
        .emif_lpddr4b_s0_axi4lite_rresp           (LPDDR4B_axil_driver_rresp),           //  output,    width = 2,                                 .rresp
        .emif_lpddr4b_s0_axi4lite_rvalid          (LPDDR4B_axil_driver_rvalid),          //  output,    width = 1,                                 .rvalid
        .emif_lpddr4b_mem_mem_cs                  (LPDDR4B_CS_n),                  //  output,    width = 1,                 emif_lpddr4b_mem.mem_cs
        .emif_lpddr4b_mem_mem_ca                  (LPDDR4B_CA),                  //  output,    width = 6,                                 .mem_ca
        .emif_lpddr4b_mem_mem_cke                 (LPDDR4B_CKE),                 //  output,    width = 1,                                 .mem_cke
        .emif_lpddr4b_mem_mem_dq                  (LPDDR4B_DQ),                  //   inout,   width = 32,                                 .mem_dq
        .emif_lpddr4b_mem_mem_dqs_t               (LPDDR4B_DQS),               //   inout,    width = 4,                                 .mem_dqs_t
        .emif_lpddr4b_mem_mem_dqs_c               (LPDDR4B_DQS_n),               //   inout,    width = 4,                                 .mem_dqs_c
        .emif_lpddr4b_mem_mem_dmi                 (LPDDR4B_DM),                 //   inout,    width = 4,                                 .mem_dmi
        .emif_lpddr4b_mem_ck_mem_ck_t             (LPDDR4B_CK),             //  output,    width = 1,              emif_lpddr4b_mem_ck.mem_ck_t
        .emif_lpddr4b_mem_ck_mem_ck_c             (LPDDR4B_CK_n),             //  output,    width = 1,                                 .mem_ck_c
        .emif_lpddr4b_mem_reset_n_mem_reset_n     (LPDDR4B_RESET_n),     //  output,    width = 1,         emif_lpddr4b_mem_reset_n.mem_reset_n
        .emif_lpddr4b_oct_oct_rzqin               (LPDDR4B_RZQ),               //   input,    width = 1,                 emif_lpddr4b_oct.oct_rzqin
        .emif_lpddr4b_ref_clk_clk                 (LPDDR4B_REFCLK_p),                 //   input,    width = 1,             emif_lpddr4b_ref_clk.clk
        
		  
		  .emif_lpddr4c_s0_axi4_ctrl_ready_reset_n  (emif_rst_n_lpddr4c),  //  output,    width = 1,  emif_lpddr4c_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4c_s0_axi4_awaddr              (LPDDR4C_awaddr),              //   input,   width = 32,             emif_lpddr4b_s0_axi4.awaddr
        .emif_lpddr4c_s0_axi4_awburst             (LPDDR4C_awburst),             //   input,    width = 2,                                 .awburst
        .emif_lpddr4c_s0_axi4_awid                (LPDDR4C_awid),                //   input,    width = 7,                                 .awid
        .emif_lpddr4c_s0_axi4_awlen               (LPDDR4C_awlen),               //   input,    width = 8,                                 .awlen
        .emif_lpddr4c_s0_axi4_awlock              (LPDDR4C_awlock),              //   input,    width = 1,                                 .awlock
        .emif_lpddr4c_s0_axi4_awqos               (0),               //   input,    width = 4,                                 .awqos
        .emif_lpddr4c_s0_axi4_awsize              (LPDDR4C_awsize),              //   input,    width = 3,                                 .awsize
        .emif_lpddr4c_s0_axi4_awvalid             (LPDDR4C_awvalid),             //   input,    width = 1,                                 .awvalid
        .emif_lpddr4c_s0_axi4_awuser              (0),              //   input,   width = 14,                                 .awuser
        .emif_lpddr4c_s0_axi4_awprot              (LPDDR4C_awprot),              //   input,    width = 3,                                 .awprot
        .emif_lpddr4c_s0_axi4_awready             (LPDDR4C_awready),             //  output,    width = 1,                                 .awready
        .emif_lpddr4c_s0_axi4_araddr              (LPDDR4C_araddr),              //   input,   width = 32,                                 .araddr
        .emif_lpddr4c_s0_axi4_arburst             (LPDDR4C_arburst),             //   input,    width = 2,                                 .arburst
        .emif_lpddr4c_s0_axi4_arid                (LPDDR4C_arid),                //   input,    width = 7,                                 .arid
        .emif_lpddr4c_s0_axi4_arlen               (LPDDR4C_arlen),               //   input,    width = 8,                                 .arlen
        .emif_lpddr4c_s0_axi4_arlock              (LPDDR4C_arlock),              //   input,    width = 1,                                 .arlock
        .emif_lpddr4c_s0_axi4_arqos               (0),               //   input,    width = 4,                                 .arqos
        .emif_lpddr4c_s0_axi4_arsize              (LPDDR4C_arsize),              //   input,    width = 3,                                 .arsize
        .emif_lpddr4c_s0_axi4_arvalid             (LPDDR4C_arvalid),             //   input,    width = 1,                                 .arvalid
        .emif_lpddr4c_s0_axi4_aruser              (0),              //   input,   width = 14,                                 .aruser
        .emif_lpddr4c_s0_axi4_arprot              (LPDDR4C_arprot),              //   input,    width = 3,                                 .arprot
        .emif_lpddr4c_s0_axi4_arready             (LPDDR4C_arready),             //  output,    width = 1,                                 .arready
        .emif_lpddr4c_s0_axi4_wdata               (LPDDR4C_wdata),               //   input,  width = 256,                                 .wdata
        .emif_lpddr4c_s0_axi4_wstrb               (LPDDR4C_wstrb),               //   input,   width = 32,                                 .wstrb
        .emif_lpddr4c_s0_axi4_wlast               (LPDDR4C_wlast),               //   input,    width = 1,                                 .wlast
        .emif_lpddr4c_s0_axi4_wvalid              (LPDDR4C_wvalid),              //   input,    width = 1,                                 .wvalid
        .emif_lpddr4c_s0_axi4_wready              (LPDDR4C_wready),              //  output,    width = 1,                                 .wready
        .emif_lpddr4c_s0_axi4_bready              (LPDDR4C_bready),              //   input,    width = 1,                                 .bready
        .emif_lpddr4c_s0_axi4_bid                 (LPDDR4C_bid),                 //  output,    width = 7,                                 .bid
        .emif_lpddr4c_s0_axi4_bresp               (LPDDR4C_bresp),               //  output,    width = 2,                                 .bresp
        .emif_lpddr4c_s0_axi4_bvalid              (LPDDR4C_bvalid),              //  output,    width = 1,                                 .bvalid
        .emif_lpddr4c_s0_axi4_rready              (LPDDR4C_rready),              //   input,    width = 1,                                 .rready
        .emif_lpddr4c_s0_axi4_rdata               (LPDDR4C_rdata),               //  output,  width = 256,                                 .rdata
        .emif_lpddr4c_s0_axi4_rid                 (LPDDR4C_rid),                 //  output,    width = 7,                                 .rid
        .emif_lpddr4c_s0_axi4_rlast               (LPDDR4C_rlast),               //  output,    width = 1,                                 .rlast
        .emif_lpddr4c_s0_axi4_rresp               (LPDDR4C_rresp),               //  output,    width = 2,                                 .rresp
        .emif_lpddr4c_s0_axi4_rvalid              (LPDDR4C_rvalid),              //  output,    width = 1,                                 .rvalid
        .emif_lpddr4c_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,    width = 1,   emif_lpddr4C_s0_axi4lite_clock.clk
        .emif_lpddr4c_s0_axi4lite_reset_n_reset_n (reset_handle), //   input,    width = 1, emif_lpddr4C_s0_axi4lite_reset_n.reset_n
        .emif_lpddr4c_s0_axi4lite_awaddr          (LPDDR4C_axil_driver_awaddr),          //   input,   width = 27,         emif_lpddr4c_s0_axi4lite.awaddr
        .emif_lpddr4c_s0_axi4lite_awprot          (LPDDR4C_axil_driver_awprot),          //   input,    width = 3,                                 .awprot
        .emif_lpddr4c_s0_axi4lite_awvalid         (LPDDR4C_axil_driver_awvalid),         //   input,    width = 1,                                 .awvalid
        .emif_lpddr4c_s0_axi4lite_awready         (LPDDR4C_axil_driver_awready),         //  output,    width = 1,                                 .awready
        .emif_lpddr4c_s0_axi4lite_araddr          (LPDDR4C_axil_driver_araddr),          //   input,   width = 27,                                 .araddr
        .emif_lpddr4c_s0_axi4lite_arprot          (LPDDR4C_axil_driver_arprot),          //   input,    width = 3,                                 .arprot
        .emif_lpddr4c_s0_axi4lite_arvalid         (LPDDR4C_axil_driver_arvalid),         //   input,    width = 1,                                 .arvalid
        .emif_lpddr4c_s0_axi4lite_arready         (LPDDR4C_axil_driver_arready),         //  output,    width = 1,                                 .arready
        .emif_lpddr4c_s0_axi4lite_wdata           (LPDDR4C_axil_driver_wdata),           //   input,   width = 32,                                 .wdata
        .emif_lpddr4c_s0_axi4lite_wstrb           (LPDDR4C_axil_driver_wstrb),           //   input,    width = 4,                                 .wstrb
        .emif_lpddr4c_s0_axi4lite_wvalid          (LPDDR4C_axil_driver_wvalid),          //   input,    width = 1,                                 .wvalid
        .emif_lpddr4c_s0_axi4lite_wready          (LPDDR4C_axil_driver_wready),          //  output,    width = 1,                                 .wready
        .emif_lpddr4c_s0_axi4lite_bready          (LPDDR4C_axil_driver_bready),          //   input,    width = 1,                                 .bready
        .emif_lpddr4c_s0_axi4lite_bresp           (LPDDR4C_axil_driver_bresp),           //  output,    width = 2,                                 .bresp
        .emif_lpddr4c_s0_axi4lite_bvalid          (LPDDR4C_axil_driver_bvalid),          //  output,    width = 1,                                 .bvalid
        .emif_lpddr4c_s0_axi4lite_rready          (LPDDR4C_axil_driver_rready),          //   input,    width = 1,                                 .rready
        .emif_lpddr4c_s0_axi4lite_rdata           (LPDDR4C_axil_driver_rdata),           //  output,   width = 32,                                 .rdata
        .emif_lpddr4c_s0_axi4lite_rresp           (LPDDR4C_axil_driver_rresp),           //  output,    width = 2,                                 .rresp
        .emif_lpddr4c_s0_axi4lite_rvalid          (LPDDR4C_axil_driver_rvalid),          //  output,    width = 1,                                 .rvalid
        .emif_lpddr4c_mem_mem_cs                  (LPDDR4C_CS_n),                  //  output,    width = 1,                 emif_lpddr4C_mem.mem_cs
        .emif_lpddr4c_mem_mem_ca                  (LPDDR4C_CA),                  //  output,    width = 6,                                 .mem_ca
        .emif_lpddr4c_mem_mem_cke                 (LPDDR4C_CKE),                 //  output,    width = 1,                                 .mem_cke
        .emif_lpddr4c_mem_mem_dq                  (LPDDR4C_DQ),                  //   inout,   width = 32,                                 .mem_dq
        .emif_lpddr4c_mem_mem_dqs_t               (LPDDR4C_DQS),               //   inout,    width = 4,                                 .mem_dqs_t
        .emif_lpddr4c_mem_mem_dqs_c               (LPDDR4C_DQS_n),               //   inout,    width = 4,                                 .mem_dqs_c
        .emif_lpddr4c_mem_mem_dmi                 (LPDDR4C_DM),                 //   inout,    width = 4,                                 .mem_dmi
        .emif_lpddr4c_mem_ck_mem_ck_t             (LPDDR4C_CK),             //  output,    width = 1,              emif_lpddr4C_mem_ck.mem_ck_t
        .emif_lpddr4c_mem_ck_mem_ck_c             (LPDDR4C_CK_n),             //  output,    width = 1,                                 .mem_ck_c
        .emif_lpddr4c_mem_reset_n_mem_reset_n     (LPDDR4C_RESET_n),     //  output,    width = 1,         emif_lpddr4C_mem_reset_n.mem_reset_n
        .emif_lpddr4c_oct_oct_rzqin               (LPDDR4C_RZQ),               //   input,    width = 1,                 emif_lpddr4C_oct.oct_rzqin
        .emif_lpddr4c_ref_clk_clk                 (LPDDR4C_REFCLK_p),                 //   input,    width = 1,             emif_lpddr4C_ref_clk.clk
        
		  .iopll_refclk_clk                         (CLK_100_p),                         //   input,    width = 1,                     iopll_refclk.clk
        .iopll_locked_export                      (LPDDR4_IOPLL_Lock),                      //  output,    width = 1,                     iopll_locked.export
        .iopll_reset_reset                        (ninit_done),                        //   input,    width = 1,                      iopll_reset.reset
        .iopll_outclk_axi_lite_clk                (AXI_LITE_CLK),                //  output,    width = 1,            iopll_outclk_axi_lite.clk
        .reset_bridge_in_reset_reset_n            (reset_handle)             //   input,    width = 1,            reset_bridge_in_reset.reset_n
    );
// LPDDR4A RW Test
parameter LPDDR4A_AXI_ADDR_W 			= 32;
parameter LPDDR4A_AXI_ADDR_W_COUNT	= 32'h2000;
parameter LPDDR4A_AXI_ADDR_W_START	= 32'h00_0000;
parameter LPDDR4A_AXI_ADDR_W_END 	= 32'hffff_e000;
parameter LPDDR4A_AXI_DATA_W 			= 256;
parameter LPDDR4A_AXI_BURST_LENGHT 	= 8'hff;
parameter LPDDR4A_AXI_ID_W			 	= 4;

wire 											LPDDR4A_awvalid;
wire 											LPDDR4A_awready;
wire	[3:0]									LPDDR4A_awid;
wire 	[LPDDR4A_AXI_ADDR_W-1:0]  		LPDDR4A_awaddr;
wire 	[7:0]        						LPDDR4A_awlen;
wire 	[2:0]        						LPDDR4A_awsize;
wire 	[1:0]        						LPDDR4A_awburst;
wire             							LPDDR4A_awlock;
wire 	[3:0]        						LPDDR4A_awcache;
wire 	[2:0]        						LPDDR4A_awprot;
wire            							LPDDR4A_wvalid;
wire             							LPDDR4A_wready;
wire 	[LPDDR4A_AXI_DATA_W-1:0] 		LPDDR4A_wdata;
wire 	[(LPDDR4A_AXI_DATA_W>>3)-1:0] LPDDR4A_wstrb;
wire             							LPDDR4A_wlast;
  wire             						LPDDR4A_bvalid;
  wire            						LPDDR4A_bready;
  wire 	[3:0]  							LPDDR4A_bid;
  wire 	[1:0]      						LPDDR4A_bresp;
  wire            						LPDDR4A_arvalid;
  wire             						LPDDR4A_arready;
  wire 	[3:0]  							LPDDR4A_arid;
  wire 	[LPDDR4A_AXI_ADDR_W-1:0]  	LPDDR4A_araddr;
  wire 	[7:0]        					LPDDR4A_arlen;
  wire 	[2:0]        					LPDDR4A_arsize;
  wire 	[1:0]        					LPDDR4A_arburst;
  wire             						LPDDR4A_arlock;
  wire 	[3:0]        					LPDDR4A_arcache;
  wire 	[2:0]        					LPDDR4A_arprot;
  wire             						LPDDR4A_rvalid;
  wire            						LPDDR4A_rready;
  wire 	[3:0]  							LPDDR4A_rid;
  wire 	[LPDDR4A_AXI_DATA_W-1:0]  	LPDDR4A_rdata;
  wire 	[1:0]        					LPDDR4A_rresp;
  wire             						LPDDR4A_rlast;
//  wire           							LPDDR4A_test_pass;

// LPDDR4B RW Test
parameter LPDDR4B_AXI_ADDR_W 			= 32;
parameter LPDDR4B_AXI_ADDR_W_COUNT	= 32'h2000;
parameter LPDDR4B_AXI_ADDR_W_START	= 32'h00_0000;
parameter LPDDR4B_AXI_ADDR_W_END 	= 32'hffff_e000;
parameter LPDDR4B_AXI_DATA_W 			= 256;
parameter LPDDR4B_AXI_BURST_LENGHT 	= 8'hff;
parameter LPDDR4B_AXI_ID_W			 	= 4;

wire 											LPDDR4B_awvalid;	
wire 											LPDDR4B_awready;  
wire	[3:0]									LPDDR4B_awid;  
wire 	[LPDDR4B_AXI_ADDR_W-1:0]  		LPDDR4B_awaddr;
wire 	[7:0]        						LPDDR4B_awlen;
wire 	[2:0]        						LPDDR4B_awsize;
wire 	[1:0]        						LPDDR4B_awburst;
wire             							LPDDR4B_awlock;
wire 	[3:0]        						LPDDR4B_awcache;
wire 	[2:0]        						LPDDR4B_awprot;
wire            							LPDDR4B_wvalid;
wire             							LPDDR4B_wready;
wire 	[LPDDR4B_AXI_DATA_W-1:0] 		LPDDR4B_wdata;
wire 	[(LPDDR4B_AXI_DATA_W>>3)-1:0] LPDDR4B_wstrb;
wire             							LPDDR4B_wlast;
  wire             						LPDDR4B_bvalid;
  wire            						LPDDR4B_bready;
  wire 	[3:0]  							LPDDR4B_bid;
  wire 	[1:0]      						LPDDR4B_bresp;
  wire            						LPDDR4B_arvalid;
  wire             						LPDDR4B_arready;
  wire 	[3:0]  							LPDDR4B_arid;
  wire 	[LPDDR4B_AXI_ADDR_W-1:0]  	LPDDR4B_araddr;
  wire 	[7:0]        					LPDDR4B_arlen;
  wire 	[2:0]        					LPDDR4B_arsize;
  wire 	[1:0]        					LPDDR4B_arburst;
  wire             						LPDDR4B_arlock;
  wire 	[3:0]        					LPDDR4B_arcache;
  wire 	[2:0]        					LPDDR4B_arprot;
  wire             						LPDDR4B_rvalid;
  wire            						LPDDR4B_rready;
  wire 	[3:0]  							LPDDR4B_rid;
  wire 	[LPDDR4B_AXI_DATA_W-1:0]  	LPDDR4B_rdata;
  wire 	[1:0]        					LPDDR4B_rresp;
  wire             						LPDDR4B_rlast;
//  wire           							LPDDR4B_test_pass;

// LPDDR4C RW Test
parameter LPDDR4C_AXI_ADDR_W 			= 32;
parameter LPDDR4C_AXI_ADDR_W_COUNT	= 32'h2000;
parameter LPDDR4C_AXI_ADDR_W_START	= 32'h00_0000;
parameter LPDDR4C_AXI_ADDR_W_END 	= 32'hffff_e000;
parameter LPDDR4C_AXI_DATA_W 			= 256;
parameter LPDDR4C_AXI_BURST_LENGHT 	= 8'hff;
parameter LPDDR4C_AXI_ID_W			 	= 4;

wire 											LPDDR4C_awvalid;
wire 											LPDDR4C_awready;
wire	[3:0]									LPDDR4C_awid;
wire 	[LPDDR4C_AXI_ADDR_W-1:0]  		LPDDR4C_awaddr;
wire 	[7:0]        						LPDDR4C_awlen;
wire 	[2:0]        						LPDDR4C_awsize;
wire 	[1:0]        						LPDDR4C_awburst;
wire             							LPDDR4C_awlock;
wire 	[3:0]        						LPDDR4C_awcache;
wire 	[2:0]        						LPDDR4C_awprot;
wire            							LPDDR4C_wvalid;
wire             							LPDDR4C_wready;
wire 	[LPDDR4C_AXI_DATA_W-1:0] 		LPDDR4C_wdata;
wire 	[(LPDDR4C_AXI_DATA_W>>3)-1:0] LPDDR4C_wstrb;
wire             							LPDDR4C_wlast;
  wire             						LPDDR4C_bvalid;
  wire            						LPDDR4C_bready;
  wire 	[3:0]  							LPDDR4C_bid;
  wire 	[1:0]      						LPDDR4C_bresp;
  wire            						LPDDR4C_arvalid;
  wire             						LPDDR4C_arready;
  wire 	[3:0]  							LPDDR4C_arid;
  wire 	[LPDDR4C_AXI_ADDR_W-1:0]  	LPDDR4C_araddr;
  wire 	[7:0]        					LPDDR4C_arlen;
  wire 	[2:0]        					LPDDR4C_arsize;
  wire 	[1:0]        					LPDDR4C_arburst;
  wire             						LPDDR4C_arlock;
  wire 	[3:0]        					LPDDR4C_arcache;
  wire 	[2:0]        					LPDDR4C_arprot;
  wire             						LPDDR4C_rvalid;
  wire            						LPDDR4C_rready;
  wire 	[3:0]  							LPDDR4C_rid;
  wire 	[LPDDR4C_AXI_DATA_W-1:0]  	LPDDR4C_rdata;
  wire 	[1:0]        					LPDDR4C_rresp;
  wire             						LPDDR4C_rlast;
//  wire           							LPDDR4C_test_pass;

// LPDDR4A AXI Master Instance
 axi4_master LPDDR4A_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(BUTTON),

  // AXI4 Master
  /* output */            				.awvalid(LPDDR4A_awvalid),
  /* input */             				.awready(LPDDR4A_awready),
  /* output [ID_WIDTH-1:0]*/    		.awid(LPDDR4A_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(LPDDR4A_awaddr),
  /* output [7:0]*/        			.awlen(LPDDR4A_awlen),
  /* output [2:0]*/        			.awsize(LPDDR4A_awsize),
  /* output [1:0]*/        			.awburst(LPDDR4A_awburst),
  /* output */             			.awlock(LPDDR4A_awlock),
  /* output [3:0]*/        			.awcache(LPDDR4A_awcache),
  /* output [2:0]*/        			.awprot(LPDDR4A_awprot),

  /* output */            				.wvalid(LPDDR4A_wvalid),
  /* input */             				.wready(LPDDR4A_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(LPDDR4A_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(LPDDR4A_wstrb),
  /* output */             			.wlast(LPDDR4A_wlast),

  /* input */             				.bvalid(LPDDR4A_bvalid),
  /* output */            				.bready(LPDDR4A_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(LPDDR4A_bid),
  /* input [1:0]*/        				.bresp(LPDDR4A_bresp),

  /* output */            				.arvalid(LPDDR4A_arvalid),
  /* input */             				.arready(LPDDR4A_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(LPDDR4A_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(LPDDR4A_araddr),
  /* output [7:0]*/        			.arlen(LPDDR4A_arlen),
  /* output [2:0]*/        			.arsize(LPDDR4A_arsize),
  /* output [1:0]*/        			.arburst(LPDDR4A_arburst),
  /* output */             			.arlock(LPDDR4A_arlock),
  /* output [3:0]*/        			.arcache(LPDDR4A_arcache),
  /* output [2:0]*/        			.arprot(LPDDR4A_arprot),

  /* input */             				.rvalid(LPDDR4A_rvalid),
  /* output */            				.rready(LPDDR4A_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(LPDDR4A_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(LPDDR4A_rdata),
  /* input [1:0]*/        				.rresp(LPDDR4A_rresp),
  /* input */             				.rlast(LPDDR4A_rlast),

  //
  /* output */            				.test_pass(lpddr4a_test_pass),
  /* output */            				.test_complete(lpddr4a_test_complete)

  );
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W 			= LPDDR4A_AXI_ADDR_W;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_COUNT 	= LPDDR4A_AXI_ADDR_W_COUNT;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_START 	= LPDDR4A_AXI_ADDR_W_START;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_END 		= LPDDR4A_AXI_ADDR_W_END;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_DATA_W 			= LPDDR4A_AXI_DATA_W;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_BURST_LENGHT 	= LPDDR4A_AXI_BURST_LENGHT;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ID_W 				= LPDDR4A_AXI_ID_W;

// LPDDR4B AXI Master Instance
 axi4_master LPDDR4B_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(BUTTON),

  // AXI4 Master 
  /* output */            				.awvalid(LPDDR4B_awvalid),
  /* input */             				.awready(LPDDR4B_awready),
  /* output [ID_WIDTH-1:0]*/    		.awid(LPDDR4B_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(LPDDR4B_awaddr),
  /* output [7:0]*/        			.awlen(LPDDR4B_awlen),
  /* output [2:0]*/        			.awsize(LPDDR4B_awsize),
  /* output [1:0]*/        			.awburst(LPDDR4B_awburst),
  /* output */             			.awlock(LPDDR4B_awlock),
  /* output [3:0]*/        			.awcache(LPDDR4B_awcache),
  /* output [2:0]*/        			.awprot(LPDDR4B_awprot),

  /* output */            				.wvalid(LPDDR4B_wvalid),
  /* input */             				.wready(LPDDR4B_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(LPDDR4B_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(LPDDR4B_wstrb),
  /* output */             			.wlast(LPDDR4B_wlast),

  /* input */             				.bvalid(LPDDR4B_bvalid),
  /* output */            				.bready(LPDDR4B_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(LPDDR4B_bid),
  /* input [1:0]*/        				.bresp(LPDDR4B_bresp),

  /* output */            				.arvalid(LPDDR4B_arvalid),
  /* input */             				.arready(LPDDR4B_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(LPDDR4B_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(LPDDR4B_araddr),
  /* output [7:0]*/        			.arlen(LPDDR4B_arlen),
  /* output [2:0]*/        			.arsize(LPDDR4B_arsize),
  /* output [1:0]*/        			.arburst(LPDDR4B_arburst),
  /* output */             			.arlock(LPDDR4B_arlock),
  /* output [3:0]*/        			.arcache(LPDDR4B_arcache),
  /* output [2:0]*/        			.arprot(LPDDR4B_arprot),

  /* input */             				.rvalid(LPDDR4B_rvalid),
  /* output */            				.rready(LPDDR4B_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(LPDDR4B_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(LPDDR4B_rdata),
  /* input [1:0]*/        				.rresp(LPDDR4B_rresp),
  /* input */             				.rlast(LPDDR4B_rlast),

  // 
  /* output */            				.test_pass(lpddr4b_test_pass),
  /* output */            				.test_complete(lpddr4b_test_complete)
  
  );
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W 			= LPDDR4B_AXI_ADDR_W; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_COUNT 	= LPDDR4B_AXI_ADDR_W_COUNT; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_START 	= LPDDR4B_AXI_ADDR_W_START; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_END 		= LPDDR4B_AXI_ADDR_W_END; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_DATA_W 			= LPDDR4B_AXI_DATA_W; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_BURST_LENGHT 	= LPDDR4B_AXI_BURST_LENGHT; 
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ID_W 				= LPDDR4B_AXI_ID_W;

// LPDDR4C AXI Master Instance
 axi4_master LPDDR4C_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(BUTTON),

  // AXI4 Master
  /* output */            				.awvalid(LPDDR4C_awvalid),
  /* input */             				.awready(LPDDR4C_awready),
  /* output [ID_WIDTH-1:0]*/    		.awid(LPDDR4C_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(LPDDR4C_awaddr),
  /* output [7:0]*/        			.awlen(LPDDR4C_awlen),
  /* output [2:0]*/        			.awsize(LPDDR4C_awsize),
  /* output [1:0]*/        			.awburst(LPDDR4C_awburst),
  /* output */             			.awlock(LPDDR4C_awlock),
  /* output [3:0]*/        			.awcache(LPDDR4C_awcache),
  /* output [2:0]*/        			.awprot(LPDDR4C_awprot),

  /* output */            				.wvalid(LPDDR4C_wvalid),
  /* input */             				.wready(LPDDR4C_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(LPDDR4C_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(LPDDR4C_wstrb),
  /* output */             			.wlast(LPDDR4C_wlast),

  /* input */             				.bvalid(LPDDR4C_bvalid),
  /* output */            				.bready(LPDDR4C_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(LPDDR4C_bid),
  /* input [1:0]*/        				.bresp(LPDDR4C_bresp),

  /* output */            				.arvalid(LPDDR4C_arvalid),
  /* input */             				.arready(LPDDR4C_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(LPDDR4C_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(LPDDR4C_araddr),
  /* output [7:0]*/        			.arlen(LPDDR4C_arlen),
  /* output [2:0]*/        			.arsize(LPDDR4C_arsize),
  /* output [1:0]*/        			.arburst(LPDDR4C_arburst),
  /* output */             			.arlock(LPDDR4C_arlock),
  /* output [3:0]*/        			.arcache(LPDDR4C_arcache),
  /* output [2:0]*/        			.arprot(LPDDR4C_arprot),

  /* input */             				.rvalid(LPDDR4C_rvalid),
  /* output */            				.rready(LPDDR4C_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(LPDDR4C_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(LPDDR4C_rdata),
  /* input [1:0]*/        				.rresp(LPDDR4C_rresp),
  /* input */             				.rlast(LPDDR4C_rlast),

  //
  /* output */            				.test_pass(lpddr4c_test_pass),
  /* output */            				.test_complete(lpddr4c_test_complete)

  );
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_ADDR_W 			= LPDDR4C_AXI_ADDR_W;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_ADDR_W_COUNT 	= LPDDR4C_AXI_ADDR_W_COUNT;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_ADDR_W_START 	= LPDDR4C_AXI_ADDR_W_START;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_ADDR_W_END 		= LPDDR4C_AXI_ADDR_W_END;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_DATA_W 			= LPDDR4C_AXI_DATA_W;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_BURST_LENGHT 	= LPDDR4C_AXI_BURST_LENGHT;
defparam LPDDR4C_axi4_master_Inst.LPDDR4_AXI_ID_W 				= LPDDR4C_AXI_ID_W;

wire heart_led;
heart_beat  heart_beat_0 ( .CLK(CLK_50_B5B ),     .CLK_FREQ  (50_000_000) , . CK_1HZ (heart_led) );

assign USER_LED = (lpddr4a_test_pass & lpddr4b_test_pass & lpddr4c_test_pass) ? 1'b0 : heart_led;





endmodule
