module avalon_bus_rw_test(
		iCLK,
		iRST_n,
		insert_error,
		
		local_init_done,
		avl_waitrequest_n,                 
		avl_address,                      
		avl_readdatavalid,                 
		avl_readdata,                      
		avl_writedata,                     
		avl_read,                          
		avl_write,    
		avl_burstbegin,
		avl_size,
		
		drv_status_pass,
		drv_status_fail,
		drv_status_test_complete
		
								);

input 						 iCLK;
input							 iRST_n;
input							 local_init_done;
input 						 insert_error;
input          			 avl_waitrequest_n;                 //             avl.waitrequest_n
input          			 avl_readdatavalid;                 //                .readdatavalid
input  		[DATA_W-1:0] avl_readdata;                      //                .readdata

output 		[ADDR_W-1:0] avl_address;                       //                .address
output 		[DATA_W-1:0] avl_writedata;                     //                .writedata
output     reg    		 avl_read;                          //                .read
output     reg    		 avl_write;                         //                .write
output					    drv_status_pass;
output					reg drv_status_fail;
output					reg drv_status_test_complete;
output					    avl_burstbegin;
output      [6:0]			 avl_size;
wire 							 max_avl_address;


reg Global_Rst_n/*synthesis noprune*/;
always @ (posedge iCLK)
begin
  if(!iRST_n)
    Global_Rst_n <=0;
  else
    Global_Rst_n <= 1;
end

parameter      ADDR_W             = 30;
//test
//`define			ADDR_TEST				15			
parameter      DATA_W             = 256;
`define        ADDR    {ADDR_W{1'b1}}
//`define        ADDR    {`ADDR_TEST{1'b1}}
`define  		BURST_LENGTH 		   8
`define 			WRITE_STATE			   0
`define 			READ_STATE			   1
`define 			FINISH_STATE			2
assign  avl_size          = `BURST_LENGTH;
assign  max_avl_address   = (avl_address==`ADDR-(`BURST_LENGTH-1))?1'b1:1'b0;
//assign  max_avl_address   = (avl_address==`ADDR_TEST-(`BURST_LENGTH-1))?1'b1:1'b0;


altera_emif_avl_tg_lfsr_wrapper write_data_gen_inst (
	.clk		(iCLK),
	.reset_n	(Global_Rst_n),
	.enable	(avl_waitrequest_n & avl_write ),
	.data		(avl_writedata)
	);
defparam write_data_gen_inst.DATA_WIDTH = DATA_W;
	
// Pseudo-random data generator
altera_emif_avl_tg_lfsr_wrapper read_data_gen_inst (
	.clk		(iCLK),
	.reset_n	(Global_Rst_n & insert_error),
	.enable	(avl_readdatavalid),
	.data		(avl_expected_data)
	);
defparam read_data_gen_inst.DATA_WIDTH = DATA_W;


//pattern_gen pattern_gen_w_inst (
//	.clk		(iCLK),
//	.reset_n	(Global_Rst_n),
//	.enable	(avl_waitrequest_n & avl_write ),
//	.data		(avl_writedata)
//	);
//
//
//pattern_gen pattern_gen_r_inst (
//	.clk		(iCLK),
//	.reset_n	(Global_Rst_n & insert_error),
//	.enable	(avl_readdatavalid),
//	.data		(avl_expected_data)
//	);
	
	
	
reg 			[1:0] 		 RW_State/*synthesis noprune*/;
reg         [ADDR_W-1:0] avl_address;           
reg         [3:0]			 w_burst_cnt;
reg   						 write_latency;
always @ (posedge iCLK or negedge Global_Rst_n)
begin
	if(!Global_Rst_n)
	begin
	  RW_State <= 0;
	  write_latency <= 0;
	  avl_address <= 0;
	  drv_status_test_complete <= 0;
	  w_burst_cnt <= 0;
	end
	else 
	begin 
	  //write
	  if(RW_State==`WRITE_STATE)
	  begin
	        if(local_init_done & avl_waitrequest_n & !max_avl_address)
			  begin
			    if(w_burst_cnt == `BURST_LENGTH-1)
		       begin
			      avl_address <= avl_address + `BURST_LENGTH;
		         w_burst_cnt <= 0;
		       end
	          else
		         w_burst_cnt <= w_burst_cnt +1;
		     end
			
		  	  else if(local_init_done & avl_waitrequest_n & max_avl_address )
			  begin
			    if(w_burst_cnt == `BURST_LENGTH-1)
			    begin
				   avl_address <= 0;
				   RW_State <= 1;
			    end
			    else
			      w_burst_cnt <= w_burst_cnt +1;
			  end
			
			  else
		       RW_State <= RW_State;
	  end
	  
	  
	  
	  
	  //read
	  else if(RW_State==`READ_STATE)
	  begin
	      if(local_init_done & avl_waitrequest_n & !max_avl_address & avl_read)
			  avl_address <= avl_address + `BURST_LENGTH;
			else if(local_init_done & avl_waitrequest_n & max_avl_address )
			begin
			  avl_address <= 0;
	        RW_State <= 2;
			end
			else
			  RW_State <= RW_State;
	  end
	  //done
	  else if(RW_State==`FINISH_STATE)
	  begin	  
	      if(pipe_last_data_1)
			  drv_status_test_complete <= 1;
			else
			  drv_status_test_complete <= drv_status_test_complete;
	  end
   end
end


always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(Global_Rst_n==0 || local_init_done==0 || RW_State!=0)
  begin
    avl_write <= 0;
  end
  else
  begin
    avl_write <= 1;
  end
end

always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(Global_Rst_n==0 || local_init_done==0 || RW_State!=1)
  begin
    avl_read <= 0;
  end
  else
  begin
    avl_read <= 1;
  end
end

///////////////////
// check readback data

reg 			[ADDR_W-1:0] r_addr;  
wire        [DATA_W-1:0] avl_expected_data;    




reg [DATA_W-1:0] Pipe_read_data_0;
reg [DATA_W-1:0] Pipe_excepted_data_0;
reg            Pipe_enable_0;
reg			   pipe_last_data_0;


wire [DATA_W-1:0] Pipe_read_data_1;
wire [DATA_W-1:0] Pipe_excepted_data_1;
//reg            Pipe_enable_1;
wire			   pipe_last_data_1;


localparam PIPEDEPTH = 15;
hyper_pipe #(.WIDTH(DATA_W), .NUM_PIPES(PIPEDEPTH)) read_data_pipe
			(.din(Pipe_read_data_0), .dout (Pipe_read_data_1), .clk (iCLK));	
			
hyper_pipe #(.WIDTH(DATA_W), .NUM_PIPES(PIPEDEPTH)) excepted_data_pipe
			(.din(Pipe_excepted_data_0), .dout (Pipe_excepted_data_1), .clk (iCLK));	
			

			
always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(!Global_Rst_n)
	 r_addr <= 0; 
  else if (avl_readdatavalid)
	   r_addr <= r_addr + 1; 
  else
		r_addr <= r_addr;
end
			
always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(!Global_Rst_n)
	 pipe_last_data_0 <= 0;
  else if (r_addr == `ADDR)
	pipe_last_data_0 <= 1'b1;
end

hyper_pipe #(.WIDTH(1), .NUM_PIPES(PIPEDEPTH)) last_data_pipe
			(.din(pipe_last_data_0), .dout (pipe_last_data_1), .clk (iCLK));	

always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(!Global_Rst_n)
    drv_status_fail <= 0;
  else if (~drv_status_test_complete) // richard add
  begin
    if(Pipe_read_data_1 != Pipe_excepted_data_1)
	   drv_status_fail <= 1;
	 else
	   drv_status_fail <= drv_status_fail;
  end 
  
end

// pipe 0
always@(posedge iCLK or negedge Global_Rst_n)
begin
  if(!Global_Rst_n)
  begin
	 Pipe_read_data_0 <= 0;
	 Pipe_excepted_data_0 <= 0;
  end
  else
  begin
    if(avl_readdatavalid)
	 begin
	   Pipe_read_data_0 <= avl_readdata;
		Pipe_excepted_data_0 <= avl_expected_data;
	 end
	 else
	 begin
	   Pipe_read_data_0 <= Pipe_read_data_0;
		Pipe_excepted_data_0 <= Pipe_excepted_data_0;
	 end
  end
end


assign drv_status_pass = drv_status_test_complete & ~drv_status_fail;
	 
endmodule 
