// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Oct  8 14:37:01 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_LPDDR4C
//`define ENABLE_HPS
//`define ENABLE_SLVS
//`define ENABLE_ENET
//`define ENABLE_PCIE
//`define ENABLE_QSFP
//`define ENABLE_CAM1
//`define ENABLE_CAM2
//`define ENABLE_GTSL1A
//`define ENABLE_GTSL1B
//`define ENABLE_GTSL1C
//`define ENABLE_GTSR4A
//`define ENABLE_GTSR4C

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_p,
      input              CLK_50_B5B,
      input              CLK_50_B6A,
      input              CLK_50_B6C,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active
      input              BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active
      output             LED, //LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_LPDDR4C
      ///////// LPDDR4C /////////
      input              LPDDR4C_REFCLK_p,
      output             LPDDR4C_CS_n,
      output   [ 5: 0]   LPDDR4C_CA,
      output             LPDDR4C_CK,
      output             LPDDR4C_CKE,
      output             LPDDR4C_CK_n,
      inout    [ 3: 0]   LPDDR4C_DM,
      inout    [31: 0]   LPDDR4C_DQ,
      inout    [ 3: 0]   LPDDR4C_DQS,
      inout    [ 3: 0]   LPDDR4C_DQS_n,
      output             LPDDR4C_RESET_n,
      input              LPDDR4C_RZQ,
`endif /*ENABLE_LPDDR4C*/

      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      output             HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,

`ifdef ENABLE_SLVS
      ///////// SLVS /////////
      input    [ 7: 0]   SLVS_EC_RX_p,
      input    [ 7: 0]   SLVS_EC_RX_n,
      input              SLVS_EC_SDO,
      input              SLVS_EC_REFCLK_p, //J1_GTSL1A_REFCLK_p
      output             SLVS_EC_INCK_OE,
      output             SLVS_EC_OMODE,
      inout              SLVS_EC_SCK_SCL,
      inout              SLVS_EC_SDI_SDA,
      input              SLVS_EC_SENSOR_PGOOD,
      output             SLVS_EC_SENSOR_PON,
      output             SLVS_EC_XCE,
      output             SLVS_EC_XCLR,
      output             SLVS_EC_XHS,
      output             SLVS_EC_XMASTER,
      output   [ 2: 1]   SLVS_EC_XTRIG,
      output             SLVS_EC_XVS,
`endif /*ENABLE_SLVS*/

`ifdef ENABLE_ENET
      ///////// ENET /////////
      output             ENET_88E2110_TX_p,
      output             ENET_88E2110_TX_n,
      input              ENET_88E2110_RX_p,
      input              ENET_88E2110_RX_n,
      input              ENET_88E2110_REFCLK_156M25_p, //GTSL1C_REFCLK_156M25_p
      input              ENET_88E2110_INT_n,
      output             ENET_88E2110_MDC,
      inout              ENET_88E2110_MDIO,
      output             ENET_88E2110_RESET_n,
`endif /*ENABLE_ENET*/

      ///////// SI5332B /////////
      inout              SI5332B_I2C_SCL,
      inout              SI5332B_I2C_SDA,

      ///////// SI5340B /////////
      inout              SI5340B_I2C_SCL,
      inout              SI5340B_I2C_SDA,
      output             SI5340B_OE_n,
      output             SI5340B_RST_n,

      ///////// SI564 /////////
      inout              SI564_SCL,
      inout              SI564_SDA,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

      ///////// SMA /////////
      input              SMA_CLKIN_p,

      ///////// QTH /////////
      inout    [15: 0]   QTH_30_p,
      inout    [15: 0]   QTH_30_n,
      inout    [ 3: 0]   QTH_30_D,

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 3: 0]   PCIE_TX_p,
      output   [ 3: 0]   PCIE_TX_n,
      input    [ 3: 0]   PCIE_RX_p,
      input    [ 3: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p, //J2_GTSR4A_REFCLK_p
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP
      ///////// QSFP /////////
      output   [ 3: 0]   QSFP_TX_p,
      output   [ 3: 0]   QSFP_TX_n,
      input    [ 3: 0]   QSFP_RX_p,
      input    [ 3: 0]   QSFP_RX_n,
      input              CIPRI_REFCLK_p, //GTSR4B_REFCLK_184M32_p
      input              QSFP_REFCLK_p, //GTSR4B_REFCLK_156M25_p
      input              QSFP_INTERRUPT_n,
      output             QSFP_LP_MODE,
      input              QSFP_MOD_PRS_n,
      output             QSFP_MOD_SEL_n,
      output             QSFP_RST_n,
      inout              QSFP_SCL,
      inout              QSFP_SDA,
`endif /*ENABLE_QSFP*/

      ///////// CAM /////////
      input              CAM_RZQ1, //RZQ_B_2A_T

`ifdef ENABLE_CAM1
      ///////// CAM1 /////////
      input              CAM1_CLK_p,
      input              CAM1_CLK_n,
      input    [ 3: 0]   CAM1_D_p,
      input    [ 3: 0]   CAM1_D_n,
      inout              CAM1_I2C_SCL,
      inout              CAM1_I2C_SDA,
      inout              CAM1_GPIO,
`endif /*ENABLE_CAM1*/

`ifdef ENABLE_CAM2
      ///////// CAM2 /////////
      input              CAM2_CLK_p,
      input              CAM2_CLK_n,
      input    [ 3: 0]   CAM2_D_p,
      input    [ 3: 0]   CAM2_D_n,
      inout              CAM2_I2C_SCL,
      inout              CAM2_I2C_SDA,
      inout              CAM2_GPIO,
`endif /*ENABLE_CAM2*/

`ifdef ENABLE_GTSL1A
      ///////// GTSL1A /////////
      input              GTSL1A_REFCLK_100M_p,
`endif /*ENABLE_GTSL1A*/

`ifdef ENABLE_GTSL1B
      ///////// GTSL1B /////////
      input              GTSL1B_REFCLK_156M25_p,
`endif /*ENABLE_GTSL1B*/

`ifdef ENABLE_GTSL1C
      ///////// GTSL1C /////////
      input              GTSL1C_REFCLK_100M_p,
`endif /*ENABLE_GTSL1C*/

`ifdef ENABLE_GTSR4A
      ///////// GTSR4A /////////
      input              GTSR4A_REFCLK_148M5_p,
`endif /*ENABLE_GTSR4A*/

`ifdef ENABLE_GTSR4C
      ///////// GTSR4C /////////
      input              GTSR4C_REFCLK_100M_p,
`endif /*ENABLE_GTSR4C*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_13, //reserved for vendor test
      inout              HPS_IOB_14, //reserved for vendor test
      inout              HPS_IOB_19, //reserved for vendor test
      inout              HPS_IOB_20, //reserved for vendor test
      inout              HPS_IOB_21, //reserved for vendor test
      inout              HPS_IOB_22, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout              HPS_LED,
      inout              HPS_LED2,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

assign SI5340B_OE_n = 1'bZ;
assign SI5340B_RST_n = 1'bZ;




//=======================================================
//  Structural coding
//=======================================================




endmodule
