module BOARD_INFO (	
input               RESET_N , 
input				     CLK_50,
output 	reg	     MOSI,
input				     MISO,
output	reg 	     CS_n,
output	reg	     SCLK,
  


output	reg         Info_Valid ,    
output	reg  [15:0] Board_Version	,
output	reg  [15:0] MaxCode_Version,
output	reg  [15:0] PowerIn_Voltage,
output	reg  [15:0] PowerIn_Current,
output	reg  [15:0] CORE_Voltage	,
output	reg  [15:0] CORE_Current	,
output	reg  [15:0] Fan_Speed	   ,
output	reg  [15:0] Fan_Speed2	   ,
output	reg  [15:0] Temp_FPGA	   ,
output	reg  [15:0] Temp_Board	   ,
output	reg  [15:0] PIN_STATUS	   ,
output	reg  [15:0] Temp_SDM	      ,
output	reg  [15:0] Temp_FTILE12C	   ,
output	reg  [15:0] Temp_FTILE13A	   ,
output	reg  [15:0] VCC1P2_Voltage	,
output	reg  [15:0] VCC1P2_Current	,
output	reg  [15:0] Temp_Board2	   ,
output	reg  [15:0] Shutdown_flag  ,
output	reg  [15:0] Temp_POWER,//core power IC (such as ltc3888) temperature 



//--test 
output            SPI_SYS_CLK,
output  reg [3:0]  ST,
output  reg [15:0] COUNTER , 
output  reg [15:0] DEV_NUN,
output  reg[23:0] RDATA , 
output  reg        WR ,
output  reg [6:0]  REGI ,
output  reg        READY 

				);
					
parameter DEV_END          = 20; 

parameter [23:0]  P_Board_Version	={1'b1 ,7'h0 ,16'h0} ;
parameter [23:0]  P_MaxCode_Version ={1'b1 ,7'h1 ,16'h0} ;
parameter [23:0]  P_PowerIn_Voltage ={1'b1 ,7'h2 ,16'h0} ;
parameter [23:0]  P_PowerIn_Current ={1'b1 ,7'h3 ,16'h0} ;
parameter [23:0]  P_CORE_Voltage	   ={1'b1 ,7'h4 ,16'h0} ;
parameter [23:0]  P_CORE_Current	   ={1'b1 ,7'h5 ,16'h0} ;
parameter [23:0]  P_Fan_Speed	      ={1'b1 ,7'h6 ,16'h0} ;
parameter [23:0]  P_Fan_Speed2      ={1'b1 ,7'h7 ,16'h0} ;
parameter [23:0]  P_Temp_FPGA	      ={1'b1 ,7'h8 ,16'h0} ;
parameter [23:0]  P_Temp_Board	   ={1'b1 ,7'h9 ,16'h0} ;
parameter [23:0]  P_PIN_STATUS	   ={1'b1 ,7'ha ,16'h0} ;
parameter [23:0]  P_Temp_SDM	      ={1'b1 ,7'hb ,16'h0} ;
parameter [23:0]  P_Temp_FTILE12C   ={1'b1 ,7'hc ,16'h0} ;
parameter [23:0]  P_Temp_FTILE13A	={1'b1 ,7'hd ,16'h0} ;
parameter [23:0]  P_VCC1P2_Voltage	={1'b1 ,7'he ,16'h0} ;
parameter [23:0]  P_VCC1P2_Current	={1'b1 ,7'hf ,16'h0} ;
parameter [23:0]  P_Temp_Board2	   ={1'b1 ,7'h10 ,16'h0} ;
parameter [23:0]  P_Shutdown_flag   ={1'b1 ,7'h11 ,16'h0} ;

parameter [23:0]  P_Temp_POWER      ={1'b1 ,7'h13 ,16'h0} ;
                                               



//=======================================================
//  REG/WIRE declarations
//=======================================================
				 
reg [23:0] CREG ;
reg [31:0] DELAY ;   
//=======================================================
// Structural coding
//=======================================================

CLOCKMEM CLOCKMEM_inst(  .RESET_n  (1),  .CLK (CLK_50),.CLK_FREQ (50),.CK_1HZ   (SPI_SYS_CLK) ) ;//1 MHZ

//--SPI Master
always@( negedge RESET_N or posedge SPI_SYS_CLK )
   if ( !RESET_N) begin 
	   ST              <=0; 
		DEV_NUN         <=0;
		CS_n            <=1; 
		SCLK            <=0;
		MOSI            <=0;
		
      Board_Version	<=0;
      MaxCode_Version<=0;
      PowerIn_Voltage<=0;
      PowerIn_Current<=0;
      CORE_Voltage	<=0;
      CORE_Current	<=0;
      Fan_Speed	   <=0;
      Fan_Speed2	   <=0;
      Temp_FPGA	   <=0;	
      Temp_Board	   <=0;	
      PIN_STATUS	   <=0;	
      Temp_SDM	      <=0;	
      Temp_FTILE12C	<=0;	
      Temp_FTILE13A	<=0;	
      VCC1P2_Voltage	<=0;	
		VCC1P2_Current	<=0; 
      Temp_Board2	   <=0;
	   Shutdown_flag	<=0;
      Temp_POWER		<=0;
			
      PIN_STATUS      <=0;    
      Info_Valid      <=0;
		
	end 
else 
begin
case (ST)
0:begin 
      Info_Valid <=0;
      ST         <=1;
		SCLK       <=0;
		COUNTER    <=24;
		RDATA      <=0;                                                  
		     if  (DEV_NUN ==0)  {WR,REGI,CREG  } <= {P_Board_Version	[23],P_Board_Version	 [22:16],P_Board_Version	[23:0]} ;
		else if  (DEV_NUN ==1)  {WR,REGI,CREG  } <= {P_MaxCode_Version [23],P_MaxCode_Version[22:16],P_MaxCode_Version [23:0]} ;
		else if  (DEV_NUN ==2)  {WR,REGI,CREG  } <= {P_PowerIn_Voltage [23],P_PowerIn_Voltage[22:16],P_PowerIn_Voltage [23:0]} ;
		else if  (DEV_NUN ==3)  {WR,REGI,CREG  } <= {P_PowerIn_Current [23],P_PowerIn_Current[22:16],P_PowerIn_Current [23:0]} ;
		else if  (DEV_NUN ==4)  {WR,REGI,CREG  } <= {P_CORE_Voltage 	[23],P_CORE_Voltage	 [22:16],P_CORE_Voltage	   [23:0]} ;
		else if  (DEV_NUN ==5)  {WR,REGI,CREG  } <= {P_CORE_Current	   [23],P_CORE_Current	 [22:16],P_CORE_Current	   [23:0]} ;
		else if  (DEV_NUN ==6)  {WR,REGI,CREG  } <= {P_Fan_Speed	      [23],P_Fan_Speed	    [22:16],P_Fan_Speed	      [23:0]} ;
		else if  (DEV_NUN ==7)  {WR,REGI,CREG  } <= {P_Fan_Speed2      [23],P_Fan_Speed2	    [22:16],P_Fan_Speed2      [23:0]} ;
		else if  (DEV_NUN ==8)  {WR,REGI,CREG  } <= {P_Temp_FPGA	      [23],P_Temp_FPGA	    [22:16],P_Temp_FPGA	      [23:0]} ;
		else if  (DEV_NUN ==9)  {WR,REGI,CREG  } <= {P_Temp_Board	   [23],P_Temp_Board	    [22:16],P_Temp_Board	   [23:0]} ;
		else if  (DEV_NUN ==10) {WR,REGI,CREG  } <= {P_PIN_STATUS	   [23],P_PIN_STATUS	    [22:16],P_PIN_STATUS	   [23:0]} ;
		else if  (DEV_NUN ==11) {WR,REGI,CREG  } <= {P_Temp_SDM	      [23],P_Temp_SDM	    [22:16],P_Temp_SDM	      [23:0]} ;
		else if  (DEV_NUN ==12) {WR,REGI,CREG  } <= {P_Temp_FTILE12C	[23],P_Temp_FTILE12C	 [22:16],P_Temp_FTILE12C	[23:0]} ;
		else if  (DEV_NUN ==13) {WR,REGI,CREG  } <= {P_Temp_FTILE13A	[23],P_Temp_FTILE13A	 [22:16],P_Temp_FTILE13A	[23:0]} ;
		else if  (DEV_NUN ==14) {WR,REGI,CREG  } <= {P_VCC1P2_Voltage	[23],P_VCC1P2_Voltage	 [22:16],P_VCC1P2_Voltage	[23:0]} ;
		else if  (DEV_NUN ==15) {WR,REGI,CREG  } <= {P_VCC1P2_Current	[23],P_VCC1P2_Current	 [22:16],P_VCC1P2_Current	[23:0]} ;
		else if  (DEV_NUN ==16) {WR,REGI,CREG  } <= {P_Temp_Board2	   [23],P_Temp_Board2	 [22:16],P_Temp_Board2	   [23:0]} ;
		else if  (DEV_NUN ==17) {WR,REGI,CREG  } <= {P_Shutdown_flag	[23],P_Shutdown_flag	 [22:16],P_Shutdown_flag	[23:0]} ;
		
		else if  (DEV_NUN ==19) {WR,REGI,CREG  } <= {P_Temp_POWER	   [23],P_Temp_POWER  	 [22:16],P_Temp_POWER    	[23:0]} ;
	                       
  end 
1:begin 
       CS_n  <= 0; 
       ST<=2;
  end 
2:begin 
			
         {MOSI,CREG[23:0]} <= {CREG[23:0], 1'b0} ; //write to slave
         ST<=3;
  end 
3:begin 
		   SCLK  <=1;
		   if ( WR )  RDATA[23:0]  <= {RDATA[22:0], MISO} ; //read from slave
         COUNTER<=COUNTER-1;
         ST<=4;
  end 
4:begin 
        SCLK  <=0;
        if    ( COUNTER!=0)  ST<=2 ; 
        else  begin 
		    ST<=5; 
			 CS_n   <=1;
		  end 
  end 
5:begin 
        if ( REGI[6:0] ==7'h00) Board_Version	<= RDATA[15:0]; //read Board_Version  
        if ( REGI[6:0] ==7'h01) MaxCode_Version <= RDATA[15:0]; //read MaxCode_Version
        if ( REGI[6:0] ==7'h02) PowerIn_Voltage <= RDATA[15:0]; //read PowerIn_Voltage
        if ( REGI[6:0] ==7'h03) PowerIn_Current <= RDATA[15:0]; //read PowerIn_Current
        if ( REGI[6:0] ==7'h04) CORE_Voltage	   <= RDATA[15:0]; //read CORE_Voltage   
        if ( REGI[6:0] ==7'h05) CORE_Current	   <= RDATA[15:0]; //read CORE_Current   
        if ( REGI[6:0] ==7'h06) Fan_Speed	      <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==7'h07) Fan_Speed2      <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==7'h08) Temp_FPGA	      <= RDATA[15:0]; //read Temp_FPGA      
        if ( REGI[6:0] ==7'h09) Temp_Board	   <= RDATA[15:0]; //read Temp_Board     
        if ( REGI[6:0] ==7'h0a) PIN_STATUS	   <= RDATA[15:0]; //read PIN_STATUS     
        if ( REGI[6:0] ==7'h0b) Temp_SDM	      <= RDATA[15:0]; //read Temp_SDM       
        if ( REGI[6:0] ==7'h0c) Temp_FTILE12C	<= RDATA[15:0]; //read Temp_FTILE12C     
        if ( REGI[6:0] ==7'h0d) Temp_FTILE13A	<= RDATA[15:0]; //read Temp_FTILE13A     
        if ( REGI[6:0] ==7'h0e) VCC1P2_Voltage	<= RDATA[15:0]; //read CORE_Voltage2  
        if ( REGI[6:0] ==7'h0f) VCC1P2_Current	<= RDATA[15:0]; //read CORE_Current2      
        if ( REGI[6:0] ==7'h10) Temp_Board2	   <= RDATA[15:0]; //read Temp_Board2     
        if ( REGI[6:0] ==7'h11) Shutdown_flag	<= RDATA[15:0]; //read Shutdown_flag
		  
        if ( REGI[6:0] ==7'h13) Temp_POWER   	<= RDATA[15:0]; //read Temp_POWER
		  
                             
		  DEV_NUN  <=DEV_NUN  +1 ; 		    
        ST<=6 ;		  
		  DELAY <=0;       
end
6: begin
         DELAY <=DELAY+1; 
           if  ( DELAY ==5 )   begin  
			  if ( DEV_NUN == DEV_END) ST<=7;
			  else ST<=0; 
			end 
	end		
		    
7: begin
			ST          <= 8;  
			Info_Valid  <= 1 ; 
        	DELAY       <= 0;       
		   DEV_NUN     <= 0 ;			  
   end 
8: begin

          DELAY <=DELAY+1; 
         if  ( DELAY == 1000 ) begin //delay 1ms 
			      ST <= 0;
			end			 
   end 	
	
endcase
end

endmodule
