// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
module mux_data_synchronizer #(
    parameter DEPTH = 3,
    parameter DATA_WIDTH = 32
)
(
    input logic                     clk_dest
   ,input logic                     rst_dest
   ,input logic                     dvalid_in_src
   ,input logic [DATA_WIDTH-1 : 0]  data_in_src
   ,output logic [DATA_WIDTH-1 : 0] data_out_dest
);

   logic [1:0]  dvalid_sync;
   logic        dvalid_out_dest;
   logic [DATA_WIDTH-1 : 0]    data_in_src_reg;
   logic [DATA_WIDTH-1 : 0]    data_temp;
   
   altera_std_synchronizer_nocut 
      #(.depth(DEPTH)) 
      syncr ( 
            .clk(clk_dest),
            .reset_n(~rst_dest),
            .din(dvalid_in_src),
            .dout(dvalid_out_dest)
            );


    assign data_temp     = dvalid_out_dest ? data_in_src : data_out_dest ;
    // assign data_out_dest = data_temp ;

    always_ff@(posedge clk_dest) begin
        if (rst_dest)
            data_out_dest <= '0;
        else    
            data_out_dest <= data_temp;
    end
    
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "/ppDS9z7L8mp55KefX5oBagYZl4cvc2OGp5eM+1UKOGiEZtqYf6GOWcg9PPsnmC1ZYPb4lRQcdfK5q6GrUb11A9bzBjjYjeGMLRh4bAMEdR90tKLgGbVjYuUjGo+kzFoTQoJQzmq2VEzEO+jpteI6AnlExrNcS8joBGLSPNExmcmhbilTSUpC7LfTtaOdwwD+ZRRk/4DaBJvgMlDPduR4rSaFcihXJRR6gs/2UxuXUm1WOLq6gB+DyvtiOF3IPXSBq7fDYIg4+AyQjrJmF8lhK6WfDrnxBLRa/3VaqjSmuug6bfpmF7rVA+Y9iT1ctVlsOIQGkAat1/yZ5WVu0ihH+P9ZdcP3IAY7wAyaBnjrvxK2wpxFre6okLSU3Kc6/h1bnR3Rxy/3WrXv8mIirpIIYt0nV/d4uIwNDX57FWvZfMMErOv0IeHUyOC8kgWbDMBmxXXSiXyosHiHyqblUK5CjENwDZfrLnDnmV3yvDxvAgx1uZ9fNwvT5OhXU98UagarJwPp8vpBDzbTcjtS8cMl4rpCJcjxDkymaw9mvhx7PoRcazgIbpke83mdkqbEZPtDDMElYKs+GoQcOKUoWNooPjD0fFD2jE+rtlbTV0kkOAuVDGd9TEezTwB4sw9n+TQQVxwSnlqC465I6/76oM/v/SGhmFM5TVpbDgPwEWQDg7dKOXpA6rS838bsnC7OY8gIq3eBFKHc1Y9t38eWaYT8CvYxA53fw4l3vi8RAfOancSPy06Zn8LYTH25bSjclFAPg5wAEt9IoeY2R27/AcGjQDPmdFpC1eTnCGZ7Awp3CpOKF7pmP39syudNn9CY24ehkCLeY/tP6UUimNLlxHAtbNCabNdvPSLJgYJP0mWbhPAiQ7+bFWs0sEuMx5TZVswFyGKI76D0xChpp8DN2uAGWlzTEU9M95RMLphCGS5bSdVxU8SQcFgRhZU596XVl+mGIK7Y5RWjQu+L8CQo7oCMYH3C4R5Xfvir1h/wlDBUgvV2opqN8zCEn2IsWfOzCrL"
`endif