// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`ifdef ALTERA_RESERVED_QIS
// See https://wiki.ith.intel.com/pages/viewpage.action?pageId=3466839469#SMHSSIMisc.Notes-__USE_SOF_SETTINGS__
`ifndef __TILE_IP_SIM_FLOW__
`define __USE_SOF_SETTINGS__
`endif
`endif

`timescale 1ps/1ps
 module agilex_hps_intel_usbphy_gts_100_j4szz2a #(
    parameter pma_data_rate = "5000",
    parameter ref_clk_freq = "100"
    ) (

    //PHY related inputs/outputs
    input i_pma_cpu_clk,
    input i_rx_serial_p,
    input i_rx_serial_n,
    input i_refclk_p,
    input i_refclk_n,
    output o_tx_serial_p,
    output o_tx_serial_n,
	  input i_reconfig_reset,
	  input i_reconfig_clk,
	  input i_reconfig_read,
	  input i_reconfig_write,
    input [20:0] i_reconfig_address,
    input [31:0] i_reconfig_writedata,
    input [3:0] i_reconfig_byteenable,
    output [31:0] o_reconfig_readdata,
    output o_reconfig_readdatavalid,
    output o_reconfig_waitrequest,
    //PIPE related inputs/outputs
    output o_usb31_pipe_clk,
    input  i_usb31_pipe_reset_n,
    input  [3:0] i_usb31_pipe_PowerDown,
     
    input  i_usb31_pipe_ElasBufferMode,
    input  [2:0] i_usb31_pipe_Rate,
    input  i_usb31_pipe_TxDetectRxLoopback,
    input  i_usb31_pipe_TxElecidle,
    input  i_usb31_pipe_TxOnesZeros,
    input  i_usb31_pipe_RxTermination,
    input  i_usb31_pipe_RxEqTrain,
    input  i_usb31_pipe_RxPolarity,
    input  [1:0] i_usb31_pipe_TxDeEmphasis,

    output o_usb31_pipe_PhyStatus,
    output o_usb31_pipe_RxElecidle,
    output [2:0] o_usb31_pipe_Rxstatus,

    output [15:0] o_usb31_pipe_RxData,
    output [1:0] o_usb31_pipe_RxDataK,
    output o_usb31_pipe_RxValid,

    input  [15:0] i_usb31_pipe_TxData,
    input  [1:0]  i_usb31_pipe_TxDataK

    );

//	input [319:0] x_std_ipfluxtop_flux_core_shim_wrap_0__iflux_ingress_direct_lane2,
//----------IMPORTANT---------------//  
//normally core ip output not driving this port we need to connet this mannually//
//----------IMPORTANT---------------//  

logic [23:0] o_usb31_pipe_RxData_blank;
logic [1:0] o_usb31_pipe_RxDataK_blank;

wire osc_clk;
`ifdef ALTERA_RESERVED_QIS
altera_config_clock_source_endpoint clock_endpoint (
        .clk(osc_clk)
                );
`else
assign osc_clk = i_pma_cpu_clk;
`endif


usb #(
  .x_mux_sm_flux_dpma_clk_mux_0__sel("SEL_CNOC_CLK"),
	.x_decoder_sm_flux_rx_demux_0__sel	("SEL_PCIE_PCS"),                        /* Settings: SEL_PCIE_PCS, SEL_XCVRIF, SEL_UNUSED */
	.x_decoder_sm_flux_rx_rxword_clk_demux_0__sel	("SEL_PCIE_RXWORD_CLK"),       /* Settings: SEL_ETH_RXWORD_CLK, SEL_PCIE_RXWORD_CLK, SEL_UNUSED */
	.x_decoder_sm_flux_tx_txword_clk_demux_0__sel	("SEL_PCIE_TXWORD_CLK"),       /* Settings: SEL_ETH_TXWORD_CLK, SEL_PCIE_TXWORD_CLK, SEL_UNUSED */
	//.x_decoder_sm_pld_tx_demux_0__sel	("SEL_PCIE"),                              /* Settings: SEL_PCIE, SEL_PCIE_BOND, SEL_ETH, SEL_UNUSED */
	.x_mux_sm_flux_tx_mux_0__sel	("SEL_PCIE_PCS"),                              /* Settings: SEL_PCIE_PCS, SEL_XCVRIF, SEL_UNUSED */ 
	.x_mux_sm_flux_tx_txword_clk_mux_0__sel	("SEL_UX_OCK_PMA_CLK"),                      /* Settings: SEL_XCVR_TXWORD_CLK, SEL_UX_OCK_PMA_CLK, SEL_UNUSED */ 
	.x_mux_sm_hssi_pcie_pcs_rst_mux_0__sel	("SEL_HPS_RST"),                     /* Settings: SEL_SAME_QUAD_PCS_RST, SEL_UPPER_QUAD_PCS_RST, SEL_HPS_RST, SEL_UNUSED */ 
	//.x_mux_sm_hssi_pld_chnl_rx_fifo_wr_clk_mux_0__sel	("SEL_PCIE"),       //?? SOME Other file ??
	//.x_mux_sm_hssi_pld_chnl_tx_fifo_rd_clk_mux_0__sel	("SEL_PCIE"),       //?? SOME Other file ??
	//.x_mux_sm_pld_rx_mux_0__sel	("SEL_PCIE"),                                    //?? SOME Other file ??
	.x_mux_sm_xcvrif_rx_ch_clk_mux_0__sel	("RX_WORD_CLK_DYNAMIC_MUX_UNUSED"),//SEL_SYS_CLK"),                      //?? Native clock mode ?? 
	.x_mux_sm_xcvrif_tx_ch_clk_mux_0__sel	("TX_WORD_CLK_DYNAMIC_MUX_UNUSED"),//SEL_SYS_CLK"),                      //?? Native clock mode ?? 

	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_cdr_l_counter	(6'b000100),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_cdr_refclk_select	("CH0_CDR_REFCLK_SELECT_LOCAL_REFCLK"),       //GLOBAL_REFCLK0"), //
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_flux_mode	("CH0_FLUX_MODE_FLUX_MODE_BYPASS"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_loopback_mode	("CH0_LOOPBACK_MODE_DISABLED"),                             //?? Didnot find in Example design??
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_pcie_mode	("CH0_PCIE_MODE_GEN1"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_pcie_mode	("CH0_PCIE_MODE_DISABLED"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_prbs_monitor_en	("CH0_RX_PRBS_MONITOR_EN_DISABLE"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_preloaded_hardware_configs	("CH0_RX_PRELOADED_HARDWARE_CONFIGS_NONE"), 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_preloaded_hardware_configs	("CH0_RX_PRELOADED_HARDWARE_CONFIGS_USB"), 
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_sim_mode	("CH0_RX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_sim_mode	("CH0_RX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_width	("CH0_RX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_rx_width	("CH0_RX_WIDTH_X16"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_bonding_category	("CH0_TX_BONDING_CATEGORY_UNUSED"),                   //?? LEADER required for one lane ?? 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_pll_l_counter	(6'b000100),                                            
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_pll_refclk_select	("CH0_TX_PLL_REFCLK_SELECT_LOCAL_REFCLK"),  //     GLOBAL_REFCLK0"), //LOCAL_REFCLK"),        
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_prbs_gen_en	("CH0_TX_PRBS_GEN_EN_DISABLE"),                           
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_preloaded_hardware_configs	("CH0_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_preloaded_hardware_configs	("CH0_TX_PRELOADED_HARDWARE_CONFIGS_USB"),
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_sim_mode	("CH0_TX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_sim_mode	("CH0_TX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_user_clk_only_mode	("CH0_TX_USER_CLK_ONLY_MODE_ENABLE"),  
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_user_clk_only_mode	("CH0_TX_USER_CLK_ONLY_MODE_DISABLE"),   
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_width	("CH0_TX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch0_tx_width	("CH0_TX_WIDTH_X16"),                                      
///////////////////////////////////////////////
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_cdr_l_counter	(6'b000100),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_cdr_refclk_select	("CH1_CDR_REFCLK_SELECT_LOCAL_REFCLK"),       //GLOBAL_REFCLK0"), //
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_flux_mode	("CH1_FLUX_MODE_FLUX_MODE_BYPASS"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_loopback_mode	("CH1_LOOPBACK_MODE_DISABLED"),                             //?? Didnot find in Example design??
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_pcie_mode	("CH1_PCIE_MODE_GEN1"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_pcie_mode	("CH1_PCIE_MODE_DISABLED"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_prbs_monitor_en	("CH1_RX_PRBS_MONITOR_EN_DISABLE"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_preloaded_hardware_configs	("CH1_RX_PRELOADED_HARDWARE_CONFIGS_NONE"), 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_preloaded_hardware_configs	("CH1_RX_PRELOADED_HARDWARE_CONFIGS_USB"), 
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_sim_mode	("CH1_RX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_sim_mode	("CH1_RX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_width	("CH1_RX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_rx_width	("CH1_RX_WIDTH_X16"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_bonding_category	("CH1_TX_BONDING_CATEGORY_UNUSED"),                   //?? LEADER required for one lane ?? 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_pll_l_counter	(6'b000100),                                            
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_pll_refclk_select	("CH1_TX_PLL_REFCLK_SELECT_LOCAL_REFCLK"),  //     GLOBAL_REFCLK0"), //LOCAL_REFCLK"),        
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_prbs_gen_en	("CH1_TX_PRBS_GEN_EN_DISABLE"),                           
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_preloaded_hardware_configs	("CH1_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_preloaded_hardware_configs	("CH1_TX_PRELOADED_HARDWARE_CONFIGS_USB"),
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_sim_mode	("CH1_TX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_sim_mode	("CH1_TX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_user_clk_only_mode	("CH1_TX_USER_CLK_ONLY_MODE_ENABLE"),                         //?? no 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_user_clk_only_mode	("CH1_TX_USER_CLK_ONLY_MODE_DISABLE"),                         //?? no 
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_width	("CH1_TX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch1_tx_width	("CH1_TX_WIDTH_X16"),                                      
///////////////////////////////////////////////
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_cdr_l_counter	(6'b000100),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_cdr_refclk_select	("CH2_CDR_REFCLK_SELECT_LOCAL_REFCLK"),       //GLOBAL_REFCLK0"), //
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_flux_mode	("CH2_FLUX_MODE_FLUX_MODE_BYPASS"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_loopback_mode	("CH2_LOOPBACK_MODE_DISABLED"),                             //?? Didnot find in Example design??
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_pcie_mode	("CH2_PCIE_MODE_GEN1"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_pcie_mode	("CH2_PCIE_MODE_DISABLED"),                                     //?? PCIE mode need to be enabled ??
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_prbs_monitor_en	("CH2_RX_PRBS_MONITOR_EN_DISABLE"),                   
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_preloaded_hardware_configs	("CH2_RX_PRELOADED_HARDWARE_CONFIGS_NONE"), 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_preloaded_hardware_configs	("CH2_RX_PRELOADED_HARDWARE_CONFIGS_USB"), 
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_sim_mode	("CH2_RX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_sim_mode	("CH2_RX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_width	("CH2_RX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_rx_width	("CH2_RX_WIDTH_X16"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_bonding_category	("CH2_TX_BONDING_CATEGORY_UNUSED"),                   //?? LEADER required for one lane ?? 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_pll_l_counter	(6'b000100),                                            
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_pll_refclk_select	("CH2_TX_PLL_REFCLK_SELECT_LOCAL_REFCLK"),  //     GLOBAL_REFCLK0"), //LOCAL_REFCLK"),        
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_prbs_gen_en	("CH2_TX_PRBS_GEN_EN_DISABLE"),                           
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_prbs_pattern	(4'b0000),                                                
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_preloaded_hardware_configs	("CH2_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_preloaded_hardware_configs	("CH2_TX_PRELOADED_HARDWARE_CONFIGS_USB"),
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_sim_mode	("CH2_TX_SIM_MODE_DISABLE"),                                   
  `else
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_sim_mode	("CH2_TX_SIM_MODE_ENABLE"),                                   
  `endif
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_user_clk_only_mode	("CH2_TX_USER_CLK_ONLY_MODE_ENABLE"),                         //?? no 
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_user_clk_only_mode	("CH2_TX_USER_CLK_ONLY_MODE_DISABLE"),                         //?? no 
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_width	("CH2_TX_WIDTH_X32"),                                      
	.x_std_ipfluxtop_flux_core_shim_wrap_0__ch2_tx_width	("CH2_TX_WIDTH_X16"),                                      
///////////////////////////////////////////////
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_cdr_l_counter	(6'b000001),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_cdr_refclk_select	("CH3_CDR_REFCLK_SELECT_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_flux_mode	("CH3_FLUX_MODE_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_loopback_mode	("CH3_LOOPBACK_MODE_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_pcie_mode	("CH3_PCIE_MODE_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_rx_prbs_monitor_en	("CH3_RX_PRBS_MONITOR_EN_ENABLE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_rx_prbs_pattern	(4'b0001),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_rx_preloaded_hardware_configs	("CH3_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_rx_sim_mode	("CH3_RX_SIM_MODE_ENABLE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_rx_width	("CH3_RX_WIDTH_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_bonding_category	("CH3_TX_BONDING_CATEGORY_UNUSED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_pll_l_counter	(6'b000001),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_pll_refclk_select	("CH3_TX_PLL_REFCLK_SELECT_DISABLED"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_prbs_gen_en	("CH3_TX_PRBS_GEN_EN_ENABLE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_prbs_pattern	(4'b0001),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_preloaded_hardware_configs	("CH3_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_sim_mode	("CH3_TX_SIM_MODE_ENABLE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_user_clk_only_mode	("CH3_TX_USER_CLK_ONLY_MODE_ENABLE"),
	//.x_std_ipfluxtop_flux_core_shim_wrap_0__ch3_tx_width	("CH3_TX_WIDTH_DISABLED"),

	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_out_hz	(36'b000010111010010000111011011101000000),                  
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_pfd_hz	(36'b000000000001011111010111100001000000),                  
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_ref_hz	(36'b000000000101111101011110000100000000),                  
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_vco_hz	(36'b001011101001000011101101110100000000),                  
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_l_counter	(6'b000100),                                               
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_m_counter	(9'b011111010),                                            
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__cdr_n_counter	(6'b000100),                                               
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_out_hz	(36'd2500000000),//2500M                  
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_pfd_hz	(36'd100000000),                  
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_ref_hz	(36'd100000000),//100M                  
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_f_vco_hz	(36'd10000000000),//10G
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_l_counter	(6'b000100),                                               
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_m_counter	(9'd50),//50                                            
	.x_std_ipfluxtop_uxtop_wrap_0__cdr_n_counter	(6'b000001),                                               

	.x_std_ipfluxtop_uxtop_wrap_0__cdr_refclk_select	("CDR_REFCLK_SELECT_LOCAL_REFCLK"),//GLOBAL_REFCLK0"), //LOCAL_REFCLK"),                 
	.x_std_ipfluxtop_uxtop_wrap_0__clk_debug_select_0_enable	("CLK_DEBUG_SELECT_0_ENABLE_DISABLE"),      
	.x_std_ipfluxtop_uxtop_wrap_0__clk_debug_select_0_setting	("CLK_DEBUG_SELECT_0_SETTING_DISABLED"),    
	.x_std_ipfluxtop_uxtop_wrap_0__clk_debug_select_1_enable	("CLK_DEBUG_SELECT_1_ENABLE_DISABLE"),      
	.x_std_ipfluxtop_uxtop_wrap_0__clk_debug_select_1_setting	("CLK_DEBUG_SELECT_1_SETTING_DISABLED"),    
	.x_std_ipfluxtop_uxtop_wrap_0__duplex_mode	("DUPLEX_MODE_DUPLEX"),                                      
	//.x_std_ipfluxtop_uxtop_wrap_0__ick_tx_word_clk_hz	(36'b011111100001011100111110011100110110),            
	.x_std_ipfluxtop_uxtop_wrap_0__ick_tx_word_clk_hz	(36'd250000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__pcs_ref_clk_hz	(36'b010010111111100100110111111000111010),                
	.x_std_ipfluxtop_uxtop_wrap_0__lane_common_ref_clk_hz	(36'b101000010100110101000100011000110100),        
	.x_std_ipfluxtop_uxtop_wrap_0__loopback_mode	("LOOPBACK_MODE_DISABLED"),                                
	//.x_std_ipfluxtop_uxtop_wrap_0__pcie_mode	("PCIE_MODE_GEN1"),                                        
	.x_std_ipfluxtop_uxtop_wrap_0__pcie_mode	("PCIE_MODE_DISABLED"),                                        
	//.x_std_ipfluxtop_uxtop_wrap_0__rx_adaptation_mode	("RX_ADAPTATION_MODE_DISABLED"),                       
	.x_std_ipfluxtop_uxtop_wrap_0__rx_adaptation_mode	("RX_ADAPTATION_MODE_UX_NATIVE_ADAPTATION"),                       
	.x_std_ipfluxtop_uxtop_wrap_0__rx_cdrdivout_en	("RX_CDRDIVOUT_EN_DISABLE"),                             
	//.x_std_ipfluxtop_uxtop_wrap_0__rx_datarate_bps	(37'b0000101110100100001110110111010000000),             
	.x_std_ipfluxtop_uxtop_wrap_0__rx_datarate_bps	(37'd5000000000),             
	.x_std_ipfluxtop_uxtop_wrap_0__rx_en	("TRUE"),                                                         
	.x_std_ipfluxtop_uxtop_wrap_0__rx_eq_dfe_tap_1	(6'b000000),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__rx_eq_hf_boost	(6'b0100000),                                               
	.x_std_ipfluxtop_uxtop_wrap_0__rx_eq_vga_gain	(7'b0100000),                                              
	.x_std_ipfluxtop_uxtop_wrap_0__rx_external_couple_type	("RX_EXTERNAL_COUPLE_TYPE_AC"),                 
	.x_std_ipfluxtop_uxtop_wrap_0__rx_force_cdr_ltr	("FALSE"),                                              
	.x_std_ipfluxtop_uxtop_wrap_0__rx_invert_pin	("RX_INVERT_PIN_DISABLE"),                                
	.x_std_ipfluxtop_uxtop_wrap_0__rx_onchip_termination_setting	("RX_ONCHIP_TERMINATION_SETTING_R_1"),    
	.x_std_ipfluxtop_uxtop_wrap_0__rx_postdiv_clk_divider	(8'b00001100),                                    
	.x_std_ipfluxtop_uxtop_wrap_0__rx_postdiv_clk_en	("RX_POSTDIV_CLK_EN_DISABLE"),                        
	.x_std_ipfluxtop_uxtop_wrap_0__rx_postdiv_clk_fractional_en	("RX_POSTDIV_CLK_FRACTIONAL_EN_DISABLE"),    
	.x_std_ipfluxtop_uxtop_wrap_0__rx_postdiv_clk_hz	(36'b000000000000000000000000000000000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__rx_prbs_monitor_en	("RX_PRBS_MONITOR_EN_DISABLE"),                        
	.x_std_ipfluxtop_uxtop_wrap_0__rx_prbs_pattern	(4'b1001),                                               
	//.x_std_ipfluxtop_uxtop_wrap_0__rx_preloaded_hardware_configs	("RX_PRELOADED_HARDWARE_CONFIGS_NONE"),    
	.x_std_ipfluxtop_uxtop_wrap_0__rx_preloaded_hardware_configs	("RX_PRELOADED_HARDWARE_CONFIGS_USB"),    
	.x_std_ipfluxtop_uxtop_wrap_0__rx_protocol_hint	("RX_PROTOCOL_HINT_DISABLED"),                           
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_uxtop_wrap_0__rx_sim_mode	("RX_SIM_MODE_DISABLE"),                                      
  `else
	.x_std_ipfluxtop_uxtop_wrap_0__rx_sim_mode	("RX_SIM_MODE_ENABLE"),                                      
  `endif
	.x_std_ipfluxtop_uxtop_wrap_0__rx_termination_mode	("RX_TERMINATION_MODE_GROUNDED"),                 
	//.x_std_ipfluxtop_uxtop_wrap_0__rx_width	("RX_WIDTH_X32"),                                           
	.x_std_ipfluxtop_uxtop_wrap_0__rx_width	("RX_WIDTH_X16"),                                           
	//.x_std_ipfluxtop_uxtop_wrap_0__rx_word_clk_hz	(36'b000000001011101001000011101101110100),            
	.x_std_ipfluxtop_uxtop_wrap_0__rx_word_clk_hz	(36'd250000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__speed_grade	("SPEED_GRADE_DASH_1"),                                  
	.x_std_ipfluxtop_uxtop_wrap_0__tx_bond_size	("TX_BOND_SIZE_X1"),                                     
	.x_std_ipfluxtop_uxtop_wrap_0__tx_bonding_category	("TX_BONDING_CATEGORY_UNUSED"),                     
	//.x_std_ipfluxtop_uxtop_wrap_0__tx_datarate_bps	(37'b0000101110100100001110110111010000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__tx_datarate_bps	(37'd5000000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__tx_en	("TRUE"),                                                         
	.x_std_ipfluxtop_uxtop_wrap_0__tx_eq_main_tap	(6'b000000),                                              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_eq_post_tap_1	(5'b00000),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_eq_pre_tap_1	(5'b00000),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_eq_pre_tap_2	(3'b000),                                                
	.x_std_ipfluxtop_uxtop_wrap_0__tx_invert_pin	("TX_INVERT_PIN_DISABLE"),                                 
	.x_std_ipfluxtop_uxtop_wrap_0__tx_master_pll_mode	("TX_MASTER_PLL_MODE_DISABLED"),                       
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_bw_sel	("TX_PLL_BW_SEL_LOW"),                                  
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_out_hz	(36'b000010111010010000111011011101000000),              
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_pfd_hz	(36'b000000000101111101011110000100000000),              
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_ref_hz	(36'b000000000101111101011110000100000000),              
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_vco_hz	(36'b001011101001000011101101110100000000),              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_out_hz	(36'd2500000000),//2500M              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_pfd_hz	(36'd100000000),//100M              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_ref_hz	(36'd100000000),//100M              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_f_vco_hz	(36'd10000000000),//10G              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_fb_counter	(2'b01),                                               
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_feed_forward_gain	(8'b00001111),                                   
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_k_counter	(22'b0000000000000000000000),                            
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_l_counter	(6'b000100),                                             
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_m_counter	(9'b001111101),                                          
	//without PCIE//.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_n_counter	(6'b000001),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_l_counter	(6'b000100),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_m_counter	(9'd100),//100                                          
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_n_counter	(6'b000001),                                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_postdiv_sel	("TX_PLL_POSTDIV_SEL_SYNTH2"),                     
	.x_std_ipfluxtop_uxtop_wrap_0__tx_pll_refclk_select	("TX_PLL_REFCLK_SELECT_LOCAL_REFCLK"),//GLOBAL_REFCLK0"), //LOCAL_REFCLK"),         
	.x_std_ipfluxtop_uxtop_wrap_0__tx_postdiv_cdr_refclk_divider	(8'b00001100),                             
	.x_std_ipfluxtop_uxtop_wrap_0__tx_postdiv_cdr_refclk_hz	(36'b000000000000000000000000000000000000),      
	.x_std_ipfluxtop_uxtop_wrap_0__tx_postdiv_clk_divider	(8'b01100100),                                     
	.x_std_ipfluxtop_uxtop_wrap_0__tx_postdiv_clk_fractional_en	("TX_POSTDIV_CLK_FRACTIONAL_EN_DISABLE"),    
	.x_std_ipfluxtop_uxtop_wrap_0__tx_postdiv_clk_hz	(36'b000000000101111101011110000100000000),
    .x_std_ipfluxtop_uxtop_wrap_0__dpma_f_ref_hz        (36'd250000000),    
	.x_std_ipfluxtop_uxtop_wrap_0__tx_prbs_gen_en	("TX_PRBS_GEN_EN_DISABLE"),                                
	.x_std_ipfluxtop_uxtop_wrap_0__tx_prbs_pattern	(4'b1001),                                               
	//.x_std_ipfluxtop_uxtop_wrap_0__tx_preloaded_hardware_configs	("TX_PRELOADED_HARDWARE_CONFIGS_NONE"),    
	.x_std_ipfluxtop_uxtop_wrap_0__tx_preloaded_hardware_configs	("TX_PRELOADED_HARDWARE_CONFIGS_USB"),    
	.x_std_ipfluxtop_uxtop_wrap_0__tx_protocol_hint	("TX_PROTOCOL_HINT_DISABLED"),                           
  `ifdef __USE_SOF_SETTINGS__
	.x_std_ipfluxtop_uxtop_wrap_0__tx_sim_mode	("TX_SIM_MODE_DISABLE"),                                      
  `else
	.x_std_ipfluxtop_uxtop_wrap_0__tx_sim_mode	("TX_SIM_MODE_ENABLE"),                                      
  `endif
	.x_std_ipfluxtop_uxtop_wrap_0__tx_spread_spectrum_en	("TX_SPREAD_SPECTRUM_EN_DISABLE"),            
	.x_std_ipfluxtop_uxtop_wrap_0__tx_synthdiv_out_divider	(8'b00001100),                              
	.x_std_ipfluxtop_uxtop_wrap_0__tx_synthdiv_out_hz	(36'b000000000000000000000000000000000000),       
	.x_std_ipfluxtop_uxtop_wrap_0__tx_user_clk_only_mode	("TX_USER_CLK_ONLY_MODE_DISABLE"),            
	//.x_std_ipfluxtop_uxtop_wrap_0__tx_width	("TX_WIDTH_X32"),                                           
	.x_std_ipfluxtop_uxtop_wrap_0__tx_width	("TX_WIDTH_X16"),                                           
	//.x_std_ipfluxtop_uxtop_wrap_0__tx_word_clk_hz	(36'b000000010010101000000101111100100000),           
	.x_std_ipfluxtop_uxtop_wrap_0__tx_word_clk_hz	(36'd250000000),            
	.x_std_ipfluxtop_uxtop_wrap_0__usb_mode	("USB_MODE_USB3GEN1"),                                           //?? USB_MODE_USB3GEN1??

////these deskew related parameters are added to solve fitter CONSTRA errors , BUT deskew modules not in use for USBPHY
//	.x_std_sm_deskew_1ch_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),                                        
//	.x_std_sm_deskew_1ch_0__ehip_lb_tx_rx	("EHIP_LB_TX_RX_DISABLE"),                                        
//	.x_std_sm_deskew_1ch_0__ehip_lb_txmac_rx	("EHIP_LB_TXMAC_RX_DISABLE"),                                 
//	.x_std_sm_deskew_1ch_0__ehip_lb_txpcs_rx	("EHIP_LB_TXPCS_RX_DISABLE"),                                 
//	.x_std_sm_deskew_1ch_0__ptp_enable	("PTP_ENABLE_DISABLE"),                                             
//	.x_std_sm_deskew_1ch_0__rx_bond_location	("RX_BOND_LOCATION_UNUSED"),                                  
//	.x_std_sm_deskew_1ch_0__rx_bond_size	("RX_BOND_SIZE_UNUSED"),                                         
//	.x_std_sm_deskew_1ch_0__rx_dyn_mux	("RX_DYN_MUX_UNUSED"),                                             
//	.x_std_sm_deskew_1ch_0__rx_en	("FALSE"),                                                               
//	.x_std_sm_deskew_1ch_0__rx_pmadir_singlewidth_en	("RX_PMADIR_SINGLEWIDTH_EN_DISABLE"),
//	.x_std_sm_deskew_1ch_0__tx_bond_location	("TX_BOND_LOCATION_UNUSED"),
//	.x_std_sm_deskew_1ch_0__tx_bond_size	("TX_BOND_SIZE_UNUSED"),
//	.x_std_sm_deskew_1ch_0__tx_en	("FALSE"),
//	.x_std_sm_deskew_1ch_0__tx_mac_en	("FALSE"),
//	.x_std_sm_deskew_1ch_0__tx_pmadir_singlewidth_en	("TX_PMADIR_SINGLEWIDTH_EN_DISABLE"),
///////////////////////////////////////////////
	.x_std_sm_flux_ingress_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),                                   
  .x_std_sm_flux_ingress_0__flux_mode	("FLUX_MODE_FLUX_MODE_BYPASS"),                                
	.x_std_sm_flux_ingress_0__rx_dl_enable	("RX_DL_ENABLE_DISABLE"),                                  
	.x_std_sm_flux_ingress_0__rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),                    
	.x_std_sm_flux_ingress_0__rx_dl_rxbit_cntr_pma	("RX_DL_RXBIT_CNTR_PMA_DISABLE"),                   
	.x_std_sm_flux_ingress_0__rx_dl_rxbit_rollover	(18'b000000000000000000),                           
	.x_std_sm_flux_ingress_0__rx_fec_type_used	("RX_FEC_TYPE_USED_NONE"),                              
	.x_std_sm_flux_ingress_0__rx_protocol_hint	("RX_PROTOCOL_HINT_DISABLED"),                          
  `ifdef __USE_SOF_SETTINGS__
	.x_std_sm_flux_ingress_0__rx_sim_mode	("RX_SIM_MODE_DISABLE"),                                       
  `else
	.x_std_sm_flux_ingress_0__rx_sim_mode	("RX_SIM_MODE_ENABLE"),                                       
  `endif
	.x_std_sm_flux_ingress_0__rx_user1_clk_mux_dynamic_sel	("RX_USER1_CLK_MUX_DYNAMIC_SEL_OCK_PCS_RXWORD"),
	.x_std_sm_flux_ingress_0__rx_user2_clk_mux_dynamic_sel	("RX_USER2_CLK_MUX_DYNAMIC_SEL_OCK_PCS_RXWORD"),
	.x_std_sm_flux_ingress_0__sequencer_reg_en	("SEQUENCER_REG_EN_DISABLE"),                      
	.x_std_sm_flux_ingress_0__tx_bond_size	("TX_BOND_SIZE_X1"),                                   
	.x_std_sm_flux_ingress_0__tx_dl_enable	("TX_DL_ENABLE_DISABLE"),                              
  `ifdef __USE_SOF_SETTINGS__
	.x_std_sm_flux_ingress_0__tx_sim_mode	("TX_SIM_MODE_DISABLE"),                                      
  `else
	.x_std_sm_flux_ingress_0__tx_sim_mode	("TX_SIM_MODE_ENABLE"),                                      
  `endif
	.x_std_sm_flux_ingress_0__tx_user1_clk_mux_dynamic_sel	("TX_USER1_CLK_MUX_DYNAMIC_SEL_OCK_PCS_TXWORD_CLK"),    
	.x_std_sm_flux_ingress_0__tx_user2_clk_mux_dynamic_sel	("TX_USER2_CLK_MUX_DYNAMIC_SEL_OCK_PCS_TXWORD_CLK"),    

 //.x_std_sm_hssi_elane_pcs_1ch_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),                           
	//.x_std_sm_hssi_elane_pcs_1ch_0__duplex_mode	("DUPLEX_MODE_DUPLEX"),                               
	 //.x_std_sm_hssi_elane_pcs_1ch_0__fec_mode	("FEC_MODE_DISABLED"),                                     
	 //.x_std_sm_hssi_elane_pcs_1ch_0__fec_rx_en	("FALSE"),                                              
	 //.x_std_sm_hssi_elane_pcs_1ch_0__fec_tx_en	("FALSE"),                                              
	//.x_std_sm_hssi_elane_pcs_1ch_0__loopback_mode	("LOOPBACK_MODE_NO_LOOPBACK"),                      
	//.x_std_sm_hssi_elane_pcs_1ch_0__pcs_ber_mon_mode	("PCS_BER_MON_MODE_DISABLED"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__power_down_mode	("FALSE"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__rate_mode	("RATE_MODE_RATE_10G"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__rx_dyn_mux	("RX_DYN_MUX_UNUSED"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__rx_en	("FALSE"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__rx_pcs_mode	("RX_PCS_MODE_DISABLED"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__sim_mode	("SIM_MODE_ENABLE"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__sup_mode	("SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__tx_dyn_mux	("TX_DYN_MUX_UNUSED"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__tx_en	("FALSE"),
	//.x_std_sm_hssi_elane_pcs_1ch_0__tx_pcs_mode	("TX_PCS_MODE_DISABLED"),
	 //.x_std_sm_hssi_fec_ingress_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),
	 //.x_std_sm_hssi_fec_ingress_0__duplex_mode	("DUPLEX_MODE_DISABLED"),
	//.x_std_sm_hssi_fec_ingress_0__dyn_tx_mux	("DYN_TX_MUX_UNUSED"),
	//.x_std_sm_hssi_fec_ingress_0__fec_error	("FALSE"),
	 //.x_std_sm_hssi_fec_ingress_0__fec_mode	("FEC_MODE_DISABLED"),
	//.x_std_sm_hssi_fec_ingress_0__fec_spec	("FEC_SPEC_DISABLED"),
	 //.x_std_sm_hssi_fec_ingress_0__fracture	("FRACTURE_UNUSED"),
	 //.x_std_sm_hssi_fec_ingress_0__loopback_mode	("LOOPBACK_MODE_DISABLE"),
	//.x_std_sm_hssi_fec_ingress_0__pcs_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_ingress_0__pcs_tx_en	("FALSE"),
	 //.x_std_sm_hssi_fec_ingress_0__rx_en	("FALSE"),
	 //.x_std_sm_hssi_fec_ingress_0__sim_mode	("SIM_MODE_DISABLE"),
	 //.x_std_sm_hssi_fec_ingress_0__sup_mode	("SUP_MODE_USER_MODE"),
	 //.x_std_sm_hssi_fec_ingress_0__tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_dr_enabled	("CH0_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_duplex_mode	("CH0_DUPLEX_MODE_DUPLEX"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_dyn_tx_mux	("CH0_DYN_TX_MUX_UNUSED"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_fec_error	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_fec_mode	("CH0_FEC_MODE_RSFEC"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_fec_spec	("CH0_FEC_SPEC_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_fracture	("CH0_FRACTURE_F25G"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_loopback_mode	("CH0_LOOPBACK_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_pcs_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_pcs_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_sim_mode	("CH0_SIM_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_sup_mode	("CH0_SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_fec_wrap_0__ch0_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_dr_enabled	("CH1_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_duplex_mode	("CH1_DUPLEX_MODE_DUPLEX"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_dyn_tx_mux	("CH1_DYN_TX_MUX_UNUSED"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_fec_error	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_fec_mode	("CH1_FEC_MODE_RSFEC"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_fec_spec	("CH1_FEC_SPEC_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_fracture	("CH1_FRACTURE_F25G"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_loopback_mode	("CH1_LOOPBACK_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_pcs_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_pcs_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_sim_mode	("CH1_SIM_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_sup_mode	("CH1_SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_fec_wrap_0__ch1_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_dr_enabled	("CH2_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_duplex_mode	("CH2_DUPLEX_MODE_DUPLEX"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_dyn_tx_mux	("CH2_DYN_TX_MUX_UNUSED"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_fec_error	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_fec_mode	("CH2_FEC_MODE_RSFEC"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_fec_spec	("CH2_FEC_SPEC_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_fracture	("CH2_FRACTURE_F25G"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_loopback_mode	("CH2_LOOPBACK_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_pcs_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_pcs_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_sim_mode	("CH2_SIM_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_sup_mode	("CH2_SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_fec_wrap_0__ch2_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_dr_enabled	("CH3_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_duplex_mode	("CH3_DUPLEX_MODE_DUPLEX"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_dyn_tx_mux	("CH3_DYN_TX_MUX_UNUSED"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_fec_error	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_fec_mode	("CH3_FEC_MODE_RSFEC"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_fec_spec	("CH3_FEC_SPEC_DISABLED"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_fracture	("CH3_FRACTURE_F25G"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_loopback_mode	("CH3_LOOPBACK_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_pcs_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_pcs_tx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_rx_en	("FALSE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_sim_mode	("CH3_SIM_MODE_ENABLE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_sup_mode	("CH3_SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_fec_wrap_0__ch3_tx_en	("FALSE"),
	.x_std_sm_hssi_pcie_pcs_lane_0__pcie_pcs_mode	("PCIE_PCS_MODE_USB"),
	.x_std_sm_hssi_pcie_pcs_lane_0__pclk_clk_hz	(36'd250000000),//250M     
	.x_std_sm_hssi_pcie_pcs_lane_0__sris_enable	("SRIS_ENABLE_DISABLED"),
  //`ifndef __USE_SOF_SETTINGS__
	.x_std_sm_hssi_pcie_pcs_lane_0__hpstx_demux ("HPSTX_DEMUX_HPS_PCS2_ENABLED"),
	.x_std_sm_hssi_pcie_pcs_lane_0__hpsrx_mux ("HPSRX_MUX_HPS_PCS2_ENABLED"),
	.x_std_sm_hssi_pcie_pcs_lane_0__hps_clkmux ("HPS_CLKMUX_HPS_PCS2_ENABLED"),
  //`endif

	.x_std_sm_hssi_pld_chnl_dp_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__duplex_mode	("DUPLEX_MODE_DISABLED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__pld_channel_identifier	("PLD_CHANNEL_IDENTIFIER_GENERIC"),
	//.x_std_sm_hssi_pld_chnl_dp_0__rx_clkout1_divider	("RX_CLKOUT1_DIVIDER_DIV1"),
	//.x_std_sm_hssi_pld_chnl_dp_0__rx_clkout2_divider	("RX_CLKOUT2_DIVIDER_DIV1"),
	.x_std_sm_hssi_pld_chnl_dp_0__rx_en	("FALSE"),
	.x_std_sm_hssi_pld_chnl_dp_0__rx_fifo_mode	("RX_FIFO_MODE_DISABLED"),
	.x_std_sm_hssi_pld_chnl_dp_0__rx_fifo_width	("RX_FIFO_WIDTH_DISABLED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__rx_fifo_wr_clk_hz	(36'b000000000000000000000000000000000000),
	//.x_std_sm_hssi_pld_chnl_dp_0__rx_user1_clk_dynamic_mux	("RX_USER1_CLK_DYNAMIC_MUX_UNUSED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__rx_user2_clk_dynamic_mux	("RX_USER2_CLK_DYNAMIC_MUX_UNUSED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__sup_mode	("SUP_MODE_USER_MODE"),
	//.x_std_sm_hssi_pld_chnl_dp_0__tx_clkout1_divider	("TX_CLKOUT1_DIVIDER_DIV1"),
	//.x_std_sm_hssi_pld_chnl_dp_0__tx_clkout2_divider	("TX_CLKOUT2_DIVIDER_DIV1"),
  .x_std_sm_hssi_pld_chnl_dp_0__vc_rx_pldif_wm_en ("VC_RX_PLDIF_WM_EN_DISABLE"),
	.x_std_sm_hssi_pld_chnl_dp_0__tx_en	("FALSE"),
	.x_std_sm_hssi_pld_chnl_dp_0__tx_fifo_mode	("TX_FIFO_MODE_DISABLED"),
	//.x_std_sm_hssi_pld_chnl_dp_0__tx_fifo_rd_clk_hz	(36'b000000000000000000000000000000000000),
	.x_std_sm_hssi_pld_chnl_dp_0__tx_fifo_width	("TX_FIFO_WIDTH_DISABLED"),

	.x_std_sm_hssi_pld_chnl_dp_0__tx_user1_clk_dynamic_mux	("TX_USER1_CLK_DYNAMIC_MUX_UNUSED"),
	.x_std_sm_hssi_pld_chnl_dp_0__tx_user2_clk_dynamic_mux	("TX_USER2_CLK_DYNAMIC_MUX_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_dr_enabled	("CH0_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch0_flux_mode	("CH0_FLUX_MODE_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch0_lc_postdiv_sel	("CH0_LC_POSTDIV_SEL_SYNTH_FAST"),
	//.x_std_sm_ux_toolbox_0__ch0_loopback_mode	("CH0_LOOPBACK_MODE_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch0_rst_mux_static_sel	("CH0_RST_MUX_STATIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_enable	("CH0_RX_DL_ENABLE_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rxbit_cntr_pma	("CH0_RX_DL_RXBIT_CNTR_PMA_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rxbit_rollover	(18'b000000000000000000),
	//.x_std_sm_ux_toolbox_0__ch0_rx_fec_type_used	("CH0_RX_FEC_TYPE_USED_NONE"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_preloaded_hardware_configs	("CH0_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_protocol_hint	("CH0_RX_PROTOCOL_HINT_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_user1_clk_mux_dynamic_sel	("CH0_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_user2_clk_mux_dynamic_sel	("CH0_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_rx_width	("CH0_RX_WIDTH_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch0_sequencer_reg_en	("CH0_SEQUENCER_REG_EN_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_bond_size	("CH0_TX_BOND_SIZE_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_bonding_category	("CH0_TX_BONDING_CATEGORY_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_dl_enable	("CH0_TX_DL_ENABLE_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_preloaded_hardware_configs	("CH0_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_user1_clk_mux_dynamic_sel	("CH0_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_tx_user2_clk_mux_dynamic_sel	("CH0_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_dr_enabled	("CH1_DR_ENABLED_DR_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch1_flux_mode	("CH1_FLUX_MODE_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch1_lc_postdiv_sel	("CH1_LC_POSTDIV_SEL_SYNTH_FAST"),
	//.x_std_sm_ux_toolbox_0__ch1_loopback_mode	("CH1_LOOPBACK_MODE_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch1_rst_mux_static_sel	("CH1_RST_MUX_STATIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_dl_enable	("CH1_RX_DL_ENABLE_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),
	//.x_std_sm_ux_toolbox_0__ch1_rx_dl_rxbit_cntr_pma	("CH1_RX_DL_RXBIT_CNTR_PMA_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_dl_rxbit_rollover	(18'b000000000000000000),
	//.x_std_sm_ux_toolbox_0__ch1_rx_fec_type_used	("CH1_RX_FEC_TYPE_USED_NONE"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_preloaded_hardware_configs	("CH1_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_protocol_hint	("CH1_RX_PROTOCOL_HINT_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_user1_clk_mux_dynamic_sel	("CH1_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_user2_clk_mux_dynamic_sel	("CH1_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_rx_width	("CH1_RX_WIDTH_DISABLED"),
	//.x_std_sm_ux_toolbox_0__ch1_sequencer_reg_en	("CH1_SEQUENCER_REG_EN_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_bond_size	("CH1_TX_BOND_SIZE_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_bonding_category	("CH1_TX_BONDING_CATEGORY_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_dl_enable	("CH1_TX_DL_ENABLE_ENABLE"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_preloaded_hardware_configs	("CH1_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_user1_clk_mux_dynamic_sel	("CH1_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch1_tx_user2_clk_mux_dynamic_sel	("CH1_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),
	//.x_std_sm_ux_toolbox_0__ch0_dr_enabled	("CH0_DR_ENABLED_DR_ENABLED"),                                       
	//.x_std_sm_ux_toolbox_0__ch0_flux_mode	("CH0_FLUX_MODE_FLUX_MODE_BYPASS"),                                             
	//.x_std_sm_ux_toolbox_0__ch0_lc_postdiv_sel	("CH0_LC_POSTDIV_SEL_SYNTH2"),                                
	//.x_std_sm_ux_toolbox_0__ch0_loopback_mode	("CH0_LOOPBACK_MODE_DISABLED"),                                     //?? could not find in ED ??
	//.x_std_sm_ux_toolbox_0__ch0_rst_mux_static_sel	("CH0_RST_MUX_STATIC_SEL_HRC"),                            
	////.x_std_sm_ux_toolbox_0__ch0_rst_mux_static_sel	("CH0_RST_MUX_STATIC_SEL_UNUSED"),                            
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_enable	("CH0_RX_DL_ENABLE_DISABLE"),                                       
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),                             
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rxbit_cntr_pma	("CH0_RX_DL_RXBIT_CNTR_PMA_DISABLE"),                        
	//.x_std_sm_ux_toolbox_0__ch0_rx_dl_rxbit_rollover	(18'b000000000000000000),                                   
	//.x_std_sm_ux_toolbox_0__ch0_rx_fec_type_used	("CH0_RX_FEC_TYPE_USED_NONE"),                                  
	////.x_std_sm_ux_toolbox_0__ch0_rx_preloaded_hardware_configs	("CH0_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	//.x_std_sm_ux_toolbox_0__ch0_rx_preloaded_hardware_configs	("CH0_RX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	//.x_std_sm_ux_toolbox_0__ch0_rx_protocol_hint	("CH0_RX_PROTOCOL_HINT_DISABLED"),                              
	//.x_std_sm_ux_toolbox_0__ch0_rx_user1_clk_mux_dynamic_sel	("CH0_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch0_rx_user2_clk_mux_dynamic_sel	("CH0_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	////.x_std_sm_ux_toolbox_0__ch0_rx_width	("CH0_RX_WIDTH_DISABLED"),                                              
	//.x_std_sm_ux_toolbox_0__ch0_rx_width	("CH0_RX_WIDTH_X16"),                                              
	//.x_std_sm_ux_toolbox_0__ch0_sequencer_reg_en	("CH0_SEQUENCER_REG_EN_DISABLE"),                               
	//.x_std_sm_ux_toolbox_0__ch0_tx_bond_size	("CH0_TX_BOND_SIZE_X1"),                                        
	//.x_std_sm_ux_toolbox_0__ch0_tx_bonding_category	("CH0_TX_BONDING_CATEGORY_UNUSED"),                           //?? _LEADER ??
	//.x_std_sm_ux_toolbox_0__ch0_tx_dl_enable	("CH0_TX_DL_ENABLE_DISABLE"),                                        
	////.x_std_sm_ux_toolbox_0__ch0_tx_preloaded_hardware_configs	("CH0_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	//.x_std_sm_ux_toolbox_0__ch0_tx_preloaded_hardware_configs	("CH0_TX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	//.x_std_sm_ux_toolbox_0__ch0_tx_user1_clk_mux_dynamic_sel	("CH0_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch0_tx_user2_clk_mux_dynamic_sel	("CH0_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
///////////////////////////
	.x_std_sm_ux_toolbox_0__ch1_dr_enabled	("CH1_DR_ENABLED_DR_ENABLED"),                                       
	.x_std_sm_ux_toolbox_0__ch1_flux_mode	("CH1_FLUX_MODE_FLUX_MODE_BYPASS"),                                             
	.x_std_sm_ux_toolbox_0__ch1_lc_postdiv_sel	("CH1_LC_POSTDIV_SEL_SYNTH2"),                                
	.x_std_sm_ux_toolbox_0__ch1_loopback_mode	("CH1_LOOPBACK_MODE_DISABLED"),                                     //?? could not find in ED ??
	.x_std_sm_ux_toolbox_0__ch1_rst_mux_static_sel	("CH1_RST_MUX_STATIC_SEL_HRC"),                            
	//.x_std_sm_ux_toolbox_0__ch1_rst_mux_static_sel	("CH1_RST_MUX_STATIC_SEL_UNUSED"),                            
	.x_std_sm_ux_toolbox_0__ch1_rx_dl_enable	("CH1_RX_DL_ENABLE_DISABLE"),                                       
	.x_std_sm_ux_toolbox_0__ch1_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),                             
	.x_std_sm_ux_toolbox_0__ch1_rx_dl_rxbit_cntr_pma	("CH1_RX_DL_RXBIT_CNTR_PMA_DISABLE"),                        
	.x_std_sm_ux_toolbox_0__ch1_rx_dl_rxbit_rollover	(18'b000000000000000000),                                   
	.x_std_sm_ux_toolbox_0__ch1_rx_fec_type_used	("CH1_RX_FEC_TYPE_USED_NONE"),                                  
	//.x_std_sm_ux_toolbox_0__ch1_rx_preloaded_hardware_configs	("CH1_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	.x_std_sm_ux_toolbox_0__ch1_rx_preloaded_hardware_configs	("CH1_RX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	.x_std_sm_ux_toolbox_0__ch1_rx_protocol_hint	("CH1_RX_PROTOCOL_HINT_DISABLED"),                              
	.x_std_sm_ux_toolbox_0__ch1_rx_user1_clk_mux_dynamic_sel	("CH1_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	.x_std_sm_ux_toolbox_0__ch1_rx_user2_clk_mux_dynamic_sel	("CH1_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch1_rx_width	("CH1_RX_WIDTH_DISABLED"),                                              
	.x_std_sm_ux_toolbox_0__ch1_rx_width	("CH1_RX_WIDTH_X16"),                                              
	.x_std_sm_ux_toolbox_0__ch1_sequencer_reg_en	("CH1_SEQUENCER_REG_EN_DISABLE"),                               
	.x_std_sm_ux_toolbox_0__ch1_tx_bond_size	("CH1_TX_BOND_SIZE_X1"),                                        
	.x_std_sm_ux_toolbox_0__ch1_tx_bonding_category	("CH1_TX_BONDING_CATEGORY_UNUSED"),                           //?? _LEADER ??
	.x_std_sm_ux_toolbox_0__ch1_tx_dl_enable	("CH1_TX_DL_ENABLE_DISABLE"),                                        
	//.x_std_sm_ux_toolbox_0__ch1_tx_preloaded_hardware_configs	("CH1_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	.x_std_sm_ux_toolbox_0__ch1_tx_preloaded_hardware_configs	("CH1_TX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	.x_std_sm_ux_toolbox_0__ch1_tx_user1_clk_mux_dynamic_sel	("CH1_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	.x_std_sm_ux_toolbox_0__ch1_tx_user2_clk_mux_dynamic_sel	("CH1_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
///////////////////////////
	.x_std_sm_ux_toolbox_0__ch2_dr_enabled	("CH2_DR_ENABLED_DR_ENABLED"),                                       
	.x_std_sm_ux_toolbox_0__ch2_flux_mode	("CH2_FLUX_MODE_FLUX_MODE_BYPASS"),                                             
	.x_std_sm_ux_toolbox_0__ch2_lc_postdiv_sel	("CH2_LC_POSTDIV_SEL_SYNTH2"),                                
	.x_std_sm_ux_toolbox_0__ch2_loopback_mode	("CH2_LOOPBACK_MODE_DISABLED"),                                     //?? could not find in ED ??
	.x_std_sm_ux_toolbox_0__ch2_rst_mux_static_sel	("CH2_RST_MUX_STATIC_SEL_HRC"),                            
	//.x_std_sm_ux_toolbox_0__ch2_rst_mux_static_sel	("CH2_RST_MUX_STATIC_SEL_UNUSED"),                            
	.x_std_sm_ux_toolbox_0__ch2_rx_dl_enable	("CH2_RX_DL_ENABLE_DISABLE"),                                       
	.x_std_sm_ux_toolbox_0__ch2_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),                             
	.x_std_sm_ux_toolbox_0__ch2_rx_dl_rxbit_cntr_pma	("CH2_RX_DL_RXBIT_CNTR_PMA_DISABLE"),                        
	.x_std_sm_ux_toolbox_0__ch2_rx_dl_rxbit_rollover	(18'b000000000000000000),                                   
	.x_std_sm_ux_toolbox_0__ch2_rx_fec_type_used	("CH2_RX_FEC_TYPE_USED_NONE"),                                  
	//.x_std_sm_ux_toolbox_0__ch2_rx_preloaded_hardware_configs	("CH2_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	.x_std_sm_ux_toolbox_0__ch2_rx_preloaded_hardware_configs	("CH2_RX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	.x_std_sm_ux_toolbox_0__ch2_rx_protocol_hint	("CH2_RX_PROTOCOL_HINT_DISABLED"),                              
	.x_std_sm_ux_toolbox_0__ch2_rx_user1_clk_mux_dynamic_sel	("CH2_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	.x_std_sm_ux_toolbox_0__ch2_rx_user2_clk_mux_dynamic_sel	("CH2_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch2_rx_width	("CH2_RX_WIDTH_DISABLED"),                                              
	.x_std_sm_ux_toolbox_0__ch2_rx_width	("CH2_RX_WIDTH_X16"),                                              
	.x_std_sm_ux_toolbox_0__ch2_sequencer_reg_en	("CH2_SEQUENCER_REG_EN_DISABLE"),                               
	.x_std_sm_ux_toolbox_0__ch2_tx_bond_size	("CH2_TX_BOND_SIZE_X1"),                                        
	.x_std_sm_ux_toolbox_0__ch2_tx_bonding_category	("CH2_TX_BONDING_CATEGORY_UNUSED"),                           //?? _LEADER ??
	.x_std_sm_ux_toolbox_0__ch2_tx_dl_enable	("CH2_TX_DL_ENABLE_DISABLE"),                                        
	//.x_std_sm_ux_toolbox_0__ch2_tx_preloaded_hardware_configs	("CH2_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	.x_std_sm_ux_toolbox_0__ch2_tx_preloaded_hardware_configs	("CH2_TX_PRELOADED_HARDWARE_CONFIGS_USB"),         
	.x_std_sm_ux_toolbox_0__ch2_tx_user1_clk_mux_dynamic_sel	("CH2_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	.x_std_sm_ux_toolbox_0__ch2_tx_user2_clk_mux_dynamic_sel	("CH2_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
///////////////////////////
	//.x_std_sm_ux_toolbox_0__ch3_dr_enabled	("CH3_DR_ENABLED_DR_ENABLED"),                                       
	//.x_std_sm_ux_toolbox_0__ch3_flux_mode	("CH3_FLUX_MODE_DISABLED"),                                             
	//.x_std_sm_ux_toolbox_0__ch3_lc_postdiv_sel	("CH3_LC_POSTDIV_SEL_SYNTH2"),                                
	//.x_std_sm_ux_toolbox_0__ch3_loopback_mode	("CH3_LOOPBACK_MODE_DISABLED"),                                     //?? could not find in ED ??
	//.x_std_sm_ux_toolbox_0__ch3_rst_mux_static_sel	("CH3_RST_MUX_STATIC_SEL_HRC"),                            
	////.x_std_sm_ux_toolbox_0__ch3_rst_mux_static_sel	("CH3_RST_MUX_STATIC_SEL_UNUSED"),                            
	//.x_std_sm_ux_toolbox_0__ch3_rx_dl_enable	("CH3_RX_DL_ENABLE_DISABLE"),                                       
	//.x_std_sm_ux_toolbox_0__ch3_rx_dl_rx_lat_bit_for_async	(18'b000000000000000000),                             
	//.x_std_sm_ux_toolbox_0__ch3_rx_dl_rxbit_cntr_pma	("CH3_RX_DL_RXBIT_CNTR_PMA_DISABLE"),                        
	//.x_std_sm_ux_toolbox_0__ch3_rx_dl_rxbit_rollover	(18'b000000000000000000),                                   
	//.x_std_sm_ux_toolbox_0__ch3_rx_fec_type_used	("CH3_RX_FEC_TYPE_USED_NONE"),                                  
	////.x_std_sm_ux_toolbox_0__ch3_rx_preloaded_hardware_configs	("CH3_RX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	//.x_std_sm_ux_toolbox_0__ch3_rx_preloaded_hardware_configs	("CH3_RX_PRELOADED_HARDWARE_CONFIGS_PCIE"),         
	//.x_std_sm_ux_toolbox_0__ch3_rx_protocol_hint	("CH3_RX_PROTOCOL_HINT_DISABLED"),                              
	//.x_std_sm_ux_toolbox_0__ch3_rx_user1_clk_mux_dynamic_sel	("CH3_RX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch3_rx_user2_clk_mux_dynamic_sel	("CH3_RX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	////.x_std_sm_ux_toolbox_0__ch3_rx_width	("CH3_RX_WIDTH_DISABLED"),                                              
	//.x_std_sm_ux_toolbox_0__ch3_rx_width	("CH3_RX_WIDTH_X20"),                                              
	//.x_std_sm_ux_toolbox_0__ch3_sequencer_reg_en	("CH3_SEQUENCER_REG_EN_ENABLE"),                               
	//.x_std_sm_ux_toolbox_0__ch3_tx_bond_size	("CH3_TX_BOND_SIZE_X1"),                                        
	//.x_std_sm_ux_toolbox_0__ch3_tx_bonding_category	("CH3_TX_BONDING_CATEGORY_UNUSED"),                           //?? _LEADER ??
	//.x_std_sm_ux_toolbox_0__ch3_tx_dl_enable	("CH3_TX_DL_ENABLE_DISABLE"),                                        
	////.x_std_sm_ux_toolbox_0__ch3_tx_preloaded_hardware_configs	("CH3_TX_PRELOADED_HARDWARE_CONFIGS_NONE"),         
	//.x_std_sm_ux_toolbox_0__ch3_tx_preloaded_hardware_configs	("CH3_TX_PRELOADED_HARDWARE_CONFIGS_PCIE"),         
	//.x_std_sm_ux_toolbox_0__ch3_tx_user1_clk_mux_dynamic_sel	("CH3_TX_USER1_CLK_MUX_DYNAMIC_SEL_UNUSED"),        
	//.x_std_sm_ux_toolbox_0__ch3_tx_user2_clk_mux_dynamic_sel	("CH3_TX_USER2_CLK_MUX_DYNAMIC_SEL_UNUSED"),        

	.x_std_sm_xcvrif_1ch_0__dr_enabled	("DR_ENABLED_DR_DISABLED"),                    
	.x_std_sm_xcvrif_1ch_0__duplex_mode	("DUPLEX_MODE_DUPLEX"),                        
	.x_std_sm_xcvrif_1ch_0__eth_rx_clk_hz	(36'b000000010011001101010110001000011001),  
	.x_std_sm_xcvrif_1ch_0__eth_tx_clk_hz	(36'b000000010011001101010110001000011001),  
	.x_std_sm_xcvrif_1ch_0__loopback_mode	("LOOPBACK_MODE_DISABLE"),                   
	.x_std_sm_xcvrif_1ch_0__rx_bond_size	("RX_BOND_SIZE_UNUSED"),                         
	.x_std_sm_xcvrif_1ch_0__rx_bonding_mode	("RX_BONDING_MODE_UNUSED"),                    
	.x_std_sm_xcvrif_1ch_0__rx_dl_enable	("RX_DL_ENABLE_DISABLE"),                       
	.x_std_sm_xcvrif_1ch_0__rx_en	("FALSE"),                                               
	.x_std_sm_xcvrif_1ch_0__rx_fifo_mode	("RX_FIFO_MODE_DISABLED"),                     //?? RX_FIFO_MODE_PHASE_COMP ??
	.x_std_sm_xcvrif_1ch_0__rx_fifo_rd_en_dynamic_mux	("RX_FIFO_RD_EN_DYNAMIC_MUX_X1"),
	.x_std_sm_xcvrif_1ch_0__rx_gb_width	("RX_GB_WIDTH_DISABLED"),                          
	.x_std_sm_xcvrif_1ch_0__rx_word_clk_dynamic_mux	("RX_WORD_CLK_DYNAMIC_MUX_RXWORD_CLK"),
	.x_std_sm_xcvrif_1ch_0__sim_mode	("SIM_MODE_ENABLE"),                             
	.x_std_sm_xcvrif_1ch_0__sup_mode	("SUP_MODE_USER_MODE"),                          
	.x_std_sm_xcvrif_1ch_0__tx_bond_size	("TX_BOND_SIZE_UNUSED"),                         
	.x_std_sm_xcvrif_1ch_0__tx_bonding_mode	("TX_BONDING_MODE_UNUSED"),                    
	.x_std_sm_xcvrif_1ch_0__tx_dl_enable	("TX_DL_ENABLE_DISABLE"),                        
	.x_std_sm_xcvrif_1ch_0__tx_dynamic_mux	("TX_DYNAMIC_MUX_DESKEW"),                     
	.x_std_sm_xcvrif_1ch_0__tx_en	("FALSE"),                                               
	.x_std_sm_xcvrif_1ch_0__tx_fifo_mode	("TX_FIFO_MODE_DISABLED"),                     //?? TX_FIFO_MODE_PHASE_COMP ??
	.x_std_sm_xcvrif_1ch_0__tx_fifo_rd_en_dynamic_mux	("TX_FIFO_RD_EN_DYNAMIC_MUX_X1"),
	.x_std_sm_xcvrif_1ch_0__tx_gb_width	("TX_GB_WIDTH_DISABLED"),                      
	.x_std_sm_xcvrif_1ch_0__tx_rst_dynamic_mux	("TX_RST_DYNAMIC_MUX_X1"),             
	.x_std_sm_xcvrif_1ch_0__tx_word_clk_dynamic_mux	("TX_WORD_CLK_DYNAMIC_MUX_UNUSED"),    
	.x_std_sm_xcvrif_1ch_0__xcvr_rxword_clk_hz	(36'b000000001011101001000011101101110100),
	.x_std_sm_xcvrif_1ch_0__xcvr_txword_clk_hz	(36'b000000001011101001000011101101110100) 
                                                                                         
) U_ch2_core (

   // PHY Interfaces
	.x_std_ipfluxtop_flux_core_shim_wrap_0__iflux_ext_cpu_fast_clk(i_pma_cpu_clk),
	//.x_std_sm_flux_ingress_0__i_dpma_refclk(i_pma_cpu_clk),
	.x_std_ipfluxtop_uxtop_wrap_0__iflux_xia_rx_n_l0_ux(i_rx_serial_n),
	.x_std_ipfluxtop_uxtop_wrap_0__iflux_xia_rx_p_l0_ux(i_rx_serial_p),
	//.x_std_ipfluxtop_uxtop_wrap_0__ioack_hsref_left_n_ux_bidir_in(i_refclk_n),
	.x_std_ipfluxtop_uxtop_wrap_0__ioack_hsref_left_p_ux_bidir_in(i_refclk_p),
  //.x_std_ipfluxtop_uxtop_wrap_0__ioack_ref_left_n_ux_bidir_in({5'hz, i_refclk_n}),
  //.x_std_ipfluxtop_uxtop_wrap_0__ioack_ref_left_p_ux_bidir_in({5'hz, i_refclk_p}),
	.x_std_ipfluxtop_uxtop_wrap_0__oflux_xoa_tx_n_l0_ux(o_tx_serial_n),
	.x_std_ipfluxtop_uxtop_wrap_0__oflux_xoa_tx_p_l0_ux(o_tx_serial_p),

   // PIPE Interfaces
  .x_mux_sm_hssi_pcie_pcs_rst_mux_0__i_hps_rst_rstn(i_usb31_pipe_reset_n),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdeemph({16'd0,i_usb31_pipe_TxDeEmphasis}),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_pclk_rate(3'b001),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rate(i_usb31_pipe_Rate),
	//.[2:0] x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxpresethint(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txmargin(3'b000),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_width(3'b001),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdata({24'd0,i_usb31_pipe_TxData}),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_phy_mode_nt(4'd1),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_powerdown(i_usb31_pipe_PowerDown),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdatak({2'd0,i_usb31_pipe_TxDataK}),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txsyncheader(4'd0),
	//.[4:0] x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_localpresetindex(),
	//.[5:0] x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_fs(),
	//.[5:0] x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_lf(),
	//.[7:0] x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_m2p_bus(),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_pcs_pclk(o_usb31_pipe_clk),
  //`ifdef RTLSIM
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_pclk_rate(3'b001),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txmargin(3'b000),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_width(3'b001),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_phy_mode_nt(4'd1),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txsyncheader(4'd0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_blockaligncontrol(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_encodedecodebypass(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txcompliance(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdatavalid(1'b0), 
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txstartblock(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txswing(1'b0),
  //`endif
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_asyncpowerchangeack(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_blockaligncontrol(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_cfg_hw_auto_sp_dis(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_dirchange(),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_ebuf_mode(i_usb31_pipe_ElasBufferMode),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_encodedecodebypass(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_getlocalpresetcoefficients(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_invalidrequest(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_lowpin_nt(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_pclkchangeack(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxelecidle_disable_a(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxeqclr(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxeqeval(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxeqinprogress(),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxeqtraining(i_usb31_pipe_RxEqTrain),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxpolarity(i_usb31_pipe_RxPolarity),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxstandby(),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_rxtermination(i_usb31_pipe_RxTermination),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_srisenable(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txcmnmode_disable_a(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txcompliance(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdatavalid(1'b0), //TBD ??
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txdtctrx_lb(i_usb31_pipe_TxDetectRxLoopback),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txelecidle(i_usb31_pipe_TxElecidle),
	.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txoneszeros(i_usb31_pipe_TxOnesZeros),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txstartblock(1'b0),
	//.x_std_sm_hssi_pcie_pcs_lane_0__i_txpipe_txswing(1'b0),

	//.[17:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_localtxpresetcoefficients(),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxstatus(o_usb31_pipe_Rxstatus),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxdata({o_usb31_pipe_RxData_blank,o_usb31_pipe_RxData}),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxdatak({o_usb31_pipe_RxDataK_blank,o_usb31_pipe_RxDataK}),
	//.[3:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxsyncheader(),
	//.[5:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_dirfeedback(),
	//.[5:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_localfs(),
	//.[5:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_locallf(),
	//.[7:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_linkevaluationfeedbackfiguremerit(),
	//.[7:0] x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_p2m_bus(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxstartblock(),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_pcs_pclk(o_usb31_pipe_clk),
	//.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_localtxcoefficientsvalid(),
	//.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_pclkchangeok(),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_phystatus(o_usb31_pipe_PhyStatus),
	//.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxdatavalid(o_usb31_pipe_RxValid),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxvalid(o_usb31_pipe_RxValid),
	.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxelecidlea(o_usb31_pipe_RxElecidle),
	//.x_std_sm_hssi_pcie_pcs_lane_0__o_rxpipe_rxstandbystatus(),

  //.x_std_sm_hssi_pld_chnl_dp_0__i_hio_uxquad_async(80'd0),//All bits to zero ? TBD
    .x_std_sm_hssi_pld_chnl_dp_0__i_hio_pld_reset_clk_row(osc_clk),
  
  	.x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_rstn(!i_reconfig_reset),
  	.x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_clk(i_reconfig_clk),
  	.x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_read(i_reconfig_read),
  	.x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_write(i_reconfig_write),
    .x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_addr(i_reconfig_address),
    .x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_wdata(i_reconfig_writedata),
    .x_std_sm_hssi_pld_chnl_dp_0__i_hio_lavmm_be(i_reconfig_byteenable),
    .x_std_sm_hssi_pld_chnl_dp_0__o_hio_lavmm_rdata(o_reconfig_readdata),
    .x_std_sm_hssi_pld_chnl_dp_0__o_hio_lavmm_rdata_valid(o_reconfig_readdatavalid),
    .x_std_sm_hssi_pld_chnl_dp_0__o_hio_lavmm_waitreq(o_reconfig_waitrequest)
);

endmodule

