// system.v

// Generated using ACDS version 25.3.1 100

`timescale 1 ps / 1 ps
module system (
		input  wire        clk_clk,                                                  //                                              clk.clk
		input  wire        i2c_i2c_serial_sda_in,                                    //                                   i2c_i2c_serial.sda_in
		input  wire        i2c_i2c_serial_scl_in,                                    //                                                 .scl_in
		output wire        i2c_i2c_serial_sda_oe,                                    //                                                 .sda_oe
		output wire        i2c_i2c_serial_scl_oe,                                    //                                                 .scl_oe
		output wire        hdmi_clk_clk,                                             //                                         hdmi_clk.clk
		output wire        csi2_axi4_clk_clk,                                        //                                    csi2_axi4_clk.clk
		output wire        dphy_clk_clk,                                             //                                         dphy_clk.clk
		output wire        pio_cam_gpio_external_connection_export,                  //                 pio_cam_gpio_external_connection.export
		input  wire        pio_hdmi_config_done_external_connection_export,          //         pio_hdmi_config_done_external_connection.export
		input  wire [1:0]  pio_key_external_connection_export,                       //                      pio_key_external_connection.export
		output wire [7:0]  pio_led_external_connection_export,                       //                      pio_led_external_connection.export
		input  wire        pio_mem_ready_external_connection_export,                 //                pio_mem_ready_external_connection.export
		input  wire [3:0]  pio_switch_external_connection_export,                    //                   pio_switch_external_connection.export
		output wire        pio_vvp_reset_n_external_connection_export,               //              pio_vvp_reset_n_external_connection.export
		input  wire        reset_n_reset_n,                                          //                                          reset_n.reset_n
		input  wire        reset_in_vvp_in_reset_reset_n,                            //                            reset_in_vvp_in_reset.reset_n
		input  wire        vvp_system_clock_in_csi2_in_clk_clk,                      //                  vvp_system_clock_in_csi2_in_clk.clk
		output wire        vvp_system_emif_io96b_lpddr4a_s0_axi4_ctrl_ready_reset_n, // vvp_system_emif_io96b_lpddr4a_s0_axi4_ctrl_ready.reset_n
		output wire [1:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_cs,               //              vvp_system_emif_io96b_lpddr4a_mem_0.mem_cs
		output wire [5:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_ca,               //                                                 .mem_ca
		output wire [1:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_cke,              //                                                 .mem_cke
		inout  wire [31:0] vvp_system_emif_io96b_lpddr4a_mem_0_mem_dq,               //                                                 .mem_dq
		inout  wire [3:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_t,            //                                                 .mem_dqs_t
		inout  wire [3:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_c,            //                                                 .mem_dqs_c
		inout  wire [3:0]  vvp_system_emif_io96b_lpddr4a_mem_0_mem_dmi,              //                                                 .mem_dmi
		output wire [0:0]  vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_t,          //           vvp_system_emif_io96b_lpddr4a_mem_ck_0.mem_ck_t
		output wire [0:0]  vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_c,          //                                                 .mem_ck_c
		output wire        vvp_system_emif_io96b_lpddr4a_mem_reset_n_mem_reset_n,    //        vvp_system_emif_io96b_lpddr4a_mem_reset_n.mem_reset_n
		input  wire        vvp_system_emif_io96b_lpddr4a_oct_0_oct_rzqin,            //              vvp_system_emif_io96b_lpddr4a_oct_0.oct_rzqin
		input  wire        vvp_system_emif_io96b_lpddr4a_ref_clk_clk,                //            vvp_system_emif_io96b_lpddr4a_ref_clk.clk
		output wire        vvp_system_intel_vvp_cvo_vid_status_vid_locked,           //              vvp_system_intel_vvp_cvo_vid_status.vid_locked
		output wire        vvp_system_intel_vvp_cvo_vid_status_vid_is_full,          //                                                 .vid_is_full
		output wire        vvp_system_intel_vvp_cvo_vid_status_vid_stall_error,      //                                                 .vid_stall_error
		output wire        vvp_system_intel_vvp_cvo_vid_status_vid_size_mismatch,    //                                                 .vid_size_mismatch
		input  wire        vvp_system_intel_vvp_cvo_frame_start_conduit,             //             vvp_system_intel_vvp_cvo_frame_start.conduit
		input  wire [63:0] vvp_system_intel_vvp_demosaic_axi4s_vid_in_tdata,         //       vvp_system_intel_vvp_demosaic_axi4s_vid_in.tdata
		input  wire        vvp_system_intel_vvp_demosaic_axi4s_vid_in_tvalid,        //                                                 .tvalid
		output wire        vvp_system_intel_vvp_demosaic_axi4s_vid_in_tready,        //                                                 .tready
		input  wire        vvp_system_intel_vvp_demosaic_axi4s_vid_in_tlast,         //                                                 .tlast
		input  wire [7:0]  vvp_system_intel_vvp_demosaic_axi4s_vid_in_tuser,         //                                                 .tuser
		output wire        vvp_system_intel_vvp_fr2cv_cv_clk_out_clk,                //            vvp_system_intel_vvp_fr2cv_cv_clk_out.clk
		output wire [23:0] vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_data,           //            vvp_system_intel_vvp_fr2cv_cv_vid_out.vid_data
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_underflow,          //                                                 .underflow
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_datavalid,      //                                                 .vid_datavalid
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v_sync,         //                                                 .vid_v_sync
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h_sync,         //                                                 .vid_h_sync
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_f,              //                                                 .vid_f
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h,              //                                                 .vid_h
		output wire        vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v               //                                                 .vid_v
	);

	wire         clock_in_out_clk_clk;                                            // clock_in:out_clk -> [iopll_hdmi:refclk, iopll_sys:refclk, reset_in_vvp:clk]
	wire         iopll_sys_outclk0_clk;                                           // iopll_sys:outclk_0 -> [i2c:clk, intel_niosv_g:clk, intel_onchip_memory:clk, irq_mapper:clk, jtag_uart:clk, mm_interconnect_0:iopll_sys_outclk0_clk, pio_cam_gpio:clk, pio_hdmi_config_done:clk, pio_key:clk, pio_led:clk, pio_mem_ready:clk, pio_switch:clk, pio_vvp_reset_n:clk, rst_controller:clk, rst_controller_001:clk, rst_controller_004:clk, sysid_qsys:clock, timer:clk, vvp_system:clock_in_control_in_clk_clk]
	wire         iopll_hdmi_outclk0_clk;                                          // iopll_hdmi:outclk_0 -> vvp_system:clock_in_hdmi_in_clk_clk
	wire         iopll_sys_outclk3_clk;                                           // iopll_sys:outclk_3 -> [rst_controller_002:clk, rst_controller_003:clk, vvp_system:clock_in_vid_in_clk_1_clk]
	wire         iopll_sys_outclk4_clk;                                           // iopll_sys:outclk_4 -> vvp_system:clock_in_mem_in_clk_clk
	wire         reset_in_out_reset_reset;                                        // reset_in:out_reset_n -> [iopll_hdmi:rst, iopll_sys:rst, rst_controller:reset_in0, rst_controller_001:reset_in1, rst_controller_002:reset_in0, rst_controller_004:reset_in0]
	wire   [7:0] intel_niosv_g_data_manager_arlen;                                // intel_niosv_g:data_manager_arlen -> mm_interconnect_0:intel_niosv_g_data_manager_arlen
	wire   [3:0] intel_niosv_g_data_manager_wstrb;                                // intel_niosv_g:data_manager_wstrb -> mm_interconnect_0:intel_niosv_g_data_manager_wstrb
	wire         intel_niosv_g_data_manager_wready;                               // mm_interconnect_0:intel_niosv_g_data_manager_wready -> intel_niosv_g:data_manager_wready
	wire         intel_niosv_g_data_manager_rready;                               // intel_niosv_g:data_manager_rready -> mm_interconnect_0:intel_niosv_g_data_manager_rready
	wire   [7:0] intel_niosv_g_data_manager_awlen;                                // intel_niosv_g:data_manager_awlen -> mm_interconnect_0:intel_niosv_g_data_manager_awlen
	wire         intel_niosv_g_data_manager_wvalid;                               // intel_niosv_g:data_manager_wvalid -> mm_interconnect_0:intel_niosv_g_data_manager_wvalid
	wire  [31:0] intel_niosv_g_data_manager_araddr;                               // intel_niosv_g:data_manager_araddr -> mm_interconnect_0:intel_niosv_g_data_manager_araddr
	wire   [2:0] intel_niosv_g_data_manager_arprot;                               // intel_niosv_g:data_manager_arprot -> mm_interconnect_0:intel_niosv_g_data_manager_arprot
	wire   [2:0] intel_niosv_g_data_manager_awprot;                               // intel_niosv_g:data_manager_awprot -> mm_interconnect_0:intel_niosv_g_data_manager_awprot
	wire  [31:0] intel_niosv_g_data_manager_wdata;                                // intel_niosv_g:data_manager_wdata -> mm_interconnect_0:intel_niosv_g_data_manager_wdata
	wire         intel_niosv_g_data_manager_arvalid;                              // intel_niosv_g:data_manager_arvalid -> mm_interconnect_0:intel_niosv_g_data_manager_arvalid
	wire  [31:0] intel_niosv_g_data_manager_awaddr;                               // intel_niosv_g:data_manager_awaddr -> mm_interconnect_0:intel_niosv_g_data_manager_awaddr
	wire   [1:0] intel_niosv_g_data_manager_bresp;                                // mm_interconnect_0:intel_niosv_g_data_manager_bresp -> intel_niosv_g:data_manager_bresp
	wire         intel_niosv_g_data_manager_arready;                              // mm_interconnect_0:intel_niosv_g_data_manager_arready -> intel_niosv_g:data_manager_arready
	wire  [31:0] intel_niosv_g_data_manager_rdata;                                // mm_interconnect_0:intel_niosv_g_data_manager_rdata -> intel_niosv_g:data_manager_rdata
	wire         intel_niosv_g_data_manager_awready;                              // mm_interconnect_0:intel_niosv_g_data_manager_awready -> intel_niosv_g:data_manager_awready
	wire   [2:0] intel_niosv_g_data_manager_arsize;                               // intel_niosv_g:data_manager_arsize -> mm_interconnect_0:intel_niosv_g_data_manager_arsize
	wire         intel_niosv_g_data_manager_bready;                               // intel_niosv_g:data_manager_bready -> mm_interconnect_0:intel_niosv_g_data_manager_bready
	wire         intel_niosv_g_data_manager_rlast;                                // mm_interconnect_0:intel_niosv_g_data_manager_rlast -> intel_niosv_g:data_manager_rlast
	wire         intel_niosv_g_data_manager_wlast;                                // intel_niosv_g:data_manager_wlast -> mm_interconnect_0:intel_niosv_g_data_manager_wlast
	wire   [1:0] intel_niosv_g_data_manager_rresp;                                // mm_interconnect_0:intel_niosv_g_data_manager_rresp -> intel_niosv_g:data_manager_rresp
	wire         intel_niosv_g_data_manager_bvalid;                               // mm_interconnect_0:intel_niosv_g_data_manager_bvalid -> intel_niosv_g:data_manager_bvalid
	wire   [2:0] intel_niosv_g_data_manager_awsize;                               // intel_niosv_g:data_manager_awsize -> mm_interconnect_0:intel_niosv_g_data_manager_awsize
	wire         intel_niosv_g_data_manager_awvalid;                              // intel_niosv_g:data_manager_awvalid -> mm_interconnect_0:intel_niosv_g_data_manager_awvalid
	wire         intel_niosv_g_data_manager_rvalid;                               // mm_interconnect_0:intel_niosv_g_data_manager_rvalid -> intel_niosv_g:data_manager_rvalid
	wire   [1:0] intel_niosv_g_instruction_manager_awburst;                       // intel_niosv_g:instruction_manager_awburst -> mm_interconnect_0:intel_niosv_g_instruction_manager_awburst
	wire   [7:0] intel_niosv_g_instruction_manager_arlen;                         // intel_niosv_g:instruction_manager_arlen -> mm_interconnect_0:intel_niosv_g_instruction_manager_arlen
	wire   [3:0] intel_niosv_g_instruction_manager_wstrb;                         // intel_niosv_g:instruction_manager_wstrb -> mm_interconnect_0:intel_niosv_g_instruction_manager_wstrb
	wire         intel_niosv_g_instruction_manager_wready;                        // mm_interconnect_0:intel_niosv_g_instruction_manager_wready -> intel_niosv_g:instruction_manager_wready
	wire         intel_niosv_g_instruction_manager_rready;                        // intel_niosv_g:instruction_manager_rready -> mm_interconnect_0:intel_niosv_g_instruction_manager_rready
	wire   [7:0] intel_niosv_g_instruction_manager_awlen;                         // intel_niosv_g:instruction_manager_awlen -> mm_interconnect_0:intel_niosv_g_instruction_manager_awlen
	wire         intel_niosv_g_instruction_manager_wvalid;                        // intel_niosv_g:instruction_manager_wvalid -> mm_interconnect_0:intel_niosv_g_instruction_manager_wvalid
	wire  [31:0] intel_niosv_g_instruction_manager_araddr;                        // intel_niosv_g:instruction_manager_araddr -> mm_interconnect_0:intel_niosv_g_instruction_manager_araddr
	wire   [2:0] intel_niosv_g_instruction_manager_arprot;                        // intel_niosv_g:instruction_manager_arprot -> mm_interconnect_0:intel_niosv_g_instruction_manager_arprot
	wire   [2:0] intel_niosv_g_instruction_manager_awprot;                        // intel_niosv_g:instruction_manager_awprot -> mm_interconnect_0:intel_niosv_g_instruction_manager_awprot
	wire  [31:0] intel_niosv_g_instruction_manager_wdata;                         // intel_niosv_g:instruction_manager_wdata -> mm_interconnect_0:intel_niosv_g_instruction_manager_wdata
	wire         intel_niosv_g_instruction_manager_arvalid;                       // intel_niosv_g:instruction_manager_arvalid -> mm_interconnect_0:intel_niosv_g_instruction_manager_arvalid
	wire  [31:0] intel_niosv_g_instruction_manager_awaddr;                        // intel_niosv_g:instruction_manager_awaddr -> mm_interconnect_0:intel_niosv_g_instruction_manager_awaddr
	wire   [1:0] intel_niosv_g_instruction_manager_bresp;                         // mm_interconnect_0:intel_niosv_g_instruction_manager_bresp -> intel_niosv_g:instruction_manager_bresp
	wire         intel_niosv_g_instruction_manager_arready;                       // mm_interconnect_0:intel_niosv_g_instruction_manager_arready -> intel_niosv_g:instruction_manager_arready
	wire  [31:0] intel_niosv_g_instruction_manager_rdata;                         // mm_interconnect_0:intel_niosv_g_instruction_manager_rdata -> intel_niosv_g:instruction_manager_rdata
	wire         intel_niosv_g_instruction_manager_awready;                       // mm_interconnect_0:intel_niosv_g_instruction_manager_awready -> intel_niosv_g:instruction_manager_awready
	wire   [1:0] intel_niosv_g_instruction_manager_arburst;                       // intel_niosv_g:instruction_manager_arburst -> mm_interconnect_0:intel_niosv_g_instruction_manager_arburst
	wire   [2:0] intel_niosv_g_instruction_manager_arsize;                        // intel_niosv_g:instruction_manager_arsize -> mm_interconnect_0:intel_niosv_g_instruction_manager_arsize
	wire         intel_niosv_g_instruction_manager_bready;                        // intel_niosv_g:instruction_manager_bready -> mm_interconnect_0:intel_niosv_g_instruction_manager_bready
	wire         intel_niosv_g_instruction_manager_rlast;                         // mm_interconnect_0:intel_niosv_g_instruction_manager_rlast -> intel_niosv_g:instruction_manager_rlast
	wire         intel_niosv_g_instruction_manager_wlast;                         // intel_niosv_g:instruction_manager_wlast -> mm_interconnect_0:intel_niosv_g_instruction_manager_wlast
	wire   [1:0] intel_niosv_g_instruction_manager_rresp;                         // mm_interconnect_0:intel_niosv_g_instruction_manager_rresp -> intel_niosv_g:instruction_manager_rresp
	wire         intel_niosv_g_instruction_manager_bvalid;                        // mm_interconnect_0:intel_niosv_g_instruction_manager_bvalid -> intel_niosv_g:instruction_manager_bvalid
	wire   [2:0] intel_niosv_g_instruction_manager_awsize;                        // intel_niosv_g:instruction_manager_awsize -> mm_interconnect_0:intel_niosv_g_instruction_manager_awsize
	wire         intel_niosv_g_instruction_manager_awvalid;                       // intel_niosv_g:instruction_manager_awvalid -> mm_interconnect_0:intel_niosv_g_instruction_manager_awvalid
	wire         intel_niosv_g_instruction_manager_rvalid;                        // mm_interconnect_0:intel_niosv_g_instruction_manager_rvalid -> intel_niosv_g:instruction_manager_rvalid
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;        // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;          // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest;       // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;           // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;              // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;             // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;         // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_sysid_qsys_control_slave_readdata;             // sysid_qsys:readdata -> mm_interconnect_0:sysid_qsys_control_slave_readdata
	wire   [0:0] mm_interconnect_0_sysid_qsys_control_slave_address;              // mm_interconnect_0:sysid_qsys_control_slave_address -> sysid_qsys:address
	wire  [31:0] mm_interconnect_0_i2c_csr_readdata;                              // i2c:readdata -> mm_interconnect_0:i2c_csr_readdata
	wire   [3:0] mm_interconnect_0_i2c_csr_address;                               // mm_interconnect_0:i2c_csr_address -> i2c:addr
	wire         mm_interconnect_0_i2c_csr_read;                                  // mm_interconnect_0:i2c_csr_read -> i2c:read
	wire         mm_interconnect_0_i2c_csr_write;                                 // mm_interconnect_0:i2c_csr_write -> i2c:write
	wire  [31:0] mm_interconnect_0_i2c_csr_writedata;                             // mm_interconnect_0:i2c_csr_writedata -> i2c:writedata
	wire  [31:0] mm_interconnect_0_intel_niosv_g_dm_agent_readdata;               // intel_niosv_g:dm_agent_readdata -> mm_interconnect_0:intel_niosv_g_dm_agent_readdata
	wire         mm_interconnect_0_intel_niosv_g_dm_agent_waitrequest;            // intel_niosv_g:dm_agent_waitrequest -> mm_interconnect_0:intel_niosv_g_dm_agent_waitrequest
	wire  [15:0] mm_interconnect_0_intel_niosv_g_dm_agent_address;                // mm_interconnect_0:intel_niosv_g_dm_agent_address -> intel_niosv_g:dm_agent_address
	wire         mm_interconnect_0_intel_niosv_g_dm_agent_read;                   // mm_interconnect_0:intel_niosv_g_dm_agent_read -> intel_niosv_g:dm_agent_read
	wire         mm_interconnect_0_intel_niosv_g_dm_agent_readdatavalid;          // intel_niosv_g:dm_agent_readdatavalid -> mm_interconnect_0:intel_niosv_g_dm_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_g_dm_agent_write;                  // mm_interconnect_0:intel_niosv_g_dm_agent_write -> intel_niosv_g:dm_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_g_dm_agent_writedata;              // mm_interconnect_0:intel_niosv_g_dm_agent_writedata -> intel_niosv_g:dm_agent_writedata
	wire  [31:0] mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdata;      // vvp_system:mm_bridge_control_s0_readdata -> mm_interconnect_0:vvp_system_mm_bridge_control_s0_readdata
	wire         mm_interconnect_0_vvp_system_mm_bridge_control_s0_waitrequest;   // vvp_system:mm_bridge_control_s0_waitrequest -> mm_interconnect_0:vvp_system_mm_bridge_control_s0_waitrequest
	wire         mm_interconnect_0_vvp_system_mm_bridge_control_s0_debugaccess;   // mm_interconnect_0:vvp_system_mm_bridge_control_s0_debugaccess -> vvp_system:mm_bridge_control_s0_debugaccess
	wire  [11:0] mm_interconnect_0_vvp_system_mm_bridge_control_s0_address;       // mm_interconnect_0:vvp_system_mm_bridge_control_s0_address -> vvp_system:mm_bridge_control_s0_address
	wire         mm_interconnect_0_vvp_system_mm_bridge_control_s0_read;          // mm_interconnect_0:vvp_system_mm_bridge_control_s0_read -> vvp_system:mm_bridge_control_s0_read
	wire   [3:0] mm_interconnect_0_vvp_system_mm_bridge_control_s0_byteenable;    // mm_interconnect_0:vvp_system_mm_bridge_control_s0_byteenable -> vvp_system:mm_bridge_control_s0_byteenable
	wire         mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdatavalid; // vvp_system:mm_bridge_control_s0_readdatavalid -> mm_interconnect_0:vvp_system_mm_bridge_control_s0_readdatavalid
	wire         mm_interconnect_0_vvp_system_mm_bridge_control_s0_write;         // mm_interconnect_0:vvp_system_mm_bridge_control_s0_write -> vvp_system:mm_bridge_control_s0_write
	wire  [31:0] mm_interconnect_0_vvp_system_mm_bridge_control_s0_writedata;     // mm_interconnect_0:vvp_system_mm_bridge_control_s0_writedata -> vvp_system:mm_bridge_control_s0_writedata
	wire   [0:0] mm_interconnect_0_vvp_system_mm_bridge_control_s0_burstcount;    // mm_interconnect_0:vvp_system_mm_bridge_control_s0_burstcount -> vvp_system:mm_bridge_control_s0_burstcount
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_readdata;               // intel_onchip_memory:readdata -> mm_interconnect_0:intel_onchip_memory_s1_readdata
	wire  [16:0] mm_interconnect_0_intel_onchip_memory_s1_address;                // mm_interconnect_0:intel_onchip_memory_s1_address -> intel_onchip_memory:address
	wire         mm_interconnect_0_intel_onchip_memory_s1_read;                   // mm_interconnect_0:intel_onchip_memory_s1_read -> intel_onchip_memory:read
	wire   [3:0] mm_interconnect_0_intel_onchip_memory_s1_byteenable;             // mm_interconnect_0:intel_onchip_memory_s1_byteenable -> intel_onchip_memory:byteenable
	wire         mm_interconnect_0_intel_onchip_memory_s1_write;                  // mm_interconnect_0:intel_onchip_memory_s1_write -> intel_onchip_memory:write
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_writedata;              // mm_interconnect_0:intel_onchip_memory_s1_writedata -> intel_onchip_memory:writedata
	wire         mm_interconnect_0_timer_s1_chipselect;                           // mm_interconnect_0:timer_s1_chipselect -> timer:chipselect
	wire  [15:0] mm_interconnect_0_timer_s1_readdata;                             // timer:readdata -> mm_interconnect_0:timer_s1_readdata
	wire   [2:0] mm_interconnect_0_timer_s1_address;                              // mm_interconnect_0:timer_s1_address -> timer:address
	wire         mm_interconnect_0_timer_s1_write;                                // mm_interconnect_0:timer_s1_write -> timer:write_n
	wire  [15:0] mm_interconnect_0_timer_s1_writedata;                            // mm_interconnect_0:timer_s1_writedata -> timer:writedata
	wire         mm_interconnect_0_pio_led_s1_chipselect;                         // mm_interconnect_0:pio_led_s1_chipselect -> pio_led:chipselect
	wire  [31:0] mm_interconnect_0_pio_led_s1_readdata;                           // pio_led:readdata -> mm_interconnect_0:pio_led_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_led_s1_address;                            // mm_interconnect_0:pio_led_s1_address -> pio_led:address
	wire         mm_interconnect_0_pio_led_s1_write;                              // mm_interconnect_0:pio_led_s1_write -> pio_led:write_n
	wire  [31:0] mm_interconnect_0_pio_led_s1_writedata;                          // mm_interconnect_0:pio_led_s1_writedata -> pio_led:writedata
	wire  [31:0] mm_interconnect_0_pio_switch_s1_readdata;                        // pio_switch:readdata -> mm_interconnect_0:pio_switch_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_switch_s1_address;                         // mm_interconnect_0:pio_switch_s1_address -> pio_switch:address
	wire         mm_interconnect_0_pio_key_s1_chipselect;                         // mm_interconnect_0:pio_key_s1_chipselect -> pio_key:chipselect
	wire  [31:0] mm_interconnect_0_pio_key_s1_readdata;                           // pio_key:readdata -> mm_interconnect_0:pio_key_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_key_s1_address;                            // mm_interconnect_0:pio_key_s1_address -> pio_key:address
	wire         mm_interconnect_0_pio_key_s1_write;                              // mm_interconnect_0:pio_key_s1_write -> pio_key:write_n
	wire  [31:0] mm_interconnect_0_pio_key_s1_writedata;                          // mm_interconnect_0:pio_key_s1_writedata -> pio_key:writedata
	wire  [31:0] mm_interconnect_0_pio_hdmi_config_done_s1_readdata;              // pio_hdmi_config_done:readdata -> mm_interconnect_0:pio_hdmi_config_done_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_hdmi_config_done_s1_address;               // mm_interconnect_0:pio_hdmi_config_done_s1_address -> pio_hdmi_config_done:address
	wire  [31:0] mm_interconnect_0_pio_mem_ready_s1_readdata;                     // pio_mem_ready:readdata -> mm_interconnect_0:pio_mem_ready_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_mem_ready_s1_address;                      // mm_interconnect_0:pio_mem_ready_s1_address -> pio_mem_ready:address
	wire         mm_interconnect_0_pio_vvp_reset_n_s1_chipselect;                 // mm_interconnect_0:pio_vvp_reset_n_s1_chipselect -> pio_vvp_reset_n:chipselect
	wire  [31:0] mm_interconnect_0_pio_vvp_reset_n_s1_readdata;                   // pio_vvp_reset_n:readdata -> mm_interconnect_0:pio_vvp_reset_n_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_vvp_reset_n_s1_address;                    // mm_interconnect_0:pio_vvp_reset_n_s1_address -> pio_vvp_reset_n:address
	wire         mm_interconnect_0_pio_vvp_reset_n_s1_write;                      // mm_interconnect_0:pio_vvp_reset_n_s1_write -> pio_vvp_reset_n:write_n
	wire  [31:0] mm_interconnect_0_pio_vvp_reset_n_s1_writedata;                  // mm_interconnect_0:pio_vvp_reset_n_s1_writedata -> pio_vvp_reset_n:writedata
	wire         mm_interconnect_0_pio_cam_gpio_s1_chipselect;                    // mm_interconnect_0:pio_cam_gpio_s1_chipselect -> pio_cam_gpio:chipselect
	wire  [31:0] mm_interconnect_0_pio_cam_gpio_s1_readdata;                      // pio_cam_gpio:readdata -> mm_interconnect_0:pio_cam_gpio_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_cam_gpio_s1_address;                       // mm_interconnect_0:pio_cam_gpio_s1_address -> pio_cam_gpio:address
	wire         mm_interconnect_0_pio_cam_gpio_s1_write;                         // mm_interconnect_0:pio_cam_gpio_s1_write -> pio_cam_gpio:write_n
	wire  [31:0] mm_interconnect_0_pio_cam_gpio_s1_writedata;                     // mm_interconnect_0:pio_cam_gpio_s1_writedata -> pio_cam_gpio:writedata
	wire  [31:0] mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdata;         // intel_niosv_g:timer_sw_agent_readdata -> mm_interconnect_0:intel_niosv_g_timer_sw_agent_readdata
	wire         mm_interconnect_0_intel_niosv_g_timer_sw_agent_waitrequest;      // intel_niosv_g:timer_sw_agent_waitrequest -> mm_interconnect_0:intel_niosv_g_timer_sw_agent_waitrequest
	wire   [5:0] mm_interconnect_0_intel_niosv_g_timer_sw_agent_address;          // mm_interconnect_0:intel_niosv_g_timer_sw_agent_address -> intel_niosv_g:timer_sw_agent_address
	wire         mm_interconnect_0_intel_niosv_g_timer_sw_agent_read;             // mm_interconnect_0:intel_niosv_g_timer_sw_agent_read -> intel_niosv_g:timer_sw_agent_read
	wire   [3:0] mm_interconnect_0_intel_niosv_g_timer_sw_agent_byteenable;       // mm_interconnect_0:intel_niosv_g_timer_sw_agent_byteenable -> intel_niosv_g:timer_sw_agent_byteenable
	wire         mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdatavalid;    // intel_niosv_g:timer_sw_agent_readdatavalid -> mm_interconnect_0:intel_niosv_g_timer_sw_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_g_timer_sw_agent_write;            // mm_interconnect_0:intel_niosv_g_timer_sw_agent_write -> intel_niosv_g:timer_sw_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_g_timer_sw_agent_writedata;        // mm_interconnect_0:intel_niosv_g_timer_sw_agent_writedata -> intel_niosv_g:timer_sw_agent_writedata
	wire         irq_mapper_receiver0_irq;                                        // i2c:intr -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                        // jtag_uart:av_irq -> irq_mapper:receiver1_irq
	wire         irq_mapper_receiver2_irq;                                        // timer:irq -> irq_mapper:receiver2_irq
	wire         irq_mapper_receiver3_irq;                                        // pio_key:irq -> irq_mapper:receiver3_irq
	wire  [15:0] intel_niosv_g_platform_irq_rx_irq;                               // irq_mapper:sender_irq -> intel_niosv_g:platform_irq_rx_irq
	wire         rst_controller_reset_out_reset;                                  // rst_controller:reset_out -> [i2c:rst_n, intel_niosv_g:reset_reset, intel_onchip_memory:reset, irq_mapper:reset, jtag_uart:rst_n, pio_cam_gpio:reset_n, pio_hdmi_config_done:reset_n, pio_key:reset_n, pio_led:reset_n, pio_mem_ready:reset_n, pio_switch:reset_n, pio_vvp_reset_n:reset_n, rst_translator:in_reset, sysid_qsys:reset_n, timer:reset_n]
	wire         rst_controller_reset_out_reset_req;                              // rst_controller:reset_req -> [intel_onchip_memory:reset_req, rst_translator:reset_req_in]
	wire         rst_controller_001_reset_out_reset;                              // rst_controller_001:reset_out -> intel_niosv_g:ndm_reset_in_reset
	wire         intel_niosv_g_dbg_reset_out_reset;                               // intel_niosv_g:dbg_reset_out_reset -> rst_controller_001:reset_in0
	wire         rst_controller_002_reset_out_reset;                              // rst_controller_002:reset_out -> vvp_system:reset_reset_n
	wire         rst_controller_003_reset_out_reset;                              // rst_controller_003:reset_out -> vvp_system:reset_in_vvp_reset_n
	wire         reset_in_vvp_out_reset_reset;                                    // reset_in_vvp:out_reset_n -> rst_controller_003:reset_in0
	wire         rst_controller_004_reset_out_reset;                              // rst_controller_004:reset_out -> [mm_interconnect_0:intel_niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset_reset, mm_interconnect_0:intel_niosv_g_reset_reset_bridge_in_reset_reset]

	system_clock_in clock_in (
		.in_clk  (clk_clk),              //   input,  width = 1,  in_clk.clk
		.out_clk (clock_in_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	system_i2c_0 i2c (
		.clk       (iopll_sys_outclk0_clk),               //   input,   width = 1,            clock.clk
		.rst_n     (~rst_controller_reset_out_reset),     //   input,   width = 1,       reset_sink.reset_n
		.intr      (irq_mapper_receiver0_irq),            //  output,   width = 1, interrupt_sender.irq
		.addr      (mm_interconnect_0_i2c_csr_address),   //   input,   width = 4,              csr.address
		.read      (mm_interconnect_0_i2c_csr_read),      //   input,   width = 1,                 .read
		.write     (mm_interconnect_0_i2c_csr_write),     //   input,   width = 1,                 .write
		.writedata (mm_interconnect_0_i2c_csr_writedata), //   input,  width = 32,                 .writedata
		.readdata  (mm_interconnect_0_i2c_csr_readdata),  //  output,  width = 32,                 .readdata
		.sda_in    (i2c_i2c_serial_sda_in),               //   input,   width = 1,       i2c_serial.sda_in
		.scl_in    (i2c_i2c_serial_scl_in),               //   input,   width = 1,                 .scl_in
		.sda_oe    (i2c_i2c_serial_sda_oe),               //  output,   width = 1,                 .sda_oe
		.scl_oe    (i2c_i2c_serial_scl_oe)                //  output,   width = 1,                 .scl_oe
	);

	system_intel_niosv_g_0 intel_niosv_g (
		.clk                          (iopll_sys_outclk0_clk),                                        //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_reset_out_reset),                               //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (intel_niosv_g_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awaddr   (intel_niosv_g_instruction_manager_awaddr),                     //  output,  width = 32, instruction_manager.awaddr
		.instruction_manager_awsize   (intel_niosv_g_instruction_manager_awsize),                     //  output,   width = 3,                    .awsize
		.instruction_manager_awlen    (intel_niosv_g_instruction_manager_awlen),                      //  output,   width = 8,                    .awlen
		.instruction_manager_awprot   (intel_niosv_g_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (intel_niosv_g_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awburst  (intel_niosv_g_instruction_manager_awburst),                    //  output,   width = 2,                    .awburst
		.instruction_manager_awready  (intel_niosv_g_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (intel_niosv_g_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (intel_niosv_g_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wlast    (intel_niosv_g_instruction_manager_wlast),                      //  output,   width = 1,                    .wlast
		.instruction_manager_wvalid   (intel_niosv_g_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (intel_niosv_g_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (intel_niosv_g_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (intel_niosv_g_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (intel_niosv_g_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (intel_niosv_g_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arsize   (intel_niosv_g_instruction_manager_arsize),                     //  output,   width = 3,                    .arsize
		.instruction_manager_arlen    (intel_niosv_g_instruction_manager_arlen),                      //  output,   width = 8,                    .arlen
		.instruction_manager_arprot   (intel_niosv_g_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (intel_niosv_g_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arburst  (intel_niosv_g_instruction_manager_arburst),                    //  output,   width = 2,                    .arburst
		.instruction_manager_arready  (intel_niosv_g_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (intel_niosv_g_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (intel_niosv_g_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rvalid   (intel_niosv_g_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (intel_niosv_g_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.instruction_manager_rlast    (intel_niosv_g_instruction_manager_rlast),                      //   input,   width = 1,                    .rlast
		.data_manager_awaddr          (intel_niosv_g_data_manager_awaddr),                            //  output,  width = 32,        data_manager.awaddr
		.data_manager_awsize          (intel_niosv_g_data_manager_awsize),                            //  output,   width = 3,                    .awsize
		.data_manager_awlen           (intel_niosv_g_data_manager_awlen),                             //  output,   width = 8,                    .awlen
		.data_manager_awprot          (intel_niosv_g_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (intel_niosv_g_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (intel_niosv_g_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (intel_niosv_g_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (intel_niosv_g_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wlast           (intel_niosv_g_data_manager_wlast),                             //  output,   width = 1,                    .wlast
		.data_manager_wvalid          (intel_niosv_g_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (intel_niosv_g_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (intel_niosv_g_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (intel_niosv_g_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (intel_niosv_g_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (intel_niosv_g_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arsize          (intel_niosv_g_data_manager_arsize),                            //  output,   width = 3,                    .arsize
		.data_manager_arlen           (intel_niosv_g_data_manager_arlen),                             //  output,   width = 8,                    .arlen
		.data_manager_arprot          (intel_niosv_g_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (intel_niosv_g_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (intel_niosv_g_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (intel_niosv_g_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (intel_niosv_g_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rvalid          (intel_niosv_g_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rlast           (intel_niosv_g_data_manager_rlast),                             //   input,   width = 1,                    .rlast
		.data_manager_rready          (intel_niosv_g_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_write         (mm_interconnect_0_intel_niosv_g_timer_sw_agent_write),         //   input,   width = 1,      timer_sw_agent.write
		.timer_sw_agent_writedata     (mm_interconnect_0_intel_niosv_g_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_byteenable    (mm_interconnect_0_intel_niosv_g_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_address       (mm_interconnect_0_intel_niosv_g_timer_sw_agent_address),       //   input,   width = 6,                    .address
		.timer_sw_agent_read          (mm_interconnect_0_intel_niosv_g_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_readdatavalid (mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.timer_sw_agent_waitrequest   (mm_interconnect_0_intel_niosv_g_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.dm_agent_write               (mm_interconnect_0_intel_niosv_g_dm_agent_write),               //   input,   width = 1,            dm_agent.write
		.dm_agent_writedata           (mm_interconnect_0_intel_niosv_g_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_address             (mm_interconnect_0_intel_niosv_g_dm_agent_address),             //   input,  width = 16,                    .address
		.dm_agent_read                (mm_interconnect_0_intel_niosv_g_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_intel_niosv_g_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_readdatavalid       (mm_interconnect_0_intel_niosv_g_dm_agent_readdatavalid),       //  output,   width = 1,                    .readdatavalid
		.dm_agent_waitrequest         (mm_interconnect_0_intel_niosv_g_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dbg_reset_out_reset          (intel_niosv_g_dbg_reset_out_reset),                            //  output,   width = 1,       dbg_reset_out.reset
		.ndm_reset_in_reset           (rst_controller_001_reset_out_reset)                            //   input,   width = 1,        ndm_reset_in.reset
	);

	system_intel_onchip_memory_0 intel_onchip_memory (
		.clk        (iopll_sys_outclk0_clk),                               //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_intel_onchip_memory_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_intel_onchip_memory_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_intel_onchip_memory_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_intel_onchip_memory_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_intel_onchip_memory_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_intel_onchip_memory_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_reset_out_reset),                      //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req)                   //   input,   width = 1,       .reset_req
	);

	system_iopll_1 iopll_hdmi (
		.refclk   (clock_in_out_clk_clk),      //   input,  width = 1,  refclk.clk
		.locked   (),                          //  output,  width = 1,  locked.export
		.rst      (~reset_in_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (iopll_hdmi_outclk0_clk),    //  output,  width = 1, outclk0.clk
		.outclk_1 (hdmi_clk_clk)               //  output,  width = 1, outclk1.clk
	);

	system_iopll_0 iopll_sys (
		.refclk   (clock_in_out_clk_clk),      //   input,  width = 1,  refclk.clk
		.locked   (),                          //  output,  width = 1,  locked.export
		.rst      (~reset_in_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (iopll_sys_outclk0_clk),     //  output,  width = 1, outclk0.clk
		.outclk_1 (csi2_axi4_clk_clk),         //  output,  width = 1, outclk1.clk
		.outclk_2 (dphy_clk_clk),              //  output,  width = 1, outclk2.clk
		.outclk_3 (iopll_sys_outclk3_clk),     //  output,  width = 1, outclk3.clk
		.outclk_4 (iopll_sys_outclk4_clk)      //  output,  width = 1, outclk4.clk
	);

	system_jtag_uart_0 jtag_uart (
		.clk            (iopll_sys_outclk0_clk),                                     //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver1_irq)                                   //  output,   width = 1,               irq.irq
	);

	system_pio_led_0 pio_cam_gpio (
		.clk        (iopll_sys_outclk0_clk),                        //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),              //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_cam_gpio_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_cam_gpio_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_cam_gpio_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_cam_gpio_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_cam_gpio_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_cam_gpio_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	system_pio_3 pio_hdmi_config_done (
		.clk      (iopll_sys_outclk0_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                    //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_pio_hdmi_config_done_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_pio_hdmi_config_done_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pio_hdmi_config_done_external_connection_export)     //   input,   width = 1, external_connection.export
	);

	system_pio_2 pio_key (
		.clk        (iopll_sys_outclk0_clk),                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_key_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_key_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_key_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_key_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_key_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (pio_key_external_connection_export),      //   input,   width = 2, external_connection.export
		.irq        (irq_mapper_receiver3_irq)                 //  output,   width = 1,                 irq.irq
	);

	system_pio_0 pio_led (
		.clk        (iopll_sys_outclk0_clk),                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_led_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_led_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_led_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_led_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_led_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_led_external_connection_export)       //  output,   width = 8, external_connection.export
	);

	system_pio_4 pio_mem_ready (
		.clk      (iopll_sys_outclk0_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_pio_mem_ready_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_pio_mem_ready_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pio_mem_ready_external_connection_export)     //   input,   width = 1, external_connection.export
	);

	system_pio_1 pio_switch (
		.clk      (iopll_sys_outclk0_clk),                    //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),          //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_pio_switch_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_pio_switch_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pio_switch_external_connection_export)     //   input,   width = 4, external_connection.export
	);

	system_pio_5 pio_vvp_reset_n (
		.clk        (iopll_sys_outclk0_clk),                           //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                 //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_vvp_reset_n_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_vvp_reset_n_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_vvp_reset_n_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_vvp_reset_n_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_vvp_reset_n_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_vvp_reset_n_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	system_reset_in reset_in (
		.in_reset_n  (reset_n_reset_n),          //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_in_out_reset_reset)  //  output,  width = 1, out_reset.reset_n
	);

	system_reset_in_0 reset_in_vvp (
		.clk         (clock_in_out_clk_clk),          //   input,  width = 1,       clk.clk
		.in_reset_n  (reset_in_vvp_in_reset_reset_n), //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_in_vvp_out_reset_reset)   //  output,  width = 1, out_reset.reset_n
	);

	system_sysid_qsys_0 sysid_qsys (
		.clock    (iopll_sys_outclk0_clk),                               //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_0_sysid_qsys_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_0_sysid_qsys_control_slave_address)   //   input,   width = 1,              .address
	);

	system_timer_0 timer (
		.clk        (iopll_sys_outclk0_clk),                 //   input,   width = 1,   clk.clk
		.reset_n    (~rst_controller_reset_out_reset),       //   input,   width = 1, reset.reset_n
		.address    (mm_interconnect_0_timer_s1_address),    //   input,   width = 3,    s1.address
		.writedata  (mm_interconnect_0_timer_s1_writedata),  //   input,  width = 16,      .writedata
		.readdata   (mm_interconnect_0_timer_s1_readdata),   //  output,  width = 16,      .readdata
		.chipselect (mm_interconnect_0_timer_s1_chipselect), //   input,   width = 1,      .chipselect
		.write_n    (~mm_interconnect_0_timer_s1_write),     //   input,   width = 1,      .write_n
		.irq        (irq_mapper_receiver2_irq)               //  output,   width = 1,   irq.irq
	);

	vvp_system vvp_system (
		.clock_in_control_in_clk_clk                   (iopll_sys_outclk0_clk),                                           //   input,   width = 1,               clock_in_control_in_clk.clk
		.clock_in_csi2_in_clk_clk                      (vvp_system_clock_in_csi2_in_clk_clk),                             //   input,   width = 1,                  clock_in_csi2_in_clk.clk
		.clock_in_hdmi_in_clk_clk                      (iopll_hdmi_outclk0_clk),                                          //   input,   width = 1,                  clock_in_hdmi_in_clk.clk
		.clock_in_mem_in_clk_clk                       (iopll_sys_outclk4_clk),                                           //   input,   width = 1,                   clock_in_mem_in_clk.clk
		.clock_in_vid_in_clk_1_clk                     (iopll_sys_outclk3_clk),                                           //   input,   width = 1,                 clock_in_vid_in_clk_1.clk
		.emif_io96b_lpddr4a_s0_axi4_ctrl_ready_reset_n (vvp_system_emif_io96b_lpddr4a_s0_axi4_ctrl_ready_reset_n),        //  output,   width = 1, emif_io96b_lpddr4a_s0_axi4_ctrl_ready.reset_n
		.emif_io96b_lpddr4a_mem_0_mem_cs               (vvp_system_emif_io96b_lpddr4a_mem_0_mem_cs),                      //  output,   width = 2,              emif_io96b_lpddr4a_mem_0.mem_cs
		.emif_io96b_lpddr4a_mem_0_mem_ca               (vvp_system_emif_io96b_lpddr4a_mem_0_mem_ca),                      //  output,   width = 6,                                      .mem_ca
		.emif_io96b_lpddr4a_mem_0_mem_cke              (vvp_system_emif_io96b_lpddr4a_mem_0_mem_cke),                     //  output,   width = 2,                                      .mem_cke
		.emif_io96b_lpddr4a_mem_0_mem_dq               (vvp_system_emif_io96b_lpddr4a_mem_0_mem_dq),                      //   inout,  width = 32,                                      .mem_dq
		.emif_io96b_lpddr4a_mem_0_mem_dqs_t            (vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_t),                   //   inout,   width = 4,                                      .mem_dqs_t
		.emif_io96b_lpddr4a_mem_0_mem_dqs_c            (vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_c),                   //   inout,   width = 4,                                      .mem_dqs_c
		.emif_io96b_lpddr4a_mem_0_mem_dmi              (vvp_system_emif_io96b_lpddr4a_mem_0_mem_dmi),                     //   inout,   width = 4,                                      .mem_dmi
		.emif_io96b_lpddr4a_mem_ck_0_mem_ck_t          (vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_t),                 //  output,   width = 1,           emif_io96b_lpddr4a_mem_ck_0.mem_ck_t
		.emif_io96b_lpddr4a_mem_ck_0_mem_ck_c          (vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_c),                 //  output,   width = 1,                                      .mem_ck_c
		.emif_io96b_lpddr4a_mem_reset_n_mem_reset_n    (vvp_system_emif_io96b_lpddr4a_mem_reset_n_mem_reset_n),           //  output,   width = 1,        emif_io96b_lpddr4a_mem_reset_n.mem_reset_n
		.emif_io96b_lpddr4a_oct_0_oct_rzqin            (vvp_system_emif_io96b_lpddr4a_oct_0_oct_rzqin),                   //   input,   width = 1,              emif_io96b_lpddr4a_oct_0.oct_rzqin
		.emif_io96b_lpddr4a_ref_clk_clk                (vvp_system_emif_io96b_lpddr4a_ref_clk_clk),                       //   input,   width = 1,            emif_io96b_lpddr4a_ref_clk.clk
		.intel_vvp_cvo_vid_status_vid_locked           (vvp_system_intel_vvp_cvo_vid_status_vid_locked),                  //  output,   width = 1,              intel_vvp_cvo_vid_status.vid_locked
		.intel_vvp_cvo_vid_status_vid_is_full          (vvp_system_intel_vvp_cvo_vid_status_vid_is_full),                 //  output,   width = 1,                                      .vid_is_full
		.intel_vvp_cvo_vid_status_vid_stall_error      (vvp_system_intel_vvp_cvo_vid_status_vid_stall_error),             //  output,   width = 1,                                      .vid_stall_error
		.intel_vvp_cvo_vid_status_vid_size_mismatch    (vvp_system_intel_vvp_cvo_vid_status_vid_size_mismatch),           //  output,   width = 1,                                      .vid_size_mismatch
		.intel_vvp_cvo_frame_start_conduit             (vvp_system_intel_vvp_cvo_frame_start_conduit),                    //   input,   width = 1,             intel_vvp_cvo_frame_start.conduit
		.intel_vvp_demosaic_axi4s_vid_in_tdata         (vvp_system_intel_vvp_demosaic_axi4s_vid_in_tdata),                //   input,  width = 64,       intel_vvp_demosaic_axi4s_vid_in.tdata
		.intel_vvp_demosaic_axi4s_vid_in_tvalid        (vvp_system_intel_vvp_demosaic_axi4s_vid_in_tvalid),               //   input,   width = 1,                                      .tvalid
		.intel_vvp_demosaic_axi4s_vid_in_tready        (vvp_system_intel_vvp_demosaic_axi4s_vid_in_tready),               //  output,   width = 1,                                      .tready
		.intel_vvp_demosaic_axi4s_vid_in_tlast         (vvp_system_intel_vvp_demosaic_axi4s_vid_in_tlast),                //   input,   width = 1,                                      .tlast
		.intel_vvp_demosaic_axi4s_vid_in_tuser         (vvp_system_intel_vvp_demosaic_axi4s_vid_in_tuser),                //   input,   width = 8,                                      .tuser
		.intel_vvp_fr2cv_cv_clk_out_clk                (vvp_system_intel_vvp_fr2cv_cv_clk_out_clk),                       //  output,   width = 1,            intel_vvp_fr2cv_cv_clk_out.clk
		.intel_vvp_fr2cv_cv_vid_out_vid_data           (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_data),                  //  output,  width = 24,            intel_vvp_fr2cv_cv_vid_out.vid_data
		.intel_vvp_fr2cv_cv_vid_out_underflow          (vvp_system_intel_vvp_fr2cv_cv_vid_out_underflow),                 //  output,   width = 1,                                      .underflow
		.intel_vvp_fr2cv_cv_vid_out_vid_datavalid      (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_datavalid),             //  output,   width = 1,                                      .vid_datavalid
		.intel_vvp_fr2cv_cv_vid_out_vid_v_sync         (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v_sync),                //  output,   width = 1,                                      .vid_v_sync
		.intel_vvp_fr2cv_cv_vid_out_vid_h_sync         (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h_sync),                //  output,   width = 1,                                      .vid_h_sync
		.intel_vvp_fr2cv_cv_vid_out_vid_f              (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_f),                     //  output,   width = 1,                                      .vid_f
		.intel_vvp_fr2cv_cv_vid_out_vid_h              (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h),                     //  output,   width = 1,                                      .vid_h
		.intel_vvp_fr2cv_cv_vid_out_vid_v              (vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v),                     //  output,   width = 1,                                      .vid_v
		.mm_bridge_control_s0_waitrequest              (mm_interconnect_0_vvp_system_mm_bridge_control_s0_waitrequest),   //  output,   width = 1,                  mm_bridge_control_s0.waitrequest
		.mm_bridge_control_s0_readdata                 (mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdata),      //  output,  width = 32,                                      .readdata
		.mm_bridge_control_s0_readdatavalid            (mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdatavalid), //  output,   width = 1,                                      .readdatavalid
		.mm_bridge_control_s0_burstcount               (mm_interconnect_0_vvp_system_mm_bridge_control_s0_burstcount),    //   input,   width = 1,                                      .burstcount
		.mm_bridge_control_s0_writedata                (mm_interconnect_0_vvp_system_mm_bridge_control_s0_writedata),     //   input,  width = 32,                                      .writedata
		.mm_bridge_control_s0_address                  (mm_interconnect_0_vvp_system_mm_bridge_control_s0_address),       //   input,  width = 12,                                      .address
		.mm_bridge_control_s0_write                    (mm_interconnect_0_vvp_system_mm_bridge_control_s0_write),         //   input,   width = 1,                                      .write
		.mm_bridge_control_s0_read                     (mm_interconnect_0_vvp_system_mm_bridge_control_s0_read),          //   input,   width = 1,                                      .read
		.mm_bridge_control_s0_byteenable               (mm_interconnect_0_vvp_system_mm_bridge_control_s0_byteenable),    //   input,   width = 4,                                      .byteenable
		.mm_bridge_control_s0_debugaccess              (mm_interconnect_0_vvp_system_mm_bridge_control_s0_debugaccess),   //   input,   width = 1,                                      .debugaccess
		.reset_reset_n                                 (~rst_controller_002_reset_out_reset),                             //   input,   width = 1,                                 reset.reset_n
		.reset_in_vvp_reset_n                          (~rst_controller_003_reset_out_reset)                              //   input,   width = 1,                          reset_in_vvp.reset_n
	);

	system_altera_mm_interconnect_1920_hordlva mm_interconnect_0 (
		.intel_niosv_g_data_manager_awaddr                                           (intel_niosv_g_data_manager_awaddr),                               //   input,  width = 32,                                            intel_niosv_g_data_manager.awaddr
		.intel_niosv_g_data_manager_awlen                                            (intel_niosv_g_data_manager_awlen),                                //   input,   width = 8,                                                                      .awlen
		.intel_niosv_g_data_manager_awsize                                           (intel_niosv_g_data_manager_awsize),                               //   input,   width = 3,                                                                      .awsize
		.intel_niosv_g_data_manager_awprot                                           (intel_niosv_g_data_manager_awprot),                               //   input,   width = 3,                                                                      .awprot
		.intel_niosv_g_data_manager_awvalid                                          (intel_niosv_g_data_manager_awvalid),                              //   input,   width = 1,                                                                      .awvalid
		.intel_niosv_g_data_manager_awready                                          (intel_niosv_g_data_manager_awready),                              //  output,   width = 1,                                                                      .awready
		.intel_niosv_g_data_manager_wdata                                            (intel_niosv_g_data_manager_wdata),                                //   input,  width = 32,                                                                      .wdata
		.intel_niosv_g_data_manager_wstrb                                            (intel_niosv_g_data_manager_wstrb),                                //   input,   width = 4,                                                                      .wstrb
		.intel_niosv_g_data_manager_wlast                                            (intel_niosv_g_data_manager_wlast),                                //   input,   width = 1,                                                                      .wlast
		.intel_niosv_g_data_manager_wvalid                                           (intel_niosv_g_data_manager_wvalid),                               //   input,   width = 1,                                                                      .wvalid
		.intel_niosv_g_data_manager_wready                                           (intel_niosv_g_data_manager_wready),                               //  output,   width = 1,                                                                      .wready
		.intel_niosv_g_data_manager_bresp                                            (intel_niosv_g_data_manager_bresp),                                //  output,   width = 2,                                                                      .bresp
		.intel_niosv_g_data_manager_bvalid                                           (intel_niosv_g_data_manager_bvalid),                               //  output,   width = 1,                                                                      .bvalid
		.intel_niosv_g_data_manager_bready                                           (intel_niosv_g_data_manager_bready),                               //   input,   width = 1,                                                                      .bready
		.intel_niosv_g_data_manager_araddr                                           (intel_niosv_g_data_manager_araddr),                               //   input,  width = 32,                                                                      .araddr
		.intel_niosv_g_data_manager_arlen                                            (intel_niosv_g_data_manager_arlen),                                //   input,   width = 8,                                                                      .arlen
		.intel_niosv_g_data_manager_arsize                                           (intel_niosv_g_data_manager_arsize),                               //   input,   width = 3,                                                                      .arsize
		.intel_niosv_g_data_manager_arprot                                           (intel_niosv_g_data_manager_arprot),                               //   input,   width = 3,                                                                      .arprot
		.intel_niosv_g_data_manager_arvalid                                          (intel_niosv_g_data_manager_arvalid),                              //   input,   width = 1,                                                                      .arvalid
		.intel_niosv_g_data_manager_arready                                          (intel_niosv_g_data_manager_arready),                              //  output,   width = 1,                                                                      .arready
		.intel_niosv_g_data_manager_rdata                                            (intel_niosv_g_data_manager_rdata),                                //  output,  width = 32,                                                                      .rdata
		.intel_niosv_g_data_manager_rresp                                            (intel_niosv_g_data_manager_rresp),                                //  output,   width = 2,                                                                      .rresp
		.intel_niosv_g_data_manager_rlast                                            (intel_niosv_g_data_manager_rlast),                                //  output,   width = 1,                                                                      .rlast
		.intel_niosv_g_data_manager_rvalid                                           (intel_niosv_g_data_manager_rvalid),                               //  output,   width = 1,                                                                      .rvalid
		.intel_niosv_g_data_manager_rready                                           (intel_niosv_g_data_manager_rready),                               //   input,   width = 1,                                                                      .rready
		.intel_niosv_g_instruction_manager_awaddr                                    (intel_niosv_g_instruction_manager_awaddr),                        //   input,  width = 32,                                     intel_niosv_g_instruction_manager.awaddr
		.intel_niosv_g_instruction_manager_awlen                                     (intel_niosv_g_instruction_manager_awlen),                         //   input,   width = 8,                                                                      .awlen
		.intel_niosv_g_instruction_manager_awsize                                    (intel_niosv_g_instruction_manager_awsize),                        //   input,   width = 3,                                                                      .awsize
		.intel_niosv_g_instruction_manager_awburst                                   (intel_niosv_g_instruction_manager_awburst),                       //   input,   width = 2,                                                                      .awburst
		.intel_niosv_g_instruction_manager_awprot                                    (intel_niosv_g_instruction_manager_awprot),                        //   input,   width = 3,                                                                      .awprot
		.intel_niosv_g_instruction_manager_awvalid                                   (intel_niosv_g_instruction_manager_awvalid),                       //   input,   width = 1,                                                                      .awvalid
		.intel_niosv_g_instruction_manager_awready                                   (intel_niosv_g_instruction_manager_awready),                       //  output,   width = 1,                                                                      .awready
		.intel_niosv_g_instruction_manager_wdata                                     (intel_niosv_g_instruction_manager_wdata),                         //   input,  width = 32,                                                                      .wdata
		.intel_niosv_g_instruction_manager_wstrb                                     (intel_niosv_g_instruction_manager_wstrb),                         //   input,   width = 4,                                                                      .wstrb
		.intel_niosv_g_instruction_manager_wlast                                     (intel_niosv_g_instruction_manager_wlast),                         //   input,   width = 1,                                                                      .wlast
		.intel_niosv_g_instruction_manager_wvalid                                    (intel_niosv_g_instruction_manager_wvalid),                        //   input,   width = 1,                                                                      .wvalid
		.intel_niosv_g_instruction_manager_wready                                    (intel_niosv_g_instruction_manager_wready),                        //  output,   width = 1,                                                                      .wready
		.intel_niosv_g_instruction_manager_bresp                                     (intel_niosv_g_instruction_manager_bresp),                         //  output,   width = 2,                                                                      .bresp
		.intel_niosv_g_instruction_manager_bvalid                                    (intel_niosv_g_instruction_manager_bvalid),                        //  output,   width = 1,                                                                      .bvalid
		.intel_niosv_g_instruction_manager_bready                                    (intel_niosv_g_instruction_manager_bready),                        //   input,   width = 1,                                                                      .bready
		.intel_niosv_g_instruction_manager_araddr                                    (intel_niosv_g_instruction_manager_araddr),                        //   input,  width = 32,                                                                      .araddr
		.intel_niosv_g_instruction_manager_arlen                                     (intel_niosv_g_instruction_manager_arlen),                         //   input,   width = 8,                                                                      .arlen
		.intel_niosv_g_instruction_manager_arsize                                    (intel_niosv_g_instruction_manager_arsize),                        //   input,   width = 3,                                                                      .arsize
		.intel_niosv_g_instruction_manager_arburst                                   (intel_niosv_g_instruction_manager_arburst),                       //   input,   width = 2,                                                                      .arburst
		.intel_niosv_g_instruction_manager_arprot                                    (intel_niosv_g_instruction_manager_arprot),                        //   input,   width = 3,                                                                      .arprot
		.intel_niosv_g_instruction_manager_arvalid                                   (intel_niosv_g_instruction_manager_arvalid),                       //   input,   width = 1,                                                                      .arvalid
		.intel_niosv_g_instruction_manager_arready                                   (intel_niosv_g_instruction_manager_arready),                       //  output,   width = 1,                                                                      .arready
		.intel_niosv_g_instruction_manager_rdata                                     (intel_niosv_g_instruction_manager_rdata),                         //  output,  width = 32,                                                                      .rdata
		.intel_niosv_g_instruction_manager_rresp                                     (intel_niosv_g_instruction_manager_rresp),                         //  output,   width = 2,                                                                      .rresp
		.intel_niosv_g_instruction_manager_rlast                                     (intel_niosv_g_instruction_manager_rlast),                         //  output,   width = 1,                                                                      .rlast
		.intel_niosv_g_instruction_manager_rvalid                                    (intel_niosv_g_instruction_manager_rvalid),                        //  output,   width = 1,                                                                      .rvalid
		.intel_niosv_g_instruction_manager_rready                                    (intel_niosv_g_instruction_manager_rready),                        //   input,   width = 1,                                                                      .rready
		.jtag_uart_avalon_jtag_slave_address                                         (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),           //  output,   width = 1,                                           jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                                           (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),             //  output,   width = 1,                                                                      .write
		.jtag_uart_avalon_jtag_slave_read                                            (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),              //  output,   width = 1,                                                                      .read
		.jtag_uart_avalon_jtag_slave_readdata                                        (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),          //   input,  width = 32,                                                                      .readdata
		.jtag_uart_avalon_jtag_slave_writedata                                       (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),         //  output,  width = 32,                                                                      .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                                     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest),       //   input,   width = 1,                                                                      .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                                      (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),        //  output,   width = 1,                                                                      .chipselect
		.sysid_qsys_control_slave_address                                            (mm_interconnect_0_sysid_qsys_control_slave_address),              //  output,   width = 1,                                              sysid_qsys_control_slave.address
		.sysid_qsys_control_slave_readdata                                           (mm_interconnect_0_sysid_qsys_control_slave_readdata),             //   input,  width = 32,                                                                      .readdata
		.i2c_csr_address                                                             (mm_interconnect_0_i2c_csr_address),                               //  output,   width = 4,                                                               i2c_csr.address
		.i2c_csr_write                                                               (mm_interconnect_0_i2c_csr_write),                                 //  output,   width = 1,                                                                      .write
		.i2c_csr_read                                                                (mm_interconnect_0_i2c_csr_read),                                  //  output,   width = 1,                                                                      .read
		.i2c_csr_readdata                                                            (mm_interconnect_0_i2c_csr_readdata),                              //   input,  width = 32,                                                                      .readdata
		.i2c_csr_writedata                                                           (mm_interconnect_0_i2c_csr_writedata),                             //  output,  width = 32,                                                                      .writedata
		.intel_niosv_g_dm_agent_address                                              (mm_interconnect_0_intel_niosv_g_dm_agent_address),                //  output,  width = 16,                                                intel_niosv_g_dm_agent.address
		.intel_niosv_g_dm_agent_write                                                (mm_interconnect_0_intel_niosv_g_dm_agent_write),                  //  output,   width = 1,                                                                      .write
		.intel_niosv_g_dm_agent_read                                                 (mm_interconnect_0_intel_niosv_g_dm_agent_read),                   //  output,   width = 1,                                                                      .read
		.intel_niosv_g_dm_agent_readdata                                             (mm_interconnect_0_intel_niosv_g_dm_agent_readdata),               //   input,  width = 32,                                                                      .readdata
		.intel_niosv_g_dm_agent_writedata                                            (mm_interconnect_0_intel_niosv_g_dm_agent_writedata),              //  output,  width = 32,                                                                      .writedata
		.intel_niosv_g_dm_agent_readdatavalid                                        (mm_interconnect_0_intel_niosv_g_dm_agent_readdatavalid),          //   input,   width = 1,                                                                      .readdatavalid
		.intel_niosv_g_dm_agent_waitrequest                                          (mm_interconnect_0_intel_niosv_g_dm_agent_waitrequest),            //   input,   width = 1,                                                                      .waitrequest
		.vvp_system_mm_bridge_control_s0_address                                     (mm_interconnect_0_vvp_system_mm_bridge_control_s0_address),       //  output,  width = 12,                                       vvp_system_mm_bridge_control_s0.address
		.vvp_system_mm_bridge_control_s0_write                                       (mm_interconnect_0_vvp_system_mm_bridge_control_s0_write),         //  output,   width = 1,                                                                      .write
		.vvp_system_mm_bridge_control_s0_read                                        (mm_interconnect_0_vvp_system_mm_bridge_control_s0_read),          //  output,   width = 1,                                                                      .read
		.vvp_system_mm_bridge_control_s0_readdata                                    (mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdata),      //   input,  width = 32,                                                                      .readdata
		.vvp_system_mm_bridge_control_s0_writedata                                   (mm_interconnect_0_vvp_system_mm_bridge_control_s0_writedata),     //  output,  width = 32,                                                                      .writedata
		.vvp_system_mm_bridge_control_s0_burstcount                                  (mm_interconnect_0_vvp_system_mm_bridge_control_s0_burstcount),    //  output,   width = 1,                                                                      .burstcount
		.vvp_system_mm_bridge_control_s0_byteenable                                  (mm_interconnect_0_vvp_system_mm_bridge_control_s0_byteenable),    //  output,   width = 4,                                                                      .byteenable
		.vvp_system_mm_bridge_control_s0_readdatavalid                               (mm_interconnect_0_vvp_system_mm_bridge_control_s0_readdatavalid), //   input,   width = 1,                                                                      .readdatavalid
		.vvp_system_mm_bridge_control_s0_waitrequest                                 (mm_interconnect_0_vvp_system_mm_bridge_control_s0_waitrequest),   //   input,   width = 1,                                                                      .waitrequest
		.vvp_system_mm_bridge_control_s0_debugaccess                                 (mm_interconnect_0_vvp_system_mm_bridge_control_s0_debugaccess),   //  output,   width = 1,                                                                      .debugaccess
		.intel_onchip_memory_s1_address                                              (mm_interconnect_0_intel_onchip_memory_s1_address),                //  output,  width = 17,                                                intel_onchip_memory_s1.address
		.intel_onchip_memory_s1_write                                                (mm_interconnect_0_intel_onchip_memory_s1_write),                  //  output,   width = 1,                                                                      .write
		.intel_onchip_memory_s1_read                                                 (mm_interconnect_0_intel_onchip_memory_s1_read),                   //  output,   width = 1,                                                                      .read
		.intel_onchip_memory_s1_readdata                                             (mm_interconnect_0_intel_onchip_memory_s1_readdata),               //   input,  width = 32,                                                                      .readdata
		.intel_onchip_memory_s1_writedata                                            (mm_interconnect_0_intel_onchip_memory_s1_writedata),              //  output,  width = 32,                                                                      .writedata
		.intel_onchip_memory_s1_byteenable                                           (mm_interconnect_0_intel_onchip_memory_s1_byteenable),             //  output,   width = 4,                                                                      .byteenable
		.timer_s1_address                                                            (mm_interconnect_0_timer_s1_address),                              //  output,   width = 3,                                                              timer_s1.address
		.timer_s1_write                                                              (mm_interconnect_0_timer_s1_write),                                //  output,   width = 1,                                                                      .write
		.timer_s1_readdata                                                           (mm_interconnect_0_timer_s1_readdata),                             //   input,  width = 16,                                                                      .readdata
		.timer_s1_writedata                                                          (mm_interconnect_0_timer_s1_writedata),                            //  output,  width = 16,                                                                      .writedata
		.timer_s1_chipselect                                                         (mm_interconnect_0_timer_s1_chipselect),                           //  output,   width = 1,                                                                      .chipselect
		.pio_led_s1_address                                                          (mm_interconnect_0_pio_led_s1_address),                            //  output,   width = 2,                                                            pio_led_s1.address
		.pio_led_s1_write                                                            (mm_interconnect_0_pio_led_s1_write),                              //  output,   width = 1,                                                                      .write
		.pio_led_s1_readdata                                                         (mm_interconnect_0_pio_led_s1_readdata),                           //   input,  width = 32,                                                                      .readdata
		.pio_led_s1_writedata                                                        (mm_interconnect_0_pio_led_s1_writedata),                          //  output,  width = 32,                                                                      .writedata
		.pio_led_s1_chipselect                                                       (mm_interconnect_0_pio_led_s1_chipselect),                         //  output,   width = 1,                                                                      .chipselect
		.pio_switch_s1_address                                                       (mm_interconnect_0_pio_switch_s1_address),                         //  output,   width = 2,                                                         pio_switch_s1.address
		.pio_switch_s1_readdata                                                      (mm_interconnect_0_pio_switch_s1_readdata),                        //   input,  width = 32,                                                                      .readdata
		.pio_key_s1_address                                                          (mm_interconnect_0_pio_key_s1_address),                            //  output,   width = 2,                                                            pio_key_s1.address
		.pio_key_s1_write                                                            (mm_interconnect_0_pio_key_s1_write),                              //  output,   width = 1,                                                                      .write
		.pio_key_s1_readdata                                                         (mm_interconnect_0_pio_key_s1_readdata),                           //   input,  width = 32,                                                                      .readdata
		.pio_key_s1_writedata                                                        (mm_interconnect_0_pio_key_s1_writedata),                          //  output,  width = 32,                                                                      .writedata
		.pio_key_s1_chipselect                                                       (mm_interconnect_0_pio_key_s1_chipselect),                         //  output,   width = 1,                                                                      .chipselect
		.pio_hdmi_config_done_s1_address                                             (mm_interconnect_0_pio_hdmi_config_done_s1_address),               //  output,   width = 2,                                               pio_hdmi_config_done_s1.address
		.pio_hdmi_config_done_s1_readdata                                            (mm_interconnect_0_pio_hdmi_config_done_s1_readdata),              //   input,  width = 32,                                                                      .readdata
		.pio_mem_ready_s1_address                                                    (mm_interconnect_0_pio_mem_ready_s1_address),                      //  output,   width = 2,                                                      pio_mem_ready_s1.address
		.pio_mem_ready_s1_readdata                                                   (mm_interconnect_0_pio_mem_ready_s1_readdata),                     //   input,  width = 32,                                                                      .readdata
		.pio_vvp_reset_n_s1_address                                                  (mm_interconnect_0_pio_vvp_reset_n_s1_address),                    //  output,   width = 2,                                                    pio_vvp_reset_n_s1.address
		.pio_vvp_reset_n_s1_write                                                    (mm_interconnect_0_pio_vvp_reset_n_s1_write),                      //  output,   width = 1,                                                                      .write
		.pio_vvp_reset_n_s1_readdata                                                 (mm_interconnect_0_pio_vvp_reset_n_s1_readdata),                   //   input,  width = 32,                                                                      .readdata
		.pio_vvp_reset_n_s1_writedata                                                (mm_interconnect_0_pio_vvp_reset_n_s1_writedata),                  //  output,  width = 32,                                                                      .writedata
		.pio_vvp_reset_n_s1_chipselect                                               (mm_interconnect_0_pio_vvp_reset_n_s1_chipselect),                 //  output,   width = 1,                                                                      .chipselect
		.pio_cam_gpio_s1_address                                                     (mm_interconnect_0_pio_cam_gpio_s1_address),                       //  output,   width = 2,                                                       pio_cam_gpio_s1.address
		.pio_cam_gpio_s1_write                                                       (mm_interconnect_0_pio_cam_gpio_s1_write),                         //  output,   width = 1,                                                                      .write
		.pio_cam_gpio_s1_readdata                                                    (mm_interconnect_0_pio_cam_gpio_s1_readdata),                      //   input,  width = 32,                                                                      .readdata
		.pio_cam_gpio_s1_writedata                                                   (mm_interconnect_0_pio_cam_gpio_s1_writedata),                     //  output,  width = 32,                                                                      .writedata
		.pio_cam_gpio_s1_chipselect                                                  (mm_interconnect_0_pio_cam_gpio_s1_chipselect),                    //  output,   width = 1,                                                                      .chipselect
		.intel_niosv_g_timer_sw_agent_address                                        (mm_interconnect_0_intel_niosv_g_timer_sw_agent_address),          //  output,   width = 6,                                          intel_niosv_g_timer_sw_agent.address
		.intel_niosv_g_timer_sw_agent_write                                          (mm_interconnect_0_intel_niosv_g_timer_sw_agent_write),            //  output,   width = 1,                                                                      .write
		.intel_niosv_g_timer_sw_agent_read                                           (mm_interconnect_0_intel_niosv_g_timer_sw_agent_read),             //  output,   width = 1,                                                                      .read
		.intel_niosv_g_timer_sw_agent_readdata                                       (mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdata),         //   input,  width = 32,                                                                      .readdata
		.intel_niosv_g_timer_sw_agent_writedata                                      (mm_interconnect_0_intel_niosv_g_timer_sw_agent_writedata),        //  output,  width = 32,                                                                      .writedata
		.intel_niosv_g_timer_sw_agent_byteenable                                     (mm_interconnect_0_intel_niosv_g_timer_sw_agent_byteenable),       //  output,   width = 4,                                                                      .byteenable
		.intel_niosv_g_timer_sw_agent_readdatavalid                                  (mm_interconnect_0_intel_niosv_g_timer_sw_agent_readdatavalid),    //   input,   width = 1,                                                                      .readdatavalid
		.intel_niosv_g_timer_sw_agent_waitrequest                                    (mm_interconnect_0_intel_niosv_g_timer_sw_agent_waitrequest),      //   input,   width = 1,                                                                      .waitrequest
		.intel_niosv_g_reset_reset_bridge_in_reset_reset                             (rst_controller_004_reset_out_reset),                              //   input,   width = 1,                             intel_niosv_g_reset_reset_bridge_in_reset.reset
		.intel_niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset_reset (rst_controller_004_reset_out_reset),                              //   input,   width = 1, intel_niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset.reset
		.iopll_sys_outclk0_clk                                                       (iopll_sys_outclk0_clk)                                            //   input,   width = 1,                                                     iopll_sys_outclk0.clk
	);

	system_altera_irq_mapper_2001_xbnlxwy irq_mapper (
		.clk           (iopll_sys_outclk0_clk),             //   input,   width = 1,       clk.clk
		.reset         (rst_controller_reset_out_reset),    //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),          //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),          //   input,   width = 1, receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),          //   input,   width = 1, receiver2.irq
		.receiver3_irq (irq_mapper_receiver3_irq),          //   input,   width = 1, receiver3.irq
		.sender_irq    (intel_niosv_g_platform_irq_rx_irq)  //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in0.reset
		.clk            (iopll_sys_outclk0_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (intel_niosv_g_dbg_reset_out_reset),  //   input,  width = 1, reset_in0.reset
		.reset_in1      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in1.reset
		.clk            (iopll_sys_outclk0_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_002 (
		.reset_in0      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in0.reset
		.clk            (iopll_sys_outclk3_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_002_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_003 (
		.reset_in0      (~reset_in_vvp_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (iopll_sys_outclk3_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_003_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_004 (
		.reset_in0      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in0.reset
		.clk            (iopll_sys_outclk0_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_004_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

endmodule
