/*
 * VVP_PIP.h
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#ifndef VVP_PIP_H_
#define VVP_PIP_H_

#include <stdint.h>
#include <stdbool.h>
#include "intel_vvp_pip_conv_regs.h"
#include "intel_vvp_pip_conv.h"
#include "VVP_Core.h"

#define PIP_IMG_INFO_WIDTH			0x0120
#define PIP_IMG_INFO_SUBSAMPLING    0x0134
#define PIP_STATUS					0x0140


class VVP_PIP : public VVP_CORE {
protected:
	intel_vvp_pip_conv_instance  m_instance;
public:
	VVP_PIP(uint32_t BaseAddr);
	virtual ~VVP_PIP();

	void ShowStatus();
	bool Config(int nWidth=1920, int nSubSampling = 3);
	bool Run(bool Start = true);
	bool IsLiteMode();
};

#endif /* VVP_PIP_H_ */
