/*
 * VVP_FB.cpp
 *
 *  Created on: Aug 23, 2024
 *      Author: Richard
 */
#include <stdio.h>
#include <stdlib.h> // malloc, free
#include <unistd.h>  // usleep (unix standard?)
#include "system.h"
#include "io.h"
#include "VVP_FB.h"



VVP_FB::VVP_FB(uint32_t BaseAddr):
VVP_CORE(BaseAddr){
	// TODO Auto-generated destructor stub
	int result;
	result =  intel_vvp_vfb_init(&m_instance, (intel_vvp_core_base)BaseAddr);
	if (result != 0){
		printf("intel_vvp_vfb_init failed\r\n");
	}else{
		m_bValidInstance = true;
	}
}

VVP_FB::~VVP_FB() {
	// TODO Auto-generated constructor stub

}

void VVP_FB::ShowStatus() {
	// TODO Auto-generated destructor stub

	int result;
	bool bYes;
	uint32_t  status, value32;
	uint8_t value8;

	if (!m_bValidInstance){
		printf("FB invalid instance\r\n");
		return;
	}
	printf("=========== FB Status =============\r\n");

		bYes = intel_vvp_vfb_get_lite_mode(&m_instance);
		printf("FB lite mode: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_vfb_get_debug_enabled(&m_instance);
		printf("FB debug mode: %s\r\n", bYes?"Yes":"No");

		result =  intel_vvp_vfb_get_bits_per_sample(&m_instance);
		printf("FB bit per sample: %d\r\n", result);

		value8 =  intel_vvp_vfb_get_num_color_planes(&m_instance);
		printf("FB number of color plane: %d\r\n", value8);

		value8 =  intel_vvp_vfb_get_pixels_in_parallel(&m_instance);
		printf("FB pixel in parallel: %d\r\n", value8);

		bYes = intel_vvp_vfb_is_input_running(&m_instance);
		printf("FB input running: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_vfb_is_output_running(&m_instance);
		printf("FB output running: %s\r\n", bYes?"Yes":"No");

		status =  intel_vvp_vfb_get_input_status(&m_instance);
		printf("FB input status: %d\r\n", status);

		status =  intel_vvp_vfb_get_output_status(&m_instance);
		printf("FB output status: %d\r\n", status);

		bYes =  intel_vvp_vfb_is_output_enabled(&m_instance);
		printf("FB output enabled: %s\r\n", bYes?"Yes":"No");

		// via register access
		printf("query via register\r\n");

		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_WIDTH);
		printf("FB image width: %d (%xh)\r\n", (value32 & 0xFFFF) , value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_HEIGHT);
		printf("FB image width: %d (%xh)\r\n", (value32 & 0xFFFF), value32);



		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_INTERLACE);
		printf("FB Interface Nibble bits: %d (%xh)\r\n", (value32 & 0xF), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_COLORSPACE);
		printf("FB color space: %d (%xh)\r\n", (value32 & 0x7F), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_SUBSAMPLING);
		printf("FB Sub Sampleing: %d (%xh)\r\n", (value32 & 0x3), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_COSITING);
		printf("FB Cosite Code: %d (%xh)\r\n", (value32 & 0x7F), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_IMG_INFO_FIELD_COUNT);
		printf("FB Count: %d (%xh)\r\n", (value32 & 0x7F), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_INPUT_STATUS);
		printf("FB Input status: %d (%xh)\r\n", (value32 & 0x1), value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_NUM_INPUT_FIELDS);
		printf("FB input field count: %d (%xh)\r\n", value32, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_NUM_DROPPED_FIELDS);
		printf("FB drop field count: %d (%xh)\r\n", value32, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_NUM_INVALID_FIELDS);
		printf("FB invalid field count: %d (%xh)\r\n", value32, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_OUTPUT_STATUS);
		printf("FB output status: %d (%xh)\r\n", value32 & 0x01, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_NUM_OUTPUT_FIELDS);
		printf("FB output field count: %d (%xh)\r\n", value32, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, FB_NUM_REPEATED_FIELDS);
		printf("FB repeated field count: %d (%xh)\r\n", value32, value32);


		value32 = IORD_32DIRECT(m_BaseAddr, FB_OUTPUT_CONTROL);
		printf("FB output control: %d (%xh)\r\n", value32 & 0x01, value32);

		printf("\r\n");

}

bool VVP_FB::Config(int nWidth, int nHeight){
	int nIntlaceNibble = 0; //Progressive frame
	int nColorSpace = 0; //RGB
	int nSubSampling = 3; // sub-sampling x1, H sub-sampling x1, sumb-sampling 444
	int nCositing = 0; // top and left

	if (!m_bValidInstance){
		printf("FB invalid instance\r\n");
		return false;
	}

	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_WIDTH, nWidth);
	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_HEIGHT, nHeight);
	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_INTERLACE, nIntlaceNibble);

	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_COLORSPACE, nColorSpace);
	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_SUBSAMPLING, nSubSampling);
	IOWR_32DIRECT(m_BaseAddr, FB_IMG_INFO_COSITING, nCositing);

	return true;

}


bool VVP_FB::Run(bool bRun){
	if (!m_bValidInstance){
		printf("FB invalid instance\r\n");
		return false;
	}

	IOWR_32DIRECT(m_BaseAddr, FB_OUTPUT_CONTROL, bRun?0x01:0x00);

	return true;

}

bool VVP_FB::IsLiteMode(){
	bool bYes;

	if (!m_bValidInstance){
		printf("FB invalid instance\r\n");
		return false;
	}
	bYes = intel_vvp_vfb_get_lite_mode(&m_instance);
	return bYes;
}
