// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module intel_vvp_vtiming_core
#(
  parameter DEVICE_FAMILY                           = "Arria 10", // -- Cyclone 10 GX -- Arria 10 -- Stratix 10 -- Agilex
  parameter C_CPU_OFFSET                            = 16,
  parameter C_NUM_PULSES                            =  2,
  parameter RUNTIME_CONTROL                         =  1, // standard VVP name
  parameter C_OUTPUT_IS_CV                          =  1,
  parameter C_USE_BLANKS                            =  1,
  parameter C_USE_SYNCS                             =  1,
  parameter NUMBER_OF_COLOR_PLANES                  =  3, // standard VVP name
  parameter PIXELS_IN_PARALLEL                      =  1, // standard VVP name
  parameter BPS                                     = 10, // standard VVP name
  parameter C_HSIZE                                 = 14, // max 16k pixels
  parameter C_VSIZE                                 = 14, // max 16k lines
  parameter ALIGNED_ONLY                            = 0,  // if 1, instance the smaller restricted core

  parameter C_CPU_CLK_FREQ_HZ                       = 100000000,

  parameter C_BUILD_VRR                             = 1,
  parameter C_BUILD_HARD_FRAME_LOCK                 = 1,
  parameter C_BUILD_SOFT_FRAME_LOCK                 = 1,

  parameter C_DEFAULT_OUT_IS_BLANK                  = 0,
  parameter C_DEFAULT_BLACK_0                       = 0,
  parameter C_DEFAULT_BLACK_1                       = 0,
  parameter C_DEFAULT_BLACK_2                       = 0,
  parameter C_DEFAULT_BLACK_3                       = 0,
  parameter C_DEFAULT_ENABLE_FRAME_LOCK             = 0,
  parameter C_DEFAULT_ENABLE_SOFT_LOCK              = 0,
  parameter C_DEFAULT_ENABLE_VARIABLE_REFRESH_RATE  = 0,
  parameter C_DEFAULT_ENABLE_VRR_LINEMODE           = 0,
  parameter C_DEFAULT_FRAME_START_PULSE             = 0,        // 1=frame start is a once-per-frame toggle. 0=frame start is a pulse once per frame.
  parameter C_DEFAULT_FRAME_START_MAX_JITTER        = 15,       // number of pixels of jitter allowed to create the "legal" window in which the start pulse can arrive
  parameter C_DEFAULT_FRAME_ADJ_IGNORE_LINES        = 3,        // number of lines for the +/- window that does not change the total_v
  parameter C_DEFAULT_FRAME_ADJ_WINDOW_LINES        = 6,        // number of lines start/end of the window that adjusts the total_v
  
  // default timing parameters
  parameter C_TIM_HRESET                            = 1,        // H Total
  parameter C_TIM_VRESET                            = 1,        // V Total
  parameter C_TIM_HTOTAL                            = 2200,     // H Total
  parameter C_TIM_VTOTAL                            = 1125,     // V Total
  parameter C_TIM_HB_END                            = 280,      // H-Active Start
  parameter C_TIM_V1B_START                         = 1122,     // V1-Blank Start
  parameter C_TIM_V1B_END                           = 44,       // V1-Blank End
  parameter C_TIM_V2B_START                         = 9999,     // V2-Blank Start
  parameter C_TIM_V2B_END                           = 9999,     // V2-Blank End
  parameter C_TIM_F1_START                          = 1,        // F1-Start
  parameter C_TIM_F2_START                          = 9999,     // F2-Start
  parameter C_TIM_HS_START                          = 5,        // HSync Start Pos
  parameter C_TIM_HS_END                            = 10,       // HSync End Pos
  parameter C_TIM_V1S_VSTART                        = 5,        // V1Sync Start Line
  parameter C_TIM_V1S_HSTART                        = 4,        // V1Sync Start HPos
  parameter C_TIM_V1S_VEND                          = 6,        // V1Sync End Line
  parameter C_TIM_V1S_HEND                          = 10,       // V1Sync End HPos
  parameter C_TIM_V2S_VSTART                        = 7,        // V2Sync Start Line
  parameter C_TIM_V2S_HSTART                        = 1,        // V2Sync Start HPos
  parameter C_TIM_V2S_VEND                          = 8,        // V2Sync End Line
  parameter C_TIM_V2S_HEND                          = 10,       // V2Sync End HPos
  parameter C_TIM_PULSE0_VSTART                     = 1,        // Line in which to generate pulse 0 (SOF_EARLY)
  parameter C_TIM_PULSE0_HSTART                     = 1,        // Pixel in which to generate pulse 0 (SOF_EARLY)
  parameter C_TIM_PULSE0_VEND                       = 1,        // Line in which to end pulse 0 (SOF_EARLY)
  parameter C_TIM_PULSE0_HEND                       = 1,        // Pixel in which to end pulse 0 (SOF_EARLY)
  parameter C_TIM_PULSE1_VSTART                     = 5,        // Line in which to generate pulse 1 (SOF)
  parameter C_TIM_PULSE1_HSTART                     = 1,        // Pixel in which to generate pulse 1 (SOF)
  parameter C_TIM_PULSE1_VEND                       = 5,        // Line in which to end pulse 1 (SOF)
  parameter C_TIM_PULSE1_HEND                       = 1,        // Pixel in which to end pulse 1 (SOF)
  parameter C_TIM_PULSE2_VSTART                     = 9999,     // Line in which to generate pulse 2
  parameter C_TIM_PULSE2_HSTART                     = 9999,     // Pixel in which to generate pulse 2
  parameter C_TIM_PULSE2_VEND                       = 9999,     // Line in which to end pulse 2
  parameter C_TIM_PULSE2_HEND                       = 9999,     // Pixel in which to end pulse 2
  parameter C_TIM_PULSE3_VSTART                     = 9999,     // Line in which to generate pulse 3
  parameter C_TIM_PULSE3_HSTART                     = 9999,     // Pixel in which to generate pulse 3
  parameter C_TIM_PULSE3_VEND                       = 9999,     // Line in which to end pulse 3
  parameter C_TIM_PULSE3_HEND                       = 9999,     // Pixel in which to end pulse 3
  parameter C_TIM_PULSE4_VSTART                     = 9999,     // Line in which to generate pulse 4
  parameter C_TIM_PULSE4_HSTART                     = 9999,     // Pixel in which to generate pulse 4
  parameter C_TIM_PULSE4_VEND                       = 9999,     // Line in which to end pulse 4
  parameter C_TIM_PULSE4_HEND                       = 9999,     // Pixel in which to end pulse 4
  parameter C_TIM_PULSE5_VSTART                     = 9999,     // Line in which to generate pulse 5
  parameter C_TIM_PULSE5_HSTART                     = 9999,     // Pixel in which to generate pulse 5
  parameter C_TIM_PULSE5_VEND                       = 9999,     // Line in which to end pulse 5
  parameter C_TIM_PULSE5_HEND                       = 9999,     // Pixel in which to end pulse 5
  parameter C_TIM_PULSE6_VSTART                     = 9999,     // Line in which to generate pulse 6
  parameter C_TIM_PULSE6_HSTART                     = 9999,     // Pixel in which to generate pulse 6
  parameter C_TIM_PULSE6_VEND                       = 9999,     // Line in which to end pulse 6
  parameter C_TIM_PULSE6_HEND                       = 9999,     // Pixel in which to end pulse 6
  parameter C_TIM_PULSE7_VSTART                     = 9999,     // Line in which to generate pulse 7
  parameter C_TIM_PULSE7_HSTART                     = 9999,     // Pixel in which to generate pulse 7
  parameter C_TIM_PULSE7_VEND                       = 9999,     // Line in which to end pulse 7
  parameter C_TIM_PULSE7_HEND                       = 9999      // Pixel in which to end pulse 7

)
(
  cpu_clk,
  cpu_rst,

  av_mm_cpu_agent_address,
  av_mm_cpu_agent_read,
  av_mm_cpu_agent_readdata,
  av_mm_cpu_agent_readdatavalid,
  av_mm_cpu_agent_waitrequest,
  av_mm_cpu_agent_write,
  av_mm_cpu_agent_writedata,
  av_mm_cpu_agent_byteenable,

  vid_clk,
  vid_rst,

  cv_vid_out_data,        
  cv_vid_out_active,
  cv_vid_out_f,     
  cv_vid_out_h,     
  cv_vid_out_v,     
  cv_vid_out_h_sync,
  cv_vid_out_v_sync,
  cv_vid_out_valid,
  cv_vid_out_ready,
  
  axi4s_fr_vid_out_tdata,
  axi4s_fr_vid_out_tuser,
  axi4s_fr_vid_out_tvalid,  
  axi4s_fr_vid_out_tready,  // this is not used, but is retained here to "complete" the axis protocol
  axi4s_fr_vid_out_tlast,   // this is not used, but is retained here to "complete" the axis protocol

  frame_start,
  
  pulse0, // sof
  pulse1, // sof_delay
  pulse2,
  pulse3,
  pulse4,
  pulse5,
  pulse6,
  pulse7
  
);
// calculate localparams needed for the interface.
localparam C_PADDED_BPS       = (BPS < 8) ? 8 : BPS;
localparam C_AXIS_PIXEL_BYTES = ((NUMBER_OF_COLOR_PLANES+1)*C_PADDED_BPS+7)/8;
localparam C_AXIS_WIDTH       = C_AXIS_PIXEL_BYTES*PIXELS_IN_PARALLEL*8;
localparam C_TUSER_WIDTH      = C_AXIS_PIXEL_BYTES*PIXELS_IN_PARALLEL;
localparam C_CV_PIXEL_BITS    = NUMBER_OF_COLOR_PLANES * BPS;
localparam C_CV_WIDTH         = PIXELS_IN_PARALLEL * C_CV_PIXEL_BITS;

input  logic                         cpu_clk;
input  logic                         cpu_rst;
input  logic [ 5:0]                  av_mm_cpu_agent_address;
input  logic                         av_mm_cpu_agent_read;
output logic [31:0]                  av_mm_cpu_agent_readdata;
output logic                         av_mm_cpu_agent_readdatavalid;
output logic                         av_mm_cpu_agent_waitrequest;
input  logic                         av_mm_cpu_agent_write;
input  logic [31:0]                  av_mm_cpu_agent_writedata;
input  logic [ 3:0]                  av_mm_cpu_agent_byteenable;

input  logic                         vid_clk;
input  logic                         vid_rst;

output logic [C_CV_WIDTH - 1    : 0] cv_vid_out_data;         
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_f;    
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_h;     
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_v;     
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_h_sync;
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_v_sync;
output logic [PIXELS_IN_PARALLEL-1 : 0] cv_vid_out_active;
output logic                            cv_vid_out_valid = 1'b1;
input  logic                            cv_vid_out_ready;

output logic [C_AXIS_WIDTH - 1  : 0] axi4s_fr_vid_out_tdata;
output logic [C_TUSER_WIDTH - 1 : 0] axi4s_fr_vid_out_tuser;
output logic                         axi4s_fr_vid_out_tvalid;  
input  logic                         axi4s_fr_vid_out_tready;// = 1'b1;  // this is not used, but is retained here to "complete" the axis protocol
output logic                         axi4s_fr_vid_out_tlast;

input  logic                         frame_start;

output logic                         pulse0; // sof
output logic                         pulse1; // sof_delay
output logic                         pulse2;
output logic                         pulse3;
output logic                         pulse4;
output logic                         pulse5;
output logic                         pulse6;
output logic                         pulse7;



///////////////////////////////////////////////////////////////////////////////
//
// Combine the clocks/resets for the two mutually exclusive output types
//

logic               r_vid_frame_start_pulse;
logic [C_HSIZE-1:0] r_vid_tim_hreset       ;
logic [C_VSIZE-1:0] r_vid_tim_vreset       ;

logic [C_HSIZE-1:0] r_vid_tim_htotal       ;
logic [C_VSIZE-1:0] r_vid_tim_vtotal       ;
logic [C_HSIZE-1:0] r_vid_tim_hb_end       ;
logic [C_VSIZE-1:0] r_vid_tim_v1b_start    ;
logic [C_VSIZE-1:0] r_vid_tim_v1b_end      ;
logic [C_VSIZE-1:0] r_vid_tim_v2b_start    ;
logic [C_VSIZE-1:0] r_vid_tim_v2b_end      ;
logic [C_VSIZE-1:0] r_vid_tim_f1_start     ;
logic [C_VSIZE-1:0] r_vid_tim_f2_start     ;
logic [C_HSIZE-1:0] r_vid_tim_hs_start     ;
logic [C_HSIZE-1:0] r_vid_tim_hs_end       ;
logic [C_VSIZE-1:0] r_vid_tim_v1s_vstart   ;
logic [C_HSIZE-1:0] r_vid_tim_v1s_hstart   ;
logic [C_VSIZE-1:0] r_vid_tim_v1s_vend     ;
logic [C_HSIZE-1:0] r_vid_tim_v1s_hend     ;
logic [C_VSIZE-1:0] r_vid_tim_v2s_vstart   ;
logic [C_HSIZE-1:0] r_vid_tim_v2s_hstart   ;
logic [C_VSIZE-1:0] r_vid_tim_v2s_vend     ;
logic [C_HSIZE-1:0] r_vid_tim_v2s_hend     ;

logic [C_VSIZE-1:0] r_vid_tim_pulse0_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse0_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse0_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse0_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse1_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse1_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse1_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse1_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse2_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse2_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse2_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse2_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse3_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse3_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse3_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse3_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse4_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse4_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse4_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse4_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse5_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse5_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse5_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse5_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse6_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse6_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse6_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse6_hend  ;
logic [C_VSIZE-1:0] r_vid_tim_pulse7_vstart;
logic [C_HSIZE-1:0] r_vid_tim_pulse7_hstart;
logic [C_VSIZE-1:0] r_vid_tim_pulse7_vend  ;
logic [C_HSIZE-1:0] r_vid_tim_pulse7_hend  ;
logic               r_vid_allow_hv_reset   ;
logic               r_vid_out_is_blank     ;
logic [C_CV_PIXEL_BITS-1:0] r_vid_black    ;
logic               r_vid_use_soft_reset   ;
logic               r_vid_vrr              ;
logic               r_vid_vrr_linemode     ;
logic [        7:0] r_vid_frame_start_jitter;
logic [        7:0] r_vid_frame_adj_ignore  ;
logic [        7:0] r_vid_frame_adj_window  ;

logic [C_VSIZE-1 : 0] r_vid_tim_vtotal_latched ;
logic [C_HSIZE + C_VSIZE - 1  : 0] r_actual_pixels_latched;

logic [15:0]                       r_vid_start_counter;
logic [15:0]                       r_vid_frame_count;

logic                              r_pixel_00;

logic [15:0]                       r_vid_hv_reset_count;

logic [15:0]                       vid_inc_count    ;
logic [15:0]                       vid_dec_count    ;
logic [15:0]                       vid_stable_count ;


intel_vvp_vtiming_cpu
#(
  .C_BUILD_VRR                             ( C_BUILD_VRR                             ),
  .C_BUILD_HARD_FRAME_LOCK                 ( C_BUILD_HARD_FRAME_LOCK                 ),
  .C_BUILD_SOFT_FRAME_LOCK                 ( C_BUILD_SOFT_FRAME_LOCK && C_BUILD_HARD_FRAME_LOCK ),

  .C_CPU_OFFSET                            ( C_CPU_OFFSET                            ),
  .C_NUM_PULSES                            ( C_NUM_PULSES                            ),
  .C_USE_CPU                               ( RUNTIME_CONTROL                         ),
  .C_OUTPUT_IS_CV                          ( C_OUTPUT_IS_CV                          ),
  .C_CV_NUM_PLANES                         ( NUMBER_OF_COLOR_PLANES                  ),
  .C_CV_NUM_PIXELS                         ( PIXELS_IN_PARALLEL                      ),
  .C_CV_BIT_DEPTH                          ( BPS                                     ),
  .C_HSIZE                                 ( C_HSIZE                                 ),    // max 16k pixels
  .C_VSIZE                                 ( C_VSIZE                                 ),    // max 16k lines

  .C_CPU_CLK_FREQ_HZ                       ( C_CPU_CLK_FREQ_HZ                       ),

  .C_DEFAULT_OUT_IS_BLANK                  ( C_DEFAULT_OUT_IS_BLANK                  ),
  .C_DEFAULT_BLACK_0                       ( C_DEFAULT_BLACK_0                       ),
  .C_DEFAULT_BLACK_1                       ( C_DEFAULT_BLACK_1                       ),
  .C_DEFAULT_BLACK_2                       ( C_DEFAULT_BLACK_2                       ),
  .C_DEFAULT_BLACK_3                       ( C_DEFAULT_BLACK_3                       ),
  .C_DEFAULT_ENABLE_FRAME_LOCK             ( C_DEFAULT_ENABLE_FRAME_LOCK            && (C_BUILD_HARD_FRAME_LOCK == 1)  ),
  .C_DEFAULT_ENABLE_SOFT_LOCK              ( C_DEFAULT_ENABLE_SOFT_LOCK             && (C_BUILD_HARD_FRAME_LOCK == 1) && (C_BUILD_SOFT_FRAME_LOCK == 1)  ),
  .C_DEFAULT_ENABLE_VARIABLE_REFRESH_RATE  ( C_DEFAULT_ENABLE_VARIABLE_REFRESH_RATE && (C_BUILD_VRR == 1)  ),
  .C_DEFAULT_ENABLE_VRR_LINEMODE           ( C_DEFAULT_ENABLE_VRR_LINEMODE          && (C_BUILD_VRR == 1)  ),
  .C_DEFAULT_FRAME_START_PULSE             ( C_DEFAULT_FRAME_START_PULSE             ),    // 1=frame start is a once-per-frame toggle. 0=frame start is a pulse once per frame.
  .C_DEFAULT_FRAME_START_MAX_JITTER        ( C_DEFAULT_FRAME_START_MAX_JITTER        ),    // number of pixels of jitter allowed to create the "legal" window in which the start pulse can arrive
  .C_DEFAULT_FRAME_ADJ_IGNORE_LINES        ( C_DEFAULT_FRAME_ADJ_IGNORE_LINES        ),    // number of lines for the +/- window that does not change the total_v
  .C_DEFAULT_FRAME_ADJ_WINDOW_LINES        ( C_DEFAULT_FRAME_ADJ_WINDOW_LINES        ),    // number of lines start/end of the window that adjusts the total_v

  // default timing parameters           
  .C_TIM_HRESET                            ( C_TIM_HRESET                            ),    // H Total
  .C_TIM_VRESET                            ( C_TIM_VRESET                            ),    // V Total
  .C_TIM_HTOTAL                            ( C_TIM_HTOTAL                            ),    // H Total
  .C_TIM_VTOTAL                            ( C_TIM_VTOTAL                            ),    // V Total
  .C_TIM_HB_END                            ( C_TIM_HB_END                            ),    // H-Active Start
  .C_TIM_V1B_START                         ( C_TIM_V1B_START                         ),    // V1-Blank Start
  .C_TIM_V1B_END                           ( C_TIM_V1B_END                           ),    // V1-Blank End
  .C_TIM_V2B_START                         ( C_TIM_V2B_START                         ),    // V2-Blank Start
  .C_TIM_V2B_END                           ( C_TIM_V2B_END                           ),    // V2-Blank End
  .C_TIM_F1_START                          ( C_TIM_F1_START                          ),    // F1-Start
  .C_TIM_F2_START                          ( C_TIM_F2_START                          ),    // F2-Start
  .C_TIM_HS_START                          ( C_TIM_HS_START                          ),    // HSync Start Pos
  .C_TIM_HS_END                            ( C_TIM_HS_END                            ),    // HSync End Pos
  .C_TIM_V1S_VSTART                        ( C_TIM_V1S_VSTART                        ),    // V1Sync Start Line
  .C_TIM_V1S_HSTART                        ( C_TIM_V1S_HSTART                        ),    // V1Sync Start HPos
  .C_TIM_V1S_VEND                          ( C_TIM_V1S_VEND                          ),    // V1Sync End Line
  .C_TIM_V1S_HEND                          ( C_TIM_V1S_HEND                          ),    // V1Sync End HPos
  .C_TIM_V2S_VSTART                        ( C_TIM_V2S_VSTART                        ),    // V2Sync Start Line
  .C_TIM_V2S_HSTART                        ( C_TIM_V2S_HSTART                        ),    // V2Sync Start HPos
  .C_TIM_V2S_VEND                          ( C_TIM_V2S_VEND                          ),    // V2Sync End Line
  .C_TIM_V2S_HEND                          ( C_TIM_V2S_HEND                          ),    // V2Sync End HPos
  .C_TIM_PULSE0_VSTART                     ( C_TIM_PULSE0_VSTART                     ),    // Line in which to generate pulse 0 (SOF_EARLY)
  .C_TIM_PULSE0_HSTART                     ( C_TIM_PULSE0_HSTART                     ),    // Pixel in which to generate pulse 0 (SOF_EARLY)
  .C_TIM_PULSE0_VEND                       ( C_TIM_PULSE0_VEND                       ),    // Line in which to end pulse 0 (SOF_EARLY)
  .C_TIM_PULSE0_HEND                       ( C_TIM_PULSE0_HEND                       ),    // Pixel in which to end pulse 0 (SOF_EARLY)
  .C_TIM_PULSE1_VSTART                     ( C_TIM_PULSE1_VSTART                     ),    // Line in which to generate pulse 1 (SOF)
  .C_TIM_PULSE1_HSTART                     ( C_TIM_PULSE1_HSTART                     ),    // Pixel in which to generate pulse 1 (SOF)
  .C_TIM_PULSE1_VEND                       ( C_TIM_PULSE1_VEND                       ),    // Line in which to end pulse 1 (SOF)
  .C_TIM_PULSE1_HEND                       ( C_TIM_PULSE1_HEND                       ),    // Pixel in which to end pulse 1 (SOF)
  .C_TIM_PULSE2_VSTART                     ( C_TIM_PULSE2_VSTART                     ),    // Line in which to generate pulse 2
  .C_TIM_PULSE2_HSTART                     ( C_TIM_PULSE2_HSTART                     ),    // Pixel in which to generate pulse 2
  .C_TIM_PULSE2_VEND                       ( C_TIM_PULSE2_VEND                       ),    // Line in which to end pulse 2
  .C_TIM_PULSE2_HEND                       ( C_TIM_PULSE2_HEND                       ),    // Pixel in which to end pulse 2
  .C_TIM_PULSE3_VSTART                     ( C_TIM_PULSE3_VSTART                     ),    // Line in which to generate pulse 3
  .C_TIM_PULSE3_HSTART                     ( C_TIM_PULSE3_HSTART                     ),    // Pixel in which to generate pulse 3
  .C_TIM_PULSE3_VEND                       ( C_TIM_PULSE3_VEND                       ),    // Line in which to end pulse 3
  .C_TIM_PULSE3_HEND                       ( C_TIM_PULSE3_HEND                       ),    // Pixel in which to end pulse 3
  .C_TIM_PULSE4_VSTART                     ( C_TIM_PULSE4_VSTART                     ),    // Line in which to generate pulse 4
  .C_TIM_PULSE4_HSTART                     ( C_TIM_PULSE4_HSTART                     ),    // Pixel in which to generate pulse 4
  .C_TIM_PULSE4_VEND                       ( C_TIM_PULSE4_VEND                       ),    // Line in which to end pulse 4
  .C_TIM_PULSE4_HEND                       ( C_TIM_PULSE4_HEND                       ),    // Pixel in which to end pulse 4
  .C_TIM_PULSE5_VSTART                     ( C_TIM_PULSE5_VSTART                     ),    // Line in which to generate pulse 5
  .C_TIM_PULSE5_HSTART                     ( C_TIM_PULSE5_HSTART                     ),    // Pixel in which to generate pulse 5
  .C_TIM_PULSE5_VEND                       ( C_TIM_PULSE5_VEND                       ),    // Line in which to end pulse 5
  .C_TIM_PULSE5_HEND                       ( C_TIM_PULSE5_HEND                       ),    // Pixel in which to end pulse 5
  .C_TIM_PULSE6_VSTART                     ( C_TIM_PULSE6_VSTART                     ),    // Line in which to generate pulse 6
  .C_TIM_PULSE6_HSTART                     ( C_TIM_PULSE6_HSTART                     ),    // Pixel in which to generate pulse 6
  .C_TIM_PULSE6_VEND                       ( C_TIM_PULSE6_VEND                       ),    // Line in which to end pulse 6
  .C_TIM_PULSE6_HEND                       ( C_TIM_PULSE6_HEND                       ),    // Pixel in which to end pulse 6
  .C_TIM_PULSE7_VSTART                     ( C_TIM_PULSE7_VSTART                     ),    // Line in which to generate pulse 7
  .C_TIM_PULSE7_HSTART                     ( C_TIM_PULSE7_HSTART                     ),    // Pixel in which to generate pulse 7
  .C_TIM_PULSE7_VEND                       ( C_TIM_PULSE7_VEND                       ),    // Line in which to end pulse 7
  .C_TIM_PULSE7_HEND                       ( C_TIM_PULSE7_HEND                       )     // Pixel in which to end pulse 7
) i_cpu_regs
(
  .cpu_clk                  ( cpu_clk                  ),
  .cpu_rst                  ( cpu_rst                  ),
  .av_address               ( av_mm_cpu_agent_address       ),
  .av_read                  ( av_mm_cpu_agent_read          ),
  .av_readdata              ( av_mm_cpu_agent_readdata      ),
  .av_readdatavalid         ( av_mm_cpu_agent_readdatavalid ),
  .av_waitrequest           ( av_mm_cpu_agent_waitrequest   ),
  .av_write                 ( av_mm_cpu_agent_write         ),
  .av_writedata             ( av_mm_cpu_agent_writedata     ),
  .av_byteenable            ( av_mm_cpu_agent_byteenable    ),

  .vid_clk                  ( vid_clk                  ),
  .vid_rst                  ( vid_rst                  ),

  .frame_start              ( frame_start              ),

  // cpu defined regs    
  .r_vid_frame_start_pulse  ( r_vid_frame_start_pulse  ),
  .r_vid_tim_hreset         ( r_vid_tim_hreset         ),
  .r_vid_tim_vreset         ( r_vid_tim_vreset         ),

  .r_vid_tim_htotal         ( r_vid_tim_htotal         ),
  .r_vid_tim_vtotal         ( r_vid_tim_vtotal         ),
  .r_vid_tim_hb_end         ( r_vid_tim_hb_end         ),
  .r_vid_tim_v1b_start      ( r_vid_tim_v1b_start      ),
  .r_vid_tim_v1b_end        ( r_vid_tim_v1b_end        ),
  .r_vid_tim_v2b_start      ( r_vid_tim_v2b_start      ),
  .r_vid_tim_v2b_end        ( r_vid_tim_v2b_end        ),
  .r_vid_tim_f1_start       ( r_vid_tim_f1_start       ),
  .r_vid_tim_f2_start       ( r_vid_tim_f2_start       ),
  .r_vid_tim_hs_start       ( r_vid_tim_hs_start       ),
  .r_vid_tim_hs_end         ( r_vid_tim_hs_end         ),
  .r_vid_tim_v1s_vstart     ( r_vid_tim_v1s_vstart     ),
  .r_vid_tim_v1s_hstart     ( r_vid_tim_v1s_hstart     ),
  .r_vid_tim_v1s_vend       ( r_vid_tim_v1s_vend       ),
  .r_vid_tim_v1s_hend       ( r_vid_tim_v1s_hend       ),
  .r_vid_tim_v2s_vstart     ( r_vid_tim_v2s_vstart     ),
  .r_vid_tim_v2s_hstart     ( r_vid_tim_v2s_hstart     ),
  .r_vid_tim_v2s_vend       ( r_vid_tim_v2s_vend       ),
  .r_vid_tim_v2s_hend       ( r_vid_tim_v2s_hend       ),

  .r_vid_tim_pulse0_vstart  ( r_vid_tim_pulse0_vstart  ),
  .r_vid_tim_pulse0_hstart  ( r_vid_tim_pulse0_hstart  ),
  .r_vid_tim_pulse0_vend    ( r_vid_tim_pulse0_vend    ),
  .r_vid_tim_pulse0_hend    ( r_vid_tim_pulse0_hend    ),
  .r_vid_tim_pulse1_vstart  ( r_vid_tim_pulse1_vstart  ),
  .r_vid_tim_pulse1_hstart  ( r_vid_tim_pulse1_hstart  ),
  .r_vid_tim_pulse1_vend    ( r_vid_tim_pulse1_vend    ),
  .r_vid_tim_pulse1_hend    ( r_vid_tim_pulse1_hend    ),
  .r_vid_tim_pulse2_vstart  ( r_vid_tim_pulse2_vstart  ),
  .r_vid_tim_pulse2_hstart  ( r_vid_tim_pulse2_hstart  ),
  .r_vid_tim_pulse2_vend    ( r_vid_tim_pulse2_vend    ),
  .r_vid_tim_pulse2_hend    ( r_vid_tim_pulse2_hend    ),
  .r_vid_tim_pulse3_vstart  ( r_vid_tim_pulse3_vstart  ),
  .r_vid_tim_pulse3_hstart  ( r_vid_tim_pulse3_hstart  ),
  .r_vid_tim_pulse3_vend    ( r_vid_tim_pulse3_vend    ),
  .r_vid_tim_pulse3_hend    ( r_vid_tim_pulse3_hend    ),
  .r_vid_tim_pulse4_vstart  ( r_vid_tim_pulse4_vstart  ),
  .r_vid_tim_pulse4_hstart  ( r_vid_tim_pulse4_hstart  ),
  .r_vid_tim_pulse4_vend    ( r_vid_tim_pulse4_vend    ),
  .r_vid_tim_pulse4_hend    ( r_vid_tim_pulse4_hend    ),
  .r_vid_tim_pulse5_vstart  ( r_vid_tim_pulse5_vstart  ),
  .r_vid_tim_pulse5_hstart  ( r_vid_tim_pulse5_hstart  ),
  .r_vid_tim_pulse5_vend    ( r_vid_tim_pulse5_vend    ),
  .r_vid_tim_pulse5_hend    ( r_vid_tim_pulse5_hend    ),
  .r_vid_tim_pulse6_vstart  ( r_vid_tim_pulse6_vstart  ),
  .r_vid_tim_pulse6_hstart  ( r_vid_tim_pulse6_hstart  ),
  .r_vid_tim_pulse6_vend    ( r_vid_tim_pulse6_vend    ),
  .r_vid_tim_pulse6_hend    ( r_vid_tim_pulse6_hend    ),
  .r_vid_tim_pulse7_vstart  ( r_vid_tim_pulse7_vstart  ),
  .r_vid_tim_pulse7_hstart  ( r_vid_tim_pulse7_hstart  ),
  .r_vid_tim_pulse7_vend    ( r_vid_tim_pulse7_vend    ),
  .r_vid_tim_pulse7_hend    ( r_vid_tim_pulse7_hend    ),
  .r_vid_allow_hv_reset     ( r_vid_allow_hv_reset     ),
  .r_vid_out_is_blank       ( r_vid_out_is_blank       ),
  .r_vid_black              ( r_vid_black              ),
  .r_vid_use_soft_reset     ( r_vid_use_soft_reset     ),
  .r_vid_vrr                ( r_vid_vrr                ),
  .r_vid_vrr_linemode       ( r_vid_vrr_linemode       ),

  .r_vid_start_counter      ( r_vid_start_counter      ),
  .r_vid_frame_count        ( r_vid_frame_count        ),
  .r_vid_frame_start_jitter ( r_vid_frame_start_jitter ),
  .r_vid_frame_adj_ignore   ( r_vid_frame_adj_ignore   ),
  .r_vid_frame_adj_window   ( r_vid_frame_adj_window   ),
  // data for cpu to read  
  .r_actual_pixels_latched  ( r_actual_pixels_latched  ),
  .r_vid_tim_vtotal_latched ( r_vid_tim_vtotal_latched ),
  .r_pixel_00               ( r_pixel_00               ),
 
  .r_vid_hv_reset_count     ( r_vid_hv_reset_count     ),

  .vid_inc_count            ( vid_inc_count            ),
  .vid_dec_count            ( vid_dec_count            ),
  .vid_stable_count         ( vid_stable_count         )
  
);



if (ALIGNED_ONLY || (PIXELS_IN_PARALLEL==1))
begin:g_ALLIGNED_CORE
  intel_vvp_vtiming_gen_aligned
  #(
    .C_BUILD_VRR                 ( C_BUILD_VRR              ),
    .C_BUILD_HARD_FRAME_LOCK     ( C_BUILD_HARD_FRAME_LOCK  ),
    .C_BUILD_SOFT_FRAME_LOCK     ( C_BUILD_HARD_FRAME_LOCK && C_BUILD_SOFT_FRAME_LOCK ),
    .C_NUM_PULSES                ( C_NUM_PULSES             ),  
    .C_USE_CPU                   ( RUNTIME_CONTROL          ),  
    .C_OUTPUT_IS_CV              ( C_OUTPUT_IS_CV           ),  
    .C_CV_NUM_PLANES             ( NUMBER_OF_COLOR_PLANES   ),  
    .C_CV_NUM_PIXELS             ( PIXELS_IN_PARALLEL       ),  
    .C_CV_BIT_DEPTH              ( BPS                      ),  
    .C_HSIZE                     ( C_HSIZE                  ), 
    .C_VSIZE                     ( C_VSIZE                  ), 
                                 
    // default timing parameters 
    .C_TIM_VTOTAL                ( C_TIM_VTOTAL    )

  ) i_vtiming_core
  (
  .*
  );
end
else
begin:g_NONALLIGNED_CORE
  intel_vvp_vtiming_gen
  #(
    .C_BUILD_VRR                 ( C_BUILD_VRR              ),
    .C_BUILD_HARD_FRAME_LOCK     ( C_BUILD_HARD_FRAME_LOCK  ),
    .C_BUILD_SOFT_FRAME_LOCK     ( C_BUILD_HARD_FRAME_LOCK && C_BUILD_SOFT_FRAME_LOCK ),
    .C_NUM_PULSES                ( C_NUM_PULSES             ),  
    .C_USE_CPU                   ( RUNTIME_CONTROL          ),  
    .C_OUTPUT_IS_CV              ( C_OUTPUT_IS_CV           ),  
    .C_CV_NUM_PLANES             ( NUMBER_OF_COLOR_PLANES   ),  
    .C_CV_NUM_PIXELS             ( PIXELS_IN_PARALLEL       ),  
    .C_CV_BIT_DEPTH              ( BPS                      ),  
    .C_HSIZE                     ( C_HSIZE                  ), 
    .C_VSIZE                     ( C_VSIZE                  ), 
                                 
    // default timing parameters 
    .C_TIM_VTOTAL                ( C_TIM_VTOTAL    )

  ) i_vtiming_core
  (
  .*
  );
end
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "FfzEnWUw9s0Avx7nzIQVUreDQpp7UJQNuZqIJo4ipAkfmgFBaCGVPWSfayglLJ+yvsAUTCIF5ybuZt/04ZwASC/QoYFe7VTGD8vGhL5ZujWUqthmKkakjbpA3leNFYH8rtNQ7JJryh67Gz6e7kpMU11+/x4mLiXBKuRgIsPfJ1AUvZ2Oicprtm1MAi5KEUZK6uMwRmhGIfPYZGZ+V7DF0bSmNKh6R+dhBvCrtgkokRROtxa0g6Yi9Nkxvp40JkLyFQg659iLE07NNDocKciv2/BlW8pxgam/SWsv9IKEv7SZrmw173jXlkCL+dMb8r0cccllErXOCQh6GcVwxekrSrtb71vcdNdn2IPFFDFsZG6ebuduMHdzytXccX9drWB5xcM9MkSMG6uwKxicwyNz39zt/oOTYmPml9eB8vVoX7FapXWqKqoxSheFwyu1Pijcl6znrnJje1cN61LSEPqwIMQiFt+9VU3AJRI/IMMxUHnadIYh/Eo8QQQ8KsEB8DNOSLU7oXxJNiDUScwXaqwtOW/8VcAexBA+whJdSW3jOSA+Ajl1wcmNl9WrooeQQMZ55MqYBRPG0qImodXXgVlLULBV5M+8Nn+wVvmlhD2ChlcO4V3MdpjFm9ddoCyCyJhxQmmmXG845Fr4fPYqk0l0CtV64/V+Mt1H97DyiIAK/iVXyv/f2JJcB5GdblgmGO2B8Q++/iPccoUorhmEn4ywaP+bX6rHNSFdsugvli1WfIz7vhjrpFh3V1X8BCepjspXKag7e+1fQGrRCwyTHdz/jCOiudFs4HSGlKJdhVVqOD5qyalU30OmxcRsFX2ftBbDuYzUu+FF0IhcScbC+7AiqfVU9NylC5iYi+WP2Byayy5GMXkPQ3CQmfoyS27ZGCv2Gy9Tn94avMLQFHZ8KaqbpKhpCxke8dGSlxBLKysTqK2imgu6sc967lsXOTsETJPoj1vbOyj7ncu/F++gGoEKewXN6si7Pc3ckt0IeP519nD7cttRGpFCpB9oLyatLKPL"
`endif