// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 13469 16735 16788 

module altera_avalon_jtag_uart_sim_scfifo_w #(
  parameter FIFO_WIDTH = 8,
  parameter WR_WIDTHU = 6,
  parameter printingMethod = 0
  ) (
  // inputs:
   clk,
   fifo_wdata,
   fifo_wr,
   rst_n,

  // outputs:
   fifo_FF,
   r_dat,
   wfifo_empty,
   wfifo_used
    )
;

  output                    fifo_FF;
  output  [FIFO_WIDTH-1: 0] r_dat;
  output                    wfifo_empty;
  output  [WR_WIDTHU-1: 0]  wfifo_used;
  input                     clk;
  input   [FIFO_WIDTH-1: 0] fifo_wdata;
  input                     fifo_wr;
  input                     rst_n;


wire                            fifo_FF;
wire  [FIFO_WIDTH-1: 0]         r_dat;
wire                            wfifo_empty;
wire  [WR_WIDTHU-1: 0]          wfifo_used;


`ifndef QUARTUS_CDC
//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  altera_avalon_jtag_uart_log_module
    #(
      .FIFO_WIDTH (FIFO_WIDTH)
     )

altera_avalon_jtag_uart_log
    (
      .clk    (clk),
      .data   (fifo_wdata),
      .strobe (fifo_wr),
      .valid  (fifo_wr)
    );

string str_buf = "";

generate
  if (printingMethod == 0)
  begin
    always @(posedge clk)
      begin
        if (fifo_wr)
          $write("%c", fifo_wdata);
      end
    end

  else if (printingMethod == 1)
  begin
    always @(posedge clk or negedge rst_n)
      begin
        if (rst_n == 0)
          begin
            str_buf = "";
          end
        else if (fifo_wr)
          begin
            str_buf = $sformatf("%s%c", str_buf, fifo_wdata);
            if (fifo_wdata == "\n")
              begin
                #2 $write("%s", str_buf);
                str_buf = "";
              end
          end
      end
  end
endgenerate

  assign wfifo_used = {WR_WIDTHU{1'b0}};
  assign r_dat = {FIFO_WIDTH{1'b0}};
  assign fifo_FF = 1'b0;
  assign wfifo_empty = 1'b1;

//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on
`endif

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "E3DP+rueYwfrR4ojrl2OEjoJywhJaMW5WlgJtfj+5tptZjiuuDLF2iraNpnJOGT+3UOTXHF3UAz83vkYsSmcHTnnSZIpHI/qX5arWGTSH8pr1Uho9XbGObyxEZWSi9ZOz9MM8xDd9UZuSs2brkq5JmWs4MfEAFN2VJTXOmHvaT0rg5dUCJSrEmgsSJAON0LpCuXp9A8QjW9/QkTlZz0xqCp4ug0+/CORmw+kYKIX7TqdSlpoUKkPi+NbJnx+/HLORiIpbPAbwxBlL4GvMG5xspWk/B0ce37OcR8/jhJCYqLSpcq5F7SbKgGr95fyPgyPUpBjxYk6fw0TjQ1/ioqaZseoaeM/gDLaAox+TrWWS4c8EFaXHT3U1YGn07zmWvgAJ919tzXvAgSGITa8zePwqfrPSPPsDYuzxjU56NPPyM7Q6EaVwqbaybwLHt8l8dInpW0LjnZFiYCV3nBAdM9MxWSbazrvy0LSFNq19O/5A7ibiVTBfc0ioUah3Z0x635QKIcYkNQkp8eHlNFO70chYy5G/PWMXMYpIN1GUXj/z1vhO5dS8FeQPb7tr6zxFdTd9ykFBfEJ0de8i6x/8Fgnp6QtPrkHGbGhu13umlAvU74oRuQpLAMDJUIdTUpq+IRIlTxJnOmtQXGQ+j26sM4Drk0yMcO5Pfx9M2SQevGs4vV5br6ziO+03DbNmXwLEjcF854OmiQ0qB4FutY2KHHN6VRoQcf8wzo418PXgbCOutMaviJy9i74+zeC0bcs0ZdYLhq0vJDHlU953Ixm3P+uUvAdBr41avFRcYQdf2E6iWuGtdxR5ySlBJhc9/xF4P3lnaz2gPDIk79d+WeZ2LgEmj2M0iGYb1u8XetvEP8gUWYGSty9xJC7FuRjj8R6u7ZxvyM2Xkz5Z6PacfD4efixLnJYroLDSG0m4H5PsVRK37X6ZM2F8f/mPR4b99ulGmosdG3tL/VPOeDuCsKyxAlTX/t6/vxsZIxwyLJHCDRUvAjveqRj2dauD3xUGeJAFFDT"
`endif