// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module altera_avalon_i2c_txout (
    input           clk,
    input           rst_n,
    input [15:0]    sda_hold,
    input           start_sda_out,
    input           restart_sda_out,
    input           stop_sda_out,
    input           mst_tx_sda_out,
    input           mst_rx_sda_out,
    input           restart_scl_out,
    input           stop_scl_out,
    input           mst_tx_scl_out,
    input           mst_rx_scl_out,
    input           pop_tx_fifo_state,
    input           pop_tx_fifo_state_dly,

    output          sda_oe,
    output          scl_oe

);

reg         data_oe;
reg         clk_oe;
reg         clk_oe_nxt_dly;
reg [15:0]  sda_hold_cnt;
reg [15:0]  sda_hold_cnt_nxt;

wire        data_oe_nxt;
wire        clk_oe_nxt;
wire        clk_oe_nxt_hl;
wire        load_sda_hold_cnt;
wire        sda_hold_en;

assign data_oe_nxt  =   ~start_sda_out   |
                        ~restart_sda_out |
                        ~stop_sda_out    |
                        ~mst_tx_sda_out  |
                        ~mst_rx_sda_out;

assign clk_oe_nxt   =   ~restart_scl_out |
                        ~stop_scl_out    |
                        ~mst_tx_scl_out  |
                        ~mst_rx_scl_out;

assign clk_oe_nxt_hl        = clk_oe_nxt & ~clk_oe_nxt_dly;
assign load_sda_hold_cnt    = clk_oe_nxt_hl;
assign sda_hold_en          = (sda_hold_cnt_nxt != 16'h0) | pop_tx_fifo_state | pop_tx_fifo_state_dly;

assign sda_oe   = data_oe;
assign scl_oe   = clk_oe;

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        clk_oe_nxt_dly <= 1'b0;
    else
        clk_oe_nxt_dly <= clk_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        data_oe <= 1'b0;
    else if (sda_hold_en)
        data_oe <= data_oe;
    else
        data_oe <= data_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        clk_oe <= 1'b0;
    else if (pop_tx_fifo_state_dly)
        clk_oe <= clk_oe;
    else
        clk_oe <= clk_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        sda_hold_cnt <= 16'h0;
    else
        sda_hold_cnt <= sda_hold_cnt_nxt;
end

always @* begin
    if (load_sda_hold_cnt)
        sda_hold_cnt_nxt = sda_hold;
    else if (sda_hold_cnt != 16'h0)
        sda_hold_cnt_nxt = sda_hold_cnt - 16'h1;
    else
        sda_hold_cnt_nxt = sda_hold_cnt;
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "GDLvJHtRI7IWPaOyWjqRT/6KR7eLUFBduIZVq8U3qE9Qf2Bvt5B+H6CRpJoaFA6ftQgbpz45r9+WfzXD8ZlyUTAD09EsfK0uw91HmfUyntMU6No6nSQEmtr9G0jI8ravyTjeHsch6gwEVdmXvOOfUk59fTGLMcE4InvcBEiQk4MsxFFDRXtEOhEISSlHSPD4hS+0r08yJ4S+q2ZNad+vGgXTZBqO1nzqL+YiFlra5Tpkg0rV+9NB4bcJS8OBU1fiigue6KYsxVLGS+bzTSX8pdDZN7WUnsSqBSwgvcM4wv9p3eSHUR4ioC1ldtwhkZWFKX6db9s6iP378tzvFzyb9NjyI+mZm98ozFBSMgHjjLAXQfce7nZTRBBnZoy9zqqzSTZqNQgV6oG9//BLsUEiXdekjqSY+wB3m2b9xSWVxQ7p/XMmtfUUOyvZ14d+95E4giPJSnbdv8iY4ff8koZTBvz7+m1l2wUeTzsla4gdZLTqu6LjNKYgP9rFL7iHsWzTJZ0Y2Xhje8NiTU3C06yM26KnGSKumeysGxhr3xX8q/PPnckQWXui8FJ2X9i9vfgzkfviO9OP4npmuQC1hNGb/ov0KY98K9yOFolznAkUQ9bfZ8A4D6uanYm2NxF/q3QueMmf2boihzEhiNbGPm9mog2DigXsSlc0Aivhrd7g2P9stYtLeVFRanRvvvr70AfXMeyQn3qMUqXQnwFAejEXgM1hI9we6nggeVpTgJFxFA2QGNndx4IhwGV8EI6MHLJdX75vBDBej/P6FtRXzJYZsGG6mnR+zQ/AGboYdNXzIV7XdtX6q+9ylILUiK2Xti5z1e81z6w0gSbTbG7fB9WSRxUrv0jzjDwmvymtO/TxBBsGqCk/UyYU6o3spI/KzKomqPp34OtWc3+VfWNCk1DPWKDcX9LHsZFaFE1YMNvWqLCoS7oszGGsiW5er5+JMknZAkPLPZgtKFaa4E0T8PWzi4XwWblrVG0KGfbgsLvHRCKbI59jrKfAa3DCydGS5BcW"
`endif