// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer_2 (
    clk_src,
    clk_dst,
    reset_n_src,
    reset_n_dst,
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n_src;
    input   reset_n_dst;        
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n_src)
        if(reset_n_src == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n_src), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n_dst), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OToz4BRqhexMNs0IGT3+g0MWfl/2ENurLA9bze060Q58kb0Mlx8dMHJQdtMm03xCxYzdFGBKF5cfVuUizPvR266eBfGBJ2JI8e2SfU9TosW37yZfcQ5LqvA5wZh1iJ5KaZ9ez+xd7h3qc+Ra5jWPFyZXSJxkeH3ybO6CEPq6v+K2q6tHo3wqhLxuepCmxZ9S4j3wVGTHJm2frGi+ArlxA2/+ArgIJTNyM8/2fODViiUwxjskE7FO3VYHV+NTBw5jDzv8DJ0KMaJIUVUqBClKKU85fCAnIT03Mfm381qUepsBRf3X7CUUTlVL2OKii4zdGkv19RWpW/l4udt/KVfnzfFE3yt9a4zMZLw8LwI+g1NY+mmwjiAV1oI/iTNUX5DC2229HcGrAr6MHQO+1tnmfOHJtfJYp0AZI3piMHWcbBrNZOsnH8CxRQL5+MZFe4BpAhyGA+JdQEo6cX3h23zvZdcyq6Cc4TZW67qZCEjbzcyPIcqI7ilEwkQPlx3exs5CfnRY4s7FrKypVsQ9tngP8AanQzNJevamT18skTfW0c7PbwpCYT9Ke2ly6pkPZ55LVOVNhQZOdJeZ1au+kjacousaPNF2ADdRv7S+wYCmcR69YMleOl6O0iBM5QpqKkwSwVIqSJKQhWq2A7nfvbdrYuBgJme8p3HK+6LKibBczqKIMA3Gq1PrSVP7AugQB375NOqXTmhfZTsTCf6jjZPxY7VYpNzGHebcESZ+AZ4lKck22vKbO+L2ad0j+5iqSzphR4SAy+eCkzHysz8mplgkUQUG"
`endif