// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer (
    clk_src,
    clk_dst,
    reset_n,    
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n;    
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n)
        if(reset_n == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OTqQqxbUkYB9ZmFqjuhIBeRfVj9xFfgvIXcDCWRB0aeOGiNNHZgkmA2UAS5JPW1Tz61k5LNLuj/UgJp/SHseTjlVOWZS22bOHQHU3zdgyqlDy3qHXTUABjoOl5Ut2QN62H3wyhkSvnL1JV8D12PPLuhrHmNFcx+hzT47oD+M9Or4YFhQmDXMAZ3l8dKuZRs4tWsVm4QT1wEOUY6o1Z7U3/QR9iZUsfRNnQzsyIkMKrM1YsHKLhruO9I6Aed17bwMsLFTnDoUNA9/2pD+AVW8ShF1RXqXUwuJ9o/RcFFLYrd3wMQlQJfPCiYXYiYqzqAW2t8O+WimsbAZyM2nZrK6yAaCeUNGBpxbwycIW8DiwShXhcrwsv5Qf8ZA6aZ0rQflj0XzzxBh/9+8cA45CLEKNfBU0WaH7FOZ81ZvZv2xxdQGhJckg5taq5y/8IShxxYM+NRVS9lAMsISJpFj815WqE6WFA5xySyFd3Syg5fhEg1FuQYIYELkvH7V6jcBN3C8LNga4Q3wmltm/Z95NO7VNpTf139Y6vSfft76eVGDCTxCND2bOAq717b0YfaS/MJUMeai5N0pIjfG/+8a+Rcz8Ddl/zWvnm588WPpnbjALUHYweNNz8RtabUBAaxBuBht6FIUeeKJEDBaR+RdQCXYFi1HZ2N3FGqey8nRKosDjCfnCrrv72IsEGWNCYhTxs5Kz32yqng9bzJLncu3kb4HXU1s3vIX4P+HQ9cHPK2i/jgXoGjh59UpTdoJP1StPCDB4sIP+5CU9QdN+BK5Gk6v9Yt3"
`endif