// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off        

`ifdef DPHY_BHV_SIM
`define BHV_OBUF 1
`endif

`ifdef BHV_OBUF
`define obuf_name dphy_obuf_bhv
`endif

`define SIM 1

// synthesis translate_on  


`ifndef obuf_name
`define obuf_name tennm_ph2_io_obuf
`endif

module dphy_obuf_wrap #(
    parameter BYTE_LOC = 0,
    parameter PIN_ID = 0,
    parameter RZQ_ID = "RZQ0",
    parameter TX_CAP_EQ_MODE = 0,
    parameter BIT_RATE = 36'd3200000000, 
    parameter TOGGLE_SPEED = "TOGGLE_SPEED_SLOW"                   
) ( 
    input wire 	inp, 
    input wire 	negbuf_in,
    input wire 	oe, 
    output wire obar,
    output wire posbuf_out,
    output wire outp                            
);

   `obuf_name #(
                .buffer_usage( "REGULAR" ),
                .io_standard( "IO_STANDARD_IOSTD_DPHY" ),
                .usage_mode( "USAGE_MODE_DPHY" ),
                .termination( "TERMINATION_SERIES_45_OHM_CAL" ),
                .rzq_id( RZQ_ID == "RZQ0" ? "RZQ_ID_RZQ0" : "RZQ_ID_RZQ1" ),
                .slew_rate( BIT_RATE < 1500000000 ? "SLEW_RATE_FAST" : "SLEW_RATE_FASTEST"),
                .equalization( TX_CAP_EQ_MODE == 1 ? "EQUALIZATION_2TAPS_MEDIUM_LP" : 
                               TX_CAP_EQ_MODE == 2 ? "EQUALIZATION_2TAPS_HIGH_LP"   :
                               TX_CAP_EQ_MODE == 3 ? "EQUALIZATION_2TAPS_MEDIUM_CZ" : "EQUALIZATION_OFF"),
                .open_drain( "OPEN_DRAIN_OFF" ),
                .toggle_speed( TOGGLE_SPEED ),
                .dynamic_pull_up_enabled( "FALSE" )
    ) obuf_inst (
                 .i( inp ),                                                    
                 .negbuf_in (negbuf_in),
                 .oe( oe ),                                                    
                 .obar(obar),
                 .posbuf_out(posbuf_out),
                 .o( outp )                                                    
                 );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OToje+vlpBA3Se+d5EAlqJ5qPwsn4/LyL5J3kUVpJeMwaW1gxk5bnSwZB34qQzcE3V0pJfC9jPMV0SIwVhe4SNoZ5IIUemLp9HZrSTYCerBMvLgu5L8EGIiNEWVi5wrcNM+KKTP0PBdiZ6aCTKlzIduFY+bozIQuOsjB6h9hWf+Jin8W+cSgETUs4dR+57zrAYQEC12OVXeayEKL05u1MMKFC/J4/Hv9tKJMTd+gZsrMHzvss1cPyy4LAbtQGp3DUeow2nOQ/hDmIaoGnPvb/xWFoTj3SuV6xQC/9ZIc4Xhd7Z2fBJ2MDx2ZATgOoa0F4svqWTqZf5hf+gIC1WfryweaeQP/XaytYlAfgkONSfFvAXJOuSPrGP25SO1r9QZf7eu6FgeoKKJeEaByeh4pxQ2WaekElFUUywt6qjDz85DHHu28Q9s6K5VVq6qiM2UY047rQp3M3Y9zFlEGaM1VIvl1BroeCatdtpEGSLAehOY5VdyAQaCOAV4ClZH8+uN13NT9AkKTuKopuWOqwVBt8rKsyTMlOQMrZIVy3lAsq9ui+M5LpZjkDrbJrNlVU3W4UXESnABiB4jknHouqMO3FnDkN8X28qKGGIvd7RPX02J/ZWfXdk1wjCA7eKDRJ8RnLQRGHSWzPn8pTsF6zn1G63iS3PMd/lHIjf6rdb2WU5vNoTJlZw/ZfN8tNgdRGZZhqqlEguZppTP95b7EDgOZgpKwb2kO5e8bsKiJEJ43TVcfUvLigvv8j/0FpbI9Rl1y558VuI7307m75USyQK8EXqGr"
`endif