// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




(* altera_attribute = "-name AUTO_SHIFT_REGISTER_RECOGNITION off" *) module hyperpipe # ( 
  parameter WIDTH = 1,
  parameter CYCLES = 3
) (
  input clk,
  input [WIDTH-1:0] din,
  output [WIDTH-1:0] dout
);

generate
  if (CYCLES==0) begin : GEN_COMB_INPUT
    assign dout = din;
  end 
  else begin : GEN_REG_INPUT  
    integer i;
    reg [WIDTH-1:0] R_data_preserve [CYCLES-1:0];
    
    always @(posedge clk) begin   
      R_data_preserve[0] <= din;      
      for(i=1;i<CYCLES;i=i+1) R_data_preserve[i] <= R_data_preserve[i-1];
    end
    assign dout = R_data_preserve[CYCLES-1];
  end
endgenerate  
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OTpwAMXLa/R6BPjKBYaadOM7BK1Za0aDAiAsoMsqQ9mtSKXzAi90XkpH0LnBg4Vi9+4CPVh979pEkckhbpUmx5yFYr8cSK/5axozGav/3Kmg2Q/nAlomEo+ZQUwtmv96WymGySKfFxggYquWwzqZcD7pmZ5D5HDtZ8quhtLMybwL1OY0pyTOToT2GcZIanHI953mDEaIxYRyszPaHXEtIjy3H0NnuceKH4DoNDkq+KFcLu0AB+NfCqYUtNt7uX5BCQxbGEZMmxn8g27/vLi4SEZvdgPje9yrY44zeIbjRg77iuNsDEU3FglMibm9/ndA9r0qF2hFH4DZsmGYOUwn5v8qVr/hBaIa+1ODjop6CZuG8AJ8i2GgWX45E+OSzNTwdEiZ0238j07I98hxWZAuSwKPxIxqCwHv1fSvzXD/GTKlP2nJlUM+GeYNpc/3ykjzL/1U/xosv6w6+kHcMa7diDWChs2TvXBebr7yIOqVm0EH8CHXlleWgB7jVgCthDm/UeUuIIWJ8XXN+mBkZ0XzkHyNxJrxxBdQvpCEV9H850Ee625grFkZ8fnNeYG7GAy5i2J1d+8CDxnxdReFSLMq2GA2im89D60tWLiX9J4fZwBvFjr6vvOVRulBP5PWOYp6YB4zlx8ghbliRbleTO0lLWGfzS3KnBLnmAxQR+bttSW97w2WbS2ShSJqSlC0hbQR7+wa06eBmTVpoMQ8TGy3AAYaUwl254rxxD5kKrdrb/0IcV8/CWQcRHYDNdcrhhSty9OUvEzYwZtvllPBw2RIf9Kv"
`endif