// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



module dphy_timer #(
        parameter WIDTH = 8
   ) 
   (
        input  wire                     clk,     
        input  wire                     srst_n,     
        
        input                           timer_en, 
        input                           ld_timer,   
        input [WIDTH-1:0]               ld_val, 
        output logic                    timer_out           

    );
    
    logic [WIDTH-1:0] cntr;
    logic [WIDTH-1:0] e_cntr;
    logic e_timeout;

    always @(posedge clk)
    begin
        if(srst_n == 1'b0)
            cntr <= {WIDTH{1'b1}};
        else if(ld_timer)
            cntr <= ld_val;
        else if(~&cntr)
            cntr <= e_cntr;
    end
    assign e_cntr = cntr - timer_en;
    assign timer_out = ~|cntr & ~ld_timer & timer_en;



endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OTp8DCNj/fuNQdJvxTbcU5IK+yyHthpMyqbTOrFlaSlfoQRDCnrwfrb1/fW9vgObS73a0EsiIFKU3LqmUzRLq9vzY5RuCOpcW9cBgN9GLy0pxs+CpZu6ltDtZAxksoyDABKlE2o1x/fYdke5vqJQHQRIyfQnXeTtjrYsZyxlxOrVaeHMi8/TKEHVfRYbEWjGkCgdwWNLx8xQUxs8J1SwI6NbJxoGlaafrueD3Cmeg8xOoIvnqO4aPbpG8NSce8a2WGR+DQ2oPW1b7lkMrdD4TUOCCaLZ6AEvBhaqG7bkXMl1PjmDPryvGm3SBf2IqakLrZexBzbGdf/bocAhWlxJ6R1FTeozC8obi8/Fww8zXYK0BJn+xUAyfDeez+r07XxbAYBNGHPsAePjMJV2govjWnq+RA1dPY+V6HaN5WzFhuATuHee0nvvWp4GO8SRhUzKdNJGpJ4lYviW7jieNLPJ0ABoQlPWhyZhqFvnfxjMzoJu0Y8/LU2DjqEZ0sziJdfEkXUHB/dfKiqLilbJlUmnvmzMtv5al1oG1DobZJ7hFIM7qEcw3mZ/D5WqA0M5GCZPegoqg0R4q+F1YbcpqqcEMK/vrnewrUoW6UJZHktO2mLGTZdetjYiajBXZ+12Gq8sNNMQSG/LhgherQmv2sY/gmnMRGla4jqmKY0Q12ZutAKxGg1MvItM/vkXxXrl6c/cyboZkC5OHAM/vD01b2PTSMIZI3pDkZbUKXRU7lXTaWFt8oJeWmP0VBoF3ln2XIWS4n6cAcQOuq43qA7daWxaMq7W"
`endif