// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





module dphy_prbs9 #(
        WIDTH = 8,                                  
        LOOKAHEAD = 0                               
        )
(
    input                       clk,
    input                       srst_n,
    input                       enable,
    input                       skip,
    input                       pause,
    input  [8:0]                init_val,
    output logic                out_valid,
    output logic [WIDTH-1:0]    prbs_out,
    output logic [15:0]         prbs_next
);

    logic [8:0] q_0;
    logic [8:0] q_1;
    logic [8:0] q_2;
    logic [8:0] q_3;

    logic [8:0] init_val_int;
    int i;
    logic [8:0] init_val_tmp;
    assign init_val_tmp = 9'h02;   
    
    `ifdef VIP
        always @(*)
        begin
            for (i = 1; i < 9; i++)
                init_val_int[9-i] <= init_val_tmp[i];
            init_val_int[0] <= init_val_tmp[0];
        end
    `else
        assign init_val_int = init_val; 
    `endif

`ifdef DEBUG_ALT_CAL

    logic [WIDTH-1:0] cnt;

    always @(posedge clk)
        begin
            if(enable == 1'b0)
                cnt <= 'hc3;
            else
                cnt <= cnt + 1'b1 + skip;
            prbs_out <= { ~cnt[7:0] , cnt[7:0] };
        end        



`else
    always @(posedge clk)
        out_valid <= enable;
    
    if(WIDTH == 16)
    begin
        
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                for(i=0; i<8; i++)
                    q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                q_1 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end
            end                                                     
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                end            
                else if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_1;
                    for(i=0; i<24; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 & skip == pause)
                begin
                    q_0 <= q_2;
                    q_1 <= q_3;
                    q_tmp = q_3;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_3 <= q_tmp;
                    
                end
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_1;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                end
		else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end
        
        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_out[16-i]   <= q_1[i];
                prbs_next[8-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
                prbs_next[16-i]  <= (LOOKAHEAD == 1) ? q_3[i] : 'h0;
            end
        `else
            prbs_out <= { q_1[8:1] , q_0[8:1] };
            prbs_next <= (LOOKAHEAD == 1) ? {  q_3[8:1] , q_2[8:1] } : 'h0;
        `endif
        end

    end
    else
    begin
        always @(posedge clk)
        begin
            logic [8:0] q_tmp;
            if(enable == 1'b0)
            begin
                q_tmp = init_val_int;
                q_0 <= q_tmp;
                if(LOOKAHEAD == 1)
                begin
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end                
            end
            else
            begin
                if(LOOKAHEAD == 1 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_2;
                    q_0 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end
                if(LOOKAHEAD == 0 && skip == 'b1 && pause == 'b0)
                begin
                    q_tmp = q_0;
                    for(i=0; i<16; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
                else if(LOOKAHEAD == 1 && skip == pause)
                begin
                    q_0 <= q_1;
                    q_tmp = q_2;
                    q_1 <= q_tmp;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_2 <= q_tmp;
                end 
                else if(LOOKAHEAD == 0 && pause == skip)
                begin
                    q_tmp = q_0;
                    for(i=0; i<8; i++)
                        q_tmp = { q_tmp[4] ^ q_tmp[0], q_tmp[8:1] };
                    q_0 <= q_tmp;
                end
	       	else
		begin
		    q_tmp <= q_tmp;
		    q_0 <= q_0;
		    q_1 <= q_1;
		end
            end
        end

        always @(posedge clk)
        begin
        `ifdef VIP
            for (i = 1; i < 9; i++)
            begin
                prbs_out[8-i]    <= q_0[i];
                prbs_next[8-i]    <= (LOOKAHEAD == 1) ? q_1[i] : 'h0;
                prbs_next[16-i]   <= (LOOKAHEAD == 1) ? q_2[i] : 'h0;
            end
        `else
            prbs_out <= q_0[8:1];
            prbs_next <= LOOKAHEAD == 1 ? {q_2[8:1], q_1[8:1]} : 'h0;
        `endif
        end

    end

`endif    

 

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OTqlSuoxbNCmRwhud5L+P5fkjGXp1lugN2E//6IqqIP3xZ6yrhkmf6947LlJfDpCW+wwKzF3DWs8LtrWLYYF04TX8W/7/96TMJkDsoz0MC9d3vmz6XqD8Wx67/Ws3l4R7WOr7SxonwUynM0rJEPnId7cxP2on3ukrx68wo1jehGHXxmIzos2FK3Sh9MPARFCF7G7XHYa1gxac2yQblhoR6xRxEkOiA1khG2TWXyvKOVyoABV2HSiChlNR70ikhZOQ0vZ/9GWoTbJbG6sBlEg00s7DnVHBPfWpmYzlmO8nEsagelgw8LUgoT0kqZ9P7GyXeNooMe00zf7XLJ0upGevGTxLXWNHw/lv1UBsP3RyTeFNTmsYRw7VU0XZuntbEAub7Eooa+SlZH+wDTL68ea/E/T2pR9veX5DN65h530CuM2Jt81SWci4kdwEDEL6ROVlGcTmValpDYP7MxLYhjOrfhhKrkS/qG34GpO1ffrs0l5ZQ3HA2WJ028/FXmNQ0j+KMn/JV8dhgiBH0AoTXAhPbt9G1st/mibrU/ddvynt4hvBxCMZ9wrJbcnpFxLlx5+uC/Ar0kYsrIlhViVwjOhtaDuQzyexBKw30LRKTn9w2khONGdsPsuFeS8tjAU47VvA4VnYLxNBhUkX399P75ZdAzSbpSLxCwmXC1CdIdZ72Zz+P/J3ZDl25UB9tuFjEX178vlSnkmgCHQHoXyX+5Lkh8G5NVrDhCIEAv+aUd8Bb8q1Z2MTYDBa2809YJTn/EOIe6VptMwwMYF0wpnzLze6MAZ"
`endif