// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

`timescale 1ns / 10 ps

module dphy_pcs_esc_rx # (
        parameter LANE_ID = 0
    )
   (
        input wire   fr_clk, 
        input wire   srst_fr_n, 
        input wire   init_done,
        input wire   lp_p,
        input wire   lp_n,
        output logic is_hs_req,
        output logic is_hs,
        output logic is_lp_req,
        output logic is_lp,
        output logic is_stop,
        output logic is_ulps,
        output logic ulps_wake_cnt,
        input wire  ulps_wake_done,   
        output logic esc_entry_err_p,
        output logic lpdt_err_p, 
        output logic ctrl_err_p,
                     ppi_if ppi_rx
    );
   
    /*
    localparam ESC_IDLE      = 'b000;
    localparam HS_REQ        = 'b100;
    localparam HS_ACTIVE     = 'b001;
    localparam ESC_REQ       = 'b101;
    localparam ESC_REQ0      = 'b110;
    localparam ESC_REQ1      = 'b111;
    localparam ESC_CMD       = 'b010;
    localparam ESC_DATA      = 'b011;
        
    logic [2:0] esc_c_st;
    */
   
   typedef enum bit[3:0] {
                 ESC_IDLE,
                 HS_ACTIVE,
                 ESC_CMD,
                 ESC_DATA,
                 HS_REQ,
                 ESC_REQ,
                 ESC_REQ0,
                 ESC_REQ1,
                 ESC_ULPS_EXIT,
                 ESC_ULPS_WAKE
                 } rx_esc_sm_t;
             
   rx_esc_sm_t esc_c_st;

   typedef enum {
                 ULPS_IDLE,
                 ULPS,
                 ULPS_EXIT,
                 ULPS_WAKE
                 } esc_ulps_sm_t;

   esc_ulps_sm_t esc_ulps_st;
   
   logic [1:0]  lp_pn;
   logic        d_in;
   logic [7:0]  d_reg;
   logic [2:0]  cntr;
   logic        lp_xor, lp_xor_q;
   logic        is_pos, is_neg;
   logic        dout_valid;
   logic        exit_cmd;
   logic        exit_cmd_q;
   logic        exit_cmd_qq;
   logic [3:0]  trigger;
   logic        is_lpdt;
   logic        is_ulps_active;    
   logic        ErrEsc;
   logic        ErrSyncEsc;
   logic        ErrControl;
   
   logic        trigger_ext;
   
   logic        twake_cnt;

   assign ulps_wake_cnt = twake_cnt;   
   
   assign lp_xor = (lp_p ^ lp_n);
   assign lp_pn = { lp_p, lp_n };
   assign is_pos = ~esc_c_st[3] & ~esc_c_st[2] & esc_c_st[1] & ~lp_xor_q & lp_xor;
   assign is_neg = ~esc_c_st[3] & ~esc_c_st[2] & esc_c_st[1] & lp_xor_q & (~lp_p & ~lp_n);
   assign exit_cmd = (esc_c_st == ESC_CMD) ? is_neg & &cntr  : 1'b0;
   
    always @(posedge fr_clk)
    begin
        lp_xor_q <= lp_xor;
        d_in <= is_pos == 1'b1 ? lp_p : d_in;
        d_reg <= (is_neg == 1'b1 && ~trigger_ext)?  { d_in, d_reg[7:1] } : d_reg;
        exit_cmd_q <= exit_cmd;
        exit_cmd_qq <= exit_cmd_q;
    end
        
    always @(posedge fr_clk)
    begin
        if (esc_c_st == ESC_IDLE)
        begin
            cntr <= 'h0;
            dout_valid <= 'b0;
        end
        else
        begin
            cntr <= cntr + is_neg;
            dout_valid <= (esc_c_st == ESC_DATA && is_neg == 1'b1 && ~|trigger) ? &cntr : dout_valid;
        end
    end

    always @(posedge fr_clk)
    begin
        trigger[0] <= ( exit_cmd_q & ( d_reg == ESC_RESET_CMD ? 1'b1 : 1'b0 ) ) | (trigger[0] & ~&lp_pn );
        trigger[1] <= ( exit_cmd_q & ( d_reg == ESC_HS_TST_CMD ? 1'b1 : 1'b0 ) ) | (trigger[1] & ~&lp_pn );
        trigger[2] <= ( exit_cmd_q & ( d_reg == ESC_UNKNOW4_CMD ? 1'b1 : 1'b0 ) ) | (trigger[2] & ~&lp_pn );
        trigger[3] <= ( exit_cmd_q & ( d_reg == ESC_UNKNOW5_CMD ? 1'b1 : 1'b0 ) ) | (trigger[3] & ~&lp_pn );
        is_lpdt <= ( exit_cmd_q & ( d_reg == ESC_LPDT_CMD ? 1'b1 : 1'b0 ) ) | (is_lpdt & ~&lp_pn );
        is_ulps <= ( exit_cmd_q & ( d_reg == ESC_ULPS_CMD ? 1'b1 : 1'b0 ) ) | (is_ulps & (~&lp_pn | (esc_c_st == ESC_ULPS_EXIT)));
        is_ulps_active <= ( exit_cmd_q & ( d_reg == ESC_ULPS_CMD ? 1'b1 : 1'b0 ) ) | (is_ulps_active & ~lp_xor );
    end


     always @(posedge fr_clk)
       begin
          if (srst_fr_n == 1'b0 || lp_pn == LPCTRL_STOP || init_done == 1'b0)
            trigger_ext <= 1'b0;
          else
	        begin
	           if (trigger_ext == 1'b0)
		         begin
		            if (is_pos && (cntr == 'h0) && |trigger)
		              trigger_ext <= 1'b1;
		         end
	           else
		         if (is_stop)
		           trigger_ext <= 1'b0;
	        end
       end
   
   
     always @(posedge fr_clk)
     begin
         if (srst_fr_n == 1'b0 || init_done == 1'b0)
           begin
              esc_c_st <= ESC_IDLE;
              twake_cnt <= 1'b0;
           end
         else
           begin
              if (lp_pn == LPCTRL_STOP)
                begin
                   twake_cnt <= 1'b0;
                   if ((esc_c_st == ESC_ULPS_EXIT) && (~ulps_wake_done))
                     esc_c_st <= ESC_ULPS_EXIT;
                   else
                     esc_c_st <= ESC_IDLE;
                end
              else
                begin
                   case(esc_c_st)
                     ESC_IDLE   :
                       begin
                          if(lp_pn == LPCTRL_LP_RQST) esc_c_st <= ESC_REQ;
                          if(lp_pn == LPCTRL_HS_RQST) esc_c_st <= HS_REQ;
                       end
                     HS_REQ     :  if(lp_pn == LPCTRL_BRIDGE) esc_c_st <= HS_ACTIVE;
                     ESC_REQ    :  if(lp_pn == ESC_SPACE) esc_c_st <= ESC_REQ0;
                     ESC_REQ0   :  if(lp_pn == ESC_MARK_0) esc_c_st <= ESC_REQ1;
                     ESC_REQ1   :  if(lp_pn == ESC_SPACE) esc_c_st <= ESC_CMD;
                     ESC_CMD    :  if(exit_cmd == 1'b1) esc_c_st <= ESC_DATA; 
                     ESC_DATA   :
                       begin
                          if (is_ulps && (lp_pn == ESC_MARK_1))
                            esc_c_st <= ESC_ULPS_EXIT;                     
                       end
                     ESC_ULPS_EXIT :
                      if(ulps_wake_done)
                        begin
                           esc_c_st <= ESC_ULPS_WAKE;
                           twake_cnt <= 1'b0;
                        end
                      else
                        begin
                           esc_c_st <= ESC_ULPS_EXIT;
                           if (lp_pn == ESC_MARK_1)
                             twake_cnt <= 1'b1;
                           else
                             twake_cnt <= 1'b0;                        
                        end 
                     ESC_ULPS_WAKE, HS_ACTIVE   : ;
                     default    : esc_c_st <= ESC_IDLE;
                   endcase
                end 
           end   
     end 

/* integrated to esc_c_st
 
   always @(posedge fr_clk)
     begin
        if (srst_fr_n == 1'b0 || init_done == 1'b0)
          begin
             esc_ulps_st <= ULPS_IDLE;
          end
        else
          begin
             if (lp_pn == LPCTRL_STOP)
               begin
                  if ((esc_ulps_st == ULPS_EXIT) && (~ulps_wake_done))
                    esc_ulps_st <= ULPS_EXIT;
                  else
                    esc_ulps_st <= ULPS_IDLE;
               end
             else
               begin
                  case(esc_ulps_st)
                    ULPS_IDLE :
                      if ( (esc_c_st == ESC_DATA) && is_ulps)
                        esc_ulps_st <= ULPS;
                      else
                        esc_ulps_st <= ULPS_IDLE;
                    ULPS :
                      if(lp_pn == ESC_MARK_1)
                        begin
                           esc_ulps_st <= ULPS_EXIT;
                        end
                    ULPS_EXIT  : 
                      if(ulps_wake_done)
                        begin
                           esc_ulps_st <= ULPS_WAKE;
                        end
                      else
                        begin
                           esc_ulps_st <= ULPS_EXIT;
                           if (lp_pn == ESC_MARK_1)
                           else
                        end                 
                    ULPS_WAKE : ;
                    default : esc_ulps_st <= ULPS_IDLE;
                  endcase
               end 
          end 
     end 
 */ 
    
    assign is_hs_req = esc_c_st == HS_REQ;
    assign is_hs = esc_c_st == HS_ACTIVE;
    assign is_lp_req = esc_c_st == ESC_REQ;
    assign is_lp = (esc_c_st == ESC_CMD || esc_c_st == ESC_DATA);
    assign is_stop = lp_pn == LPCTRL_STOP;
    assign esc_entry_err_p = exit_cmd_qq & ~ ( |trigger | is_lpdt | is_ulps );
    assign lpdt_err_p = is_lp & is_stop & |cntr;
    assign ctrl_err_p = ( (esc_c_st == HS_REQ) & (( lp_pn == LPCTRL_HS_RQST || lp_pn == LPCTRL_BRIDGE ) ? 1'b0 : 1'b1 ) ) | 
                        ( (esc_c_st == ESC_REQ) & (( lp_pn == LPCTRL_LP_RQST || lp_pn == ESC_SPACE ) ? 1'b0 : 1'b1 ) ) | 
                        ( (esc_c_st == ESC_REQ0) & (( lp_pn == ESC_SPACE || lp_pn == ESC_MARK_0 ) ? 1'b0 : 1'b1 ) ) | 
                        ( (esc_c_st == ESC_REQ1) & (( lp_pn == ESC_MARK_0 || lp_pn == ESC_SPACE ) ? 1'b0 : 1'b1 ) );

    
    assign ppi_rx.RxClkEsc [LANE_ID]        = lp_xor & init_done;
    assign ppi_rx.RxLpdtEsc [LANE_ID]       = LANE_ID == 0 ? is_lpdt : 1'b0;
    assign ppi_rx.RxUlpsEsc [LANE_ID]       = is_ulps;
    assign ppi_rx.RxTriggerEsc [LANE_ID]    = LANE_ID == 0 ? trigger : 'h0;
    assign ppi_rx.RxWakeup [LANE_ID]        = 1'b0;
    assign ppi_rx.RxDataEsc [LANE_ID]       = LANE_ID == 0 ?  d_reg :'h0 ;
    assign ppi_rx.RxValidEsc [LANE_ID]      = LANE_ID == 0 ? is_lpdt & dout_valid : 'h0;
    assign ppi_rx.UlpsActiveNot[LANE_ID]    = ~is_ulps_active;

     always @(posedge fr_clk)
     begin
         if (srst_fr_n == 1'b0 || init_done == 1'b0)
         begin
            ErrEsc      <= 1'b0;
            ErrSyncEsc  <= 1'b0;
            ErrControl  <= 1'b0;
         end
         else
         begin
            ErrEsc      <= ( esc_entry_err_p | ErrEsc ) & ~ (esc_c_st == ESC_IDLE && (lp_pn == LPCTRL_LP_RQST || lp_pn == LPCTRL_HS_RQST) ) ;
            ErrSyncEsc  <= ( lpdt_err_p | ErrSyncEsc )  & ~ (esc_c_st == ESC_IDLE && (lp_pn == LPCTRL_LP_RQST || lp_pn == LPCTRL_HS_RQST) ) ;
            ErrControl  <= ( ctrl_err_p | ErrControl )  & ~ (esc_c_st == ESC_IDLE && (lp_pn == LPCTRL_LP_RQST || lp_pn == LPCTRL_HS_RQST) ) ;
         end
    end
    
    assign ppi_rx.ErrEsc[LANE_ID] = ErrEsc;
    assign ppi_rx.ErrSyncEsc[LANE_ID] = ErrSyncEsc;
    assign ppi_rx.ErrControl[LANE_ID] = ErrControl;

 

endmodule 


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wL3xy0897+SaA2l8k0LcQeickywP/aAsDpmXGk+qqHOEfKDvnmwJ3NFScvPOOMjVxkEsG2tlgj7t0aWLTI4m9H+V/GTsSAggoI0n8McMaJFvJf9+UOR7eS5nE/Fb62J1RUW7sRYwGtVQS8qj0Fr45dObK4NJGiZTIeRSkKuaTHw77sfnjisKF7z5N2gNoQYKGuEUaoyzxFqTrSu3m65xQqczL/Dnhle0uAaBrCL3srnZ50GCWPy8L06CPrFzkolpqFQBgWV/T106CjsVLD6e1+JEKrVq7xvnrmGz807Pxtk52OPQ/CpT2MhIuA//w8arZNULjDVqJXbr0sUdfbLRhhLUsAd4HU394BJNTah49y4nSaIZdxNuK+aUVzyh/KpYfFyAyzarpPLB2U5Oea40bl2ESuPkOIcw+lm+98g4/+uDPyvsfPxsekT7FKhAHDAauCtQODe3ybf5z6j4YNxSCjc3kpdzeCnzfX6uyr952ao4sDlVtxKDtHUF7rPZn+8jFJiwgjAqMG8vTnpGM6Hijog6jveqgA2MirkGRWFrJfGUuWdd3iDXCLRVYMVkVEMa9ChhvR8Pl2cgP5taLWVbMn4gWlLdjc6xNslAot2haUujOy2rRNHePS9b9wD6uJu2yfjwnDLFSlCbZ/P6+T7002KS2Sb/HA31cYHJC3Zv3z7EiukcFScVlvgeqOIectcfoTI00j5tlYi/rPtSHyMOIrPMaWXoXk0rQ0Rj1jdHSMJ7+Ul4cRg8c3JXLFuktpJ/1PHuYdpXPl0j3FKqHiS4g+X6UpVEXRGap/doQ7omjADPrXMOA9iQfZvwtAmcDcjlR40Sby0GcXU4j7BwQqyDM6jlgp5KRp5F3qQUTRzNoHLo79elIYZUbNA2Pd+qZi+AP3qKKyVN7+JQXIojBJFzDoUqaJ5QhKLJjIIB4A/BDcRJKP71btOBz2UVrt89LSzgppYf5t1a/0rVybX+MZP//yT/u/6ckvrtlAh17c6GND6luj0mgdMvKsUHT8u2yTFo"
`endif