// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;


module dphy_pcs_data_timing_rx # (
        parameter DIN_PIPE_DEPTH = 2
   ) (
        input wire   rx_clk, 
        input wire   srst_rx_n,
        input wire   arst_rx_n, 
        input wire   fr_clk,
        input wire   srst_fr_n, 
        input wire   fr_clk_1024,
        input wire   enable,
        input wire   is_ulps,
        input wire   ulps_wake_cnt, 
        
        input wire   lpctrl_hs_req_fr,
        input wire   lpctrl_hs_stop_fr,
        input wire   lpctrl_hs_diff_fr,
        input wire   lpctrl_lp_req_fr,
        input wire   fast_stop,

        input [7:0]  t_hs_settle, 
        input [7:0]  t_hs_skip, 
        input [7:0]  t_init,
        input [7:0]  t_wake_ulps,

        output logic ulps_wake_done,
        output logic init_done,
        output logic din_valid           

    );
    
    localparam FR_TIMER_WIDTH = 16;
    localparam DIN_VALID_PIPE_LEN = DIN_PIPE_DEPTH > 2 ? DIN_PIPE_DEPTH - 2 : 0;
    
   logic             fr_ld_timer;   
   logic [FR_TIMER_WIDTH-1:0] fr_ld_val; 
   logic                      fr_timer_out;
   
   logic                      din_valid_fr;
   logic                      din_valid_rx;
   logic                      din_valid_int;
   logic                      fast_stop_rx;
   logic                      enable_q;


   
   
   assign ulps_wake_done = is_ulps & fr_timer_out;
    
    always @(posedge fr_clk)
    begin
        if(srst_fr_n == 1'b0)
        begin
                din_valid_fr <= 1'b0;
                init_done <= 1'b0;
                enable_q <= 1'b0;
        end
        else 
        begin
            din_valid_fr <= (init_done & fr_timer_out) | (din_valid_fr & lpctrl_hs_diff_fr);
            init_done <= ( init_done & ( enable === 1'b1) )  | (fr_timer_out === 1'b1);
            enable_q <= enable;
        end
    end

    assign fr_timer_en = (init_done == 1'b0) || (ulps_wake_cnt == 1'b1) ? fr_clk_1024 : lpctrl_hs_diff_fr;
    assign fr_ld_timer = init_done == 1'b1 ? ( is_ulps == 1'b1 ? ~ulps_wake_cnt : lpctrl_hs_req_fr ) : lpctrl_hs_stop_fr === 1'b1 && enable_q === 1'b1 ? 1'b0 : 1'b1;
    assign fr_ld_val = init_done == 1'b1 ? (is_ulps == 1'b1 ? { 8'h0, t_wake_ulps } : { 8'h0, t_hs_settle }) : { 8'h0, t_init }  ;

    dphy_timer #(
        .WIDTH(FR_TIMER_WIDTH)
   ) rx_timer_fr
   (
        .clk(fr_clk),     
        .srst_n(srst_fr_n),     
        .timer_en(fr_timer_en), 
        .ld_timer(fr_ld_timer),   
        .ld_val(fr_ld_val), 
        .timer_out(fr_timer_out)   
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_din_valid (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(din_valid_fr),
        .dout(din_valid_rx)
    );

    altera_std_synchronizer_nocut # (
        .depth(3)
    ) cdc_sync_fast_stop (
        .clk(rx_clk),
        .reset_n(arst_rx_n),
        .din(fast_stop),
        .dout(fast_stop_rx)
    );

    assign din_valid_int = din_valid_rx & ~fast_stop_rx;
    hyperpipe # (.WIDTH(1), .CYCLES(DIN_VALID_PIPE_LEN)) din_valid_pipe (.clk(rx_clk), .din(din_valid_int), .dout(din_valid) );

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wL3xy0897+SaA2l8k0LcQeickywP/aAsDpmXGk+qqHOEfKDvnmwJ3NFScvPOOMjVxkEsG2tlgj7t0aWLTI4m9H+V/GTsSAggoI0n8McMaJFvJf9+UOR7eS5nE/Fb62J1RUW7sRYwGtVQS8qj0Fr45dObK4NJGiZTIeRSkKuaTHw77sfnjisKF7z5N2gNoQYKGuEUaoyzxFqTrSu3m65xQqczL/Dnhle0uAaBrCL3srkcG6KfhYcEFYKEfOo5150DkxHGR/WYlP1fyf5+a8+jQrluJjprS3zi4g7rX0h+50DsyiqCdMqxOwYnFU742s49p5Ip5rFJ5wg8enpeMH1lRYcl1CgTSoEeQ18f/PLbr7xd/U+0SqOUNZMX9JOs4rZWCm2P7yNQQt7ceuSwALaR5h5kh6NXKYMSnkD8vT2THIlbaNwNfJV/wpMzh2aKgQXkMAawuSFRDEV6FWWFlREdXlk2AUIoaSt8gIrYJTsMvkYd4iFJTxg7i5p5tnj0rFViz0qV62ZwYRgI8JiGOY84X6I4vneGSQhrgk00IRF2/pY6zevQ8EIbA729wF5KYPtNsUZhQyZzjMeG+kt4yUL4YSoSaqcfexvWIbpfThcZzSCVP0sL+kVqTrS5EDh+kp5dMMPBL6W5nY/mJCD+rSpCbLzaRSgsMgS7yvejWNsgPNAn9FTXBbtmrZt54hG/UzWd+KnW2CEx1uIE6qXIebGBdpGJOXEfRRjGT/CIZuynPxOVcFDwo2S2ULITTD4MbPmz64joI4D2G3vKEn7ALZnj0xIzZICu6/Udk7MDuZhcqv1bjWyVoqU8TjEgdoG9Xe0PN1VYPz/fmFzXwYSbVeD43i4iNo7nscGaYxwfObShHFMk2ZJSNIa4G5VkzDXfRIXmC0TKQ6Kb/wDqxL36k0WJ+dvcPqgUl4p5J/7DapaV/BumDubAp1BywPefijA1Qjjsr3q6iMuUEb19M+lNn4I6tdLeUSnIXzhTEatQHS/TWytIadBaEKpJOGnP/quT/AiH"
`endif