// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

interface dphy_io_if #(
    parameter NUM_LANES = 8,
    parameter IO_CONVERT_RATIO = 16,
    parameter BYTE_CNT = NUM_LANES > 4 ? 2 : 1
    ) ;
   
    logic [BYTE_CNT-1:0]                         rx_clk;         
    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       rx_rd_data; 
    logic [3:0]                                  rx_rd_valid;   
    logic                                        rx_clk_lp_p;
    logic                                        rx_clk_lp_n;
    logic [NUM_LANES-1:0]                        rx_data_lp_p;
    logic [NUM_LANES-1:0]                        rx_data_lp_n;
    logic [3:0]                                  rx_data_read_en;    
    logic                                        rx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        rx_data_lp_hs_b;
    logic [16*NUM_LANES-1:0]                     rx_data_deskew_cntrl;
    logic                                        core_clk;
    logic                                        srst_n;

    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       tx_wr_data; 
    logic [IO_CONVERT_RATIO-1:0]                 tx_clk_data; 
    logic                                        tx_clk_lp_p;
    logic                                        tx_clk_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_p;
    logic [NUM_LANES-1:0]                        tx_data_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_hs_b;
    logic                                        tx_clk_lp_hs_b;

    logic                                        mnl_tx_en;
    logic                                        mnl_tx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        mnl_tx_data_lp_hs_b;
    logic                                        mnl_tx_data_lp_p;
    logic                                        mnl_tx_data_lp_n;
    logic [1:0]                                  mnl_tx_data_hs;
    logic [1:0]                                  mnl_tx_clk_hs;


endinterface : dphy_io_if
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wL3xy0897+SaA2l8k0LcQeickywP/aAsDpmXGk+qqHOEfKDvnmwJ3NFScvPOOMjVxkEsG2tlgj7t0aWLTI4m9H+V/GTsSAggoI0n8McMaJFvJf9+UOR7eS5nE/Fb62J1RUW7sRYwGtVQS8qj0Fr45dObK4NJGiZTIeRSkKuaTHw77sfnjisKF7z5N2gNoQYKGuEUaoyzxFqTrSu3m65xQqczL/Dnhle0uAaBrCL3srm+jmYhpuhtNOYtbIvHBHdyjPo6KG4t85i+4wbM7JIAhQ4sjPF/YgIHXviRd4rlteHjI0F0fO3In+S4bZXoIDEHAwNyGzSiZhB9R4SthtzceqEpFRsnH+ZC9YPyiGl77IjPcdKJZr2qODDhm8JJD1aGf/YfouiCEmUCk5KgS7GliOGTZOR0zN2XHXnFQIg1VG8q1Erxiiu8tDtEFr17OTUp+G5GTdPqwVymTn1mSlxTwaemMXtcFEAbRZ/uvB/VZxpf2OtgJrCvClRpBGlmtT801+HNw3cJvr9tR63wRqtr3TPZFbIi16mgVBl5e6JGCk5NB6YuDLxZCojacO+/7L3pYbcAk6vGXUeEFffXgzuk9XXuDucQGVQC0T8LWm3JC1p2dns7Hvz9GFHeA5QGZh8PWRM+cg2AR0Jj53YaL/8q1u3Upgbff54e1MIuIQGJFdHHqNe5R1CKbqIlFZbCbbR1pT2TSrSwsOUG6H033bkjHl4tXfkG4vHBEcmCKTyutbx3RjJ6T1DVtXl0wZ+pUQuoMCGdA31ff1VfvdyN/veLRVVsDbcs/qa79QC4juvyY5MAfXxsR+ZnmIQJaBlLAnnXCVgcqF56rUpXc60giD3tcp67w8WK3ASx4LLLxzZF0mv+k2/K+WR2rub/lX4dgE+CSWTls4UXLTFQy9HwD/iJ+xVk9M38qIeGByefzT8xwYV5PysxtWn6BaZlr7SZBOGRR5SxXsfd6PaPX5dS1tYxySd0Ra18Bn7fwm6K8aSJdcVhrs4k4+04u4uqpfWErNJ2"
`endif