// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





// synthesis translate_off   

`ifdef DPHY_BHV_SIM
`define BHV_CPA 1
`endif

`ifdef BHV_CPA
`define cpa_name dphy_cpa_bhv
`endif

`define SIM 1

// synthesis translate_on

`ifndef cpa_name
`define cpa_name tennm_clkgen
`endif

module dphy_cpa_wrap #(
    parameter CPA_ID = 0,
    parameter PHY_CLK_DIV = 1,
    parameter VCO_CLK_DIV_EXPONENT = 2,
    parameter VCO_CLK_FREQ = 36'h00000000
) ( 
    input  wire            i_core_clk_in,                  
    input  wire            i_phyclk,                       
    input  wire            i_phyclk_sync,                  
    output logic           o_core_clk_out,                 
    input  wire  [7:0]     i_vco8ph,                       
    output logic           o_lock,                         
    input  wire            i_pll_lock                      
);

localparam PROTOCOL_MODE = 1'b0
// synthesis translate_off
                           | 1'b1
// synthesis translate_on
                           ? "PROTOCOL_MODE_NON_EMIF"
                           : "PROTOCOL_MODE_EMIF";

   
    `cpa_name #(
        .base_address( (16'h3<<8) | (16'h1a<<1) | CPA_ID ),
        .feedback_dly_sel( "FEEDBACK_DLY_SEL_DLY_PHY" ),
        .feedback_dly_steps( 7'h00 ),
        .phy_clk_div( PHY_CLK_DIV ),
        .protocol_mode( PROTOCOL_MODE ),
        .vco_clk_div_exponent( VCO_CLK_DIV_EXPONENT ),
        .vco_clk_div_mantissa( 5'h00 ),
        .vco_clk_freq( VCO_CLK_FREQ )
    ) cpa_inst (
        .i_core_clk_in( i_core_clk_in ),                              
        .i_phyclk( i_phyclk ),                                        
        .i_phyclk_sync( i_phyclk_sync ),                              
        .o_core_clk_out( o_core_clk_out ),                            
        .i_vco8ph( i_vco8ph ),                                        
        .o_lock( o_lock ),                                            
        .i_avl_clk(),                                                 
        .i_avl_rst_n(),                                               
        .i_avl_write(),                                               
        .i_avl_read(),                                                
        .i_avl_address(),                                             
        .i_avl_writedata(),                                           
        .o_avl_readdata(  ),                                          
        .i_pll_lock( i_pll_lock )                                     
    );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "9xOA0T0hLsszxl9neEbUOlg9nCn3xojUASGmKN7xi5wCFHIqS5J73Sx0HuAAk+82BAr76MeO23YzwuXNecTbmIvkihD0OfUABVBjg7oDhGpXt7C4MsJKy9th2HYapPzUXQGB9qBmL08ZU50mdmBrRmvWUioY4yFzEIVnG6+XsAlNzDoWbSQL2lcff8RxwF4XW8BO2loTLKzWqlFpKaXFNHOorqsvF9G/ISdPspd2OTq4sXShCJ2WqL7qZKKgAyl7wGRKNNJ71yWEwYnTSNJ8WIfhfCNm/Q2oGF4tD2kbVbLznUDdVvGfBPHpmsYVX4HEUrmn97oZznYlLJG/Iis+u7XPfaNGvxNwq/YkN8Ttl8qJtIDZJQIG1PAWYK+mdLPIaDBpOs1qC6Dun4be5FmZurz5T7TN2o10twMLQF8px+LZ/x8Z/ipfRpoG9W0yUG+cr20dFZsyIQ+fyrAgraBkKL02gX9QMRtcdI4GpUXr7erUu0z7SdZTSD0q9Pk+D60OAIZzxi8hWA7S1pyXdefNoK/T9MhQhuzDr8XIinFWj6/v3YLq7Y3ftLr9iSLAEjM1iL9aye8XJSnkzGfIj1geyeD4eLQkZTCdosqqOehUe7gMaRN0KB0RoOp2fwEZKXfMD41gVsr/s/Uv2tfLr+IEKVdbaAm82/Zf6sP8SaX6UZG5BlBl+vjbeygDixtKq8g+nu0zoSfUv9EMbqoKEUUGe10hm8+9DoTt9ScmNYTEPDEyl69mX1pWWTJWI1lzSTL3XygzTDqxiFy4ESTsr5XxP7OnNS5JsA4cn2GCMqtKF7WKRR4Y0IoJMECZp7LnwajwbUv/K7IMCML4jUUG5tzyXlAXivRr3xtSHyMsEgzsei8FEfZ1BVC956z+y9Iy2zlcgoxKzs47dVpwPOsPqm52syN59nOkP5dmltauVMkzckM91PI1VoPZOD0KcUITf4TvLgmeKKDsbhXt0Jx+EqbG1n5SHcPnzrnZ1QOwb3jYTfujoDwiB5w0WecfNKxZe2Qx"
`endif