// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





`timescale 1ns / 1ns

module altera_std_synchronizer_nocut (
                                clk, 
                                reset_n, 
                                din, 
                                dout
                                );

   parameter depth = 3; 
   parameter rst_value = 0;     
     
   input   clk;
   input   reset_n;    
   input   din;
   output  dout;
   

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name SYNCHRONIZER_IDENTIFICATION FORCED; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON  "} *) reg din_s1;

   (* altera_attribute = {"-name ADV_NETLIST_OPT_ALLOWED NEVER_ALLOW; -name DONT_MERGE_REGISTER ON; -name PRESERVE_REGISTER ON"} *) reg [depth-2:0] dreg;    
   
   // synthesis translate_off
   `ifndef QUARTUS_CDC
   initial begin
      if (depth <2) begin
         $display("%m: Error: synchronizer length: %0d less than 2.", depth);
      end
   end
   `endif

   
`ifdef __ALTERA_STD__METASTABLE_SIM

   reg[31:0]  RANDOM_SEED = 123456;      
   wire  next_din_s1;
   wire  dout;
   reg   din_last;
   reg          random;
   event metastable_event; 

   
   always @(posedge clk) begin
      if (reset_n == 0)
        random <= $random(RANDOM_SEED);
      else
        random <= $random;
   end

   assign next_din_s1 = (din_last ^ din) ? random : din;   

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0) 
         din_last <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_last <= din;
   end

   always @(posedge clk or negedge reset_n) begin
       if (reset_n == 0) 
         din_s1 <= (rst_value == 0)? 1'b0 : 1'b1;
       else
         din_s1 <= next_din_s1;
   end
   
`else 

   // synthesis translate_on   
   generate if (rst_value == 0)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0) 
             din_s1 <= 1'b0;
           else
             din_s1 <= din;
       end
   endgenerate
   
   generate if (rst_value == 1)
       always @(posedge clk or negedge reset_n) begin
           if (reset_n == 0) 
             din_s1 <= 1'b1;
           else
             din_s1 <= din;
       end
   endgenerate
   // synthesis translate_off      

`endif

`ifdef __ALTERA_STD__METASTABLE_SIM_VERBOSE
   always @(*) begin
      if (reset_n && (din_last != din) && (random != din)) begin
         $display("%m: Verbose Info: metastable event @ time %t", $time);
         ->metastable_event;
      end
   end      
`endif

   // synthesis translate_on

   generate if (rst_value == 0)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b0}};            
            else
              dreg <= din_s1;
         end         
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b0}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate
   
   generate if (rst_value == 1)
      if (depth < 3) begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b1}};            
            else
              dreg <= din_s1;
         end         
      end else begin
         always @(posedge clk or negedge reset_n) begin
            if (reset_n == 0) 
              dreg <= {depth-1{1'b1}};
            else
              dreg <= {dreg[depth-3:0], din_s1};
         end
      end
   endgenerate

   assign dout = dreg[depth-2];
   
endmodule 


                        
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wL3xy0897+SaA2l8k0LcQeickywP/aAsDpmXGk+qqHOEfKDvnmwJ3NFScvPOOMjVxkEsG2tlgj7t0aWLTI4m9H+V/GTsSAggoI0n8McMaJFvJf9+UOR7eS5nE/Fb62J1RUW7sRYwGtVQS8qj0Fr45dObK4NJGiZTIeRSkKuaTHw77sfnjisKF7z5N2gNoQYKGuEUaoyzxFqTrSu3m65xQqczL/Dnhle0uAaBrCL3srlNLguSQQJvib/mC4kEgjfPfElqRchsnBJgIQinwLsxfiezJdBjHRG4W4GPOU8irIEd/8yaQ5CXzt5jAt98fzigXq9R/1EG3NI1quyAbmuaQT+jqU4gFfmHL4bbrSI+iEVlir16sYwgPbBJlih8oFdhcyoxBX5YBDVLPrHEgQ9tw9MZ0JIDlhR+iTs7oO1gYKCIeURoR0ROJyxZOlp9tcK3Te7mMMBlFymJhQrTKNpGoTj0tz4JNxBkUdR6hwBAhEckXsmP3Tq51g08X3yUZAd3DYZGHb0Acs3/qxSKaj+806zwLJMPu82q1eHpHxbKOwWNBt8rMEie+XuHBAkBHRUU0LNI8ArA4v0NZYQ0p884IoBzL2opmqI4IL4A1+iOPMR2Td5lTXsQpbmc7qKsCtcpdCbf1X7HhOrG5+V+LpuFkcet8s8pMRb8oRcJXnarh2tOqHQkx8LB8DzknXqfCwlhA05stAa2f2q9dq15ocOeBv6bcMyDinuvPMj25W6TEOGyXrj1NIA7fTg+6Ngemu8m3SuMj6qiPt5MGOw4cMS9qx9XAucQOkas8k4sHghGBPlSkCxkHplviGPsvuhfd1lITMiGXaIlwsA3gyfXi7qZM6E22VemLYoQeUeH87QSZWFKTdTvMYrPWPB4yOABHqJt7nbyHg+MQ2ld4nygwm9BbwhtNgQ7c8v1B4Al7igaJiYJZ6JVCB4HMS4Dw0y5ngcdImh7EUGKpOuED8fl9xYjjOHE8YPtXUvmLlBp3z1YkjnmMumUqAJAY3p+EegYV2sX"
`endif