// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Oct 16 15:44:06 2025
// ============================================================================

/* 

   2026/1/14. 
	adjust LPDDR4A setting for improve compatibility
	-- Mem Target Wrtie Terminala: 80 omhz (RZQ/3)
	-- Mem VrefDQ Value: 22
	change MIPI DPHY setting for improve compatibility
	-- RX Data Lane deskew delay : 3/64 UI

   2026/1/15. 
	- HDMI_TX_CLK_p delay -3100ps (by PLL)
	
*/

`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_HPS
`define ENABLE_CAM
`define ENABLE_HDMI

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B2A_p,
      input              CLK_100_p,
      input              CLK_50_B5A,
      input              CLK_50_B6A,
      input              CLK_50_B6C,
      input              CLK_50_B6F,
      input              CLK_50_B6H,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS0_n,
      output             LPDDR4A_CS1_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output   [ 1: 0]   LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 1: 0]   LPDDR4B_DM,
      inout    [15: 0]   LPDDR4B_DQ,
      inout    [ 1: 0]   LPDDR4B_DQS,
      inout    [ 1: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      input              HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,
`endif /*ENABLE_HDMI*/

      ///////// I2Cs /////////
      inout              FAN_I2C_SCL,
      inout              FAN_I2C_SDA,
      input              FAN_ALERT_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
//      input    [ 3: 0]   CAM_D_p,
//      input    [ 3: 0]   CAM_D_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ0, //RZQ_B_2A_B
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout              HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout              HPS_LED,
      inout              HPS_LED2,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p,
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n, 
`endif /*ENABLE_HPS*/

      ///////// PM /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT
		
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrControl,                //                                              .ErrControl
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
//		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrControl,                //                                              .ErrControl
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
//		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrControl,                //                                              .ErrControl
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
//		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
//		input  wire        csi2_rx_avalon_mm_control_interface_write,         //           csi2_rx_avalon_mm_control_interface.write
//		input  wire        csi2_rx_avalon_mm_control_interface_read,          //                                              .read
//		input  wire [9:0]  csi2_rx_avalon_mm_control_interface_address,       //                                              .address
//		input  wire [31:0] csi2_rx_avalon_mm_control_interface_writedata,     //                                              .writedata
//		output wire [31:0] csi2_rx_avalon_mm_control_interface_readdata,      //                                              .readdata
//		output wire        csi2_rx_avalon_mm_control_interface_readdatavalid, //                                              .readdatavalid
//		output wire        csi2_rx_avalon_mm_control_interface_waitrequest,   //                                              .waitrequest
//		input  wire [3:0]  csi2_rx_avalon_mm_control_interface_byteenable,    //                                              .byteenable
//		output wire        csi2_rx_avalon_mm_control_interface_interrupt_irq, // csi2_rx_avalon_mm_control_interface_interrupt.irq
//		output wire        mipi_dphy_LINK0_link_core_srst_reset_n,            //                mipi_dphy_LINK0_link_core_srst.reset_n
//		output wire        mipi_dphy_LINK0_link_core_arst_reset_n,            //                mipi_dphy_LINK0_link_core_arst.reset_n
//		input  wire [11:0] mipi_dphy_axi_lite_awaddr,                         //                            mipi_dphy_axi_lite.awaddr
//		input  wire        mipi_dphy_axi_lite_awvalid,                        //                                              .awvalid
//		output wire        mipi_dphy_axi_lite_awready,                        //                                              .awready
//		input  wire [31:0] mipi_dphy_axi_lite_wdata,                          //                                              .wdata
//		input  wire [3:0]  mipi_dphy_axi_lite_wstrb,                          //                                              .wstrb
//		input  wire        mipi_dphy_axi_lite_wvalid,                         //                                              .wvalid
//		output wire        mipi_dphy_axi_lite_wready,                         //                                              .wready
//		output wire [1:0]  mipi_dphy_axi_lite_bresp,                          //                                              .bresp
//		output wire        mipi_dphy_axi_lite_bvalid,                         //                                              .bvalid
//		input  wire        mipi_dphy_axi_lite_bready,                         //                                              .bready
//		input  wire [11:0] mipi_dphy_axi_lite_araddr,                         //                                              .araddr
//		input  wire        mipi_dphy_axi_lite_arvalid,                        //                                              .arvalid
//		output wire        mipi_dphy_axi_lite_arready,                        //                                              .arready
//		output wire [31:0] mipi_dphy_axi_lite_rdata,                          //                                              .rdata
//		output wire [1:0]  mipi_dphy_axi_lite_rresp,                          //                                              .rresp
//		output wire        mipi_dphy_axi_lite_rvalid,                         //                                              .rvalid
//		input  wire        mipi_dphy_axi_lite_rready,                         //                                              .rready
//		input  wire [2:0]  mipi_dphy_axi_lite_arprot,                         //                                              .arprot
//		input  wire [2:0]  mipi_dphy_axi_lite_awprot,                         //                                              .awprot
//		output wire        mipi_dphy_reg_bus_reg_wr_en_o,                     //                             mipi_dphy_reg_bus.reg_wr_en_o
//		output wire        mipi_dphy_reg_bus_reg_rd_en_o,                     //                                              .reg_rd_en_o
//		output wire [10:0] mipi_dphy_reg_bus_reg_raddr_o,                     //                                              .reg_raddr_o
//		output wire [10:0] mipi_dphy_reg_bus_reg_waddr_o,                     //                                              .reg_waddr_o
//		output wire [3:0]  mipi_dphy_reg_bus_reg_be_o,                        //                                              .reg_be_o
//		output wire [31:0] mipi_dphy_reg_bus_reg_din_o,                       //                                              .reg_din_o
//		input  wire [31:0] mipi_dphy_reg_bus_reg_dout_i                      //                                              .reg_dout_i
		
	  
);


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================



wire clk_50;

assign clk_50 = CLK_50_B5A;


//=======================================================
//  Structural coding
//=======================================================

//-------------------------------------
// reset
//-------------------------------------


// for debug
//wire        vvp_streamming_ready;
//assign csi2_rx_video_streaming_interface_0_tready = not_use_vvp? 1'b1 : vvp_streamming_ready;




wire ninit_done;
	ResetRelease ResetRelease_inst (
		.ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
	);


wire reset_n;

// 100ms Power-On Reset (POR) counter
reg [22:0] por_counter;
reg por_done;
wire por_reset_n;

always @(posedge clk_50 or posedge ninit_done) begin
	if (ninit_done)
	begin
        por_done <= 1'b0;
		  por_counter <= 0;
	end
	else if (~por_done && (por_counter < 23'd4999999))   // 100ms at 50MHz
        por_counter <= por_counter + 1'b1;
   else if (~por_done)
        por_done <= 1'b1;
end

assign por_reset_n = por_done;


assign reset_n = por_reset_n & ~ninit_done & USER_BUTTON;	// Added 100ms POR + press KEY0 to trigger reset (low active)




wire vvp_reset_n;
assign vvp_reset_n = reset_n;// & KEY[1]; // press KEY0 to trigger reset (low active)


//-------------------------------------
// CAMERA Decalre
//-------------------------------------

// camera i2c bus


wire camera_i2c_serial_sda_in;
wire camera_i2c_serial_scl_in;
wire camera_i2c_serial_sda_oe;
wire camera_i2c_serial_scl_oe;


assign camera_i2c_serial_scl_in = CAM_I2C_SCL;
assign camera_i2c_serial_sda_in = CAM_I2C_SDA;
assign CAM_I2C_SCL = camera_i2c_serial_scl_oe ? 1'b0 : 1'bz;
assign CAM_I2C_SDA = camera_i2c_serial_sda_oe ? 1'b0 : 1'bz;

// power on Camera
assign CAM_GPIO = nios_cam_gpio;


//-----------------------------------------------------------------------------
// Nios V System
//-----------------------------------------------------------------------------

wire [7:0] nios_led;
wire clk_1080p;


wire [23: 0] disp_data;
wire disp_clk;
wire disp_hs;
wire disp_vs;
wire disp_de;


wire csi2_axi4_clock;
wire dphy_clock;
//wire mipi_dphy_ref_clk;



wire [63:0] csi2_rx_video_streaming_interface_0_tdata /*synthesis keep*/;         //           csi2_rx_video_streaming_interface_0.tdata
wire        csi2_rx_video_streaming_interface_0_tvalid /*synthesis keep*/;        //                                              .tvalid
wire        csi2_rx_video_streaming_interface_0_tready /*synthesis keep*/;        //                                              .tready
wire        csi2_rx_video_streaming_interface_0_tlast /*synthesis keep*/;         //                                              .tlast
wire [7:0]  csi2_rx_video_streaming_interface_0_tuser /*synthesis keep*/;         //                                              .tuser




wire hdmi_config_done;
wire pio_mem_ready;
wire nios_reset_n_vvp; // reset vvp when lpddr4 is ready. otherwise, vvp frame buffer could malfunction
wire nios_cam_gpio;




 system u0 (
        .clk_clk                            (clk_50),
        .reset_n_reset_n                    (reset_n),
        .reset_in_vvp_in_reset_reset_n      (vvp_reset_n & nios_reset_n_vvp & pio_mem_ready),                          //   input,   width = 1,                      reset_in_vvp_in_reset.reset_n
        .pio_hdmi_config_done_external_connection_export   (hdmi_config_done),        //   input,   width = 1,   pio_hdmi_config_done_external_connection.export

        .pio_mem_ready_external_connection_export          (pio_mem_ready),                  //   input,   width = 1,                pio_mem_ready_external_connection.export
        .pio_vvp_reset_n_external_connection_export        (nios_reset_n_vvp),               //  output,   width = 1,              pio_vvp_reset_n_external_connection.export
		  .pio_cam_gpio_external_connection_export           (nios_cam_gpio),                  //  output,   width = 8,                 pio_cam_gpio_external_connection.export


		  // PLL clock output
        .csi2_axi4_clk_clk                                     (csi2_axi4_clock),                                     //  output,   width = 1,                         csi2_axi4_clk.clk
        .dphy_clk_clk                                          (dphy_clock),                                          //  output,   width = 1,                              dphy_clk.clk
        .hdmi_clk_clk                                          (clk_1080p),                                          //  output,   width = 1,                              hdmi_clk.clk



		  // User IO
        .pio_switch_external_connection_export (USER_SW), //   input,  width = 10, pio_switch_external_connection.export
        .pio_key_external_connection_export    ({USER_BUTTON, USER_BUTTON, USER_BUTTON, USER_BUTTON}),     //   input,   width = 4,    pio_key_external_connection.export
        .pio_led_external_connection_export (nios_led),  //  output,  width = 10, pio_led_external_connection.export

		  // CAMERA I2C
        .i2c_i2c_serial_sda_in (camera_i2c_serial_sda_in), //   input,  width = 1, i2c_camera_i2c_serial.sda_in
        .i2c_i2c_serial_scl_in (camera_i2c_serial_scl_in), //   input,  width = 1,                      .scl_in
        .i2c_i2c_serial_sda_oe (camera_i2c_serial_sda_oe), //  output,  width = 1,                      .sda_oe
        .i2c_i2c_serial_scl_oe (camera_i2c_serial_scl_oe),  //  output,  width = 1,                      .scl_oe

		  ////////////////////////////
		  // VVP interface
        .vvp_system_clock_in_csi2_in_clk_clk                   (csi2_axi4_clock),                   //   input,   width = 1,       vvp_system_clock_in_csi2_in_clk.clk
//        .vvp_system_clock_in_hdmi_in_clk_clk                   (clk_1080p),                   //   input,   width = 1,       vvp_system_clock_in_hdmi_in_clk.clk

			// LPDDR4A
			
//        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_cs            (LPDDR4A_CS_n),            //  output,   width = 1,        vvp_system_emif_io96b_lpddr4a_mem_0.mem_cs
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_cs            ({LPDDR4A_CS1_n, LPDDR4A_CS0_n}),            //  output,   width = 1,        vvp_system_emif_io96b_lpddr4a_mem_0.mem_cs
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_ca            (LPDDR4A_CA),            //  output,   width = 6,                                           .mem_ca
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_cke           (LPDDR4A_CKE),           //  output,   width = 1,                                           .mem_cke
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_dq            (LPDDR4A_DQ),            //   inout,  width = 32,                                           .mem_dq
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_t         (LPDDR4A_DQS),         //   inout,   width = 4,                                           .mem_dqs_t
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_dqs_c         (LPDDR4A_DQS_n),         //   inout,   width = 4,                                           .mem_dqs_c
        .vvp_system_emif_io96b_lpddr4a_mem_0_mem_dmi           (LPDDR4A_DM),           //   inout,   width = 4,                                           .mem_dmi
        .vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_t       (LPDDR4A_CK),       //  output,   width = 1,     vvp_system_emif_io96b_lpddr4a_mem_ck_0.mem_ck_t
        .vvp_system_emif_io96b_lpddr4a_mem_ck_0_mem_ck_c       (LPDDR4A_CK_n),       //  output,   width = 1,                                           .mem_ck_c
        .vvp_system_emif_io96b_lpddr4a_mem_reset_n_mem_reset_n (LPDDR4A_RESET_n), //  output,   width = 1,  vvp_system_emif_io96b_lpddr4a_mem_reset_n.mem_reset_n
        .vvp_system_emif_io96b_lpddr4a_oct_0_oct_rzqin         (LPDDR4A_RZQ),         //   input,   width = 1,        vvp_system_emif_io96b_lpddr4a_oct_0.oct_rzqin
        .vvp_system_emif_io96b_lpddr4a_ref_clk_clk             (LPDDR4A_REFCLK_p),             //   input,   width = 1,      vvp_system_emif_io96b_lpddr4a_ref_clk.clk
        .vvp_system_emif_io96b_lpddr4a_s0_axi4_ctrl_ready_reset_n (pio_mem_ready), //  output,   width = 1, vvp_system_emif_io96b_lpddr4a_s0_axi4_ctrl_ready.reset_n
		  


		  // video input (Camera RGB input, 4 pixel paralle, 10 bit per sample, RGB)
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tdata      (csi2_rx_video_streaming_interface_0_tdata),      //   input,  width = 64, vvp_system_intel_vvp_demosaic_axi4s_vid_in.tdata
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tvalid     (csi2_rx_video_streaming_interface_0_tvalid),     //   input,   width = 1,                                           .tvalid
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tready     (csi2_rx_video_streaming_interface_0_tready),     //  output,   width = 1,                                           .tready
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tlast      (csi2_rx_video_streaming_interface_0_tlast),      //   input,   width = 1,                                           .tlast
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tuser      (csi2_rx_video_streaming_interface_0_tuser),      //   input,   width = 8,                                           .tuser



				// video output
        .vvp_system_intel_vvp_cvo_vid_status_vid_locked        (),        //  output,   width = 1,   vvp_system_intel_vvp_cvo_vid_status.vid_locked
        .vvp_system_intel_vvp_cvo_vid_status_vid_is_full       (),       //  output,   width = 1,                                      .vid_is_full
        .vvp_system_intel_vvp_cvo_vid_status_vid_stall_error   (),   //  output,   width = 1,                                      .vid_stall_error
        .vvp_system_intel_vvp_cvo_vid_status_vid_size_mismatch (), //  output,   width = 1,                                      .vid_size_mismatch
        .vvp_system_intel_vvp_cvo_frame_start_conduit          (1'b1),          //   input,   width = 1,  vvp_system_intel_vvp_cvo_frame_start.conduit
        .vvp_system_intel_vvp_fr2cv_cv_clk_out_clk             (),             //  output,   width = 1, vvp_system_intel_vvp_fr2cv_cv_clk_out.clk
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_data        (disp_data),        //  output,  width = 24, vvp_system_intel_vvp_fr2cv_cv_vid_out.vid_data
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_underflow       (),       //  output,   width = 1,                                      .underflow
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_datavalid   (disp_de),   //  output,   width = 1,                                      .vid_datavalid
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v_sync      (disp_vs),      //  output,   width = 1,                                      .vid_v_sync
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h_sync      (disp_hs),      //  output,   width = 1,                                      .vid_h_sync
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_f           (),           //  output,   width = 1,                                      .vid_f
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h           (),           //  output,   width = 1,                                      .vid_h
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v           ()           //  output,   width = 1,                                      .vid_v


    );


/////////////////////////
// VVP to HDMI OUTPUT

assign disp_clk = clk_1080p;

assign HDMI_TX_D = disp_data;
assign HDMI_TX_CLK_p = disp_clk;
assign HDMI_TX_HS = disp_hs;
assign HDMI_TX_VS = disp_vs;
assign HDMI_TX_DE = disp_de;


//-----------------------------------------------------------------------------
// Camera System: DPHY + CSI-2
//-----------------------------------------------------------------------------



	csi2_dphy_sys csi2_dphy_sys_cam (
		.reset_n_bridge_in_reset_reset_n                   (reset_n),                   //   input,   width = 1,                       reset_n_bridge_in_reset.reset_n
		.rx_axi4s_clk_bridge_in_clk_clk                    (csi2_axi4_clock),                     //   input,   width = 1,                    rx_axi4s_clk_bridge_in_clk.clk

		// cSI2
//		.csi2_rx_o_d0_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d0_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
//		.csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
//		.csi2_rx_o_d0_ppi_rx_err_ErrEsc                    (csi2_rx_o_d0_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
//		.csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
//		.csi2_rx_o_d0_ppi_rx_err_ErrControl                (csi2_rx_o_d0_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
//		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
//		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
//		.csi2_rx_o_d1_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d1_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
//		.csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
//		.csi2_rx_o_d1_ppi_rx_err_ErrEsc                    (csi2_rx_o_d1_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
//		.csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
//		.csi2_rx_o_d1_ppi_rx_err_ErrControl                (csi2_rx_o_d1_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
//		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
//		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
//		.csi2_rx_o_ck_ppi_rx_err_ErrSotHS                  (csi2_rx_o_ck_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
//		.csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
//		.csi2_rx_o_ck_ppi_rx_err_ErrEsc                    (csi2_rx_o_ck_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
//		.csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
//		.csi2_rx_o_ck_ppi_rx_err_ErrControl                (csi2_rx_o_ck_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
//		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
//		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_video_streaming_interface_0_tdata         (csi2_rx_video_streaming_interface_0_tdata),         //  output,  width = 64,           csi2_rx_video_streaming_interface_0.tdata
		.csi2_rx_video_streaming_interface_0_tvalid        (csi2_rx_video_streaming_interface_0_tvalid),        //  output,   width = 1,                                              .tvalid
		.csi2_rx_video_streaming_interface_0_tready        (csi2_rx_video_streaming_interface_0_tready),        //   input,   width = 1,                                              .tready
		.csi2_rx_video_streaming_interface_0_tlast         (csi2_rx_video_streaming_interface_0_tlast),         //  output,   width = 1,                                              .tlast
		.csi2_rx_video_streaming_interface_0_tuser         (csi2_rx_video_streaming_interface_0_tuser),         //  output,   width = 8,                                              .tuser
//		.csi2_rx_avalon_mm_control_interface_write         (csi2_rx_avalon_mm_control_interface_write),         //   input,   width = 1,           csi2_rx_avalon_mm_control_interface.write
//		.csi2_rx_avalon_mm_control_interface_read          (csi2_rx_avalon_mm_control_interface_read),          //   input,   width = 1,                                              .read
//		.csi2_rx_avalon_mm_control_interface_address       (csi2_rx_avalon_mm_control_interface_address),       //   input,  width = 10,                                              .address
//		.csi2_rx_avalon_mm_control_interface_writedata     (csi2_rx_avalon_mm_control_interface_writedata),     //   input,  width = 32,                                              .writedata
//		.csi2_rx_avalon_mm_control_interface_readdata      (csi2_rx_avalon_mm_control_interface_readdata),      //  output,  width = 32,                                              .readdata
//		.csi2_rx_avalon_mm_control_interface_readdatavalid (csi2_rx_avalon_mm_control_interface_readdatavalid), //  output,   width = 1,                                              .readdatavalid
//		.csi2_rx_avalon_mm_control_interface_waitrequest   (csi2_rx_avalon_mm_control_interface_waitrequest),   //  output,   width = 1,                                              .waitrequest
//		.csi2_rx_avalon_mm_control_interface_byteenable    (csi2_rx_avalon_mm_control_interface_byteenable),    //   input,   width = 4,                                              .byteenable
//		.csi2_rx_avalon_mm_control_interface_interrupt_irq (csi2_rx_avalon_mm_control_interface_interrupt_irq), //  output,   width = 1, csi2_rx_avalon_mm_control_interface_interrupt.irq

		// MIPI PHY
		.mipi_dphy_rzq_rzq                                 (CAM_RZQ0),                                 //   input,   width = 1,                                 mipi_dphy_rzq.rzq
		.mipi_dphy_ref_clk_0_clk                           (CLK_100_p),                           //   input,   width = 1,                           mipi_dphy_ref_clk_0.clk
//		.mipi_dphy_LINK0_link_core_srst_reset_n            (mipi_dphy_LINK0_link_core_srst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_srst.reset_n
//		.mipi_dphy_LINK0_link_core_arst_reset_n            (mipi_dphy_LINK0_link_core_arst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_arst.reset_n
//		.mipi_dphy_axi_lite_awaddr                         (mipi_dphy_axi_lite_awaddr),                         //   input,  width = 12,                            mipi_dphy_axi_lite.awaddr
//		.mipi_dphy_axi_lite_awvalid                        (mipi_dphy_axi_lite_awvalid),                        //   input,   width = 1,                                              .awvalid
//		.mipi_dphy_axi_lite_awready                        (mipi_dphy_axi_lite_awready),                        //  output,   width = 1,                                              .awready
//		.mipi_dphy_axi_lite_wdata                          (mipi_dphy_axi_lite_wdata),                          //   input,  width = 32,                                              .wdata
//		.mipi_dphy_axi_lite_wstrb                          (mipi_dphy_axi_lite_wstrb),                          //   input,   width = 4,                                              .wstrb
//		.mipi_dphy_axi_lite_wvalid                         (mipi_dphy_axi_lite_wvalid),                         //   input,   width = 1,                                              .wvalid
//		.mipi_dphy_axi_lite_wready                         (mipi_dphy_axi_lite_wready),                         //  output,   width = 1,                                              .wready
//		.mipi_dphy_axi_lite_bresp                          (mipi_dphy_axi_lite_bresp),                          //  output,   width = 2,                                              .bresp
//		.mipi_dphy_axi_lite_bvalid                         (mipi_dphy_axi_lite_bvalid),                         //  output,   width = 1,                                              .bvalid
//		.mipi_dphy_axi_lite_bready                         (mipi_dphy_axi_lite_bready),                         //   input,   width = 1,                                              .bready
//		.mipi_dphy_axi_lite_araddr                         (mipi_dphy_axi_lite_araddr),                         //   input,  width = 12,                                              .araddr
//		.mipi_dphy_axi_lite_arvalid                        (mipi_dphy_axi_lite_arvalid),                        //   input,   width = 1,                                              .arvalid
//		.mipi_dphy_axi_lite_arready                        (mipi_dphy_axi_lite_arready),                        //  output,   width = 1,                                              .arready
//		.mipi_dphy_axi_lite_rdata                          (mipi_dphy_axi_lite_rdata),                          //  output,  width = 32,                                              .rdata
//		.mipi_dphy_axi_lite_rresp                          (mipi_dphy_axi_lite_rresp),                          //  output,   width = 2,                                              .rresp
//		.mipi_dphy_axi_lite_rvalid                         (mipi_dphy_axi_lite_rvalid),                         //  output,   width = 1,                                              .rvalid
//		.mipi_dphy_axi_lite_rready                         (mipi_dphy_axi_lite_rready),                         //   input,   width = 1,                                              .rready
//		.mipi_dphy_axi_lite_arprot                         (mipi_dphy_axi_lite_arprot),                         //   input,   width = 3,                                              .arprot
//		.mipi_dphy_axi_lite_awprot                         (mipi_dphy_axi_lite_awprot),                         //   input,   width = 3,                                              .awprot

		.mipi_dphy_LINK0_dphy_io_dphy_link_dp              (CAM_D_p),              //   input,   width = 2,                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
		.mipi_dphy_LINK0_dphy_io_dphy_link_dn              (CAM_D_n),              //   input,   width = 2,                                              .dphy_link_dn
		.mipi_dphy_LINK0_dphy_io_dphy_link_cp              (CAM_CLK_p),              //   input,   width = 1,                                              .dphy_link_cp
		.mipi_dphy_LINK0_dphy_io_dphy_link_cn              (CAM_CLK_n)              //   input,   width = 1,                                              .dphy_link_cn

//		.mipi_dphy_reg_bus_reg_wr_en_o                     (mipi_dphy_reg_bus_reg_wr_en_o),                     //  output,   width = 1,                             mipi_dphy_reg_bus.reg_wr_en_o
//		.mipi_dphy_reg_bus_reg_rd_en_o                     (mipi_dphy_reg_bus_reg_rd_en_o),                     //  output,   width = 1,                                              .reg_rd_en_o
//		.mipi_dphy_reg_bus_reg_raddr_o                     (mipi_dphy_reg_bus_reg_raddr_o),                     //  output,  width = 11,                                              .reg_raddr_o
//		.mipi_dphy_reg_bus_reg_waddr_o                     (mipi_dphy_reg_bus_reg_waddr_o),                     //  output,  width = 11,                                              .reg_waddr_o
//		.mipi_dphy_reg_bus_reg_be_o                        (mipi_dphy_reg_bus_reg_be_o),                        //  output,   width = 4,                                              .reg_be_o
//		.mipi_dphy_reg_bus_reg_din_o                       (mipi_dphy_reg_bus_reg_din_o),                       //  output,  width = 32,                                              .reg_din_o
//		.mipi_dphy_reg_bus_reg_dout_i                      (mipi_dphy_reg_bus_reg_dout_i)                      //   input,  width = 32,                                              .reg_dout_i
	);



/////////////////////////////////////
// Optional, Analysis CSI-2 AXI4 video stream

AXI_Stream_Analyze AXI_Stream_Analyze_inst(
	.reset_n    (reset_n),
	.axi_clock  (csi2_axi4_clock),
	.axi_tdata  (csi2_rx_video_streaming_interface_0_tdata),
	.axi_tvalid (csi2_rx_video_streaming_interface_0_tvalid),
	.axi_tready (csi2_rx_video_streaming_interface_0_tready),
	.axi_tlast  (csi2_rx_video_streaming_interface_0_tlast),
	.axi_tuser  (csi2_rx_video_streaming_interface_0_tuser)

);

// override default value
defparam AXI_Stream_Analyze_inst.TICK_PER_SEC = 60000000;




//-----------------------------------------------------------------------------
// TFP410 configrue
//-----------------------------------------------------------------------------

assign HDMI_ISEL = reset_n; // I2C mode
assign HDMI_PD_n = 1'b0; // In I2C mode, pin should be tied to GND
	 
//HDMI I2C
I2C_HDMI_Config u_I2C_HDMI_Config (
	.iCLK(clk_50),
	.iRST_N(reset_n),
	.I2C_SCLK(HDMI_I2C_SCL),
	.I2C_SDAT(HDMI_I2C_SDA)
	 );
	 




endmodule
