
module TERASIC_LOOPBACK(
	input					clk,
	input					reset_n,

	// avmm slave
	input					slave_address,
	input					slave_cs_n,
	input					slave_read_n,
	output	reg	[(PAIR_NUM-1):0]	slave_readdata,
	input					slave_write_n,
	input		[(PAIR_NUM-1):0]	slave_writedata,

	// tested bus
	inout	[(PAIR_NUM-1):0] lb_in,
	inout	[(PAIR_NUM-1):0] lb_out
);

parameter PAIR_NUM = 32;
parameter PAIR_BIR = 1;

reg 								test_start;
wire 								test_done;
wire [(PAIR_NUM-1):0]	test_error_mask;

always @(posedge clk or negedge reset_n) begin
	if (~reset_n) begin
		test_start <= 1'b0;
	end
	else if (~slave_cs_n && ~slave_write_n) begin
		if (slave_address == 1'b0) begin
			test_start <= slave_writedata[0]; // bit 0: control start signal
		end
	end
	else if (~slave_cs_n && ~slave_read_n) begin
		if (slave_address == 1'b0) begin
			slave_readdata <= {{(PAIR_NUM - 1){1'b0}}, test_done}; // bit 0: done status
		end
		else begin
			slave_readdata <= {test_error_mask};
		end
	end
end


defparam test.PATTERN_WIDTH = PAIR_NUM;
defparam test.IO_BIDIRECTION = PAIR_BIR;

LOOPBACK_PATTERN test(
	.clk(clk),
	.reset_n(reset_n),

	// start & result
	.test_start(test_start), // restart a test, edge trigger
	.test_done(test_done),  // assert when all patterns are test once
	.test_error_mask(test_error_mask),

	// tested bus
	.Port_A(lb_out),
	.Port_B(lb_in)
);


endmodule

