// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module wr_comp_sel_cwyib4q #(
    parameter WIDTH=10,
    parameter PIPELINE_OUT=0,
    parameter PIPELINE_CMP=0
) (
    input           clk,
input [WIDTH:0] in_0, 

    input [WIDTH-1:0] base,
    input [1-1:0] shift_occurred, 
    input [1-1:0] clr,    
    output logic sel,
    output logic [1-1:0] sel_index
);
logic [1-1:0] equal,equal_reg;
logic sel_int;
logic [1-1:0] sel_index_int;
logic [1-1:0] shift_occurred_reg;


compare_eq #( .WIDTH (WIDTH) ) com0 ( .in_a(in_0[WIDTH-1:0]), .in_b(base), .equal(equal[0]) );



generate 
    if (PIPELINE_CMP) begin : PIPELINE_CMP_OUT
        always @ (posedge clk) begin
            equal_reg <= equal;
            shift_occurred_reg <= shift_occurred;
        end
    end
    else begin : NO_PIPELINE_CMP_OUT
        assign equal_reg = equal;
        assign shift_occurred_reg = shift_occurred;
    end
endgenerate

wr_pri_mux_cwyib4q pri_mux (
.in0             (equal_reg[0] && in_0[WIDTH]),

    .shift_index_out (shift_occurred_reg),
    .sel             (sel_int),
    .sel_index       (sel_index_int),
    .clr             (clr)

);

generate
    if (PIPELINE_OUT) begin
        always @ (posedge clk) begin
            sel       <= sel_int;
            sel_index <= sel_index_int;
        end
    end
    else begin
        assign sel = sel_int;
        assign sel_index = sel_index_int;
    end
endgenerate 
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkb9QzWgkT6U6aVZQ2M4MRYsx8PNfmddV3y5Z+vuL22UKZtOAp4Q5CDBrRnhpNL1UJoz5QWg9QeFbls7WZV7/RmwSxYTd2wq+mNTWmKuEOf59/jE09wF8qUmkmgGpBI/f+FskAPx4snjJLOVak9uhiOuIv1JV+AVVUgzj+OUq7XYjfW6QJIETQTGSjmUoFKQNe7DqHHcCJVgflkXLtkzs2wWyfEh2i2J8vaRD3KtXpzBKhwkUAse+4b7U+5zfM4QFlbEi1zzzlvvSqGnVW6wcnbx61Q6PN+HOGoDAhX4PTzTsJkWis8klPS4l1nbxGc4REO3o0Ml+lE2Fwe1oBFCsJEachv971rQBh3GZtqypQQmk6tlHcAArdkcn57V9K3ut8vItrzeyMQF4xwyd0kgzuQgIibc78XxY/yJTVphFdOlAQ8br0f2ZAbDLRk3YTiMVSKozDmzOMpFMZszHsZgCo0W3YYugHF3IYnzio9uxBgsPVTfp2qa5e7dLFqEvBL8QsfYSFmh5SRUO8xWx/z83oynxLMKunfoS5EPMnqxHEEX0EOwK3FM+gJa+An9uexDOTjdANKr5QVBxXmC2dxh07p+58Xelvd0hSUv79/5xUbAItbTbkhF5E3XcFvxtdn+8HEIpw38E5DhtIiWVR/rDsWmR/xoMHOxUHb25LqmKl89pMRcWeMr9QfcyVsOiHEVv+Kf+PScJwvQs5pWqqt/mm+x1NqFx78DqWLAVWTgfdRqXS5WKiUNSu3opBy6TDQHf8clBIFguONCTY0jytBMorXq"
`endif